# Egret游戏开发：hello world

## 创建入口index.html
在根目录创建`index.html`文件，这是本地项目访问入口。
在`body`标签内创建class属性值为`egret-player`的div标签，这是画布`canvas`的容器。这个标签上还有其他的一些配置相关的属性。详细如下：
```html
<div style="margin: auto;width: 100%;height: 100%;" class="egret-player" data-entry-class="Main" data-orientation="auto"
    data-scale-mode="showAll" data-frame-rate="30" data-content-width="750" data-content-height="1624"
    data-multi-fingered="2" data-show-fps="false" data-show-log="false" data-show-fps-style="x:0,y:0,size:12,textColor:0xffffff,bgAlpha:0.9">
</div>
```

然后，在`index.html`引入Egret的代码库文件egret.min.js以及egret.web.min.js。
```html
<script src="https://yun.duiba.com.cn/db_games/egret_5.2.9/egret.min.js"></script>
<script src="https://yun.duiba.com.cn/db_games/egret_5.2.9/egret.web.min.js"></script>
```

之后，我们再把用户代码文件`main.js`引入进来。
```html
<script src="main.js"></script>
```

## 编写代码
在根目录创建`main.js`用户代码文件，并在其中创建一个名为`Main`的class，之后把这个class暴露到`window`全局对象中。
在`onAddToStage`方法中，我们创建了一个红色的文本框，文本内容为`hello world`。
```js
class Main extends egret.DisplayObjectContainer {
    constructor() {
        super();
        this.addEventListener(egret.Event.ADDED_TO_STAGE, this.onAddToStage, this);
    }

    onAddToStage(event) {
        let textfield = new egret.TextField();
        this.addChild(textfield);
        textfield.textColor = 0xff0000;
        textfield.text = 'hello world';
    }
}
window['Main']=Main;
```

最后我们把下面的代码放入`main.js`尾部来启动引擎。
```js
egret.runEgret({
    renderMode: "webgl", audioType: 0, calculateCanvasScaleFactor: function (context) {
        var backingStore = context.backingStorePixelRatio ||
            context.webkitBackingStorePixelRatio ||
            context.mozBackingStorePixelRatio ||
            context.msBackingStorePixelRatio ||
            context.oBackingStorePixelRatio ||
            context.backingStorePixelRatio || 1;
        return (window.devicePixelRatio || 1) / backingStore;
    }
});
```

## 运行代码
我们用chrome来运行`index.html`便可以看到在画布上出现了红色的`hello world`字样。运行结果如下图。完整的源码请见：https://github.com/wildfirecode/egret-hello-world.
![avatar](http://yun.duiba.com.cn/db_games/game-development-tutorial/hello_egret.png)