import { ModuleTypes } from "../types/sceneTypes";
import Scene from "../components/Scene";
export default class SceneCtrl {
    private _parent: egret.Sprite;
    private _currentScene: Scene;

    static _instance: SceneCtrl;
    static get instance() {
        return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl())
    }
    init(parent: egret.Sprite) {
        this._parent = parent;
    }

    change(type: ModuleTypes) {
        if (this._currentScene) {
            this._currentScene.destroy();
            this._parent.removeChild(this._currentScene);
        }
        const cls = this._sceneClassMap[type];
        const scene: Scene = new cls();
        scene.start();
        this.addToStage(scene);
    }

    private addToStage(scene: Scene) {
        this._currentScene = scene;
        this._parent.addChild(scene);
    }

    private _sceneClassMap: any;
    registerScene(name, config) {
        this._sceneClassMap = this._sceneClassMap || {};
        this._sceneClassMap[name] = config.cls;
    }
}