import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import { HtmlTextParser } from "../HtmlTextParser";
import Panel from "./Panel";

export default class RulePanel extends Panel {
    public labContent: eui.Label;
    public scroller: eui.Scroller;
    start() {
        if (!DataManager.ins.getRuleData)
            NetManager.ins.getRule(() => {
                this.addRule();
            });
        else
            this.addRule();
    }

    group: eui.Group;
    private addRule() {
        const text = DataManager.ins.getRuleData.ruleText;
        this.labContent.textFlow = (new HtmlTextParser).parser(DataManager.ins.getRuleData.ruleText);
    }

    protected get skinKey() { return 'Rule' }
}