/*
 * @Author: 周成
 * @Date: 2018-01-24 14:32:14
 * @Last Modified by: 周成
 * @Last Modified time: 2018-01-29 20:58:10
 */

const fs = require('fs');

const co = require('co');
const OSS = require('ali-oss');

const chalk = require('chalk');
const ProgressBar = require('progress');

const BUILD_TYPE_argv = process.argv[2];
const BUILD_TYPE = BUILD_TYPE_argv.split('=')[1];
class TuiaAutoUpload {
  constructor(props) {
    const defaultOptions = {
      dir: undefined,
      originDir: undefined,
      sourcemap: false
    }
    this.options = Object.assign({}, defaultOptions, props);
    if (!this.options.dir || !this.options.originDir) {
      console.log(chalk.red('缺少参数，初始化失败'))
      return;
    }
    this.init();
  }
  init() {
    this.client = new OSS({
      region: 'oss-cn-hangzhou',
      accessKeyId: 'LTAIdGi1IOap7fkF',
      accessKeySecret: 'SKrOOp6EVtDGEV47yn0t2h97gyNioQ',
      bucket: BUILD_TYPE === 'production' ? 'duiba' : 'daily-duiba'
    });
    this.bar = new ProgressBar(chalk.yellow(`  文件上传中 [:bar] :current/${this.files().length} :percent :elapseds`), {
      complete: '●',
      incomplete: '○',
      width: 20,
      total: this.files().length,
      callback: () => {
        console.log(chalk.green('\n  All complete.'));
        console.log(chalk.blue(`\n  本次队列文件共${this.files().length}个，已存在文件${this.existFiles}个，上传文件${this.uploadFiles}个，上传失败文件${this.errorFiles}个\n`));
      }
    })
    return this;
  }
  files() {
    let list = fs.readdirSync(this.options.dir);
    if (!this.options.sourcemap)
      list = list.filter(e => e.indexOf('.js.map') == -1);
    return list;
  }
  start() {
    this.files().map((file, index) => {
      let _this = this;
      const path = this.options.dir + file;
      let originFile;
      this.existFiles = 0;
      this.uploadFiles = 0;
      this.errorFiles = 0;
      co(function* () {
        const originPath = `${_this.options.originDir}${file}`;
        try {
          originFile = yield _this.client.head(originPath);
        } catch (error) {
          originFile = error;
        }
        if (BUILD_TYPE === 'production') {
          if (originFile.status === 404) {
            yield _this.client.put(originPath, path);
            _this.uploadFiles += 1;
          } else {
            _this.existFiles += 1;
          }
        } else if (BUILD_TYPE === 'development') {
          if (originFile.status === 404 || originFile.status === 200) {
            _this.existFiles += 1;
          }
          yield _this.client.put(originPath, path, {
            headers: {
              'Cache-Control': 'no-cache'
            }
          })
          _this.uploadFiles += 1;
        }
        _this.bar.tick();
      }).catch(function (err) {
        _this.errorFiles += 1;
        console.log(err);
      });
    });
  }
}

module.exports = TuiaAutoUpload;