// const publish = require('./publish');
const ora = require('ora');
const rm = require('rimraf');
const path = require('path');
const chalk = require('chalk');
const webpack = require('webpack');
const prodConfig = require('./webpack.prod.conf');
const shelljs = require('shelljs');

let build = opts => {
    if (!opts.BUILD_SKIN) {
        console.error('请输入需要构建的项目名称\n');
        return false;
    }
    const dist = path.join(process.cwd(), opts.BUILD_SKIN, 'bin-release')
    rm(dist, err => {
        if (err) throw err;
        let webpackConfig = prodConfig(opts);
        var spinner = ora('building for production...\n');
        spinner.start();
        // 构建
        webpack(webpackConfig, function (err, stats) {
            spinner.stop();
            if (err) throw err;
            process.stdout.write(
                stats.toString({
                    colors: true,
                    modules: false,
                    children: false,
                    chunks: false,
                    chunkModules: false
                }) + '\n\n'
            );
            console.log(chalk.cyan('Build complete.\n'));
            spinner.text = '正在生成TextureMerger proj\n';
            spinner.start();
            shelljs.cd(opts.BUILD_SKIN);
            shelljs.exec('node autoMerger.js');
            spinner.stop();
            spinner.text = '正在编译exmls\n';
            spinner.start();
            shelljs.exec('egret publish');
            console.log('编译exmls结束');
            spinner.stop();
            shelljs.exec('dbtinypng -i bin-release/resource/TextureMerger -o bin-release/resource/TextureMerger && node publish.js');
            shelljs.cd('..');
        });
    });
};

module.exports = build;
