const devServer = require('./build/dev-server');
// const build = require('./build/build');
// const backup = require('./util/backup');
// const copy = require('./util/copy');

class DuibaGameBuild {
    constructor(config) {
        let defaults = {
            devPort: 8081,
            devServerWatchOptions: {
                ignored: [
                    'src/**/*.js',
                    '**/*.md',
                    'bin-release',
                ]
            },
            proxy: {
                '/ngapi/*': 'http://localhost:3000',
                '/plugin/*': 'http://localhost:3000',
                '/ngame/*': 'http://localhost:3000',
                '/activityCommon/*': 'http://localhost:3000',
                '/ctool/*': 'http://localhost:3000',
                '/activityVist/*': 'http://localhost:3000',
                '/collectGoods/*': 'http://localhost:3000',
                '/activityPlugDrawInfo/*': 'http://localhost:3000',
                '/collectRule/*': 'http://localhost:3000',
                '/hdtool/*': 'http://localhost:3000',
                '/activityPlugin/*': 'http://localhost:3000',
                '/summer/*': 'http://localhost:3000'
            }
        };
        this.opts = Object.assign({}, defaults, config);

        global.buildOptions = this.opts;
    }

    /**
     * 本地开发服务
     * @param {*} skin 皮肤名称
     */
    dev(skin) {
        process.env.NODE_ENV = '"development"';
        this.slicePath(skin);
        devServer.start(this.opts);
    }

    /**
     * 构建 daily库 dui88环境
     * @param {*} skin 皮肤名称
     */
    build(skin) {
        this.opts.sourceMap = false;
        this.opts.daily = true;
        this.buildBase(skin);
    }

    /**
     * 构建 duiba库 生产环境
     * @param {*} skin 皮肤名称
     */
    buildProd(skin) {
        this.opts.daily = false;
        this.buildBase(skin);
    }

    /**
     * 构建 统一入口
     * @param {*} skin 皮肤名称
     */
    buildBase(skin) {
        process.env.NODE_ENV = '"production"';
        this.slicePath(skin);
        build(this.opts);
    }

    /**
     * 备份 把skins/下的所有文件复制到backup/下
     */
    backup() {
        backup(this.opts.skins, this.opts.backup);
    }

    /**
     * 创建模板
     * @param {*} skin  皮肤名称
     * @param {*} temp  模板名称
     */
    copy(skin, temp) {
        copy(this.opts, skin, temp);
    }

    /**
     * 路径处理 支持 demo 和 path/demo/demo 多种参数格式
     * @param {*} skin
     */
    slicePath(skin) {
        if (!skin) return false;
        if (skin.includes('/')) {
            // 包含路径
            this.opts.BUILD_PATH = skin.split('/').pop();
        }
        this.opts.BUILD_SKIN = skin;
    }
}

module.exports = DuibaGameBuild;
