const merge = require('webpack-merge');
const baseConfig = require('./webpack.base.conf');
const UglifyJSPlugin = require('uglifyjs-webpack-plugin');
const webpack = require('webpack');
const path = require('path');


let config = opts => {
    let baseWebpackConfig = baseConfig(opts);
    return merge(baseWebpackConfig, {
        devtool: 'source-map',
        plugins: [
            new UglifyJSPlugin(
                { sourceMap: true }
            ),
            new webpack.DefinePlugin({
                'process.env.NODE_ENV': JSON.stringify('production')
            })
        ],
        output: {
            filename: `./${opts.BUILD_SKIN}/bin-release/output.js`,
            sourceMapFilename: `./${opts.BUILD_SKIN}/bin-release/output_develop.js`,
            path: process.cwd()
        },
        mode:"production"
    });
}

module.exports = config;