const devServer = require('./build/dev-server');
const buildObj = require('./build/build');
// const backup = require('./util/backup');
// const copy = require('./util/copy');

class DuibaGameBuild {
    constructor(config) {
        let defaults = {
            devPort: 8081,
            devServerWatchOptions: {},
            proxy: {
                '/customActivity/*': 'http://localhost:3000',
                '/ngapi/*': 'http://localhost:3000',
                '/plugin/*': 'http://localhost:3000',
                '/ngame/*': 'http://localhost:3000',
                '/activityCommon/*': 'http://localhost:3000',
                '/ctool/*': 'http://localhost:3000',
                '/activityVist/*': 'http://localhost:3000',
                '/collectGoods/*': 'http://localhost:3000',
                '/activityPlugDrawInfo/*': 'http://localhost:3000',
                '/collectRule/*': 'http://localhost:3000',
                '/hdtool/*': 'http://localhost:3000',
                '/activityPlugin/*': 'http://localhost:3000',
                '/summer/*': 'http://localhost:3000'
            }
        };
        this.opts = Object.assign({}, defaults, config);

        global.buildOptions = this.opts;
    }

    /**
     * 本地开发服务
     * @param {*} skin 皮肤名称
     */
    dev(skin) {
        process.env.NODE_ENV = '"development"';
        this.slicePath(skin);
        devServer.start(this.opts);
    }

    buildProd(skin) {
        this.slicePath(skin);
        buildObj.build(this.opts);
    }
    notinypng(skin) {
        this.slicePath(skin);
        buildObj.notinypng(this.opts);
    }

    buildProdTS(skin) {
        this.slicePath(skin);
        buildObj.buildTS(this.opts);
    }
    buildProdEXML(skin) {
        this.slicePath(skin);
        buildObj.buildEXML(this.opts);
    }

    /**
     * 备份 把skins/下的所有文件复制到backup/下
     */
    backup() {
        backup(this.opts.skins, this.opts.backup);
    }

    /**
     * 创建模板
     * @param {*} skin  皮肤名称
     * @param {*} temp  模板名称
     */
    copy(skin, temp) {
        copy(this.opts, skin, temp);
    }

    /**
     * 路径处理 支持 demo 和 path/demo/demo 多种参数格式
     * @param {*} skin
     */
    slicePath(skin) {
        if (!skin) return false;
        if (skin.includes('/')) {
            // 包含路径
            this.opts.BUILD_PATH = skin.split('/').pop();
        }
        this.opts.BUILD_SKIN = skin;
    }
}

module.exports = DuibaGameBuild;
