var opn = require('opn');
var path = require('path');
var webpack = require('webpack');
var devConfig = require('./webpack.dev.conf');
const WebpackDevServer = require('webpack-dev-server');
// const apiMocker = require('webpack-api-mocker');

var serverStart = opts => {
    let webpackConfig = devConfig(opts);

    // 遍历每个entry，加入dev-server client
    Object.keys(webpackConfig.entry).forEach(function (name) {
        let _devServer = `webpack-dev-server/client?http://localhost:${
            opts.devPort
            }`;
        webpackConfig.entry[name] = [_devServer].concat(webpackConfig.entry[name]);
    });

    var compiler = webpack(webpackConfig);

    const devServerOptions = {
        host: '0.0.0.0',
        watchContentBase: true,
        watchOptions: opts.devServerWatchOptions,
        contentBase: '.',
        proxy: opts.proxy,
        after(app) {
            // 自动打开浏览器
            if (opts.BUILD_SKIN && opts.opn) {
                opn(
                    path.join(`http://localhost:${opts.devPort}`, opts.BUILD_SKIN, 'index.html')
                );
            }
        }

    };

    WebpackDevServer.addDevServerEntrypoints(webpackConfig, devServerOptions);
    const devServer = new WebpackDevServer(compiler, devServerOptions);
    devServer.listen(opts.devPort, '0.0.0.0', () => {
        console.log(`Starting server ...`);
    });

};

module.exports = {
    close: () => { },
    start: opts => {
        serverStart(opts);
    }
};