var webpack = require('webpack');
var getDevConfig = require('./webpack.dev');
const WebpackDevServer = require('webpack-dev-server');

var serverStart = proj => {
    const devConfig = getDevConfig(proj);
    var compiler = webpack(devConfig);

    const devServerOptions = {
        host: '0.0.0.0',
        contentBase: `./${proj}`,
        proxy: {
            '/ngapi/*': 'http://localhost:3000',
            '/plugin/*': 'http://localhost:3000',
            '/ngame/*': 'http://localhost:3000',
            '/activityCommon/*': 'http://localhost:3000',
            '/ctool/*': 'http://localhost:3000',
            '/activityVist/*': 'http://localhost:3000',
            '/collectGoods/*': 'http://localhost:3000',
            '/activityPlugDrawInfo/*': 'http://localhost:3000',
            '/collectRule/*': 'http://localhost:3000',
            '/hdtool/*': 'http://localhost:3000',
            '/activityPlugin/*': 'http://localhost:3000',
            '/summer/*': 'http://localhost:3000'
        },
    };

    WebpackDevServer.addDevServerEntrypoints(devConfig, devServerOptions);
    const devServer = new WebpackDevServer(compiler, devServerOptions);
    devServer.listen(8080, '0.0.0.0', () => {
        console.log(`Starting server ...`);
    });
};

module.exports = {
    close: () => { },
    start: proj => {
        serverStart(proj);
    }
};