var merge = require('webpack-merge');
var baseConfig = require('./webpack.base.conf');
const path = require('path');

const MockWebpackPlugin = require('mock-webpack-plugin');

const configPath = path.join(process.cwd(), './mock/config.js');
const mockConfig = require(configPath);

let config = opts => {
    let baseWebpackConfig = baseConfig(opts);

    return merge(baseWebpackConfig, {
        mode: 'development',
        devtool: 'eval-source-map',
        // // cheap-module-eval-source-map is faster for development
        // devtool: '#cheap-module-eval-source-map',
        plugins: [
            new MockWebpackPlugin({
                config: mockConfig,
                port: 3000
            })
        ]
    });
};

module.exports = config;
