const path = require('path');

module.exports = opts => {
    const result = {
        entry: {
            app: `./${opts.BUILD_SKIN}/src/Main.ts`
        },
        module: {
            rules: [
                {
                    test: /\.tsx?$/,
                    use: 'ts-loader',
                    exclude: /node_modules/
                }
            ]
        },

        resolve: {
            extensions: ['.tsx', '.ts', '.js']
        },
        output: {
            filename: `./${opts.BUILD_SKIN}/output.js`,
            path: __dirname
        }
    };
    return result
}