import { RES } from "../../../module/RES";
import { Tools } from "../../Tools";

/**
 * 分数条的托管类，不需要继承
 */
export class ScoreProgress extends FYGE.Container {
    hasOver: boolean
    starCount: number = 0;
    /**
     * 各星数的对应分数
     */
    starScores: number[];

    star1: FYGE.Sprite;
    star2: FYGE.Sprite;
    star3: FYGE.Sprite;

    starProgress: FYGE.Sprite;
    scoreTxt: FYGE.BitmapText;
    allScore: number;

    private diss = [
        202,
        291,
        370,
        402
    ]

    private _score: number;
    get score() {
        return this._score
    }
    set score(value: number) {
        if (this._score == value) return
        this._score = value
        this.scoreTxt.text = "" + Math.ceil(value);

        var w: number, scale: number;
        //先计算是否达到了3星
        if (value >= this.starScores[2]) {
            var aa = (value - this.starScores[2]) / (this.allScore - this.starScores[2]);
            scale = aa > 1 ? 1 : aa;
            if (scale >= 1) {
                if (!this.hasOver) {
                    this.hasOver = true;
                } else {
                    return
                }
            }
            w = (this.diss[3] - this.diss[2]) * scale + this.diss[2];
            if (this.star3.texture != RES.getRes("lightedStar.png")) {
                this.star3.texture = RES.getRes("lightedStar.png");
                this.star2.texture = RES.getRes("lightedStar.png");
                this.star1.texture = RES.getRes("lightedStar.png");
                this.starCount = 3;
            };
        }
        //是否超过2星
        else if (value >= this.starScores[1]) {
            scale = (value - this.starScores[1]) / (this.starScores[2] - this.starScores[1]);
            w = (this.diss[2] - this.diss[1]) * scale + this.diss[1];
            if (this.star2.texture != RES.getRes("lightedStar.png")) {
                this.star2.texture = RES.getRes("lightedStar.png");
                this.star1.texture = RES.getRes("lightedStar.png");
                this.starCount = 2;
            };
        }
        //是否超过1星
        else if (value >= this.starScores[0]) {
            scale = (value - this.starScores[0]) / (this.starScores[1] - this.starScores[0]);
            w = (this.diss[1] - this.diss[0]) * scale + this.diss[0];
            if (this.star1.texture != RES.getRes("lightedStar.png")) {
                this.star1.texture = RES.getRes("lightedStar.png");
                this.starCount = 1;
            };
        } else {
            scale = value / this.starScores[0];
            w = this.diss[0] * scale;
        }
        //(466-428)/428,扩分数
        //星星
        //进度条遮罩
        var mask = this.starProgress.mask;
        mask.clear()
        mask.beginFill(0xff0000, 1);
        mask.drawRoundedRect(0, 0, w, 32, 50)
        mask.endFill();


    }

    /**
     * 
     * @param starProgress 托管
     * @param scoreTxt 托管
     * @param starScores 
     */
    constructor(starScores: number[]) {
        super()
        this.starProgress = this.addChild(FYGE.Sprite.fromFrame("starProgress.png"));
        this.scoreTxt = this.addChild(new FYGE.BitmapText(Tools.getNumTextures("scoreNum")));
        this.scoreTxt.position.set(39,-32)
        this.starScores = starScores;
        this.allScore = this.diss[3] / this.diss[2] * this.starScores[2];

        //加遮罩，加到starProgress的父级中
        var mask = new FYGE.Shape();
        mask.beginFill(0xff0000, 1);
        mask.drawRoundedRect(0, 0, 0, 32, 50)
        mask.endFill();
        this.starProgress.mask = mask;
        this.addChild(mask);
        //星星1   lightedStar.png
        var textureStar: FYGE.Texture = RES.getRes("unlightedStar.png")
        this.star1 = this.addChild(new FYGE.Sprite(textureStar))
        this.star1.position.set(this.diss[0] - textureStar.width / 2, -2)
        this.star2 = this.addChild(new FYGE.Sprite(textureStar));
        this.star2.position.set(this.diss[1] - textureStar.width / 2, -2)
        this.star3 = this.addChild(new FYGE.Sprite(textureStar));
        this.star3.position.set(this.diss[2] - textureStar.width / 2, -2)
    }
}