import { RES } from "../../../module/RES";
import Sprite = FYGE.Sprite;


export class PropBtnCon extends FYGE.Container {
    boomBtn: FYGE.Button;
    hammerBtn: FYGE.Button;
    stepBtn: FYGE.Button;

    private stepNum: FYGE.BitmapText;
    private _stepCount: number;
    get stepCount() {
        return this._stepCount;
    }

    set stepCount(value) {
        this._stepCount = value;
        this.stepNum.text = "" + value;
    }

    private boomNum: FYGE.BitmapText;
    private _boomCount: number;
    get boomCount() {
        return this._boomCount;
    }

    set boomCount(value) {
        this._boomCount = value;
        this.boomNum.text = "" + value;
    }

    private hammerNum: FYGE.BitmapText;
    private _hammerCount: number;
    get hammerCount() {
        return this._hammerCount;
    }

    set hammerCount(value) {
        this._hammerCount = value;
        this.hammerNum.text = "" + value;
    }


    constructor() {
        super();
        this.addChild(FYGE.Sprite.fromFrame("table.png"));

        this.stepBtn = new FYGE.Button(RES.getRes("stepBtn.png"));
        this.stepBtn.x = 132
        this.addChild(this.stepBtn);
        this.boomBtn = new FYGE.Button(RES.getRes("boomBtn.png"));
        this.boomBtn.x = 334
        this.addChild(this.boomBtn)
        this.hammerBtn = new FYGE.Button(RES.getRes("hammerBtn.png"));
        this.hammerBtn.x = 516;
        this.addChild(this.hammerBtn)
        this.stepBtn.y = this.boomBtn.y = this.hammerBtn.y = 3;

        this.addChild(Sprite.fromFrame('prop_count_bg.png'))
            .position.set(205, 68);

        this.addChild(Sprite.fromFrame('prop_count_bg.png'))
            .position.set(392, 68);

        this.addChild(Sprite.fromFrame('prop_count_bg.png'))
            .position.set(579, 68);

        var arr = {};
        for (var i = 0; i < 10; i++) arr[i] = RES.getRes("propNum" + i + ".png")
        //文案
        this.stepNum = this.addChild(new FYGE.BitmapText(arr));
        this.boomNum = this.addChild(new FYGE.BitmapText(arr));
        this.hammerNum = this.addChild(new FYGE.BitmapText(arr));
        this.stepNum.y = this.boomNum.y = this.hammerNum.y = 75;
        this.stepNum.text = this.boomNum.text = this.hammerNum.text = "13";
        this.stepNum.textAlign = this.boomNum.textAlign = this.hammerNum.textAlign = FYGE.TEXT_ALIGN.CENTER;
        this.stepNum.x = 227
        this.boomNum.x = 227 + 187
        this.hammerNum.x = 227 + 187 * 2;
        // console.log(this.stepNum, this.boomNum,this.hammerNum)
    }
}


/**
 * 自定义按钮
 */


