
import { Tool } from "../Tool";
import { generateMapBg, drawPoly } from "../logic/aaa";
import { RES } from "../../../module/RES";
import { PlayScene } from "../../scene/PlayScene";
import { Tools } from "../../Tools";
import { GTool } from "../../../module/tools/GTool";

/**
 * 引导前，initElements需要编排特定元素
 * 游戏引导，。8种
 * 蒙层都一致，但是需要特定镂空，手势，和提示文案
 *
 */
export class GameGuide extends FYGE.Container {
    /**
     * 背景黑色蒙层
     */
    bg: FYGE.Shape;
    hand: FYGE.Sprite;
    stepCount: number;
    stepAll: number;
    thisObj: PlayScene;

    msgBoard: MsgBoard
    /**
     * 直接把this传入得了，懒得弄了
     * @param thisObj
     */
    constructor(thisObj: PlayScene) {
        super();
        // this.touchEnabled = true;
        this.bg = new FYGE.Shape()
        this.addChild(this.bg);
        this.hand = new FYGE.Sprite(RES.getRes("guidePropHand.png"));
        this.hand.mouseEnable = false;
        this.addChild(this.hand);

        this.msgBoard = this.addChild(new MsgBoard());

        this.thisObj = thisObj
        this.stepCount = chapterFuns[thisObj.chapter] ? chapterFuns[thisObj.chapter].stepCount : 0;
        this.stepAll = this.stepCount;
    }



    show() {
        var step = this.stepAll - this.stepCount;
        this.drawBg(step);
        //修改元素的层级，置顶，否则可能点击其他元素,handIndexs
        var handIndexs = chapterFuns[this.thisObj.chapter].handIndexs[step];
        for (var i = 0; i < handIndexs.length; i++) {
            var index = handIndexs[i];
            var lat = this.thisObj.lattices[index]
            if (lat && lat.element) this.thisObj.elementContainer.addChild(lat.element);
        }

        this.handAni(handIndexs);
        this.msgBoard.msg = chapterFuns[this.thisObj.chapter].msg[step] || "";
        this.msgBoard.x = (750 - this.msgBoard.width) / 2;
        var p1 = Tool.getPositionByIndex(handIndexs[0]);
        var p2 = Tool.getPositionByIndex(handIndexs[1]);
        this.msgBoard.y = Math.max(p1[1], p2[1]) + 135;
        //定制修改，101关毛球引导，
        if (this.thisObj.chapter == 101 && step == 0) {
            this.msgBoard.y += 80;
        }
        //定制修改，9关组合特效修改
        if (this.thisObj.chapter == 9) {
            this.msgBoard.y -= 80;
        }

        this.stepCount--;
    }


    hideSelf() {
        if (this.parent) this.parent.removeChild(this);
        if (!this.stepCount) {
            //计入缓存
            GTool.writeCache(Tools.cacheKey + this.thisObj.chapter);
            //置空gameGuide
            this.thisObj.gameGuide = null;
        }
    }

    private handAni(handIndexs: number[]) {
        FYGE.Tween.removeTweens(this.hand)
        var p1 = Tool.getPositionByIndex(handIndexs[0]);
        var p2 = Tool.getPositionByIndex(handIndexs[1]);
        this.hand.x = p1[0];
        this.hand.y = p1[1];
        FYGE.Tween.get(this.hand, { loop: true })
            // .set({ x: p1[0], y: p1[1] })
            .to({ x: p2[0], y: p2[1] }, 1000)
            .to({ x: p1[0], y: p1[1] }, 100)
    }

    /**
     *
     * @param chapter
     * @param step 0第一步，1第二步
     */
    private drawBg(step: number = 0) {
        this.bg.clear();
        this.bg.beginFill(0x000000, 0.7);
        this.drawRect();
        //画特定的洞
        var data = chapterFuns[this.thisObj.chapter]
        drawHole(this.bg, data.showIndexs[step], data.hideIndexs[step]);
    }

    private drawRect() {
        //逆时针
        this.bg.moveTo(0, 0);
        this.bg.lineTo(0, 1624);
        this.bg.lineTo(750, 1624);
        this.bg.lineTo(750, 0);
        this.bg.lineTo(0, 0);
    }

}
/**
 * 提示板
 */
export class MsgBoard extends FYGE.Sprite {
    private _msg: FYGE.TextField
    set msg(value) {
        this._msg.text = value
    }
    constructor() {
        super(RES.getRes("gameGuideBoard.png"));
        var msg = this.addChild(Tools.getText(
            "",
            30,
            "#ffffff",
            FYGE.TEXT_ALIGN.LEFT,
            540,
            50,
            0
        ))
        msg.textHeight = 182;
        msg.verticalAlign = FYGE.VERTICAL_ALIGN.MIDDLE;
        msg.lineType = FYGE.TEXT_lINETYPE.MULTI;
        this._msg = msg;
    }
}

const chapterFuns = {
    //基本操作 1
    1: {
        //需要步数
        stepCount: 1,
        //中空的格子,stepCount有多少，就有多少组
        showIndexs: [
            [67, 66, 68, 58],
        ],
        //和遮挡的格子
        hideIndexs: [
            [66, 68],
        ],
        //手势来回滑的两个位置索引
        handIndexs: [
            [58, 67]
        ],
        //提示文案，尽量通用点的位置。x肯定都居中
        msg: [
            "3个同色元素成一排即可消除~"
        ]
    },
    //冰块消除
    2: {
        stepCount: 1,
        showIndexs: [
            [18, 19, 20, 21],
        ],
        hideIndexs: [
            [18, 19],
        ],
        handIndexs: [
            [21, 20]
        ],
        msg: [
            "消除冰块上的元素即可打破冰块"
        ]
    },
    //石头消除
    3: {
        stepCount: 1,
        showIndexs: [
            [12, 13, 14, 15],
        ],
        hideIndexs: [
            [14, 15],
        ],
        handIndexs: [
            [12, 13]
        ],
        msg: [
            "当石头附近的元素产生消除时，即可粉碎石头"
        ]
    },
    //直线特效
    5: {
        stepCount: 2,
        showIndexs: [
            [13, 22, 31, 40, 23],
            [40, 49, 58, 50],
        ],
        hideIndexs: [
            [13, 31, 40],
            [40, 58],
        ],
        handIndexs: [
            [23, 22],
            [49, 50]
        ],
        msg: [
            "4个同色元素形成直线就能合成直线特效",
            "消除直线特效会产生直线消除"
        ]
    },
    //爆炸特效
    8: {
        stepCount: 2,
        showIndexs: [
            [2, 11, 20, 19, 18, 21],
            [20, 29, 38, 30]
        ],
        hideIndexs: [
            [2, 11, 19, 18],
            [20, 38],
        ],
        handIndexs: [
            [21, 20],
            [30, 29]
        ],
        msg: [
            "5个同色元素成L形或T形就能合成爆炸特效",
            "消除爆炸特效会产生3*3的范围消除",
        ]
    },
    //特效组合
    9: {
        stepCount: 1,
        showIndexs: [
            [63, 72],
        ],
        hideIndexs: [
            [],
        ],
        handIndexs: [
            [63, 72],
        ],
        msg: [//"将两个特效互相拖动即可直接触发组合特效，\n组合特效的效果视组合的两个特效类型而定"
            "两个特效互相拖动即可触发组合特效，组合特效的效果视两个特效类型而定"//缩短了
        ]
    },
    //魔力鸟特效
    10: {
        stepCount: 2,
        showIndexs: [
            [73, 64, 55, 46, 37, 54],
            [73, 64]
        ],
        hideIndexs: [
            [73, 64, 46, 37],
            []
        ],
        handIndexs: [
            [54, 55],
            [73, 64]
        ],
        msg: [
            "五个相同元素形成一字型即可合成魔力猫特效",
            "拖动魔力猫特效即可直接触发"
        ]
    },
    //魔力鸟加特效
    12: {
        stepCount: 1,
        showIndexs: [
            [13, 22],
        ],
        hideIndexs: [
            [],
        ],
        handIndexs: [
            [13, 22],
        ],
        msg: [
            "交换这两个特效元素，\n猜猜会发生什么"
        ]
    },
    //棒棒糖消除
    17: {
        stepCount: 2,
        showIndexs: [
            [22, 31, 40, 49, 39],
            [68, 49, 58, 67, 76],
        ],
        hideIndexs: [
            [22, 31, 49],
            [49, 58, 76],
        ],
        handIndexs: [
            [39, 40],
            [68, 67],
        ],
        msg: [
            "当棒棒糖移至底层时，即可移除棒棒糖",
            "消除棒棒糖下方的元素\n就可以收集棒棒糖啦"
        ]
    },
    //笼子消除
    25: {
        stepCount: 1,
        showIndexs: [
            [0, 1, 2, 3],
        ],
        hideIndexs: [
            [0, 1],
        ],
        handIndexs: [
            [3, 2]
        ],
        msg: [
            "和困住藤蔓里的元素匹配\n消除，就可以打破藤蔓啦！"
        ]
    },
    //果冻消除
    41: {
        stepCount: 1,
        showIndexs: [
            [40, 49, 58, 48, 50],
        ],
        hideIndexs: [
            [58, 48, 50],
        ],
        handIndexs: [
            [40, 49]
        ],
        msg: [
            "小心！会蔓延的果冻！\n消除果冻旁边的元素\n就能消除果冻~"
        ]
    },
    //鸡蛋
    61: {
        stepCount: 1,
        showIndexs: [
            [66, 57, 48, 39],
        ],
        hideIndexs: [
            [48, 39],
        ],
        handIndexs: [
            [66, 57]
        ],
        msg: [
            "铁锅边上不断有元素消除时,会炸出爆米花"
        ]
    },
    //灰毛球
    101: {
        stepCount: 1,
        showIndexs: [
            [13, 22, 21, 23, 31, 40],
        ],
        hideIndexs: [
            [21, 23, 31, 40],
        ],
        handIndexs: [
            [13, 22]
        ],
        msg: [
            "灰毛球每步会随机选择相邻的格子跳动~\n移动一步试试吧"
        ]
    },
    //褐色毛球
    121: {
        stepCount: 1,
        showIndexs: [
            [55, 56, 65, 47],
        ],
        hideIndexs: [
            [65, 47],
        ],
        handIndexs: [
            [55, 56]
        ],
        msg: [
            "需用特效将褐色毛球分裂成\n两个灰色毛球，才能将它消除"
        ]
    }
}

/**
 * 根据显示index和隐藏的绘制图形
 * @param shape
 * @param showIndexs
 * @param hideIndexs
 */
function drawHole(shape: FYGE.Shape, showIndexs: number[], hideIndexs: number[]) {

    var lattices = createLattices9(showIndexs);
    var paths = generateMapBg(lattices);
    //顺时针
    //画洞
    for (var j = 0; j < paths.length; j++) {
        var path = paths[j];
        drawPoly(shape, path)
    }
    shape.endFill();

    //根据hideIndexs画遮,为了不能点击
    if (!hideIndexs || !hideIndexs.length) return
    shape.beginFill(0x000000, 0.01);//为了能用这个遮挡，必须设置0.01
    for (var i = 0; i < hideIndexs.length; i++) {
        var center = Tool.getPositionByIndex(hideIndexs[i]);
        shape.drawRect(center[0] - Tool.width / 2, center[1] - Tool.height / 2, Tool.width, Tool.height);
    }
    shape.endFill();
}

//根据显示的格子求Tool.colNum * Tool.rowNum格子,显示的标为1;
function createLattices9(indexs: number[]): number[] {
    var arr: number[] = [];
    for (var i = 0; i < Tool.colNum * Tool.rowNum; i++) {
        if (indexs.indexOf(i) > -1) {
            arr[i] = 1
        } else {
            arr[i] = 0
        }
    }
    return arr
}

var arr = ["apple", "orange", "apple", "orange", "pear", "orange"];
function getWordCnt(arr: any[]) {
    return arr.reduce(function (prev, next) {
        prev[next] = (prev[next] + 1) || 1;
        return prev;
    }, {});
}
