import { RES } from "../../../module/RES";
import Texture = FYGE.Texture;
import FrameAni = FYGE.FrameAni;

//只是为了魔力鸟背后的
export class MagicLionBgAni extends FYGE.Container {
    showImage: FYGE.Sprite;

    magicAniNormal: FrameAni;

    constructor() {
        super()

        //不交互
        this.mouseEnable = false;
        this.mouseChildren = false;

        var texture: FYGE.Texture = RES.getRes("magicLionBg.png")
        this.showImage = new FYGE.Sprite(texture);
        this.showImage.anchorTexture.set(0.5, 0.5);
        this.showImage.scaleX = this.showImage.scaleY = 0.7
        this.addChild(this.showImage);
        this.addEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);

        let other = new FYGE.Sprite(texture);
        other.anchorTexture.set(0.5, 0.5);
        other.scaleX = other.scaleY = 0.7
        this.addChild(other);
        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            other.rotation += 5;
        }, this);

        const magicAniNormalTexture: Texture[] = [];
        for (let i = 0; i <= 21; i++) {
            magicAniNormalTexture.push(RES.getRes(`MagicAniNormal_${i}.png`));
        }

        this.magicAniNormal = this.addChild(new FrameAni(magicAniNormalTexture));
        this.magicAniNormal.play(-1);

        var upTexture: FYGE.Texture = RES.getRes("magicLion.png")
        let up = new FYGE.Sprite(upTexture);
        up.anchorTexture.set(0.5, 0.5);
        this.addChild(up);
        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            // up.rotation += 2;
        }, this);

    }

    private onEnterFrame() {
        this.showImage.rotation -= 5;
    }

    /**
     * 重置
     */
    reset() {
        // this.showImage.scaleX = this.showImage.scaleY = 0.7;
        // this.showImage.alpha = 1;
    }
}
