import { RES } from "../../../module/RES";

//只是为了魔力鸟背后的
export class HorizontalBgAni extends FYGE.Container {
    leftArrow: FYGE.Sprite;
    rightArrow: FYGE.Sprite;
    outSpeed: number = 0.25;
    inSpeed: number = 1;
    direction: boolean = true;
    count: number = 0;
    constructor() {
        super()
        //不交互
        this.mouseEnable = false;
        this.mouseChildren = false;

        var textureL: FYGE.Texture = RES.getRes("leftArrow.png")
        this.leftArrow = new FYGE.Sprite(textureL);
        this.leftArrow.x = -50;
        this.leftArrow.y = -textureL.height / 2;
        this.addChild(this.leftArrow);

        var textureR: FYGE.Texture = RES.getRes("rightArrow.png")
        this.rightArrow = new FYGE.Sprite(textureR);
        var oriX = 50 - textureR.width;
        this.rightArrow.x = oriX;
        this.rightArrow.y = -textureR.height / 2
        this.addChild(this.rightArrow);


        this.addTweens();
    }

    /**
     * 重置
     */
    reset() {
        FYGE.Tween.removeTweens(this.leftArrow);
        FYGE.Tween.removeTweens(this.rightArrow);
        this.addTweens();
    }

    private addTweens() {
        FYGE.Tween.get(this.leftArrow, { loop: true })
            .set({ alpha: 1 })
            .wait(300)
            .to({ alpha: 0 }, 700)
        FYGE.Tween.get(this.leftArrow, { loop: true })
            .set({ x: -50 })
            .to({ x: -50 - 6 }, 1000)

        var textureR: FYGE.Texture = RES.getRes("rightArrow.png")
        var oriX = 50 - textureR.width;
        FYGE.Tween.get(this.rightArrow, { loop: true })
            .set({ alpha: 1 })
            .wait(300)
            .to({ alpha: 0 }, 700)
        FYGE.Tween.get(this.rightArrow, { loop: true })
            .set({ x: oriX })
            .to({ x: oriX + 6 }, 1000)
    }
}