import { RES } from "../../../module/RES";
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import Texture = FYGE.Texture;
import FrameAni = FYGE.FrameAni;
import Sprite = FYGE.Sprite;

/**
 * 节日元素
 *
 */
export class FestivalEle extends FYGE.Container {
    _type;
    /**
     * 是否要分裂了
     */
    isActive: boolean;
    /**
     * 状态变化 2 1 0 再往后，可分裂
     */
    private _statusNum: number;
    get statusNum() {
        return this._statusNum
    }

    set statusNum(value: number) {
        if (value >= 0) {
            //播放原来的动画
            let child = this.children[this._statusNum];
            child["play"](() => {
                //切换
                this.toggleStatus(value);
            })
            this._statusNum = value;
        } else {
            //不用动画
            this._statusNum = 0;
            let child = this.children[this._statusNum];
            child["play"](() => {
            })
            this.isActive = true;
        }
    }

    constructor(n: number = 2) {
        super();
        this.addChild(new Status3());
        this.addChild(new Status2());
        this.addChild(new Status1());

        this.toggleStatus(n);
        this.isActive = false;
        this._statusNum = n;
    }


    reset(n: number = 2) {
        this.toggleStatus(n);
        this.isActive = false;
        this._statusNum = n;
    }

    toggleStatus(index: number) {
        for (let i = 0; i < this.children.length; i++) {
            const child = this.children[i];
            if (i == index) {
                child.visible = true;
                //重置状态
                child["reset"]();
            } else {
                child.visible = false;
            }
        }
    }
}

//第一种状态
class Status1 extends FYGE.Container {

    up: Sprite;

    defaultX: number;
    defaultY: number;

    constructor() {
        super();

        const down = new FYGE.Sprite(RES.getRes("fesRedDown.png"));
        down.anchorTexture.set(0.5, 0.5);
        this.addChild(down);

        const textureUp: FYGE.Texture = RES.getRes("fesRedBombSta1.png")
        this.up = this.addChild(new Sprite(textureUp));
        this.defaultX = this.up.x = -textureUp.width / 2;
        this.defaultY = this.up.y = -textureUp.height / 2;
        this.up.anchor.set(0.5 * textureUp.width, 0.866 * textureUp.height);
        this.scaleX = this.scaleY = 0.31;
    }

    shake() {

        Tween.removeTweens(this.up);

        const cX = this.defaultX, cY = this.defaultY,
            ty = cY - 6 * 3, dx = 4 * 3, dr = 8, duration = 130, ease = Ease.quadInOut;

        Tween.get(this.up)
            .wait(1500)
            .call(() => {
                Tween.get(this.up, {loop: true})
                    .set({x: cX, y: cY})
                    .wait(1650)
                    .to({x: cX - dx, y: ty, rotation: -dr}, duration, ease)
                    .to({x: cX, y: cY, rotation: 0}, duration, ease)
                    .to({x: cX + dx, y: ty, rotation: dr}, duration, ease)
                    .to({x: cX, y: cY, rotation: 0}, duration, ease);
            });
    }

    reset() {
        this.shake();
        this.scale.set(0.31, 0.31);
    }

    play(callback: Function) {
        FYGE.Tween.get(this)
            .to({scaleX: 0, scaleY: 0}, 240)
            .call(() => {
                callback();
            });
    }
}

//第二种状态
class Status2 extends FYGE.Container {
    light: FYGE.Sprite;
    fesRedCap: FYGE.Sprite

    up: Sprite;

    defaultX: number;
    defaultY: number;


    constructor() {
        super();

        const down = new Sprite(RES.getRes("fesRedDown.png"));
        down.anchorTexture.set(0.5, 0.5);
        down.scale.set(0.31, 0.31);
        this.addChild(down);

        const textureUp: Texture = RES.getRes("fesRedBombSta2.png")
        this.up = this.addChild(new Sprite(textureUp));
        this.defaultX = this.up.x = -textureUp.width / 2;
        this.defaultY = this.up.y = -textureUp.height / 2;
        this.up.anchor.set(0.5 * textureUp.width, 0.866 * textureUp.height);
        this.up.scale.set(0.92, 0.92);

        this.scale.set(0, 0);

    }

    shake() {
        Tween.removeTweens(this.up);

        const cX = this.defaultX, cY = this.defaultY,
            ty = cY - 6, dx = 4, dr = 8, duration = 130, ease = Ease.quadInOut;

        Tween.get(this.up, {loop: true})
            .set({x: cX, y: cY})
            .wait(1650)
            .to({x: cX - dx, y: ty, rotation: -dr}, duration, ease)
            .to({x: cX, y: cY, rotation: 0}, duration, ease)
            .to({x: cX + dx, y: ty, rotation: dr}, duration, ease)
            .to({x: cX, y: cY, rotation: 0}, duration, ease);
    }

    reset() {
        Tween.removeTweens(this);
        this.shake();
        Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 270, Ease.backOut);
    }

    play(callback: Function) {
        Tween.get(this)
            .to({scaleX: 0, scaleY: 0}, 270, Ease.backOut)
            .call(() => {
                callback();
            });
    }
}

class Status3 extends FYGE.Container {

    private ani1: FrameAni;
    private timeOut = null;

    constructor() {
        super();

        const down = new FYGE.Sprite(RES.getRes("fesRedDown.png"));
        down.anchorTexture.set(0.5, 0.5);
        down.scale.set(0.31, 0.31);
        this.addChild(down);

        const ani1Texture: Texture[] = [];
        for (let i = 0; i < 14; i++) {
            ani1Texture.push(RES.getRes(`fesRedBombSta3_${i}.png`));
        }
        this.ani1 = this.addChild(new FrameAni(ani1Texture));

        this.scale.set(0, 0);
    }

    playCall() {
        this.timeOut = setTimeout(() => {
            this.ani1.play(1, () => {
                this.playCall();
            });
        }, 1500);
    }

    reset() {
        Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 270, Ease.backOut)
            .call(() => {
                this.playCall();
            });
    }

    play(callback: Function) {
    }
}
