import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";

import { Element } from "../class/Element";
import { Tool } from "../Tool";
import { ElementType } from "../enum/ElementType";
import { RES } from "../../../module/RES";
import Texture = FYGE.Texture;

/**
 * 需要回调的
 * 手动修改this.shoot.rotation=
 */
export class FesRedShootAni extends FYGE.Container {
    light: LightingAni;
    imageAni: FYGE.FrameAni;
    imageAniCon: FYGE.Container

    constructor() {
        super();

        this.light = new LightingAni();
        this.addChild(this.light);
        const arr = [];
        for (let i = 1; i <= 10; i++) {
            arr.push(RES.getRes("fesEleSmallDis" + i + ".png"));
        }
        this.imageAniCon = new FYGE.Container();
        this.imageAni = new FYGE.FrameAni(arr);
        this.imageAniCon.addChild(this.imageAni);
        this.addChild(this.imageAniCon);
        this.imageAni.visible = false;

    }

    reset() {
        this.light.visible = true;
        this.imageAni.visible = false;
        this.light.scaleX = 0.2;
    }

    play(startP: number[], ele: Element, callback: Function) {

        this.reset()

        this.light.visible = true;
        //算角度
        const r = Tool.getForwardRotation(startP, [ele.x, ele.y]);
        this.light.rotation = r * 180 / Math.PI;
        this.light.x = startP[0];
        this.light.y = startP[1];
        this.imageAniCon.x = ele.x;
        this.imageAniCon.y = ele.y;
        //247
        const dis = Math.sqrt(
            (startP[0] - ele.x) * (startP[0] - ele.x) +
            (startP[1] - ele.y) * (startP[1] - ele.y)
        );
        const scaleX = dis / 247;
        FYGE.Tween.get(this.light)
            .to({scaleX: scaleX,}, 400)
            .call(() => {
                ele.reset(ElementType.FESTIVALELE_SMALL);
                ele.scaleX = ele.scaleY = 0.1
                FYGE.Tween.get(ele)
                    .to({scaleX: 1, scaleY: 1}, 500, FYGE.Ease.backOut)

                //回调
                callback();

                this.imageAni.visible = true;
                this.imageAni.play(1, () => {
                    if (this.parent) {
                        this.parent.removeChild(this)
                    }
                    Pool.recover(RecoverName.FESREDSHOOT_ANI, this)
                })
                setTimeout(() => {
                    this.light.visible = false;
                }, 200)

            });
    }
}


class LightingAni extends FYGE.Sprite {
    sourceAll: Texture[];
    currentFrame: number;
    totalFrames: number;
    isPlay: boolean;

    startTime: number
    /**
     * 所有时间，帧数按每秒30
     */
    allTime: number

    /**
     * 播放完的回调
     */
    constructor() {
        super();
        const arr = [];
        for (let i = 1; i <= 13; i++) {
            arr.push(RES.getRes("lineLight" + i + ".png"))
        }
        this.anchorTexture.set(23 / 293, 27 / 58)
        // this.anchorOffsetX = 23;
        // this.anchorOffsetY = 27;
        this.sourceAll = arr;
        this.texture = this.sourceAll[0];
        this.currentFrame = 0;
        this.totalFrames = arr.length;
        this.addEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this)

        this.startTime = Date.now()
        this.allTime = this.sourceAll.length / 30 * 1000;

    }

    onEnterFrame() {
        if (!this.stage) return
        const dataNow = Date.now();
        const deltaTime = dataNow - this.startTime;
        const scale = deltaTime / this.allTime;
        if (scale >= 1) {
            this.startTime = Date.now()
            this.currentFrame = 0;
        } else {
            this.currentFrame = (scale * this.sourceAll.length) >> 0;
        }
        this.texture = this.sourceAll[this.currentFrame];
    }
}

