import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { RES } from "../../../module/RES";


export class FesRedBombShowAni extends FYGE.Container {

    constructor() {
        super()

        const down = new FYGE.Sprite(RES.getRes("fesRedDown.png"));
        down.anchorTexture.set(0.5, 0.5);
        this.addChild(down);

        const textureDown: FYGE.Texture = RES.getRes("fesRedBombSta1.png")
        const up = new FYGE.Sprite(textureDown);
        up.anchorTexture.set(0.5, 0.5);
        this.addChild(up);
    }

    play(position: number[], callback: Function) {
        this.scaleX = this.scaleY = 0.29;

        this.x = position[0];
        this.y = position[1];
        FYGE.Tween.get(this)
            .wait(200)
            .to({scaleX: 1, scaleY: 1}, 500, FYGE.Ease.backOut)
            .wait(500)
            .to({scaleX: 0.29, scaleY: 0.29}, 500, FYGE.Ease.backInOut)
            .call(() => {
                if (this.parent) this.parent.removeChild(this);
                Pool.recover(RecoverName.FESREDBOMBSHOW_ANI, this);
                callback()
            })
    }
}
