import { Ani } from "../class/Ani";
import { RecoverName } from "../enum/RecoverName";
import { RES } from "../../../module/RES";
import Texture = FYGE.Texture;
import FrameAni = FYGE.FrameAni;


export class MagicLionAni extends Ani {
    downImage: FYGE.Container;
    upImage: FYGE.Sprite;

    magicAniActive:FrameAni;

    constructor() {
        super()
        this.aniName = RecoverName.MAGICLION_ANI//"MagicLionAni";

        this.downImage = new FYGE.Container();
        this.addChild(this.downImage)
        const texture: FYGE.Texture = RES.getRes("magicLionBg.png");
        let one = new FYGE.Sprite(texture);
        one.anchorTexture.set(0.5,0.5)
        this.downImage.addChild(one);
        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            one.rotation -= 5;
        }, this);

        let other = new FYGE.Sprite(texture);
        other.anchorTexture.set(0.5,0.5);
        this.downImage.addChild(other);
        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            other.rotation += 5;
        }, this);

        const magicAniActiveTexture: Texture[] = [];
        for (let i = 0; i <= 16; i++) {
            magicAniActiveTexture.push(RES.getRes(`MagicAniActive_${i}.png`));
        }

        this.magicAniActive = this.addChild(new FrameAni(magicAniActiveTexture));

        //上图
        this.upImage = new FYGE.Sprite(RES.getRes("magicLion.png"));
        this.upImage.anchorTexture.set(0.5,0.5);
        this.addChild(this.upImage);
    }

    play() {

        this.magicAniActive.play(1);

        this.downImage.scaleX = this.downImage.scaleY = 0.7;
        this.downImage.alpha = 1;
        this.upImage.scaleX = this.upImage.scaleY = 1;
        this.upImage.alpha = 1;
        FYGE.Tween.get(this.downImage)
            .to({ scaleX: 2, scaleY: 2 }, 400)
            .to({ scaleX: 1.2, scaleY: 1.2 }, 300)
            .wait(450)//和所有元素旋转时间一致，反正到时调整
            .to({ alpha: 0, scaleX: 0.2, scaleY: 0.2 }, 100)
            .call(() => {
                this.recover();
            })
        FYGE.Tween.get(this.upImage)
            .to({ scaleX: 1.7, scaleY: 1.7 }, 350)
            .wait(300)
            .to({ scaleX: 0, scaleY: 0, alpha: 0 }, 300)
    }

}
