
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { Tool } from "../Tool";
import { ElementType } from "../enum/ElementType";
import { RES } from "../../../module/RES";

//位置信息暂时都统一，因为现在所有基础5种元素的长宽都是90，如果以后基础元素图修改
const baseEleWidth = 80//90;
const baseEleHeight = 80//90;
//动画时间
const time = 300;

/**
 * 需要回调的
 * 变色气泡动画
 */
export class BubbleAni extends FYGE.Container {
    /**
     * 
     */
    private eleFrom: FYGE.Sprite;
    private eleTarget: FYGE.Sprite;
    /**
     * 气泡动画
     * 不用单独回收，整个用
     */
    private bubbleAni: FYGE.FrameAni;
    constructor() {
        super()
        this.eleFrom = new FYGE.Sprite();
        this.eleFrom.x = -baseEleWidth / 2;
        this.eleFrom.y = -baseEleHeight / 2;
        this.eleFrom.visible = false;
        this.addChild(this.eleFrom);
        this.eleTarget = new FYGE.Sprite();
        this.eleTarget.x = -baseEleWidth / 2;
        this.eleTarget.y = -baseEleHeight / 2;
        this.eleTarget.visible = false;
        this.addChild(this.eleTarget);

        //气泡动画
        var arr = [];
        for (var i = 1; i <= 19; i++) {
            arr.push(RES.getRes("bubbleStar" + i + ".png"));
        }
        this.bubbleAni = new FYGE.FrameAni(arr);
        this.bubbleAni.visible = false
        this.addChild(this.bubbleAni);
    }

    play(fromType: ElementType, targetType: ElementType, callback: Function) {
        this.eleFrom.texture = RES.getRes("bubleEle" + fromType + ".png");
        this.eleFrom.visible = true;
        this.eleFrom.alpha = 1;
        this.eleTarget.texture = RES.getRes("bubleEle" + targetType + ".png");
        this.eleTarget.visible = true;
        this.eleTarget.alpha = 0;
        //缩放，直接改自己的
        FYGE.Tween.get(this)
            .to({ scaleX: 0.96, scaleY: 1.02 }, 100)
            .to({ scaleX: 1.02, scaleY: 0.98 }, 100)
            .to({ scaleX: 0.98, scaleY: 1.02 }, 100)
            .to({ scaleX: 1, scaleY: 1 }, 100)
            .call(() => {
                //气泡
                //显示动画
                this.bubbleAni.visible = true;
                this.bubbleAni.play(1, () => {
                    //隐藏动画
                    this.bubbleAni.visible = false;
                })
                //透明度
                FYGE.Tween.get(this.eleTarget)
                    .to({ alpha: 1 }, 600)
                    .call(() => {
                        FYGE.Tween.get(this.eleFrom)
                            .to({ alpha: 0 }, 100)
                            .call(() => {
                                if (this.parent) {
                                    this.parent.removeChild(this)
                                };
                                Pool.recover(RecoverName.BUBBLE_ANI, this);
                                //回调
                                callback();
                            })
                    })
            })
    }
}