import Container = FYGE.Container;
import Button = FYGE.Button;
import TextField = FYGE.TextField;
import MouseEvent = FYGE.MouseEvent;
import VERTICAL_ALIGN = FYGE.VERTICAL_ALIGN;
import Sprite = FYGE.Sprite;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import { RES } from "../../../module/RES";
import { Tools } from "../../Tools";
import { showPanel, showToast } from "../../../module/ctrls";
import { RulePanel } from "../../panels/RulePanel";
import { TaskPanel } from "../../panels/TaskPanel";
import { sendTbNet, TbNetName } from "../../TaoBaoNet";

export default class MapUI extends Container {
    public energyBox: EnergyBox = null;

    private myPrizeBtn: Button = null;
    private ruleBtn: Button = null;
    private taskBtn: Button = null;

    constructor() {
        super();

        this.initUi();
        this.initEvent();

    }

    private initEvent() {
        this.ruleBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
    }

    private removeEvent() {
        this.ruleBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
    }

    private clickBtn(e) {
        switch (e.target) {
            case this.ruleBtn:
                showPanel(RulePanel);
                break;
            case this.myPrizeBtn:
                console.log('我的奖品');
                sendTbNet(
                    TbNetName.navigateTo,
                    {url: '/pages/myprize/myprize'},
                    () => {
                    },
                    true
                );
                break;

            case this.taskBtn:
                if(!Tools.actStart){
                    showToast('活动未开始');
                    return;
                }
                if (Tools.actEnd) {
                    showToast('活动已结束');
                    return;
                }
                showPanel(TaskPanel);
                break;
        }
    }

    public destroy() {
        super.destroy();
        this.removeEvent();
    }

    private initUi() {
        // 我的奖品
        this.myPrizeBtn = this.addChild(new Button(RES.getRes('map_prizeBtn.png')));
        this.myPrizeBtn.position.set(16, 135);

        // 规则按钮
        this.ruleBtn = this.addChild(new Button(RES.getRes('map_ruleBtn.png')));
        this.ruleBtn.position.set(16, 57);

        // 任务按钮
        this.taskBtn = this.addChild(new Button(RES.getRes('map_taskBtn.png')));
        this.taskBtn.position.set(605, 145);
        this.taskBtn.addChild(Tools.getSprite('map_taskBtn_tip.png', -131, 8));

        this.energyBox = this.addChild(new EnergyBox({}));
    }

    public updateUI() {
        sendTbNet(TbNetName.getPower, {},
            (success, res) => {
                this.energyBox.count = Tools.propInfo.power;
                if (!success) return;
                this.energyBox.count = Tools.propInfo.power = res.data.power;
            }
        );
    }
}

/**
 * 能量
 */
class EnergyBox extends Container {

    private countLabel: TextField = null;
    private lightImg: Sprite = null;

    private _count = 0;
    public set count(count: number) {
        this._count = count;
        this.countLabel.text = '' + count;
        this.doAlign();
    }

    constructor(data) {
        super();

        this.initUi(data);

    }

    private initUi(data) {
        this.position.set(549, 59);

        this.addChild(Tools.getSprite('map_energyBg.png'));

        this.countLabel = this.addChild(new TextField());
        this.countLabel.size = 30;
        this.countLabel.fillColor = '#ffffff';
        this.countLabel.textAlign = TEXT_ALIGN.CENTER;
        this.countLabel.y = 1;
        this.countLabel.textHeight = this.height;
        this.countLabel.verticalAlign = VERTICAL_ALIGN.MIDDLE;
        this.countLabel.strokeColor = '#1c7ab8';
        this.countLabel.bold = true;
        this.countLabel.stroke = 3;

        this.lightImg = this.addChild(Tools.getSprite('lightImg.png'));
        this.lightImg.y = 16;

        this.doAlign();
    }

    private doAlign() {
        const tW = this.countLabel.textWidth;
        const iW = this.lightImg.width;
        this.lightImg.x = (this.width - (tW + iW + 6)) / 2 + 2;
        this.countLabel.x = this.lightImg.x + this.lightImg.width + 6;
    }

    public destroy() {
        super.destroy();
    }
}
