import MapPart from "./MapPart";
import { RES } from "../../../module/RES";
import Point = FYGE.Point;
import { Tools } from "../../Tools";
import Texture = FYGE.Texture;
import FrameAni = FYGE.FrameAni;
import Tween = FYGE.Tween;

export default class MapTop extends MapPart {

    public static HEIGHT = 1218;

    public static totalCount = 6;

    public btnPos = [
        [374, 1114],
        [255, 1066],
        [196, 960],
        [312, 905],
        [392, 814],
        [492, 747],
    ];

    constructor(data) {
        super(data);

        this.data = data;

        this.bg.texture = RES.getRes('map_bg3.jpg');
        this.initIcon();
    }

    protected initEffect() {

        const treeTexture: Texture[] = [];
        for (let i = 0; i < 32; i++) {
            treeTexture.push(RES.getRes(`map_tree_${i}.png`));
        }

        for (let i = 32; i >= 0; i--) {
            treeTexture.push(RES.getRes(`map_tree_${i}.png`));
        }

        for (let i = 65; i < 120; i++) {
            treeTexture.push(RES.getRes(`map_tree_${0}.png`));
        }

        const treeEffect1 = this.addChild(new FrameAni(treeTexture));
        treeEffect1.frameRate = 20;
        treeEffect1.position.set(85, 913);
        treeEffect1.scaleX = -1;
        treeEffect1.play(-1);

        const treeEffect2 = this.addChild(new FrameAni(treeTexture));
        treeEffect2.position.set(729, 1068);
        treeEffect2.frameRate = 20;
        this.timeOutArr.push(
            setTimeout(() => {
                treeEffect2.play(-1);
            }, 1000)
        );

        const foot = this.addChild(Tools.getSprite('top_foot.png'));
        foot.position.set(-24, 758);

        const cloud = this.addChild(Tools.getSprite('cloud.png'));
        cloud.position.set(750, 50);
        Tween.get(cloud, {loop: true})
            .set({x: 750})
            .to({x: -692}, 50000)
            .wait(1000);
    }

    public update() {
        super.update();
        let up = this.localToGlobal(new Point(0, -10), new Point());
        let bp = this.localToGlobal(new Point(0, MapTop.HEIGHT + 10), new Point());
        let ucp = this.localToGlobal(new Point(0, MapTop.HEIGHT / 4), new Point());
        let bcp = this.localToGlobal(new Point(0, MapTop.HEIGHT / 4 * 3), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp);
    }

    public destroy() {
        super.destroy();
        this.timeOutArr.forEach(v => clearTimeout(v));
    }

}
