import MapPart from "./MapPart";
import { RES } from "../../../module/RES";
import Point = FYGE.Point;
import Texture = FYGE.Texture;
import FrameAni = FYGE.FrameAni;
import { Tools } from "../../Tools";

export default class MapMid extends MapPart {

    public static HEIGHT = 2222;

    public static totalCount = 18;

    protected btnPos = [
        [125, 2090],
        [56, 1969],
        [223, 1872],
        [316, 1741],
        [293, 1590],
        [289, 1423],
        [395, 1322],
        [437, 1193],
        [367, 1056],
        [307, 883],
        [218, 773],
        [340, 696],
        [429, 602],
        [412, 478],
        [306, 395],
        [238, 272],
        [296, 150],
        [265, 5],
    ];

    constructor(data) {
        super(data);
        this.data = data;

        this.bg.texture = RES.getRes('map_bg2.jpg');

        this.initIcon();
    }

    protected initEffect() {
        const mapCatTexture: Texture[] = [];
        for (let i = 0; i < 35; i++) {
            mapCatTexture.push(RES.getRes(`map_cat_${i}.png`));
        }

        const mapCat = this.addChild(new FrameAni(mapCatTexture));
        mapCat.position.set(650, 420);
        mapCat.play(-1);

        const tinyBalloonTexture: Texture[] = [];
        for (let i = 0; i <= 41; i++) {
            tinyBalloonTexture.push(RES.getRes(`tinyBalloon_${i}.png`));
        }

        for (let i = 41; i >= 0; i--) {
            tinyBalloonTexture.push(RES.getRes(`tinyBalloon_${i}.png`));
        }
        const tinyBalloon = this.addChild(new FrameAni(tinyBalloonTexture));
        tinyBalloon.position.set(180, 640);
        tinyBalloon.play(-1);

        const treeTexture: Texture[] = [];
        for (let i = 0; i <= 32; i++) {
            treeTexture.push(RES.getRes(`map_tree_${i}.png`));
        }

        for (let i = 32; i >= 0; i--) {
            treeTexture.push(RES.getRes(`map_tree_${i}.png`));
        }

        for (let i = 65; i < 120; i++) {
            treeTexture.push(RES.getRes(`map_tree_${0}.png`));
        }

        const treeEffect1 = this.addChild(new FrameAni(treeTexture));
        treeEffect1.frameRate = 20;
        treeEffect1.position.set(735, 400);
        treeEffect1.play(-1);

        const treeEffect2 = this.addChild(new FrameAni(treeTexture));
        treeEffect2.frameRate = 20;
        treeEffect2.position.set(30, 765);
        treeEffect2.scaleX = -1;
        this.timeOutArr.push(
            setTimeout(() => {
                treeEffect2.play(-1);
            }, 1200)
        );

        const treeEffect3 = this.addChild(new FrameAni(treeTexture));
        treeEffect3.frameRate = 20;
        treeEffect3.position.set(30, 1590);
        treeEffect3.scaleX = -1;
        treeEffect3.play(-1);
        this.timeOutArr.push(
            setTimeout(() => {
                treeEffect3.play(-1);
            }, 2000)
        );

        const treeEffect4 = this.addChild(new FrameAni(treeTexture));
        treeEffect4.frameRate = 20;
        treeEffect4.position.set(740, 1780);
        treeEffect4.scaleX = -1;
        treeEffect4.play(-1);
        this.timeOutArr.push(
            setTimeout(() => {
                treeEffect4.play(-1);
            }, 2500)
        );

        this.addChild(Tools.getSprite('薯片店.png', -80, 1570));

        const aromaTexture: Texture[] = [];
        for (let i = 0; i <= 18; i++) {
            aromaTexture.push(RES.getRes(`Aroma_1_${i}.png`));
        }

        for (let i = 19; i <= 100; i++) {
            aromaTexture.push(null);
        }

        const aroma = this.addChild(new FrameAni(aromaTexture));
        aroma.position.set(55, 1460);
        aroma.play(-1);

    }

    public update() {
        super.update();
        let up = this.localToGlobal(new Point(0, -10), new Point());
        let bp = this.localToGlobal(new Point(0, MapMid.HEIGHT + 10), new Point());
        let ucp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4), new Point());
        let bcp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4 * 3), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp);
    }


    public destroy() {
        super.destroy();
        this.timeOutArr.forEach(v => clearTimeout(v));
    }

}
