import MapPart from "./MapPart";
import { RES } from "../../../module/RES";
import Point = FYGE.Point;
import { Tools } from "../../Tools";
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;

export default class MapBottom extends MapPart {

    public static HEIGHT = 623;

    public static totalCount = 6;

    protected btnPos = [
        [358, 420],
        [241, 367],
        [256, 262],
        [337, 172],
        [307, 68],
        [207, 4],
    ];

    constructor(data) {
        super(data);
        this.data = data;

        this.bg.texture = RES.getRes('map_bg1.jpg');
        this.initIcon();
    }

    protected initEffect() {
        const balloon = this.addChild(Tools.getSprite('热气球.png'));
        balloon.position.set(19, 40);
        Tween.get(balloon, {loop: true})
            .to({y: -10}, 2500, Ease.quadInOut)
            .to({y: 40}, 2500, Ease.quadInOut);
    }

    public update() {
        super.update();
        let up = this.localToGlobal(new Point(0, -10), new Point());
        let bp = this.localToGlobal(new Point(0, MapBottom.HEIGHT + 10), new Point());
        let ucp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4), new Point());
        let bcp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4 * 3), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp);
    }

    public destroy() {
        super.destroy();
    }

}
