import Button = FYGE.Button;
import { RES } from "../../../module/RES";
import Container = FYGE.Container;
import Sprite = FYGE.Sprite;
import Texture = FYGE.Texture;
import TextField = FYGE.TextField;
import { Tools } from "../../Tools";
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import MouseEvent = FYGE.MouseEvent;
import Point = FYGE.Point;
import Tween = FYGE.Tween;
import { showPanel, showToast } from "../../../module/ctrls";
import { StartPanelPrize } from "../../panels/StartPanelPrize";

export enum CHECK_TYPE {
    COM,   // 普通
    CUR,    // 当前
}

export default class CheckBtn extends Container {

    public checkData: {
        level: number,
        scores: number,
        stars: number,
        isVisitSuccess: boolean
        isPlayed: boolean,
    } = {
        level: 1,
        scores: 0,
        stars: 0,
        isVisitSuccess: false,
        isPlayed: false,
    };

    private _sendAwardType: any;

    private btn: Button = null;
    private checkLabel: TextField = null;

    private star: CheckStar[] = null;

    private checkNum: number = null;
    private checkCurEffect: CheckCurEffect = null;

    private _data: any = null;
    public set data(data) {
        this._data = data;
        this.checkData.isPlayed = true;
        if (!data) return;
        if (!data.isVisitSuccess) return;
        this.enabled = data.isVisitSuccess;
        this.starCount = data.stars;

        this.checkData = data;
        this.checkData.isPlayed = true;

        this._sendAwardType = data.sendAwardType;
    }

    public get sendAwardType() {
        return this._sendAwardType;
    }

    private _starCount = 0;
    public set starCount(count: number) {
        if (count > 3) {
            count = 3;
        } else if (count < 1) {
            count = 1;
        }
        if (this._starCount == count) return;
        this._starCount = count;
        this.star.forEach((value, index) => {
            value.enabled = (index < count);
        });
    }

    public get starCount(): number {
        return this._starCount;
    }

    private _enabled: boolean = true;
    public set enabled(enabled: boolean) {
        if (this._enabled == enabled) return;
        this._enabled = enabled;

        this.btn.enabled = enabled;
        this.star.forEach(v => v.visible = enabled);
        this.checkLabel.visible = enabled;
    }

    // 按钮类型
    private _type: CHECK_TYPE = CHECK_TYPE.COM;
    public set type(type: CHECK_TYPE) {
        if (this._type == type) return;
        this._type = type;

        switch (type) {
            case CHECK_TYPE.COM:
                this.btn.changeTexture(
                    RES.getRes('map_check_enable.png'),
                    RES.getRes('map_check_enable.png'),
                    RES.getRes('map_check_disable.png'));
                this.checkLabel.strokeColor = '#316ec6';

                this.checkCurEffect.visible = false;
                this.checkCurEffect.stop();
                break;

            case CHECK_TYPE.CUR:
                this.btn.changeTexture(
                    RES.getRes('map_check_enable_cur.png'),
                    RES.getRes('map_check_enable_cur.png'),
                    RES.getRes('map_check_disable.png'));
                this.checkLabel.strokeColor = '#a55507';

                this.checkCurEffect.visible = true;
                this.checkCurEffect.play();
                break;
        }
    }

    public update() {
        super.update();
        let up = this.localToGlobal(new Point(), new Point());
        let bp = this.localToGlobal(new Point(0, 120), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up) || this.stage.viewRect.isPointIn(bp);
    }

    constructor(data) {
        super();
        this.initUi(data);
    }

    protected initUi(data) {
        this.btn = this.addChild(new Button(
            RES.getRes('map_check_enable.png'),
            RES.getRes('map_check_enable.png'),
            RES.getRes('map_check_disable.png')
        ));

        // 三个星星
        const star1 = this.addChild(new CheckStar());
        star1.position.set(16, 84);
        const star2 = this.addChild(new CheckStar());
        star2.position.set(42, 91);
        const star3 = this.addChild(new CheckStar());
        star3.position.set(67, 84);
        this.star = [star1, star2, star3];

        // 关卡文字
        this.checkNum = data.check;
        this.checkData.level = data.check;
        this.checkLabel = this.btn.addChild(Tools.getText(
            data.check, 30, '#ffffff',
            TEXT_ALIGN.CENTER, 90, 8, 33
        ));
        this.checkLabel.stroke = 2;
        this.checkLabel.strokeColor = '#d69422';

        // 当前关卡动画
        this.checkCurEffect = this.addChild(new CheckCurEffect());
        this.checkCurEffect.visible = false;

        this.enabled = false;   // 先设置成关闭

        // 点击事件
        this.btn.addEventListener(MouseEvent.CLICK, this.clickStart, this);

    }

    public clickStart() {
        if(!Tools.actStart){
            showToast('活动未开始');
            return;
        }
        if (Tools.actEnd) {
            showToast('活动已结束');
            return;
        }
        Tools.btnDelay(this, 200);
        console.log(`关卡:${this.checkNum}`);
        showPanel(StartPanelPrize, this.checkData);
    }
}

/**
 * 关卡按钮star
 */
class CheckStar extends Sprite {

    private static starEnableTexture: Texture = null;
    private static starDisableTexture: Texture = null;

    private _enabled: boolean = false;

    public set enabled(enabled: boolean) {
        this._enabled = enabled;
        this.texture = enabled ? CheckStar.starEnableTexture : CheckStar.starDisableTexture;
    }

    constructor() {
        super(RES.getRes('map_star_disable.png'));
        CheckStar.starDisableTexture = RES.getRes('map_star_disable.png');
        CheckStar.starEnableTexture = RES.getRes('map_star_enable.png');
    }

}

/**
 * 当前关卡的动画
 */
class CheckCurEffect extends Container {

    private light1: Sprite = null;
    private light2: Sprite = null;

    constructor() {
        super();

        this.light1 = this.addChild(Tools.getSprite('cur_light_1.png'));
        this.light2 = this.addChild(Tools.getSprite('cur_light_2.png'));
        this.light1.anchorTexture.set(0.5, 0.5);
        this.light2.anchorTexture.set(0.5, 0.5);

        this.position.set(55, 50);

        this.mouseEnable = this.mouseChildren = false;
    }

    public play() {

        Tween.get(this.light1, {loop: true})
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1.5, scaleY: 1.5}, 1300)
            .wait(700);

        Tween.get(this.light1, {loop: true})
            .set({alpha: 1})
            .wait(700)
            .to({alpha: 0}, 600)
            .wait(700)

        Tween.get(this.light2, {loop: true})
            .set({scaleX: 0.8, scaleY: 0.8})
            .to({scaleX: 1.3, scaleY: 1.3}, 1000)
            .wait(1000);

        Tween.get(this.light2, {loop: true})
            .set({alpha: 0})
            .to({alpha: 1}, 400)
            .to({alpha: 0}, 600)
            .wait(1000);

        return this;

    }

    public stop() {
        Tween.removeTweens(this.light1);
        Tween.removeTweens(this.light2);

        return this;
    }

}
