import { Scene } from "../../module/views/Scene";
import { Tools } from "../Tools";
import { ProgressBarS } from "../common/ProgressBarS";
import { RES } from "../../module/RES";
import { changeScene } from "../../module/ctrls";
import { MapScene } from "./map/MapScene";
import { layers } from "../../module/views/layers";
import { GTool } from "../../module/tools/GTool";
import { Lottie } from "../Lottie";
import { pop_laoding_bg } from "../lotties/pop_laoding_bg";
import { pop_loading_title } from "../lotties/pop_loading_title";
import Sprite = FYGE.Sprite;
import FrameAni = FYGE.FrameAni;

export class LoadingScene extends Scene {
    get groupNames() {
        return ["loadingScene", 'pop_laoding_bg', 'pop_loading_title']
    }

    progressBar: ProgressBarS;

    initUi() {
        //适配
        this.y = -layers.stageOffsetY
        //背景
        this.addChild(Sprite.fromFrame("loadingBg.jpg"))

        const loadingBg = this.addChild(new Lottie(pop_laoding_bg));
        loadingBg.play(-1);

        const loadingTitle = this.addChild(new Lottie(pop_loading_title));

        loadingTitle.play(1);

        //进度条底图
        this.addChild(Sprite.fromFrame("proDown.png"))
            .position.set((750 - 577) / 2, 1288 - 24)
        //进度条帧动画
        var arr = [];
        for (var i = 0; i <= 11; i++) arr.push(RES.getRes("loadingPro" + i + ".png"))
        var pro = this.addChild(new FrameAni(arr));
        pro.play(0)
        pro.position.set(375, 1288)//位置按正常满条的位置
        //@ts-ignore 进度条托管
        this.progressBar = new ProgressBarS(pro);

        //提示文案，随机文案待定
        this.addChild(Tools.getText(
            GTool.randomT([
                '游戏加载中...'
            ]),
            28,
            "#ae3830",
            FYGE.TEXT_ALIGN.CENTER,
            500,
            (750 - 500) / 2,
            1288 - 24 + 18 + 48
        ))
    }

    async start() {
        super.start()

        this.addEventListener(FYGE.Event.PROGRESS, this.progressEvent, this)
        //首次进度一点
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.2)

        //获取app数据
        await Tools.getAppData();

        this.dispatchEvent(FYGE.Event.PROGRESS, 0.3)
        //询问读取权限，不阻止进程
        // Tools.checkPermission();//这个需要吗？
        //获取首页数据
        //失败不进入

        // 游戏基本信息
        await Tools.getBaseInfo();

        this.dispatchEvent(FYGE.Event.PROGRESS, 0.5);

        //加载地图资源
        // await Promise.all([
        //     'map',
        //     'mapCrabEffect',
        //     'mapOwlEffect',
        //     'mapWhaleEffect',
        //     'mapCheckPrizeEffect'
        // ].map((e) => {
        //     return RES.loadGroup(e)
        // }))
        await RES.loadGroup("map");
        await RES.loadGroup("mapEffect");
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.6);
        await RES.loadGroup("mapTree");
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.7);
        await RES.loadGroup("mapCat");
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.8);
        await RES.loadGroup("mapAroma1");
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.9);
        await RES.loadGroup("mapTinyBalloon");

        this.dispatchEvent(FYGE.Event.PROGRESS, 1);
    }

    // private lastP=0
    progressEvent(e: FYGE.Event) {
        let pro = e.data;
        FYGE.Tween.get(this.progressBar, null, null, true)
            .to({value: pro}, 2000/**(p-this.lastP)*/)
            .call(() => {
                if (pro >= 1) {
                    this.removeEventListener(FYGE.Event.PROGRESS, this.progressEvent, this);
                    changeScene(MapScene, {from: "loading"})
                    // changeScene(LotteryScene,{level:1});
                }
            })
        // this.lastP=p
    }

    destroy() {
        //动效要去掉
        // FYGE.Tween.removeTweens()
        super.destroy()
        //到时如果内存炸了，考虑销毁用过的贴图缓存，待测试，在RES里写个根据销毁组内贴图的方法
    }
}
