import { Panel } from "../../module/views/Panel";
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import { SuccessStarGroup } from "./SuccessNoPrizePanel";
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import Sprite = FYGE.Sprite;
import { PropType } from "../something/enum/PropType";
import { RES } from "../../module/RES";
import { changeScene } from "../../module/ctrls";
import { MapScene } from "../scene/map/MapScene";
import MouseEvent = FYGE.MouseEvent;
import Button = FYGE.Button;
import Texture = FYGE.Texture;
import { sendTbNet, TbNetName } from "../TaoBaoNet";

const propImg = {
    [PropType.BOOMS]: 'boomBtn.png',
    [PropType.HAMMERS]: 'hammerBtn.png',
    [PropType.STEPS]: 'stepBtn.png',
    [PropType.POWER]:'power.png'
}

export class SuccessPrizePanel extends Panel {
    get groupNames() {
        return ['SuccessPanel', 'starLight']
    }

    get skinName() {
        return "SuccessPrizePanel"
    }

    public showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(() => {
                this.isShowing = false;
            });
    }

    closeBtn: FYGE.Button;
    tipsTex: FYGE.TextField;
    tipsTex2: FYGE.TextField;
    prizeImg: Sprite;

    private starGroup: SuccessStarGroup = null;

    initUi() {

        const { stars, tool, prize } = this.data;

        this.tipsTex.textWidth = 750;
        this.tipsTex.x = 0;
        this.tipsTex.textAlign = TEXT_ALIGN.CENTER;

        this.tipsTex2.textWidth = 750;
        this.tipsTex2.x = 0;
        this.tipsTex2.textAlign = TEXT_ALIGN.CENTER;

        this.starGroup = this.addChild(new SuccessStarGroup());
        this.starGroup.position.set(375, 663);

        this.prizeImg.anchorTexture.x = 0.5;
        this.prizeImg.x = 370;

        this.starGroup.play(stars);

        if (tool && tool.type) {
            this.tipsTex.text = '\t闯关成功！获得奖励：';
            this.prizeImg.scale.set(1.8, 1.8);
            this.prizeImg.texture = RES.getRes(propImg[tool.type]);
            if (stars == 3) {
                this.tipsTex2.visible = false;
                this.prizeImg.y = 879;
                this.addChild(new Button(RES.getRes('继续闯关大.png')))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(163, 1109);
            } else {
                this.tipsTex2.text = '满星通关可抽取更大奖励哦';
                this.addChild(new Button(RES.getRes('继续闯关小.png')))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(388, 1145);

                this.addChild(new Button(RES.getRes('闯关成功不满星按钮.png')))
                    .addEventListener(MouseEvent.CLICK, this.again, this)
                    .position.set(100, 1145);
            }
        } else if (prize && prize.image) {
            this.prizeImg.texture = Texture.fromUrl(prize.image);
            this.tipsTex2.text = '奖品可以在“我的奖品”页面查看';

            this.addChild(new Button(RES.getRes('继续闯关红.png')))
                .addEventListener(MouseEvent.CLICK, this.continue, this)
                .position.set(100, 1145);

            this.addChild(new Button(RES.getRes('查看奖品.png')))
                .addEventListener(MouseEvent.CLICK, this.lookPrize, this)
                .position.set(388, 1145);
        }
    }

    start(data) {
        super.start();
    }

    /**
     * 查看奖品
     */
    private lookPrize() {
        changeScene(MapScene, {doSomething:'toMyPrize'});
        // sendTbNet(
        //     TbNetName.navigateTo,
        //     { url: '/pages/myprize/myprize' },
        //     () => {
        //     },
        //     true
        // );
        super.hidePanel();
    }

    /**
     * 挑战满星
     */
    private again() {
        changeScene(MapScene, { level: this.data.level });
        super.hidePanel();
    }

    /**
     * 继续闯关
     */
    private continue() {
        if (this.data.level == 120) {
            changeScene(MapScene);
        } else {
            changeScene(MapScene, { level: this.data.level + 1 });
        }
        super.hidePanel();
    }

    public hidePanel() {
        changeScene(MapScene);
        super.hidePanel();
    }

    initEvents() {
        super.initEvents();
    }

    removeEvents() {
        super.removeEvents();
    }
}
