import { Panel } from "../../module/views/Panel";
import MouseEvent = FYGE.MouseEvent;
import { changeScene, showPanel } from "../../module/ctrls";
import { PlayScene } from "../scene/PlayScene";
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import Sprite = FYGE.Sprite;
import Texture = FYGE.Texture;
import { Tools } from "../Tools";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { NoEnergyPanel } from "./NoEnergyPanel";
import { ElementTargetData } from "../something/interface/ElementTargetData";
import Container = FYGE.Container;
import { getChapterData } from "../something/chapters/getChapter";

export class StartPanelPrize extends Panel {
    get groupNames() {
        return ["StartPanelPrize"]
    }

    get skinName() {
        return "StartPanelPrize"
    }

    public showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(() => {
                this.isShowing = false;
            });
    }

    closeBtn: FYGE.Button;
    startBtn: FYGE.Button;
    startBtn2: FYGE.Button;
    tipsTex: FYGE.TextField;
    checkTex: FYGE.TextField;
    prizeImg: Sprite;

    initUi() {

        const { level } = this.data;

        this.checkTex.textWidth = 750;
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;
        this.checkTex.x = 0;
        this.checkTex.text = `第\t${level}\t关`;
        this.checkTex.strokeColor = '#c95122';
        this.checkTex.stroke = 3;

        // this.startBtn.visible = !this.data.isPlayed;
        // this.startBtn2.visible = this.data.isPlayed;
        this.startBtn.visible = true;
        this.startBtn2.visible = false;

        this.addChild(new StartTarget(level))
            .position.set(0, 652);

        let prizeLevel = 50;
        if (level > 50 && level <= 100) {
            prizeLevel = 100;
        } else if (level > 100) {
            prizeLevel = 120;
        }
        this.prizeImg.texture = Texture.fromUrl(Tools.baseInfo.levelPrize[`level${prizeLevel}`]);
        this.prizeImg.anchorTexture.x = 0.5;
        this.prizeImg.x = 750 / 2;
    }

    start(data) {
        super.start();
    }

    private startGame() {
        const { level, isPlayed } = this.data;
        this.enableMouseEvt(false);
        if (!isPlayed && Tools.propInfo.power <= 0) {// 体力不足
            this.enableMouseEvt(true);
            showPanel(NoEnergyPanel);
            this.hidePanel();
            return;
        }
        sendTbNet(TbNetName.dojoin, { level: level },
            (success, res) => {
                this.enableMouseEvt(true);
                if (!success) return;

                Tools.propInfo.power = res.data.power;
                changeScene(PlayScene, {
                    chapter: level,
                    isGiftPrizeLevel: res.data.isGiftPrizeLevel
                });
                this.hidePanel();
            }
        );
    }

    initEvents() {
        super.initEvents();
        this.startBtn.addEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.addEventListener(MouseEvent.CLICK, this.startGame, this);
    }

    removeEvents() {
        super.removeEvents();
        this.startBtn.removeEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.removeEventListener(MouseEvent.CLICK, this.startGame, this);
    }
}


const pos = [
    [325],
    [240, 410],
    [180, 325, 470],
]

export class StartTarget extends Container {
    constructor(checkNum: number) {
        super();

        const passTarget = getChapterData(checkNum).passTarget;
        if (passTarget.type == 0) { // 分数

        } else if (passTarget.type == 1) {  // 消除元素个数
            passTarget.elements.forEach((v, i) => {
                const targetItem = this.addChild(new StartTargetItem(v));
                targetItem.x = pos[passTarget.elements.length - 1][i];
                setTimeout(() => {
                    targetItem.playEffect();
                }, i * 200);
            });
        }

    }
}

export class StartTargetItem extends Container {

    constructor(data: ElementTargetData) {
        super();

        const targetImg = this.addChild(Tools.getSprite(`ele${data.type}.png`));
        targetImg.width = targetImg.height = 100;

        const targetTex = this.addChild(Tools.getText(
            `${data.count}`, 30, '#ffffff',
            TEXT_ALIGN.CENTER, 100, 0, 108
        ));
        targetTex.strokeColor = '#eb5b57';
        targetTex.stroke = 3;

        this.anchor.set(50, 79);
        this.scale.set(0, 0);

    }

    // 变大的动效
    public playEffect() {
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 500, Ease.backOut)
    }
}
