import { Panel } from "../../module/views/Panel";
import TextField = FYGE.TextField;
import TEXT_lINETYPE = FYGE.TEXT_lINETYPE;
import ScrollPage = FYGE.ScrollPage;
import { Tools } from "../Tools";
import Button = FYGE.Button;
import { RES } from "../../module/RES";
import MouseEvent = FYGE.MouseEvent;

export class RulePanel extends Panel {
    get groupNames() {
        return ["RulePanel"]
    }

    get skinName() {
        return "RulePanel"
    }

    closeBtn: FYGE.Button;
    closeBtn1: FYGE.Button;
    ruleTex: TextField;
    scroll: ScrollPage;

    initUi() {

    }

    start(data) {
        super.start();

        const rule = Tools.baseInfo.rule;
        this.ruleTex = this.addChild(Tools.getText(
            rule, 26, '#892a1a',
            FYGE.TEXT_ALIGN.LEFT, 570
        ));
        this.ruleTex.lineType = TEXT_lINETYPE.MULTI;

        this.scroll = this.addChild(new ScrollPage(
            570, 425, this.ruleTex.textHeight + 30
        ));
        this.scroll.position.set(100, 549);
        this.scroll.view.addChild(this.ruleTex);

        this.addChild(new Button(RES.getRes('liaojiele.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(165, 995);
    }

    initEvents() {
        super.initEvents();
    }

    removeEvents() {
        super.removeEvents();
    }
}
