import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { wait } from "../../module/ctrls";
import { GDispatcher } from "../Main";
import { G_EVENT } from "../common/G_EVENT";

export class JoinPanel extends Panel {
    get groupNames() {
        return ["JoinPanel"]
    }

    data: { url: string }

    initUi() {
        this.addChild(FYGE.Sprite.fromFrame("joinBg.png"))
        this.addChild(new FYGE.Button(RES.getRes("关闭按钮.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, () => { this.hidePanel(); }, this)
            .position.set(634, 472)

        this.addChild(new FYGE.Button(RES.getRes("joinBtn.png")))
            .addEventListener(FYGE.MouseEvent.CLICK, () => {
                this.enableMouseEvt(false);
                wait(() => { this.enableMouseEvt(true) }, 2000)
                sendTbNet(TbNetName.navigateToOutside, { url: this.data.url })
                //回来时关闭，回来讲道理必执行
                GDispatcher.once(G_EVENT.ON_SHOW, () => {
                    this.hidePanel();
                }, this)
            }, this)
            .position.set(166, 744)
    }

}
