import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { Tools } from "../Tools";
import { getTbData, TbNetName } from "../TaoBaoNet";
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import Sprite = FYGE.Sprite;
import MouseEvent = FYGE.MouseEvent;
import Button = FYGE.Button;

export class FesRedPrizePanel extends Panel {
    get groupNames() {
        return ['FesRedPrizePanel']
    }

    public showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 400, Ease.backOut)
            .call(() => {
                this.isShowing = false;
            });
    }

    closeBtn: FYGE.Button;
    btn: Button;
    img: Sprite;

    initUi() {

        // const {stars, tool, prize} = this.data;

        this.addChild(Tools.getSprite('FesRedPrizeBg.png'))
            .position.set(53, 209);

        this.addChild(new Button(RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(625, 431);

        this.addChild(new Button(RES.getRes('开心收下.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(165, 1045);

        const res = getTbData(TbNetName.drawLotteryPrize);
        this.img = this.addChild(Sprite.fromUrl(res.data.image));
        this.img.anchorTexture.x = 0.5;
        this.img.position.set(375, 693);
        this.img.width = this.img.height = 252;
    }

    start(data) {
        super.start();
    }

    public hidePanel() {
        super.hidePanel();
        this.data.callback && this.data.callback();
    }

    initEvents() {
        super.initEvents();
    }

    removeEvents() {
        super.removeEvents();
    }
}
