import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import MouseEvent = FYGE.MouseEvent;
import { changeScene } from "../../module/ctrls";
import { MapScene } from "../scene/map/MapScene";

export class FailedPanel extends Panel {
    get groupNames() {
        return ["FailedPanel"]
    }

    get skinName() {
        return "FailedPanel"
    }

    againBtn: FYGE.Button;
    closeBtn: FYGE.Button;

    initUi() {
    }

    start(data) {
        super.start();
    }

    public hidePanel() {
        changeScene(MapScene);
        super.hidePanel();
    }

    public again() {
        changeScene(MapScene, {level: this.data.level});
        super.hidePanel();
    }

    initEvents() {
        super.initEvents();
        this.againBtn.addEventListener(MouseEvent.CLICK, this.again, this);
    }

    removeEvents() {
        super.removeEvents();
        this.againBtn.removeEventListener(MouseEvent.CLICK, this.again, this);
    }
}
