
var fs = require("fs");
var exec = require('child_process').exec;
var iconv = require('iconv-lite');
var del = require('del');
const join = require('path').join;

//写入图集的文件夹
var outPath = "./released/resource/";
//读取散图的文件夹
var readPath = "./released/tm/";

var files = fs.readdirSync(readPath);
files.forEach(function (file) {
  //路径
  let fPath = join(readPath, file);
  //只处理文件夹
  if (fs.statSync(fPath).isDirectory()) {

    //判断文件夹内是否有图片
    if (!judgeHasImage(fPath)) return;

    var cli = getTmCmd(fPath, outPath + file + "/", file);
    //如果文件夹不存在
    if (!fs.existsSync(outPath + file)) {
      fs.mkdirSync(outPath + file);
    }
    else {
      //图集文件存在就删除
      if (fs.existsSync(outPath + file + "/" + file + ".json")) {
        del(outPath + file + "/" + file + ".json")
      }
      if (fs.existsSync(outPath + file + "/" + file + ".png")) {
        del(outPath + file + "/" + file + ".png")
      }
    }

    //执行合图指令
    exec(cli, { encoding: 'utf8' }, function (err, stdout, stderr) {
      if (err) {
        console.log(err);
        return;
      }
      // console.log('stdout:' + stdout);
      // console.log('stderr:' + stderr);
      console.log('生成图集:' + file);

      var pathname = outPath + file + "/" + file + ".json";
      //有中文命名时处理
      var data = iconv.decode(fs.readFileSync(pathname), "utf-8");//GBK，window版本只能GBK，TexturePacker版本问题，mac改成utf-8
      // console.log(data)
      //反序列化
      data = JSON.parse(data); //eval(data)
      //重写数据
      var obj = {};
      var frames = data.frames;
      var frameKeys = Object.keys(frames);
      for (var i = 0; i < frameKeys.length; i++) {
        const name = frameKeys[i];
        const data = frames[name];
        if (!data.frame) continue;
        const sourceSize = data.trimmed !== false && data.sourceSize
          ? data.sourceSize : data.frame;
        obj[name] = {
          "x": data.frame.x,
          "y": data.frame.y,
          "w": data.frame.w,
          "h": data.frame.h,
          "ox": data.trimmed ? data.spriteSourceSize.x : 0,
          "oy": data.trimmed ? data.spriteSourceSize.y : 0,
          "sw": sourceSize.w,
          "sh": sourceSize.h,
          "ro": data.rotated,
        }
      }
      //序列化，不格式化，节省内存
      fs.writeFileSync(pathname, JSON.stringify(obj, "", "\t"));
    })
  }
})

//不同版本参数可能不同，具体情况具体分析
function getTmCmd(src, outPath, name) {
  var cli =
    'TexturePacker ' + //基础指令
    src +  //要合图集的文件夹路径
    ' --format json' + //图集数据格式
    ' --max-size 4096' + //最大尺寸
    ' --allow-free-size' +//允许使用最小尺寸输出，webgl最好别设置，现在小程序只有canvas模式，所以用最小尺寸导出吧
    ' --shape-padding 2' + //图片间隔
    ' --border-padding 2' + //边界间隔
    ' --enable-rotation' + //旋转 diable-rotation
    ' --opt RGBA8888' +  //图片像素格式
    ' --trim' + //裁切透明像素 no-trim
    ' --sheet ' + outPath + name + '.png' + //图片名字
    ' --data ' + outPath + name + '.json'; //数据名字
  return cli
}

/**
 * 对文件使用utf8编码
 * @param {string} pathname
 */
function applyUtf8(pathname) {
  fs.writeFile(pathname, iconv.decode(fs.readFileSync(pathname), "GBK"), {
    encoding: "UTF8"
  }, function (err) {
    if (err) {
      throw err;
    }
  });
}

/**
 * 判断文件夹内是否有图片
 * @param {*} path
 */
function judgeHasImage(path) {
  var files = fs.readdirSync(path);
  for (var i = 0; i < files.length; i++) {
    var itm = files[i]
    var stat = fs.statSync(path + "/" + itm);
    if (stat.isDirectory()) {
      //递归读取文件
      if (judgeHasImage(path + "/" + itm + "/")) return true;
    } else {
      if (itm.substr(-4) == ".jpg" || itm.substr(-4) == ".png") return true;
    }
  }
  return false;
}
