var fs = require("fs");

//测试脚本，白鹭的图集格式转fyge的图集格式

var readPath = "./scripts/";

var writePath = "./psd/"

//取指令后的参数
let arg = process.argv.splice(2);
//json名字
var jsonName = arg[0];

var data = fs.readFileSync(readPath + jsonName + ".json");

//反序列化
data = JSON.parse(data);

let frames = data.frames;

var obj = {};

for (var key in frames) {
    let f = frames[key];
    obj[jsonName + key + ".png"] = {
        "x": f.x,
        "y": f.y,
        "w": f.w,
        "h": f.h,
        "ox": f.offX,
        "oy": f.offY,
        "sw": f.sourceW,
        "sh": f.sourceH,
        "ro": false,
    }
}
//写入
fs.writeFileSync(writePath + jsonName + ".json", JSON.stringify(obj, "", "\t"));

//例子json
// {"file":"coin.png","frames":{
//     "8":{"x":0,"y":0,"w":109,"h":112,"offX":3,"offY":1,"sourceW":115,"sourceH":115},
//     "4":{"x":67,"y":340,"w":65,"h":113,"offX":25,"offY":1,"sourceW":115,"sourceH":115},
//     "5":{"x":222,"y":0,"w":24,"h":108,"offX":45,"offY":3,"sourceW":115,"sourceH":115},
//     "7":{"x":0,"y":114,"w":94,"h":113,"offX":10,"offY":1,"sourceW":115,"sourceH":115},
//     "6":{"x":0,"y":229,"w":65,"h":114,"offX":25,"offY":0,"sourceW":115,"sourceH":115},
//     "2":{"x":111,"y":0,"w":109,"h":111,"offX":3,"offY":2,"sourceW":115,"sourceH":115},
//     "3":{"x":96,"y":225,"w":94,"h":113,"offX":10,"offY":1,"sourceW":115,"sourceH":115},
//     "1":{"x":111,"y":113,"w":109,"h":110,"offX":3,"offY":2,"sourceW":115,"sourceH":115}}}