(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/Main.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./module/RES.ts":
/*!***********************!*\
  !*** ./module/RES.ts ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var RES;
(function (RES) {
    var resData;
    var videoEntityHash = {};
    var soundHash = {};
    var groupsCompleteHash = {};
    var groupsPromiseHash = {};
    var singleResPromiseHash = {};
    function loadConfig(res) {
        resData = res;
        RES.resPath = res.path;
    }
    RES.loadConfig = loadConfig;
    function loadGroup(name) {
        if (groupsCompleteHash[name]) {
            return new Promise(function (resolve) {
                resolve();
            });
        }
        if (groupsPromiseHash[name]) {
            return groupsPromiseHash[name];
        }
        var arr = getGroupResByName(name);
        if (!arr || !arr.length) {
            groupsCompleteHash[name] = true;
            return new Promise(function (resolve) {
                resolve();
            });
        }
        var p = new Promise(function (resolve, reject) {
            loadResList(function (s) {
                delete groupsPromiseHash[name];
                if (s) {
                    groupsCompleteHash[name] = true;
                    resolve();
                }
                else {
                    reject();
                }
            }, arr);
        });
        groupsPromiseHash[name] = p;
        return p;
    }
    RES.loadGroup = loadGroup;
    function getResAsync(str, comFun, thisObj) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            if (FYGE.TextureCache[str]) {
                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                new Promise(function (r) {
                    r(FYGE.TextureCache[str]);
                });
            }
            else if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                if (groupName && type != "jpg") {
                    var group = getGroupByName(groupName);
                    if (group && group.atlas) {
                        var json = groupName + ".json";
                        if (singleResPromiseHash[json]) {
                            return singleResPromiseHash[json].then(function (r) {
                                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                                return FYGE.TextureCache[str];
                            }, function () {
                                comFun && comFun.call(thisObj, null, str);
                                return null;
                            });
                        }
                        else {
                            return getResAsync(json)
                                .then(function () {
                                comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                                return FYGE.TextureCache[str];
                            }, function () {
                                comFun && comFun.call(thisObj, null, str);
                                return null;
                            });
                        }
                    }
                }
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    FYGE.GlobalLoader.loadImage(function (s, image) {
                        delete singleResPromiseHash[str];
                        if (s) {
                            FYGE.Texture.addToCache(FYGE.Texture.from(image), str);
                            comFun && comFun.call(thisObj, FYGE.TextureCache[str], str);
                            resolve(FYGE.TextureCache[str]);
                        }
                        else {
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src);
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
        else if (type == "svga") {
            if (videoEntityHash[str]) {
                comFun && comFun.call(thisObj, videoEntityHash[str], str);
                return new Promise(function (r) {
                    r(videoEntityHash[str]);
                });
            }
            else if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    FYGE.GlobalLoader.loadSvga(function (s, v) {
                        delete singleResPromiseHash[str];
                        if (s) {
                            if (s)
                                videoEntityHash[str] = v;
                            comFun && comFun.call(thisObj, v, str);
                            resolve(v);
                        }
                        else {
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src);
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
        else if (type == "json") {
            if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    var jsonData = getGroupByName(groupName).atlas;
                    FYGE.GlobalLoader.loadImage(function (s, data) {
                        if (s) {
                            var t = FYGE.createTextureSheet(new FYGE.BaseTexture(data), jsonData);
                            comFun && comFun.call(thisObj, t, str);
                            resolve(t);
                        }
                        else {
                            delete singleResPromiseHash[str];
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src.replace("json", "png"));
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
    }
    RES.getResAsync = getResAsync;
    function getResByUrl() {
    }
    RES.getResByUrl = getResByUrl;
    function getRes(str) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            return FYGE.TextureCache[str] || null;
        }
        else if (type == "svga") {
            return videoEntityHash[str] || null;
        }
        else if (type == "mp3") {
            return soundHash[str] || null;
        }
    }
    RES.getRes = getRes;
    function hasRes(str) {
        for (var i = 0; i < resData.groups.length; i++) {
            var group = resData.groups[i];
            var keys = group.keys;
            if (keys && keys.split(",").indexOf(str) > -1) {
                return group.name;
            }
            if (group.atlas && group.name + ".json" == str) {
                return group.name;
            }
        }
        return null;
    }
    function getGroupResByName(name) {
        var group = getGroupByName(name);
        if (!group)
            return null;
        if (group.atlas) {
            var arr = [name + ".json"];
            if (group.keys) {
                arr = arr.concat(group.keys.split(",").filter(function (k) {
                    return k.substr(-4) != ".png";
                }));
            }
            return arr;
        }
        else if (group.keys) {
            return group.keys.split(",");
        }
        else {
            return null;
        }
    }
    RES.getGroupResByName = getGroupResByName;
    function destroyGroup(name) {
        var group = getGroupByName(name);
        if (!group)
            return;
        var arr = [];
        if (group.keys) {
            arr = group.keys.split(",");
        }
        var removed = [];
        for (var i = 0; i < arr.length; i++) {
            var t = getRes(arr[i]);
            if (t) {
                if (removed.indexOf(t.baseTexture) == -1) {
                    t.baseTexture.destroy();
                    removed.push();
                }
                t.destroy();
            }
        }
    }
    RES.destroyGroup = destroyGroup;
    function getGroupByName(name) {
        var groups = resData.groups;
        var group;
        for (var i = 0; i < groups.length; i++) {
            if (groups[i].name === name) {
                group = groups[i];
                break;
            }
        }
        return group;
    }
    function loadResList(callback, arr) {
        var count = 0;
        var countAll = arr.length;
        if (!countAll)
            callback(true);
        var mark = true;
        for (var i = 0; i < countAll; i++) {
            var resName = arr[i];
            getResAsync(resName, function (res, str) {
                if (!res)
                    mark = false;
                if (++count == countAll)
                    callback(mark);
            }, this);
        }
    }
    function returnSingleResPromise(str, comFun, thisObj) {
        singleResPromiseHash[str].then(function (r) {
            comFun && comFun.call(thisObj, r, str);
        }, function () {
            comFun && comFun.call(thisObj, null, str);
        });
        return singleResPromiseHash[str];
    }
    var skinData;
    function loadSkinConfig(skinJson) {
        skinData = skinJson;
    }
    RES.loadSkinConfig = loadSkinConfig;
    function initSkinDisplay(con, skin, root) {
        var data = typeof (skin) == 'string' ? getSkinDataByName(skin) : skin;
        if (!data.children || !data.children.length)
            return;
        for (var i = 0; i < data.children.length; i++) {
            var child = data.children[i];
            if (child.type == "skin")
                continue;
            var dis = con.addChild(getDisplayByData(child));
            if (root && child.id)
                root[child.id] = dis;
            if (child.type == "container")
                initSkinDisplay(dis, child, root);
        }
    }
    RES.initSkinDisplay = initSkinDisplay;
    function getSkinDataByName(skinName, skinNode) {
        if (skinNode === void 0) { skinNode = skinData; }
        if (!skinNode || !skinNode.children || !skinNode.children.length)
            return null;
        for (var i = 0; i < skinNode.children.length; i++) {
            var child = skinNode.children[i];
            if (child.name == skinName && (child.type == "container" || child.type == "skin"))
                return child;
            var gson = getSkinDataByName(skinName, child);
            if (gson)
                return gson;
        }
        return null;
    }
    RES.getSkinDataByName = getSkinDataByName;
    function getDisplayByData(data) {
        var dis;
        switch (data.type) {
            case "container":
                dis = new FYGE.Container();
                break;
            case "button":
                dis = new FYGE.Button(getRes(data.props.tUp), data.props.tDown ? getRes(data.props.tDown) : null, data.props.tDisable ? getRes(data.props.tDisable) : null);
                break;
            case "text":
                dis = new FYGE.TextField();
                for (var key in data.props)
                    dis[key] = data.props[key];
                break;
            case "sprite":
                dis = new FYGE.Sprite(getRes(data.props.source));
                break;
            case "rect":
                dis = new FYGE.Shape();
                dis.beginFill(FYGE.string2hex(data.props.fillColor));
                dis.drawRect(0, 0, data.props.width, data.props.height);
                dis.endFill();
                break;
        }
        dis.name = data.name;
        dis.alpha = data.alpha || 1;
        dis.position.set(data.x, data.y);
        return dis;
    }
    function destroyRES() {
    }
})(RES = exports.RES || (exports.RES = {}));


/***/ }),

/***/ "./module/ctrls/index.ts":
/*!*******************************!*\
  !*** ./module/ctrls/index.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var panelCtrl_1 = __webpack_require__(/*! ./panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ./sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var toastCtrl_2 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
exports.showToast = toastCtrl_2.showToast;
__export(__webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts"));
exports.showPanel = function (panel, data) {
    return panelCtrl_1.default.instance.show(panel, data);
};
exports.showConfirm = function (panel, data) {
    var confirmPanel = panelCtrl_1.default.instance.show(panel, data);
    return confirmPanel.makePromise();
};
exports.closeAllPanels = function () {
    panelCtrl_1.default.instance.closeAll();
};
exports.closeCurrentPanel = function () {
    panelCtrl_1.default.instance.closeCurrent();
};
exports.changeScene = function (scene, data) {
    sceneCtrl_1.default.instance.change(scene, data);
};
function getCurrentScene() {
    return sceneCtrl_1.default.instance.currentScene;
}
exports.getCurrentScene = getCurrentScene;
exports.showAlert = function (title, content) {
    if (my) {
        my.alert({
            title: title || "",
            content: content || ""
        });
    }
    else {
        console.log(title, content);
    }
};
function wait(callback, time) {
    var obj = {};
    FYGE.Tween.get(obj)
        .wait(time)
        .call(callback);
    return obj;
}
exports.wait = wait;
function clearWait(obj) {
    obj && FYGE.Tween.removeTweens(obj);
}
exports.clearWait = clearWait;
function removeTweens(obj, isRecursive) {
    if (isRecursive === void 0) { isRecursive = true; }
    if (!obj)
        return;
    FYGE.Tween.removeTweens(obj);
    if (!isRecursive || !obj.children || !obj.children.length)
        return;
    obj.children.forEach(function (child) {
        removeTweens(child);
    });
}
exports.removeTweens = removeTweens;
function destroyAllCtrls() {
    toastCtrl_1.destroyToast();
    waitingCtrl_1.destroyWaiting();
    panelCtrl_1.default.instance.destroy();
    sceneCtrl_1.default.instance.destroy();
}
exports.destroyAllCtrls = destroyAllCtrls;


/***/ }),

/***/ "./module/ctrls/panelCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/panelCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var PanelCtrl = (function () {
    function PanelCtrl() {
        this.stacks = [];
    }
    Object.defineProperty(PanelCtrl, "instance", {
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: true,
        configurable: true
    });
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
        var bg = new FYGE.Shape();
        bg.beginFill(0);
        bg.drawRect(layers_1.layers.stageOffsetX - parent.x, layers_1.layers.stageOffsetY - parent.y, layers_1.layers.stageWidth, layers_1.layers.stageHeight);
        bg.endFill();
        bg.hitTestByPixel = false;
        bg.visible = false;
        this._parent.addChild(bg);
        this._bg = bg;
    };
    PanelCtrl.prototype.closeAll = function () {
        this.stacks.forEach(function (e) { return e.hidePanel(); });
    };
    PanelCtrl.prototype.show = function (cls, data) {
        var _this = this;
        waitingCtrl_1.showWaiting();
        var panel = new cls(data);
        this.add(panel);
        this.stacks.push(panel);
        panel.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            _this.updateView(false);
            panel.start(data);
            if (panel.visible)
                panel.showAni();
        };
        panel.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            panel.removeEventListener('onDestroy', _this.onPanelHide, _this);
            _this.remove(panel);
        };
        return panel;
    };
    PanelCtrl.prototype.updateView = function (showPanelAni) {
        var _this = this;
        if (showPanelAni === void 0) { showPanelAni = true; }
        if (!this.stacks.length) {
            if (this._bg.visible) {
                this.bgAni = "hide";
                FYGE.Tween.removeTweens(this._bg);
                FYGE.Tween.get(this._bg)
                    .to({ alpha: 0 }, 200, FYGE.Ease.cubicOut)
                    .call(function () {
                    _this._bg.visible = false;
                    _this._current = null;
                    _this._parent.visible = false;
                });
            }
        }
        else {
            this._parent.visible = true;
            if (this.bgAni == "hide") {
                this.bgAni = "show";
                FYGE.Tween.removeTweens(this._bg);
                this._bg.alpha = 0.7;
            }
            if (this._bg.visible === false) {
                this._bg.visible = true;
                this._bg.alpha = 0;
                FYGE.Tween.get(this._bg).to({ alpha: 0.7 }, 200, FYGE.Ease.cubicOut);
            }
        }
        for (var i = 0; i < this.stacks.length; i++) {
            if (i < this.stacks.length - 1) {
                this.stacks[i].visible = false;
            }
            else {
                this.stacks[i].visible = true;
                if (showPanelAni)
                    this.stacks[i].showAni();
                this._current = this.stacks[i];
            }
        }
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    PanelCtrl.prototype.remove = function (panel) {
        this._parent.removeChild(panel);
        this.stacks = this.stacks.filter(function (e) { return e != panel; });
    };
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this.updateView();
    };
    PanelCtrl.prototype.closeCurrent = function () {
        if (this._current) {
            this._current.hidePanel();
        }
    };
    PanelCtrl.prototype.destroy = function () {
        PanelCtrl._instance = null;
        this.stacks = null;
        this._current = null;
        this._parent = null;
        FYGE.Tween.removeTweens(this._bg);
        this._bg = null;
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;


/***/ }),

/***/ "./module/ctrls/sceneCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/sceneCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var SceneCtrl = (function () {
    function SceneCtrl() {
    }
    Object.defineProperty(SceneCtrl, "instance", {
        get: function () {
            return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl());
        },
        enumerable: true,
        configurable: true
    });
    SceneCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    SceneCtrl.prototype.change = function (cls, data) {
        var _this = this;
        var scene = new cls(data);
        scene.visible = false;
        waitingCtrl_1.showWaiting();
        var preScene = this._currentScene;
        scene.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            scene.showAni(function () {
                if (preScene)
                    preScene.destroy();
            });
            scene.visible = true;
            scene.start(data);
        };
        scene.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            _this._currentScene = preScene || null;
            _this._parent.removeChild(scene);
        };
        this._currentScene = scene;
        this._parent.addChild(scene);
    };
    Object.defineProperty(SceneCtrl.prototype, "currentScene", {
        get: function () {
            return this._currentScene;
        },
        enumerable: true,
        configurable: true
    });
    SceneCtrl.prototype.destroy = function () {
        SceneCtrl._instance = null;
        this._currentScene = null;
        this._parent = null;
    };
    return SceneCtrl;
}());
exports.default = SceneCtrl;


/***/ }),

/***/ "./module/ctrls/toastCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/toastCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var inited = false;
var _toast;
var _parent;
var startY;
var endY;
var initToast = function () {
    if (!inited) {
        inited = true;
        _toast = new Toast();
        _parent = layers_1.layers.toastLayer;
        _toast.alpha = 0;
        _toast.x = layers_1.layers.stageOffsetX - _parent.x + (layers_1.layers.stageWidth - _toast.width) / 2;
        var h = _toast.height;
        var y = layers_1.layers.stageOffsetY - _parent.y;
        startY = y - h;
        endY = y + (layers_1.layers.stageHeight - h) / 2;
    }
};
exports.showToast = function (msg) {
    initToast();
    _toast.show(msg);
    _parent.addChild(_toast);
    FYGE.Tween.removeTweens(_toast);
    FYGE.Tween.get(_toast)
        .set({ y: startY, alpha: 1 })
        .to({ y: endY }, 500, FYGE.Ease.quartOut)
        .wait(800)
        .to({ alpha: 0 }, 300)
        .call(function () {
        _parent.removeChild(_toast);
    });
};
exports.destroyToast = function () {
    if (inited && _toast && !_toast.destroyed) {
        _toast.destroy();
        _toast = null;
        _parent = null;
        inited = false;
    }
};
var Toast = (function (_super) {
    __extends(Toast, _super);
    function Toast() {
        var _this = _super.call(this) || this;
        _this.PADDING = 40;
        _this.mouseChildren = false;
        _this.mouseEnable = false;
        var toastBgTexture = RES_1.RES.getRes("toastBg.png");
        _this.bg = new FYGE.Sprite(toastBgTexture);
        _this.addChild(_this.bg);
        _this.msg = new FYGE.TextField();
        _this.msg.size = 28;
        _this.msg.fillColor = "0xffffff";
        _this.msg.text = "";
        _this.msg.verticalAlign = FYGE.VERTICAL_ALIGN.MIDDLE;
        _this.msg.textHeight = toastBgTexture.height;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.addChild(_this.msg);
        return _this;
    }
    Toast.prototype.show = function (msg) {
        this.msg.text = msg;
        this.msg.x = (this.bg.width - this.msg.textWidth) / 2;
    };
    Toast.prototype.destroy = function () {
        FYGE.Tween.removeTweens(this);
        _super.prototype.destroy.call(this);
        this.msg = null;
        this.bg = null;
    };
    return Toast;
}(FYGE.Container));


/***/ }),

/***/ "./module/ctrls/waitingCtrl.ts":
/*!*************************************!*\
  !*** ./module/ctrls/waitingCtrl.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var inited = false;
var _waiting;
var _parent;
var initWaiting = function () {
    if (!inited) {
        inited = true;
        var waiting = new Waiting();
        _parent = layers_1.layers.topLayer;
        _waiting = waiting;
        var offX = (layers_1.layers.stageWidth - 160) / 2;
        var offY = (layers_1.layers.stageHeight - _waiting.height) / 2;
        _waiting.x = layers_1.layers.stageOffsetX - _parent.x + offX;
        _waiting.y = layers_1.layers.stageOffsetY - _parent.y + offY;
        var bg = new FYGE.Graphics()
            .beginFill(0x000000)
            .drawRect(-offX, -offY, layers_1.layers.stageWidth, layers_1.layers.stageHeight)
            .endFill();
        bg.alpha = 0;
        _waiting.addChildAt(bg, 0);
    }
};
exports.showWaiting = function (msg) {
    initWaiting();
    _waiting.show(msg);
    _parent.addChild(_waiting);
};
exports.hideWaiting = function () {
    _parent.removeChild(_waiting);
};
exports.destroyWaiting = function () {
    if (inited && _waiting && !_waiting.destroyed) {
        _waiting.destroy();
        _waiting = null;
        _parent = null;
        inited = false;
    }
};
var Waiting = (function (_super) {
    __extends(Waiting, _super);
    function Waiting() {
        var _this = _super.call(this) || this;
        var rectBgTexture = RES_1.RES.getRes("waitingBg.png");
        var rectBg = new FYGE.Sprite(rectBgTexture);
        _this.addChild(rectBg);
        var rotTexture = RES_1.RES.getRes("waitingRot.png");
        var rot = new FYGE.Sprite(rotTexture);
        rot.x = (rectBgTexture.width - rotTexture.width) / 2;
        rot.y = 47;
        rot.anchorX = rotTexture.width / 2;
        rot.anchorY = rotTexture.height / 2;
        _this.addChild(rot);
        var count = 0;
        rot.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            count++;
            if (count % 30 == 0)
                rot.rotation += 45;
        }, _this);
        _this.msg = new FYGE.TextField();
        _this.msg.y = 125;
        _this.msg.textWidth = rectBgTexture.width;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.msg.size = 26;
        _this.msg.fillColor = "#ffffff";
        _this.addChild(_this.msg);
        return _this;
    }
    Waiting.prototype.show = function (msg) {
        if (msg === void 0) { msg = "加载中"; }
        this.msg.text = msg;
    };
    Waiting.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.msg = null;
    };
    return Waiting;
}(FYGE.Container));


/***/ }),

/***/ "./module/tools/GTool.ts":
/*!*******************************!*\
  !*** ./module/tools/GTool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var GTool = (function () {
    function GTool() {
    }
    GTool.changeURLArg = function (url, arg, arg_val) {
        var pattern = arg + '=([^&]*)';
        var replaceText = arg + '=' + arg_val;
        if (url.match(pattern)) {
            var tmp = '/(' + arg + '=)([^&]*)/gi';
            tmp = url.replace(new RegExp(tmp), replaceText);
            return tmp;
        }
        else {
            if (url.match('[\?]')) {
                return url + '&' + replaceText;
            }
            else {
                return url + '?' + replaceText;
            }
        }
    };
    GTool.readCache = function (key) {
        return my ? my.getStorageSync({ key: key }).data : localStorage.getItem(key);
    };
    GTool.writeCache = function (key, value) {
        if (value === void 0) { value = 'true'; }
        my ? my.setStorageSync({ key: key, data: value }) : localStorage.setItem(key, value);
    };
    GTool.returnTodayTimes = function (cacheKey) {
        var year1 = this.readCache("year" + cacheKey);
        var month1 = this.readCache("month" + cacheKey);
        var day1 = this.readCache("day" + cacheKey);
        var date = new Date();
        var year2 = date.getFullYear().toString();
        var month2 = date.getMonth().toString();
        var day2 = date.getDate().toString();
        if (this.int(year2) <= this.int(year1)) {
            if (this.int(month2) <= this.int(month1)) {
                if (this.int(day2) <= this.int(day1)) {
                    return this.int(this.readCache(cacheKey));
                }
            }
        }
        var today = "0";
        this.writeCache("year" + cacheKey, year2);
        this.writeCache("month" + cacheKey, month2);
        this.writeCache("day" + cacheKey, day2);
        this.writeCache(cacheKey, today);
        return 0;
    };
    GTool.randomT = function (e, n) {
        return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e));
    };
    GTool.removeEle = function (e, arr) {
        var index = arr.indexOf(e);
        if (index >= 0) {
            arr.splice(index, 1);
        }
    };
    GTool.insert = function (num, arr) {
        for (var i = arr.length - 1; i >= 0; i--) {
            if (num > arr[i]) {
                arr.splice(i + 1, 0, num);
                break;
            }
        }
    };
    GTool.getRandomNumber = function (start, end, n) {
        var arr = [];
        for (var i = 0; i < n; i++) {
            var number = Math.floor(Math.random() * (end - start + 1) + start);
            if (arr.indexOf(number) < 0) {
                arr.push(number);
            }
            else {
                i--;
            }
        }
        return arr;
    };
    GTool.disturbNumberArr = function (arr) {
        arr.sort(function () {
            return (0.5 - Math.random());
        });
    };
    GTool.disturbArr = function (arr) {
        return arr.sort(function () {
            return (0.5 - Math.random());
        });
    };
    GTool.getRandomArrayElements = function (arr, count) {
        var shuffled = arr.slice(0), i = arr.length, min = i - count, temp, index;
        if (min <= 0)
            return shuffled;
        if (count <= 0)
            return [];
        while (i-- > min) {
            index = Math.floor((i + 1) * Math.random());
            temp = shuffled[index];
            shuffled[index] = shuffled[i];
            shuffled[i] = temp;
        }
        return shuffled.slice(min);
    };
    GTool.getRandomArrayElementsEx = function (arr, count) {
        if (arr.length <= count)
            return arr.slice();
        if (count <= 0)
            return [];
        var arrCopy = arr.slice();
        var outArr = [];
        while (count--) {
            var rand = Math.floor(Math.random() * arrCopy.length);
            var ele = arrCopy.splice(rand, 1)[0];
            outArr.push(ele);
        }
        return outArr;
    };
    GTool.int = function (n) {
        return n >> 0;
    };
    ;
    GTool.addSpaceInString = function (str) {
        if (!str.length || str.length == 1)
            return str;
        var txt = "";
        for (var i = 0; i < str.length - 1; i++) {
            txt = txt + str[i] + " ";
        }
        txt = txt + str[str.length - 1];
        return txt;
    };
    GTool.getShiFenMiaoByTimeStamp = function (timeStamp) {
        var hours = Math.floor((timeStamp % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((timeStamp % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((timeStamp % (1000 * 60)) / 1000);
        hours = hours < 10 ? ('0' + hours) : hours;
        minutes = minutes < 10 ? ('0' + minutes) : minutes;
        seconds = seconds < 10 && seconds >= 1 ? ('0' + seconds) : seconds;
        return hours + "小时" + minutes + "分" + seconds + "秒";
    };
    GTool.emojiReg = /[\uD83C|\uD83D|\uD83E][\uDC00-\uDFFF][\u200D|\uFE0F]|[\uD83C|\uD83D|\uD83E][\uDC00-\uDFFF]|[0-9|*|#]\uFE0F\u20E3|[0-9|#]\u20E3|[\u203C-\u3299]\uFE0F\u200D|[\u203C-\u3299]\uFE0F|[\u2122-\u2B55]|\u303D|[\A9|\AE]\u3030|\uA9|\uAE|\u3030/ig;
    return GTool;
}());
exports.GTool = GTool;


/***/ }),

/***/ "./module/views/Item.ts":
/*!******************************!*\
  !*** ./module/views/Item.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var Item = (function (_super) {
    __extends(Item, _super);
    function Item(data) {
        var _this = _super.call(this) || this;
        if (_this.skinName)
            RES_1.RES.initSkinDisplay(_this, _this.skinName, _this);
        setTimeout(function () { _this.initUi(data); });
        return _this;
    }
    Object.defineProperty(Item.prototype, "skinName", {
        get: function () { return null; },
        enumerable: true,
        configurable: true
    });
    ;
    Item.prototype.initUi = function (data) {
    };
    Item.prototype.updateData = function (data) {
    };
    Item.prototype.initData = function (id, data) {
        this.resetData();
    };
    Item.prototype.resetData = function () {
    };
    return Item;
}(FYGE.Container));
exports.Item = Item;


/***/ }),

/***/ "./module/views/Module.ts":
/*!********************************!*\
  !*** ./module/views/Module.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../ctrls */ "./module/ctrls/index.ts");
var Module = (function (_super) {
    __extends(Module, _super);
    function Module(data) {
        var _this = _super.call(this) || this;
        _this.data = data;
        _this.init();
        return _this;
    }
    Module.prototype.init = function () {
        var _this = this;
        this.preLoadRes().then(function () {
            if (_this.skinName)
                RES_1.RES.initSkinDisplay(_this, _this.skinName, _this);
            _this.initUi();
            _this.onLoaded && _this.onLoaded();
        }, function () {
            _this.onLoadError && _this.onLoadError();
        });
    };
    Module.prototype.preLoadRes = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (_this.groupNames && _this.groupNames.length) {
                var arr = [];
                for (var i = 0; i < _this.groupNames.length; i++) {
                    arr.push(RES_1.RES.loadGroup(_this.groupNames[i]));
                }
                Promise.all(arr).then(resolve, reject);
            }
            else {
                resolve();
            }
        });
    };
    Module.prototype.initUi = function () {
    };
    Object.defineProperty(Module.prototype, "groupNames", {
        get: function () { return null; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Module.prototype, "skinName", {
        get: function () { return null; },
        enumerable: true,
        configurable: true
    });
    ;
    Module.prototype.start = function (data) {
        this.initEvents();
    };
    Module.prototype.initEvents = function () {
    };
    Module.prototype.removeEvents = function () {
    };
    Module.prototype.enableMouseEvt = function (enable) {
        this.mouseEnable = enable;
        this.mouseChildren = enable;
    };
    Module.prototype.btnDelay = function (target, delay) {
        if (delay === void 0) { delay = 2000; }
        target.mouseEnable = false;
        target.mouseChildren = false;
        setTimeout(function () {
            target.mouseEnable = true;
            target.mouseChildren = true;
        }, delay);
    };
    Module.prototype.destroy = function () {
        ctrls_1.removeTweens(this);
        this.removeEvents();
        this.dispatchEvent("onDestroy");
        _super.prototype.destroy.call(this);
    };
    return Module;
}(FYGE.Container));
exports.Module = Module;


/***/ }),

/***/ "./module/views/Panel.ts":
/*!*******************************!*\
  !*** ./module/views/Panel.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Panel = (function (_super) {
    __extends(Panel, _super);
    function Panel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Panel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        var oriY = this.y || 0;
        this.y = -200;
        FYGE.Tween.get(this)
            .to({ y: oriY }, 500, FYGE.Ease.quartOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    Panel.prototype.initEvents = function () {
        var _this = this;
        this.closeBtns.forEach(function (btn) {
            if (btn)
                btn.addEventListener(FYGE.MouseEvent.CLICK, _this.hidePanel, _this);
        });
    };
    Panel.prototype.removeEvents = function () {
        var _this = this;
        this.closeBtns.forEach(function (btn) {
            if (btn)
                btn.removeEventListener(FYGE.MouseEvent.CLICK, _this.hidePanel, _this);
        });
    };
    Object.defineProperty(Panel.prototype, "closeBtns", {
        get: function () {
            return [this['closeBtn']];
        },
        enumerable: true,
        configurable: true
    });
    Panel.prototype.hidePanel = function () {
        this.destroy();
    };
    return Panel;
}(Module_1.Module));
exports.Panel = Panel;


/***/ }),

/***/ "./module/views/Scene.ts":
/*!*******************************!*\
  !*** ./module/views/Scene.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Scene = (function (_super) {
    __extends(Scene, _super);
    function Scene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene.prototype.showAni = function (callback) {
        callback();
    };
    Scene.prototype.updateScene = function () {
    };
    return Scene;
}(Module_1.Module));
exports.Scene = Scene;


/***/ }),

/***/ "./module/views/layers.ts":
/*!********************************!*\
  !*** ./module/views/layers.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var panelCtrl_1 = __webpack_require__(/*! ../ctrls/panelCtrl */ "./module/ctrls/panelCtrl.ts");
var sceneCtrl_1 = __webpack_require__(/*! ../ctrls/sceneCtrl */ "./module/ctrls/sceneCtrl.ts");
var Layers = (function (_super) {
    __extends(Layers, _super);
    function Layers() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Layers.prototype.init = function (stage) {
        stage.addChild(this);
        var arr = [
            "_bottomLayer",
            "_sceneLayer",
            "_popupLayer",
            "_toastLayer",
            "_topLayer",
            "_shareLayer"
        ];
        for (var i = 0; i < arr.length; i++) {
            this[arr[i]] = new FYGE.Container();
            this.addChild(this[arr[i]]);
        }
        this.sceneLayer.y = this.stageOffsetY;
        this.shareLayer.y = -this.stageOffsetY;
        sceneCtrl_1.default.instance.init(this.sceneLayer);
        panelCtrl_1.default.instance.init(this.popupLayer);
    };
    Object.defineProperty(Layers.prototype, "bottomLayer", {
        get: function () { return this._bottomLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "sceneLayer", {
        get: function () { return this._sceneLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "popupLayer", {
        get: function () { return this._popupLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "toastLayer", {
        get: function () { return this._toastLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "topLayer", {
        get: function () { return this._topLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "shareLayer", {
        get: function () { return this._shareLayer; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageHeight", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.height;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageWidth", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetX", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.x;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetY", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.y;
        },
        enumerable: true,
        configurable: true
    });
    return Layers;
}(FYGE.Container));
exports.layers = new Layers();
function destroyLayers() {
    exports.layers.removeChildren();
    if (exports.layers.parent)
        exports.layers.parent.removeChild(exports.layers);
}
exports.destroyLayers = destroyLayers;


/***/ }),

/***/ "./src/Lottie.ts":
/*!***********************!*\
  !*** ./src/Lottie.ts ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Lottie = (function (_super) {
    __extends(Lottie, _super);
    function Lottie(data) {
        var _this = _super.call(this) || this;
        _this.deltaFrame = 1;
        _this._instanceType = "Lottie";
        if (data) {
            _this.init(data);
        }
        return _this;
    }
    Object.defineProperty(Lottie.prototype, "totalFrames", {
        get: function () {
            return this.rawData && (this.rawData.op - this.rawData.ip);
        },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(Lottie.prototype, "videoWidth", {
        get: function () {
            return this.rawData && this.rawData.w;
        },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(Lottie.prototype, "videoHeight", {
        get: function () {
            return this.rawData && this.rawData.h;
        },
        enumerable: true,
        configurable: true
    });
    ;
    Lottie.prototype.init = function (data) {
        if (!data)
            return;
        this.rawData = data;
        this.timeInterval = 1000 / data.fr;
        this.deltaFrame = 60 / data.fr;
        this.name = data.nm;
        if (data.assets && !data.textures) {
            data.textures = {};
            data.assets.forEach(function (a) {
                var imgTag = FYGE.getCreateImage()();
                imgTag.src = a.p;
                data.textures[a.id] = new FYGE.Texture(new FYGE.BaseTexture(imgTag));
            });
        }
        this.initChildren();
    };
    Lottie.prototype.initChildren = function () {
        var layers = this.rawData.layers.slice();
        for (var i = layers.length - 1; i >= 0; i--) {
            var layer = layers[i];
            var c = this.addChild(new FYGE.Sprite(layer.refId ?
                this.rawData.textures ?
                    this.rawData.textures[layer.refId] :
                    FYGE.TextureCache[layer.refId] ||
                        FYGE.TextureCache[layer.refId + ".png"] : null));
            c["layerData"] = layer;
        }
        this.initState();
    };
    Lottie.prototype.initState = function (con) {
        if (con === void 0) { con = this.children; }
        for (var i = 0; i < con.length; i++) {
            var c = con[i];
            if (c["layerData"]) {
                var data = c["layerData"];
                c.alpha = data.ks.o.k[0] ? data.ks.o.k[0].s[0] / 100 : data.ks.o.k / 100;
                c.rotation = data.ks.r.k[0] ? data.ks.r.k[0].s[0] : data.ks.r.k;
                var ad = typeof data.ks.a.k[0] == "number" ? data.ks.a.k : data.ks.a.k[0].s;
                c.anchor.set(ad[0], ad[1]);
                var ad = typeof data.ks.p.k[0] == "number" ? data.ks.p.k : data.ks.p.k[0].s;
                c.position.set(ad[0] - c.anchorX, ad[1] - c.anchorY);
                var ad = typeof data.ks.s.k[0] == "number" ? data.ks.s.k : data.ks.s.k[0].s;
                c.scale.set(ad[0] / 100, ad[1] / 100);
                c.visible = data.ip <= 0;
            }
            if (c.children.length)
                this.initState(c.children);
        }
    };
    Lottie.prototype.play = function (loop, callback) {
        if (loop === void 0) { loop = 0; }
        this.stop(true);
        this.loops = loop;
        this.callback = callback;
        this.addTweens();
    };
    Lottie.prototype.stop = function (isReset) {
        if (isReset === void 0) { isReset = false; }
        FYGE.Tween.removeTweens(this);
        this.children.forEach(function (c) { FYGE.Tween.removeTweens(c); });
        isReset && this.initState();
    };
    Lottie.prototype.addTweens = function (con) {
        var _this = this;
        if (con === void 0) { con = this.children; }
        var _loop_1 = function () {
            var c = con[i];
            if (c["layerData"]) {
                var data = c["layerData"];
                if (data.ks.o.k.length)
                    this_1.addTween(c, "o");
                if (data.ks.r.k.length)
                    this_1.addTween(c, "r");
                if (typeof data.ks.p.k[0] != "number")
                    this_1.addTween(c, "p");
                if (typeof data.ks.s.k[0] != "number")
                    this_1.addTween(c, "s");
                t = FYGE.Tween.get(c, { loop: true });
                if (data.ip > 0 || data.op < this_1.rawData.op) {
                    aa = data.ip < 0 ? 0 : data.ip;
                    bb = data.op > this_1.rawData.op ? this_1.rawData.op : data.op;
                    t.wait(aa * this_1.timeInterval)
                        .call(function () { c.visible = true; })
                        .wait((bb - aa) * this_1.timeInterval)
                        .call(function () { c.visible = false; })
                        .wait((this_1.rawData.op - bb) * this_1.timeInterval);
                }
            }
            if (c.children.length)
                this_1.addTweens(c.children);
        };
        var this_1 = this, t, aa, bb;
        for (var i = 0; i < con.length; i++) {
            _loop_1();
        }
        FYGE.Tween.get(this, { loop: true })
            .wait((this.rawData.op - this.rawData.ip) * this.timeInterval)
            .call(function () {
            if (--_this.loops == 0) {
                _this.stop();
                _this.callback && _this.callback();
            }
        });
    };
    Lottie.prototype.addTween = function (dis, type) {
        var data = dis["layerData"].ks[type].k;
        var tween = FYGE.Tween.get(dis, { loop: true });
        var countTime = 0;
        if (dis["layerData"].ks[type].x) {
            var xs = dis["layerData"].ks[type].x;
            var rr = +xs.replace(/[^0-9]/ig, "");
            if (xs.indexOf("loopOut") >= 0) {
                var objArr = [];
                var curT = 0;
                for (var i = 0; i < data.length; i++) {
                    var d = data[i];
                    if (d.t > dis["layerData"].op)
                        break;
                    var deltaT = d.t - curT;
                    var deltaTime = deltaT * this.timeInterval;
                    var obj = getTweenObj(d);
                    if (i == 0 && d.t > 0) {
                        tween.wait(deltaTime);
                        countTime += deltaTime;
                    }
                    else if (i == 0 && d.t == 0) {
                        tween.set(obj);
                        objArr.push({ obj: obj, deltaT: deltaT, deltaTime: deltaTime, isSet: true });
                    }
                    else {
                        if (d.t - curT == 1) {
                            tween.wait(deltaTime)
                                .set(obj);
                            objArr.push({ obj: obj, deltaT: deltaT, deltaTime: deltaTime, isSet: true });
                            countTime += deltaTime;
                        }
                        else {
                            tween.to(obj, deltaTime);
                            objArr.push({ obj: obj, deltaT: deltaT, deltaTime: deltaTime });
                            countTime += deltaTime;
                        }
                    }
                    curT = d.t;
                }
                if (xs.indexOf("pingpong") >= 0 && data[data.length - 1].t < dis["layerData"].op) {
                    var round = Math.round((dis["layerData"].op - data[data.length - 1].t) /
                        (data[data.length - 1].t - data[0].t));
                    curT += round * (data[data.length - 1].t - data[0].t);
                    var dir = false;
                    while (--round) {
                        if (dir) {
                            for (var o = 0; o < objArr.length; o++) {
                                tween.to(objArr[o].obj, objArr[o].deltaTime);
                                countTime += objArr[o].deltaTime;
                            }
                        }
                        else {
                            for (var o = objArr.length - 1; o >= 1; o--) {
                                tween.to(objArr[o - 1].obj, objArr[o].deltaTime);
                                countTime += objArr[o].deltaTime;
                            }
                        }
                        dir = !dir;
                    }
                }
                else if (xs.indexOf("cycle") >= 0 && data[data.length - 1].t < dis["layerData"].op) {
                    var lastIndex = data.length - 1;
                    var num = Math.floor((dis["layerData"].op - data[lastIndex].t) /
                        (data[lastIndex].t - data[lastIndex - (rr || lastIndex)].t));
                    var objArrC = objArr.slice(-rr);
                    while (num) {
                        num--;
                        for (var o = 0; o < objArrC.length; o++) {
                            if (objArrC[o].isSet) {
                                tween.wait(objArrC[o].deltaTime)
                                    .set(objArrC[o].obj);
                            }
                            else {
                                tween.to(objArrC[o].obj, objArrC[o].deltaTime);
                            }
                            countTime += objArrC[o].deltaTime;
                        }
                    }
                    var left = (dis["layerData"].op - data[lastIndex].t) % (data[lastIndex].t - data[lastIndex - (rr || lastIndex)].t);
                    for (var o = 0; o < objArrC.length; o++) {
                        if (objArrC[o].deltaT <= left) {
                            if (objArrC[o].isSet) {
                                tween.wait(objArrC[o].deltaTime)
                                    .set(objArrC[o].obj);
                            }
                            else {
                                tween.to(objArrC[o].obj, objArrC[o].deltaTime);
                            }
                            left -= objArrC[o].deltaT;
                            countTime += objArrC[o].deltaTime;
                        }
                        else {
                            if (left > 0) {
                                var ooo = o == 0 ?
                                    calculateInterpolation(copyProps(objArrC[o].obj, tween["_initQueueProps"]), objArrC[o].obj, left / objArrC[o].deltaT) : calculateInterpolation(objArrC[o - 1].obj, objArrC[o].obj, left / objArrC[o].deltaT);
                                tween.to(ooo, left * this.timeInterval);
                                countTime += left * this.timeInterval;
                            }
                            break;
                        }
                    }
                }
            }
            else if (xs.indexOf("loopIn") >= 0) {
                var objArr = [];
                var curT = 0;
                for (var i = 0; i < data.length; i++) {
                    var d = data[i];
                    var deltaT = d.t - curT;
                    var deltaTime = deltaT * this.timeInterval;
                    var obj = getTweenObj(d);
                    if (d.t - curT == 1) {
                        objArr.push({ obj: obj, deltaT: deltaT, deltaTime: deltaTime, isSet: true, timeOri: d.t });
                    }
                    else {
                        objArr.push({ obj: obj, deltaT: deltaT, deltaTime: deltaTime, timeOri: d.t });
                    }
                    curT = d.t;
                }
                if (xs.indexOf("pingpong") >= 0 && data[0].t > 0) {
                    objArr = getLoopInPingpongTween(objArr, rr, dis["layerData"].op);
                    for (var o = 0; o < objArr.length; o++) {
                        if (objArr[o].isSet) {
                            tween.wait(objArr[o].deltaTime)
                                .set(objArr[o].obj);
                        }
                        else {
                            tween.to(objArr[o].obj, objArr[o].deltaTime);
                        }
                        countTime += objArr[o].deltaTime;
                    }
                }
                else if (xs.indexOf("cycle") >= 0 && data[0].t > 0) {
                    objArr = getLoopInCycleTween(objArr, rr, dis["layerData"].op, dis["layerData"].ip);
                    if (dis["layerData"].ip) {
                        tween.wait(dis["layerData"].ip * this.timeInterval);
                        countTime += dis["layerData"].ip * this.timeInterval;
                    }
                    for (var o = 0; o < objArr.length; o++) {
                        if (objArr[o].isSet) {
                            tween.wait(objArr[o].deltaTime)
                                .set(objArr[o].obj);
                        }
                        else {
                            tween.to(objArr[o].obj, objArr[o].deltaTime);
                        }
                        countTime += objArr[o].deltaTime;
                    }
                }
                var op = Math.min(dis["layerData"].op, this.rawData.op);
                if (countTime < op * this.timeInterval) {
                    var dd = op * this.timeInterval - countTime;
                    tween.wait(dd);
                    countTime += dd;
                }
            }
            if (dis["layerData"].op < this.rawData.op) {
                tween.wait((this.rawData.op - dis["layerData"].op) * this.timeInterval);
                countTime += (this.rawData.op - dis["layerData"].op) * this.timeInterval;
            }
        }
        else {
            var curT = 0;
            for (var i = 0; i < data.length; i++) {
                var d = data[i], obj = getTweenObj(d), deltaTime = void 0;
                if (d.t < 0) {
                    if (!data[i + 1] || data[i + 1].t < 0)
                        break;
                    obj = calculateInterpolation(obj, getTweenObj(data[i + 1]), -d.t / (data[i + 1].t - d.t));
                    tween.set(obj);
                    curT = 0;
                }
                else if (d.t > this.rawData.op) {
                    if (!data[i - 1] || data[i - 1].t > this.rawData.op)
                        break;
                    var dt = this.rawData.op - data[i - 1].t;
                    deltaTime = dt * this.timeInterval;
                    obj = calculateInterpolation(getTweenObj(data[i - 1]), obj, dt / (d.t - data[i - 1].t));
                    tween.to(obj, deltaTime);
                    countTime += deltaTime;
                    curT = this.rawData.op;
                }
                else {
                    deltaTime = (d.t - curT) * this.timeInterval;
                    if (i == 0 && d.t > 0) {
                        tween.wait(deltaTime);
                    }
                    else if (i == 0 && d.t == 0) {
                        tween.set(obj);
                    }
                    else {
                        tween.to(obj, deltaTime);
                    }
                    countTime += deltaTime;
                    curT = d.t;
                }
            }
            if (this.rawData.op > curT) {
                tween.wait((this.rawData.op - curT) * this.timeInterval);
            }
        }
        function getTweenObj(d) {
            var obj;
            switch (type) {
                case "r":
                    obj = { rotation: d.s[0] };
                    break;
                case "o":
                    obj = { alpha: d.s[0] / 100 };
                    break;
                case "s":
                    obj = { scaleX: d.s[0] / 100, scaleY: d.s[1] / 100 };
                    break;
                case "p":
                    obj = { x: d.s[0] - dis.anchorX, y: d.s[1] - dis.anchorY };
                    break;
            }
            return obj;
        }
    };
    Lottie.prototype.updateTransform = function () {
        var _this = this;
        this.displayObjectUpdateTransform();
        this.children.forEach(function (c) {
            _this._recursivePostUpdateTransformAA(c);
        });
        this.children.forEach(function (c) {
            c.mark = false;
        });
    };
    Lottie.prototype.findChildByInd = function (ind) {
        for (var i = 0; i < this.children.length; i++) {
            if (this.children[i].layerData &&
                this.children[i].layerData.ind === ind)
                return this.children[i];
        }
        return null;
    };
    Lottie.prototype._recursivePostUpdateTransformAA = function (c) {
        if (c.layerData && c.layerData.parent) {
            var p = this.findChildByInd(c.layerData.parent);
            this._recursivePostUpdateTransformAA(p);
            if (!c.mark) {
                c.mark = true;
                c.transform.updateWorldMatrix(p.transform);
                c._worldAlpha = c.alpha * c.parent._worldAlpha;
            }
        }
        else if (!c.mark) {
            c.updateTransform();
            c.mark = true;
        }
    };
    Lottie.prototype.startAniRange = function (beginFrame, endFrame, loops, callback) {
        if (beginFrame === void 0) { beginFrame = 1; }
        if (endFrame === void 0) { endFrame = this.totalFrames; }
        if (loops === void 0) { loops = 1; }
        this.play(loops, callback);
    };
    Lottie.prototype.destroy = function () {
        this.children.forEach(function (c) { FYGE.Tween.removeTweens(c); });
        _super.prototype.destroy.call(this);
    };
    return Lottie;
}(FYGE.Container));
exports.Lottie = Lottie;
function calculateInterpolation(d1, d2, scale) {
    var obj = {};
    for (var key in d1)
        obj[key] = (d2[key] - d1[key]) * scale + d1[key];
    return obj;
}
function copyProps(obj, sObj) {
    var o = {};
    if (!obj)
        return o;
    for (var key in obj)
        o[key] = sObj[key];
    return o;
}
function getLoopInCycleTween(objArr, round, op, ip) {
    if (ip === void 0) { ip = 0; }
    var time = objArr[0].deltaT - ip;
    if (round >= objArr.length)
        round = 0;
    var objArrC = objArr.slice(0, round ? round + 1 : objArr.length);
    var tweenArr = [];
    var curIndex = 0;
    while (time > 0) {
        curIndex--;
        if (curIndex < 0)
            curIndex = objArrC.length - 1;
        if (!curIndex) {
            tweenArr.unshift({
                obj: objArrC[0].obj,
                deltaT: 0,
                deltaTime: 0,
                timeOri: objArrC[0].timeOri,
                isSet: true
            });
        }
        else {
            tweenArr.unshift(objArrC[curIndex]);
            time -= objArrC[curIndex].deltaT;
        }
    }
    tweenArr.unshift({
        obj: objArrC[0].obj,
        deltaT: 0,
        deltaTime: 0,
        timeOri: objArrC[0].timeOri,
        isSet: true
    });
    tweenArr.push({
        obj: objArrC[0].obj,
        deltaT: 0,
        deltaTime: 0,
        isSet: true
    });
    for (var i = 1; i < objArr.length; i++) {
        if (objArr[i].timeOri > op)
            break;
        tweenArr.push(objArr[i]);
    }
    return tweenArr;
}
function getLoopInCycleTween11(objArr, time, round) {
    if (round >= objArr.length)
        round = 0;
    var lastDeltaT = objArr[round || objArr.length - 1].deltaT;
    var lastDeltaTime = objArr[round || objArr.length - 1].deltaTime;
    objArr[0].deltaT = lastDeltaT;
    objArr[0].deltaTime = lastDeltaTime;
    var objArrC = objArr.slice(0, round || objArr.length);
    var tweenArr = [];
    var curT = 0;
    for (var i = 1; i < objArrC.length; i++) {
        tweenArr.push(objArrC[i]);
        curT += objArrC[i].deltaT;
    }
    time -= curT;
    while (time > lastDeltaT) {
        for (var i = 0; i < objArrC.length; i++) {
            tweenArr.push(objArrC[i]);
            time -= objArrC[i].deltaT;
        }
    }
    tweenArr = tweenArr.concat(objArr);
    return tweenArr;
}
function getLoopInPingpongTween(objArr, round, op) {
    var time = objArr[0].deltaT;
    if (round >= objArr.length)
        round = 0;
    var objArrC = objArr.slice(0, round ? round + 1 : objArr.length);
    var timeInterval = objArr[0].deltaTime / objArr[0].deltaT;
    var tweenArr = [];
    var dir = true;
    var curIndex = 0;
    var lastIndex = 0;
    while (time > 0) {
        dir ? curIndex++ : curIndex--;
        if (curIndex > objArrC.length - 1) {
            dir = false;
            curIndex -= 2;
        }
        else if (curIndex < 0) {
            dir = true;
            curIndex += 2;
        }
        var deltaT = Math.abs(objArrC[lastIndex].timeOri - objArrC[curIndex].timeOri);
        tweenArr.unshift({
            obj: objArrC[lastIndex].obj,
            deltaT: deltaT,
            deltaTime: deltaT * timeInterval,
            timeOri: objArrC[lastIndex].timeOri,
            isSet: objArrC[lastIndex].isSet
        });
        lastIndex = curIndex;
        time -= deltaT;
    }
    tweenArr.unshift({
        obj: objArrC[lastIndex].obj,
        deltaT: 0,
        deltaTime: 0,
        timeOri: objArrC[lastIndex].timeOri,
        isSet: true
    });
    for (var i = 1; i < objArr.length; i++) {
        if (objArr[i].timeOri > op)
            break;
        tweenArr.push(objArr[i]);
    }
    return tweenArr;
}


/***/ }),

/***/ "./src/Main.ts":
/*!*********************!*\
  !*** ./src/Main.ts ***!
  \*********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../module/views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var ResJson_1 = __webpack_require__(/*! ./ResJson */ "./src/ResJson.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
var SkinJson_1 = __webpack_require__(/*! ./SkinJson */ "./src/SkinJson.ts");
var G_EVENT_1 = __webpack_require__(/*! ./common/G_EVENT */ "./src/common/G_EVENT.ts");
var LoadingScene_1 = __webpack_require__(/*! ./scene/LoadingScene */ "./src/scene/LoadingScene.ts");
exports.GDispatcher = new FYGE.EventDispatcher();
var Main = (function () {
    function Main(canvas) {
        var sysInfo;
        if (my) {
            FYGE.initedByCanvas(canvas);
            sysInfo = my.getSystemInfoSync();
        }
        var stage = new FYGE.Stage(canvas, 750, 1624, sysInfo && sysInfo.windowWidth || document.body.clientWidth, sysInfo && sysInfo.windowHeight || document.body.clientHeight, FYGE.RENDERER_TYPE.CANVAS);
        this.stage = stage;
        this.canvas = canvas;
        stage.addEventListener(FYGE.Event.INIT_STAGE, this.onAddToStage, this);
        var self = this;
        loop();
        function loop() {
            if (!self._pause) {
                FYGE.Tween.flush();
                stage.flush();
            }
            my ? self.requestID = canvas.requestAnimationFrame(loop) :
                self.requestID = window.requestAnimationFrame(loop);
        }
    }
    Main.prototype.onAddToStage = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        layers_1.layers.init(this.stage);
                        console.log("初始化层级完成");
                        RES_1.RES.loadConfig(ResJson_1.ResJson);
                        console.log("初始化资源配置完成");
                        RES_1.RES.loadSkinConfig(SkinJson_1.SkinJson);
                        return [4, RES_1.RES.loadGroup("common")];
                    case 1:
                        _a.sent();
                        console.log("通用资源加载完成");
                        ctrls_1.changeScene(LoadingScene_1.LoadingScene);
                        return [2];
                }
            });
        });
    };
    Main.prototype.run = function () {
        this._pause = false;
        FYGE.Tween._lastTime = null;
        exports.GDispatcher.dispatchEvent({ type: G_EVENT_1.G_EVENT.ON_SHOW });
    };
    Main.prototype.pause = function () {
        exports.GDispatcher.dispatchEvent({ type: G_EVENT_1.G_EVENT.ON_HIDE });
    };
    Main.prototype.addGlobalEvent = function (name, fun, thisObj, once) {
        if (once === void 0) { once = false; }
        if (once) {
            exports.GDispatcher.once(name, fun, thisObj);
        }
        else {
            exports.GDispatcher.addEventListener(name, fun, thisObj);
        }
    };
    Main.prototype.dispatchGlobalEvent = function (name, data) {
        exports.GDispatcher.dispatchEvent(name, data);
    };
    Main.prototype.removeGlobalEvent = function (name, fun, thisObj) {
        exports.GDispatcher.removeEventListener(name, fun, thisObj);
    };
    Main.prototype.destroy = function () {
        FYGE.Tween.removeAllTweens();
        my ? this.canvas.cancelAnimationFrame(this.requestID) :
            window.cancelAnimationFrame(this.requestID);
        layers_1.destroyLayers();
        ctrls_1.destroyAllCtrls();
        this.stage.destroy();
        exports.GDispatcher.removeAllEventListener();
        TaoBaoNet_1.destroyNetData();
    };
    return Main;
}());
exports.Main = Main;
function createNineTextures(imageUrl) {
    return new Promise(function (resolve, reject) {
        var image = new Image();
        image.setAttribute("crossOrigin", "anonymous");
        image.onload = function () {
            var obj = {};
            var name = "lalala";
            var row = 4, col = 3;
            var w = image.width / col;
            var h = image.height / row;
            for (var i = 0; i < col * row; i++)
                obj[name + i] = {
                    "x": i % col * w,
                    "y": ~~(i / col) * h,
                    w: w, h: h, sw: w, sh: h, ox: 0, oy: 0, ro: false
                };
            FYGE.createTextureSheet(new FYGE.BaseTexture(image), obj);
            var arr = [];
            for (var i = 0; i < col * row; i++)
                arr.push(FYGE.TextureCache[name + i]);
            resolve(arr);
        };
        image.onerror = function (err) {
            reject(err);
        };
        image.src = imageUrl;
    });
}


/***/ }),

/***/ "./src/ResJson.ts":
/*!************************!*\
  !*** ./src/ResJson.ts ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ResJson = {
    "groups": [
        {
            "keys": "失败Bg.png,失败重新闯关.png",
            "name": "FailedPanel",
            "atlas": {
                "失败Bg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 644,
                    "h": 488,
                    "ox": 0,
                    "oy": 0,
                    "sw": 644,
                    "sh": 488,
                    "ro": false
                },
                "失败重新闯关.png": {
                    "x": 648,
                    "y": 2,
                    "w": 424,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 119,
                    "ro": true
                }
            }
        },
        {
            "keys": "FesRedPrizeBg.png",
            "name": "FesRedPrizePanel",
            "atlas": {
                "FesRedPrizeBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 644,
                    "h": 1028,
                    "ox": 0,
                    "oy": 0,
                    "sw": 644,
                    "sh": 1028,
                    "ro": false
                }
            }
        },
        {
            "keys": "圆圈.png",
            "name": "FreePowerPanel",
            "atlas": {
                "圆圈.png": {
                    "x": 2,
                    "y": 2,
                    "w": 644,
                    "h": 718,
                    "ox": 0,
                    "oy": 0,
                    "sw": 644,
                    "sh": 718,
                    "ro": false
                }
            }
        },
        {
            "keys": "MagicAniActive_0.png,MagicAniActive_1.png,MagicAniActive_10.png,MagicAniActive_11.png,MagicAniActive_12.png,MagicAniActive_13.png,MagicAniActive_14.png,MagicAniActive_15.png,MagicAniActive_16.png,MagicAniActive_2.png,MagicAniActive_3.png,MagicAniActive_4.png,MagicAniActive_5.png,MagicAniActive_6.png,MagicAniActive_7.png,MagicAniActive_8.png,MagicAniActive_9.png,MagicAniNormal_0.png,MagicAniNormal_1.png,MagicAniNormal_10.png,MagicAniNormal_11.png,MagicAniNormal_12.png,MagicAniNormal_13.png,MagicAniNormal_14.png,MagicAniNormal_15.png,MagicAniNormal_16.png,MagicAniNormal_17.png,MagicAniNormal_18.png,MagicAniNormal_19.png,MagicAniNormal_2.png,MagicAniNormal_20.png,MagicAniNormal_21.png,MagicAniNormal_3.png,MagicAniNormal_4.png,MagicAniNormal_5.png,MagicAniNormal_6.png,MagicAniNormal_7.png,MagicAniNormal_8.png,MagicAniNormal_9.png",
            "name": "MagicAni",
            "atlas": {
                "MagicAniActive_0.png": {
                    "x": 252,
                    "y": 606,
                    "w": 96,
                    "h": 282,
                    "ox": 63,
                    "oy": 55,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_1.png": {
                    "x": 2,
                    "y": 606,
                    "w": 248,
                    "h": 238,
                    "ox": 91,
                    "oy": 99,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_10.png": {
                    "x": 1502,
                    "y": 302,
                    "w": 290,
                    "h": 290,
                    "ox": 57,
                    "oy": 51,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_11.png": {
                    "x": 1210,
                    "y": 2,
                    "w": 294,
                    "h": 298,
                    "ox": 53,
                    "oy": 49,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_12.png": {
                    "x": 304,
                    "y": 304,
                    "w": 300,
                    "h": 300,
                    "ox": 50,
                    "oy": 49,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_13.png": {
                    "x": 908,
                    "y": 2,
                    "w": 300,
                    "h": 298,
                    "ox": 50,
                    "oy": 51,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_14.png": {
                    "x": 1204,
                    "y": 302,
                    "w": 296,
                    "h": 292,
                    "ox": 54,
                    "oy": 55,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_15.png": {
                    "x": 1494,
                    "y": 596,
                    "w": 288,
                    "h": 290,
                    "ox": 56,
                    "oy": 51,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_16.png": {
                    "x": 350,
                    "y": 606,
                    "w": 204,
                    "h": 206,
                    "ox": 97,
                    "oy": 96,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_2.png": {
                    "x": 606,
                    "y": 302,
                    "w": 298,
                    "h": 300,
                    "ox": 50,
                    "oy": 49,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_3.png": {
                    "x": 304,
                    "y": 2,
                    "w": 300,
                    "h": 300,
                    "ox": 50,
                    "oy": 49,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_4.png": {
                    "x": 606,
                    "y": 2,
                    "w": 300,
                    "h": 298,
                    "ox": 50,
                    "oy": 51,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_5.png": {
                    "x": 1204,
                    "y": 596,
                    "w": 292,
                    "h": 288,
                    "ox": 56,
                    "oy": 53,
                    "sw": 400,
                    "sh": 400,
                    "ro": true
                },
                "MagicAniActive_6.png": {
                    "x": 1506,
                    "y": 2,
                    "w": 292,
                    "h": 298,
                    "ox": 53,
                    "oy": 49,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_7.png": {
                    "x": 2,
                    "y": 304,
                    "w": 300,
                    "h": 300,
                    "ox": 50,
                    "oy": 49,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_8.png": {
                    "x": 2,
                    "y": 2,
                    "w": 300,
                    "h": 300,
                    "ox": 50,
                    "oy": 49,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniActive_9.png": {
                    "x": 906,
                    "y": 302,
                    "w": 296,
                    "h": 300,
                    "ox": 54,
                    "oy": 47,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "MagicAniNormal_0.png": {
                    "x": 760,
                    "y": 652,
                    "w": 1,
                    "h": 1,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_1.png": {
                    "x": 604,
                    "y": 748,
                    "w": 8,
                    "h": 8,
                    "ox": 27,
                    "oy": 72,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_10.png": {
                    "x": 494,
                    "y": 814,
                    "w": 70,
                    "h": 62,
                    "ox": 6,
                    "oy": 16,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_11.png": {
                    "x": 422,
                    "y": 814,
                    "w": 70,
                    "h": 62,
                    "ox": 6,
                    "oy": 12,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_12.png": {
                    "x": 350,
                    "y": 814,
                    "w": 70,
                    "h": 62,
                    "ox": 6,
                    "oy": 7,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_13.png": {
                    "x": 556,
                    "y": 606,
                    "w": 70,
                    "h": 60,
                    "ox": 6,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "MagicAniNormal_14.png": {
                    "x": 618,
                    "y": 604,
                    "w": 70,
                    "h": 54,
                    "ox": 6,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_15.png": {
                    "x": 760,
                    "y": 604,
                    "w": 70,
                    "h": 46,
                    "ox": 6,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_16.png": {
                    "x": 56,
                    "y": 846,
                    "w": 70,
                    "h": 40,
                    "ox": 6,
                    "oy": 7,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_17.png": {
                    "x": 832,
                    "y": 604,
                    "w": 70,
                    "h": 38,
                    "ox": 6,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_18.png": {
                    "x": 128,
                    "y": 846,
                    "w": 70,
                    "h": 30,
                    "ox": 6,
                    "oy": 10,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_19.png": {
                    "x": 904,
                    "y": 604,
                    "w": 68,
                    "h": 32,
                    "ox": 7,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_2.png": {
                    "x": 350,
                    "y": 878,
                    "w": 38,
                    "h": 10,
                    "ox": 27,
                    "oy": 70,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_20.png": {
                    "x": 618,
                    "y": 660,
                    "w": 44,
                    "h": 8,
                    "ox": 7,
                    "oy": 5,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_21.png": {
                    "x": 390,
                    "y": 878,
                    "w": 10,
                    "h": 8,
                    "ox": 41,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "MagicAniNormal_3.png": {
                    "x": 1784,
                    "y": 594,
                    "w": 38,
                    "h": 14,
                    "ox": 27,
                    "oy": 65,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "MagicAniNormal_4.png": {
                    "x": 974,
                    "y": 604,
                    "w": 48,
                    "h": 34,
                    "ox": 17,
                    "oy": 46,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_5.png": {
                    "x": 566,
                    "y": 812,
                    "w": 52,
                    "h": 36,
                    "ox": 17,
                    "oy": 43,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "MagicAniNormal_6.png": {
                    "x": 2,
                    "y": 846,
                    "w": 52,
                    "h": 42,
                    "ox": 17,
                    "oy": 38,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_7.png": {
                    "x": 556,
                    "y": 748,
                    "w": 62,
                    "h": 46,
                    "ox": 7,
                    "oy": 34,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "MagicAniNormal_8.png": {
                    "x": 690,
                    "y": 604,
                    "w": 68,
                    "h": 52,
                    "ox": 7,
                    "oy": 28,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "MagicAniNormal_9.png": {
                    "x": 556,
                    "y": 678,
                    "w": 68,
                    "h": 58,
                    "ox": 8,
                    "oy": 22,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                }
            }
        },
        {
            "keys": "体力不足Bg.png,体力不足按钮.png",
            "name": "NoEnergyPanel",
            "atlas": {
                "体力不足Bg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 644,
                    "h": 565,
                    "ox": 0,
                    "oy": 0,
                    "sw": 644,
                    "sh": 565,
                    "ro": false
                },
                "体力不足按钮.png": {
                    "x": 648,
                    "y": 2,
                    "w": 424,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 119,
                    "ro": true
                }
            }
        },
        {
            "keys": "步数耗尽Bg.png,步数耗尽复活.png,步数耗尽结束按钮.png",
            "name": "NoStepPanel",
            "atlas": {
                "步数耗尽Bg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 644,
                    "h": 565,
                    "ox": 0,
                    "oy": 0,
                    "sw": 644,
                    "sh": 565,
                    "ro": true
                },
                "步数耗尽复活.png": {
                    "x": 271,
                    "y": 648,
                    "w": 267,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 267,
                    "sh": 119,
                    "ro": false
                },
                "步数耗尽结束按钮.png": {
                    "x": 2,
                    "y": 648,
                    "w": 267,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 267,
                    "sh": 119,
                    "ro": false
                }
            }
        },
        {
            "keys": "活动规则背景.png",
            "name": "RulePanel",
            "atlas": {
                "活动规则背景.png": {
                    "x": 2,
                    "y": 2,
                    "w": 644,
                    "h": 718,
                    "ox": 0,
                    "oy": 0,
                    "sw": 644,
                    "sh": 718,
                    "ro": false
                }
            }
        },
        {
            "keys": "关卡弹窗Bg.png",
            "name": "StartPanelPrize",
            "atlas": {
                "关卡弹窗Bg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 644,
                    "h": 1055,
                    "ox": 0,
                    "oy": 0,
                    "sw": 644,
                    "sh": 1055,
                    "ro": false
                }
            }
        },
        {
            "keys": "star_dis.png,star_en.png,去抽奖.png,圆角矩形 648.png,开奖按钮120.png,查看奖品.png,继续闯关红.png,道具圆圈.png,闯关成功.png,闯关成功Bg.png,闯关成功不满星按钮.png",
            "name": "SuccessPanel",
            "atlas": {
                "star_dis.png": {
                    "x": 819,
                    "y": 648,
                    "w": 150,
                    "h": 144,
                    "ox": 0,
                    "oy": 0,
                    "sw": 150,
                    "sh": 144,
                    "ro": true
                },
                "star_en.png": {
                    "x": 506,
                    "y": 648,
                    "w": 164,
                    "h": 157,
                    "ox": 0,
                    "oy": 0,
                    "sw": 164,
                    "sh": 157,
                    "ro": true
                },
                "去抽奖.png": {
                    "x": 1391,
                    "y": 769,
                    "w": 274,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 274,
                    "sh": 114,
                    "ro": false
                },
                "圆角矩形 648.png": {
                    "x": 2,
                    "y": 648,
                    "w": 502,
                    "h": 196,
                    "ox": 0,
                    "oy": 2,
                    "sw": 504,
                    "sh": 200,
                    "ro": false
                },
                "开奖按钮120.png": {
                    "x": 965,
                    "y": 769,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                },
                "查看奖品.png": {
                    "x": 1503,
                    "y": 648,
                    "w": 267,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 267,
                    "sh": 119,
                    "ro": false
                },
                "继续闯关红.png": {
                    "x": 1234,
                    "y": 648,
                    "w": 267,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 267,
                    "sh": 119,
                    "ro": false
                },
                "道具圆圈.png": {
                    "x": 665,
                    "y": 648,
                    "w": 152,
                    "h": 152,
                    "ox": 0,
                    "oy": 0,
                    "sw": 152,
                    "sh": 152,
                    "ro": false
                },
                "闯关成功.png": {
                    "x": 2,
                    "y": 2,
                    "w": 644,
                    "h": 1106,
                    "ox": 0,
                    "oy": 0,
                    "sw": 644,
                    "sh": 1106,
                    "ro": true
                },
                "闯关成功Bg.png": {
                    "x": 1110,
                    "y": 2,
                    "w": 644,
                    "h": 935,
                    "ox": 0,
                    "oy": 0,
                    "sw": 644,
                    "sh": 935,
                    "ro": true
                },
                "闯关成功不满星按钮.png": {
                    "x": 965,
                    "y": 648,
                    "w": 267,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 267,
                    "sh": 119,
                    "ro": false
                }
            }
        },
        {
            "keys": "browseGoods_btn_dis.png,browseGoods_btn_en.png,browseGoods_icon.png,follow_btn_dis.png,follow_btn_en.png,follow_icon.png,invites_btn_dis.png,invites_btn_en.png,invites_icon.png,member_btn_dis.png,member_btn_en.png,member_icon.png,orderGoods_btn_dis.png,orderGoods_btn_en.png,orderGoods_icon.png,task_get_btn.png,task_item_bg.png,任务背景.png,去完成.png,去完成灰.png",
            "name": "TaskPanel",
            "atlas": {
                "browseGoods_btn_dis.png": {
                    "x": 2,
                    "y": 248,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "browseGoods_btn_en.png": {
                    "x": 557,
                    "y": 166,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "browseGoods_icon.png": {
                    "x": 595,
                    "y": 248,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "follow_btn_dis.png": {
                    "x": 372,
                    "y": 166,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "follow_btn_en.png": {
                    "x": 187,
                    "y": 166,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "follow_icon.png": {
                    "x": 493,
                    "y": 248,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "invites_btn_dis.png": {
                    "x": 2,
                    "y": 166,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "invites_btn_en.png": {
                    "x": 557,
                    "y": 84,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "invites_icon.png": {
                    "x": 391,
                    "y": 248,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "member_btn_dis.png": {
                    "x": 372,
                    "y": 84,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "member_btn_en.png": {
                    "x": 187,
                    "y": 84,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "member_icon.png": {
                    "x": 289,
                    "y": 248,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "orderGoods_btn_dis.png": {
                    "x": 2,
                    "y": 84,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "orderGoods_btn_en.png": {
                    "x": 557,
                    "y": 2,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "orderGoods_icon.png": {
                    "x": 187,
                    "y": 248,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "task_get_btn.png": {
                    "x": 372,
                    "y": 2,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "task_item_bg.png": {
                    "x": 2,
                    "y": 350,
                    "w": 700,
                    "h": 160,
                    "ox": 0,
                    "oy": 0,
                    "sw": 700,
                    "sh": 160,
                    "ro": false
                },
                "任务背景.png": {
                    "x": 2,
                    "y": 512,
                    "w": 749,
                    "h": 1286,
                    "ox": 0,
                    "oy": 0,
                    "sw": 749,
                    "sh": 1286,
                    "ro": false
                },
                "去完成.png": {
                    "x": 187,
                    "y": 2,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                },
                "去完成灰.png": {
                    "x": 2,
                    "y": 2,
                    "w": 183,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 183,
                    "sh": 80,
                    "ro": false
                }
            }
        },
        {
            "keys": "使用道具背景.png",
            "name": "UseToolPanel",
            "atlas": {
                "使用道具背景.png": {
                    "x": 2,
                    "y": 2,
                    "w": 644,
                    "h": 456,
                    "ox": 0,
                    "oy": 0,
                    "sw": 644,
                    "sh": 456,
                    "ro": false
                }
            }
        },
        {
            "keys": "1f439912-6c0b-4ebe-bd58-4b2585e10b5e.png,390c5e0f-8f18-4b68-a08d-e7e92afec39b.png,55910cee-07e1-4f38-93e3-93d26a9c58d5.png,65198343-f322-4b14-8bda-869cc254bd6d.png,67159d75-5c21-4e5b-9236-5c8d4a95820f.png,72913f3a-3287-4d53-9dec-12dcd0930a77.png,a0c39e69-7c6d-4657-b955-8881a5925c32.png,ae162876-c68f-4f10-a1c7-f19aca284f86.png,b5fd8b69-afc7-437a-a905-00895c2d22fc.png,d4b4ea28-d1ee-4d23-8d9c-154b15db39ec.png,d7f99e60-cd13-4e4d-aea9-77a3ccb11107.png,dd03474f-5b55-49a2-beaa-28196529272a.png,ddf3a45c-d782-42f3-8516-ee70d71936bc.png,de5f62aa-2655-4aac-a792-a8c34c916ba1.png,ebd5a2df-8698-488e-9c53-d8539842cf43.png,ec84570e-381b-4967-8a65-a5615d7cc9c8.png",
            "name": "bonus",
            "atlas": {
                "1f439912-6c0b-4ebe-bd58-4b2585e10b5e.png": {
                    "x": 2,
                    "y": 2,
                    "w": 648,
                    "h": 563,
                    "ox": 0,
                    "oy": 0,
                    "sw": 648,
                    "sh": 563,
                    "ro": false
                },
                "390c5e0f-8f18-4b68-a08d-e7e92afec39b.png": {
                    "x": 2,
                    "y": 581,
                    "w": 336,
                    "h": 203,
                    "ox": 0,
                    "oy": 0,
                    "sw": 336,
                    "sh": 203,
                    "ro": true
                },
                "55910cee-07e1-4f38-93e3-93d26a9c58d5.png": {
                    "x": 652,
                    "y": 2,
                    "w": 206,
                    "h": 138,
                    "ox": 0,
                    "oy": 0,
                    "sw": 206,
                    "sh": 138,
                    "ro": true
                },
                "65198343-f322-4b14-8bda-869cc254bd6d.png": {
                    "x": 391,
                    "y": 567,
                    "w": 252,
                    "h": 161,
                    "ox": 0,
                    "oy": 0,
                    "sw": 252,
                    "sh": 161,
                    "ro": false
                },
                "67159d75-5c21-4e5b-9236-5c8d4a95820f.png": {
                    "x": 775,
                    "y": 210,
                    "w": 15,
                    "h": 13,
                    "ox": 0,
                    "oy": 0,
                    "sw": 15,
                    "sh": 13,
                    "ro": false
                },
                "72913f3a-3287-4d53-9dec-12dcd0930a77.png": {
                    "x": 81,
                    "y": 919,
                    "w": 75,
                    "h": 76,
                    "ox": 0,
                    "oy": 0,
                    "sw": 75,
                    "sh": 76,
                    "ro": false
                },
                "a0c39e69-7c6d-4657-b955-8881a5925c32.png": {
                    "x": 645,
                    "y": 627,
                    "w": 42,
                    "h": 57,
                    "ox": 0,
                    "oy": 0,
                    "sw": 42,
                    "sh": 57,
                    "ro": false
                },
                "ae162876-c68f-4f10-a1c7-f19aca284f86.png": {
                    "x": 652,
                    "y": 210,
                    "w": 121,
                    "h": 369,
                    "ox": 0,
                    "oy": 0,
                    "sw": 121,
                    "sh": 369,
                    "ro": false
                },
                "b5fd8b69-afc7-437a-a905-00895c2d22fc.png": {
                    "x": 215,
                    "y": 916,
                    "w": 486,
                    "h": 105,
                    "ox": 0,
                    "oy": 0,
                    "sw": 486,
                    "sh": 105,
                    "ro": false
                },
                "d4b4ea28-d1ee-4d23-8d9c-154b15db39ec.png": {
                    "x": 158,
                    "y": 919,
                    "w": 55,
                    "h": 76,
                    "ox": 0,
                    "oy": 0,
                    "sw": 55,
                    "sh": 76,
                    "ro": false
                },
                "d7f99e60-cd13-4e4d-aea9-77a3ccb11107.png": {
                    "x": 2,
                    "y": 919,
                    "w": 77,
                    "h": 81,
                    "ox": 0,
                    "oy": 0,
                    "sw": 77,
                    "sh": 81,
                    "ro": false
                },
                "dd03474f-5b55-49a2-beaa-28196529272a.png": {
                    "x": 703,
                    "y": 581,
                    "w": 58,
                    "h": 66,
                    "ox": 0,
                    "oy": 0,
                    "sw": 58,
                    "sh": 66,
                    "ro": true
                },
                "ddf3a45c-d782-42f3-8516-ee70d71936bc.png": {
                    "x": 645,
                    "y": 581,
                    "w": 52,
                    "h": 44,
                    "ox": 0,
                    "oy": 0,
                    "sw": 52,
                    "sh": 44,
                    "ro": false
                },
                "de5f62aa-2655-4aac-a792-a8c34c916ba1.png": {
                    "x": 207,
                    "y": 877,
                    "w": 37,
                    "h": 63,
                    "ox": 0,
                    "oy": 0,
                    "sw": 37,
                    "sh": 63,
                    "ro": true
                },
                "ebd5a2df-8698-488e-9c53-d8539842cf43.png": {
                    "x": 207,
                    "y": 581,
                    "w": 294,
                    "h": 182,
                    "ox": 0,
                    "oy": 0,
                    "sw": 294,
                    "sh": 182,
                    "ro": true
                },
                "ec84570e-381b-4967-8a65-a5615d7cc9c8.png": {
                    "x": 391,
                    "y": 730,
                    "w": 179,
                    "h": 270,
                    "ox": 0,
                    "oy": 0,
                    "sw": 179,
                    "sh": 270,
                    "ro": true
                }
            }
        },
        {
            "keys": "boomBtn.png,closeBtn2.png,comCloseBtn.png,comm_light.png,ele0.png,ele1.png,ele10.png,ele11.png,ele12.png,ele13.png,ele14.png,ele2.png,ele3.png,ele4.png,ele5.png,ele6.png,ele7.png,ele8.png,ele9.png,hammerBtn.png,liaojiele.png,power.png,powerImg.png,stepBtn.png,toastBg.png,waitingBg.png,waitingRot.png,关闭按钮.png,再想想.png,开始闯关不要能量.png,开始闯关要能量.png,开心收下.png,确定.png,继续闯关大.png,继续闯关小.png",
            "name": "common",
            "atlas": {
                "boomBtn.png": {
                    "x": 428,
                    "y": 626,
                    "w": 81,
                    "h": 99,
                    "ox": 0,
                    "oy": 0,
                    "sw": 81,
                    "sh": 99,
                    "ro": false
                },
                "closeBtn2.png": {
                    "x": 425,
                    "y": 1189,
                    "w": 83,
                    "h": 83,
                    "ox": 0,
                    "oy": 0,
                    "sw": 83,
                    "sh": 83,
                    "ro": false
                },
                "comCloseBtn.png": {
                    "x": 462,
                    "y": 1555,
                    "w": 48,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 48,
                    "sh": 48,
                    "ro": false
                },
                "comm_light.png": {
                    "x": 2,
                    "y": 134,
                    "w": 439,
                    "h": 439,
                    "ox": 0,
                    "oy": 0,
                    "sw": 439,
                    "sh": 439,
                    "ro": false
                },
                "ele0.png": {
                    "x": 443,
                    "y": 410,
                    "w": 58,
                    "h": 66,
                    "ox": 10,
                    "oy": 8,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele1.png": {
                    "x": 443,
                    "y": 275,
                    "w": 70,
                    "h": 66,
                    "ox": 5,
                    "oy": 7,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele10.png": {
                    "x": 425,
                    "y": 1274,
                    "w": 72,
                    "h": 60,
                    "ox": 4,
                    "oy": 8,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele11.png": {
                    "x": 428,
                    "y": 1127,
                    "w": 72,
                    "h": 60,
                    "ox": 4,
                    "oy": 8,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele12.png": {
                    "x": 428,
                    "y": 1127,
                    "w": 72,
                    "h": 60,
                    "ox": 4,
                    "oy": 8,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele13.png": {
                    "x": 443,
                    "y": 134,
                    "w": 67,
                    "h": 67,
                    "ox": 0,
                    "oy": 0,
                    "sw": 67,
                    "sh": 67,
                    "ro": false
                },
                "ele14.png": {
                    "x": 443,
                    "y": 347,
                    "w": 61,
                    "h": 66,
                    "ox": 0,
                    "oy": 0,
                    "sw": 61,
                    "sh": 66,
                    "ro": true
                },
                "ele2.png": {
                    "x": 443,
                    "y": 203,
                    "w": 70,
                    "h": 66,
                    "ox": 4,
                    "oy": 7,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele3.png": {
                    "x": 392,
                    "y": 1555,
                    "w": 56,
                    "h": 68,
                    "ox": 12,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele4.png": {
                    "x": 443,
                    "y": 552,
                    "w": 62,
                    "h": 72,
                    "ox": 7,
                    "oy": 3,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele5.png": {
                    "x": 428,
                    "y": 987,
                    "w": 76,
                    "h": 76,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele6.png": {
                    "x": 428,
                    "y": 909,
                    "w": 76,
                    "h": 76,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele7.png": {
                    "x": 428,
                    "y": 1065,
                    "w": 74,
                    "h": 60,
                    "ox": 2,
                    "oy": 10,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele8.png": {
                    "x": 443,
                    "y": 470,
                    "w": 80,
                    "h": 64,
                    "ox": 0,
                    "oy": 14,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele9.png": {
                    "x": 428,
                    "y": 829,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hammerBtn.png": {
                    "x": 164,
                    "y": 1417,
                    "w": 91,
                    "h": 103,
                    "ox": 0,
                    "oy": 0,
                    "sw": 91,
                    "sh": 103,
                    "ro": true
                },
                "liaojiele.png": {
                    "x": 2,
                    "y": 938,
                    "w": 424,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 119,
                    "ro": false
                },
                "power.png": {
                    "x": 392,
                    "y": 1336,
                    "w": 108,
                    "h": 108,
                    "ox": 0,
                    "oy": 0,
                    "sw": 108,
                    "sh": 108,
                    "ro": false
                },
                "powerImg.png": {
                    "x": 271,
                    "y": 1175,
                    "w": 152,
                    "h": 152,
                    "ox": 0,
                    "oy": 0,
                    "sw": 152,
                    "sh": 152,
                    "ro": false
                },
                "stepBtn.png": {
                    "x": 428,
                    "y": 727,
                    "w": 80,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 100,
                    "ro": false
                },
                "toastBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 460,
                    "h": 130,
                    "ox": 0,
                    "oy": 0,
                    "sw": 460,
                    "sh": 130,
                    "ro": false
                },
                "waitingBg.png": {
                    "x": 2,
                    "y": 1417,
                    "w": 160,
                    "h": 180,
                    "ox": 0,
                    "oy": 0,
                    "sw": 160,
                    "sh": 180,
                    "ro": false
                },
                "waitingRot.png": {
                    "x": 164,
                    "y": 1510,
                    "w": 56,
                    "h": 56,
                    "ox": 0,
                    "oy": 0,
                    "sw": 56,
                    "sh": 56,
                    "ro": false
                },
                "关闭按钮.png": {
                    "x": 392,
                    "y": 1446,
                    "w": 107,
                    "h": 107,
                    "ox": 0,
                    "oy": 0,
                    "sw": 107,
                    "sh": 107,
                    "ro": false
                },
                "再想想.png": {
                    "x": 271,
                    "y": 1336,
                    "w": 267,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 267,
                    "sh": 119,
                    "ro": true
                },
                "开始闯关不要能量.png": {
                    "x": 2,
                    "y": 1059,
                    "w": 424,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 114,
                    "ro": false
                },
                "开始闯关要能量.png": {
                    "x": 2,
                    "y": 817,
                    "w": 424,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 119,
                    "ro": false
                },
                "开心收下.png": {
                    "x": 2,
                    "y": 696,
                    "w": 424,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 119,
                    "ro": false
                },
                "确定.png": {
                    "x": 2,
                    "y": 1296,
                    "w": 267,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 267,
                    "sh": 119,
                    "ro": false
                },
                "继续闯关大.png": {
                    "x": 2,
                    "y": 575,
                    "w": 424,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 424,
                    "sh": 119,
                    "ro": false
                },
                "继续闯关小.png": {
                    "x": 2,
                    "y": 1175,
                    "w": 267,
                    "h": 119,
                    "ox": 0,
                    "oy": 0,
                    "sw": 267,
                    "sh": 119,
                    "ro": false
                }
            }
        },
        {
            "keys": "fesEleSmallDis1.png,fesEleSmallDis10.png,fesEleSmallDis2.png,fesEleSmallDis3.png,fesEleSmallDis4.png,fesEleSmallDis5.png,fesEleSmallDis6.png,fesEleSmallDis7.png,fesEleSmallDis8.png,fesEleSmallDis9.png,fesRedBigLight.png,fesRedBombSta1.png,fesRedBombSta2.png,fesRedBombSta3_0.png,fesRedBombSta3_1.png,fesRedBombSta3_10.png,fesRedBombSta3_11.png,fesRedBombSta3_12.png,fesRedBombSta3_13.png,fesRedBombSta3_2.png,fesRedBombSta3_3.png,fesRedBombSta3_4.png,fesRedBombSta3_5.png,fesRedBombSta3_6.png,fesRedBombSta3_7.png,fesRedBombSta3_8.png,fesRedBombSta3_9.png,fesRedBombSta4_0.png,fesRedBombSta4_1.png,fesRedBombSta4_10.png,fesRedBombSta4_11.png,fesRedBombSta4_12.png,fesRedBombSta4_13.png,fesRedBombSta4_14.png,fesRedBombSta4_15.png,fesRedBombSta4_16.png,fesRedBombSta4_17.png,fesRedBombSta4_2.png,fesRedBombSta4_3.png,fesRedBombSta4_4.png,fesRedBombSta4_5.png,fesRedBombSta4_6.png,fesRedBombSta4_7.png,fesRedBombSta4_8.png,fesRedBombSta4_9.png,fesRedDown.png,festivalBg.png,festivalTargetBg.png,lineLight1.png,lineLight10.png,lineLight11.png,lineLight12.png,lineLight13.png,lineLight2.png,lineLight3.png,lineLight4.png,lineLight5.png,lineLight6.png,lineLight7.png,lineLight8.png,lineLight9.png",
            "name": "festival",
            "atlas": {
                "fesEleSmallDis1.png": {
                    "x": 553,
                    "y": 821,
                    "w": 102,
                    "h": 106,
                    "ox": 23,
                    "oy": 24,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis10.png": {
                    "x": 769,
                    "y": 501,
                    "w": 146,
                    "h": 144,
                    "ox": 1,
                    "oy": 6,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis2.png": {
                    "x": 917,
                    "y": 501,
                    "w": 96,
                    "h": 100,
                    "ox": 27,
                    "oy": 27,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis3.png": {
                    "x": 916,
                    "y": 703,
                    "w": 90,
                    "h": 92,
                    "ox": 29,
                    "oy": 31,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis4.png": {
                    "x": 2,
                    "y": 1143,
                    "w": 82,
                    "h": 86,
                    "ox": 34,
                    "oy": 34,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis5.png": {
                    "x": 86,
                    "y": 1143,
                    "w": 80,
                    "h": 84,
                    "ox": 34,
                    "oy": 37,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis6.png": {
                    "x": 917,
                    "y": 599,
                    "w": 98,
                    "h": 102,
                    "ox": 25,
                    "oy": 28,
                    "sw": 150,
                    "sh": 150,
                    "ro": false
                },
                "fesEleSmallDis7.png": {
                    "x": 435,
                    "y": 821,
                    "w": 110,
                    "h": 116,
                    "ox": 19,
                    "oy": 21,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis8.png": {
                    "x": 728,
                    "y": 647,
                    "w": 122,
                    "h": 128,
                    "ox": 13,
                    "oy": 15,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesEleSmallDis9.png": {
                    "x": 2,
                    "y": 567,
                    "w": 134,
                    "h": 140,
                    "ox": 7,
                    "oy": 9,
                    "sw": 150,
                    "sh": 150,
                    "ro": true
                },
                "fesRedBigLight.png": {
                    "x": 2,
                    "y": 703,
                    "w": 438,
                    "h": 431,
                    "ox": 0,
                    "oy": 0,
                    "sw": 438,
                    "sh": 431,
                    "ro": true
                },
                "fesRedBombSta1.png": {
                    "x": 769,
                    "y": 299,
                    "w": 200,
                    "h": 210,
                    "ox": 20,
                    "oy": 15,
                    "sw": 240,
                    "sh": 240,
                    "ro": true
                },
                "fesRedBombSta2.png": {
                    "x": 626,
                    "y": 989,
                    "w": 68,
                    "h": 62,
                    "ox": 6,
                    "oy": 11,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta3_0.png": {
                    "x": 911,
                    "y": 985,
                    "w": 70,
                    "h": 62,
                    "ox": 4,
                    "oy": 12,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta3_1.png": {
                    "x": 785,
                    "y": 835,
                    "w": 70,
                    "h": 62,
                    "ox": 4,
                    "oy": 12,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta3_10.png": {
                    "x": 690,
                    "y": 567,
                    "w": 74,
                    "h": 70,
                    "ox": 6,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta3_11.png": {
                    "x": 306,
                    "y": 1143,
                    "w": 72,
                    "h": 68,
                    "ox": 6,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta3_12.png": {
                    "x": 376,
                    "y": 1143,
                    "w": 72,
                    "h": 64,
                    "ox": 4,
                    "oy": 10,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta3_13.png": {
                    "x": 916,
                    "y": 859,
                    "w": 72,
                    "h": 62,
                    "ox": 3,
                    "oy": 12,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta3_2.png": {
                    "x": 911,
                    "y": 1049,
                    "w": 70,
                    "h": 60,
                    "ox": 4,
                    "oy": 12,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta3_3.png": {
                    "x": 657,
                    "y": 821,
                    "w": 72,
                    "h": 60,
                    "ox": 3,
                    "oy": 11,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta3_4.png": {
                    "x": 916,
                    "y": 923,
                    "w": 72,
                    "h": 60,
                    "ox": 4,
                    "oy": 9,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta3_5.png": {
                    "x": 916,
                    "y": 795,
                    "w": 72,
                    "h": 62,
                    "ox": 6,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta3_6.png": {
                    "x": 238,
                    "y": 1143,
                    "w": 74,
                    "h": 66,
                    "ox": 6,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta3_7.png": {
                    "x": 168,
                    "y": 1143,
                    "w": 74,
                    "h": 68,
                    "ox": 6,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta3_8.png": {
                    "x": 618,
                    "y": 567,
                    "w": 74,
                    "h": 70,
                    "ox": 6,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta3_9.png": {
                    "x": 472,
                    "y": 567,
                    "w": 74,
                    "h": 72,
                    "ox": 6,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta4_0.png": {
                    "x": 785,
                    "y": 771,
                    "w": 70,
                    "h": 62,
                    "ox": 4,
                    "oy": 12,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta4_1.png": {
                    "x": 719,
                    "y": 821,
                    "w": 70,
                    "h": 64,
                    "ox": 5,
                    "oy": 10,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta4_10.png": {
                    "x": 766,
                    "y": 1051,
                    "w": 68,
                    "h": 60,
                    "ox": 5,
                    "oy": 14,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta4_11.png": {
                    "x": 626,
                    "y": 1053,
                    "w": 68,
                    "h": 60,
                    "ox": 5,
                    "oy": 14,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta4_12.png": {
                    "x": 696,
                    "y": 1051,
                    "w": 68,
                    "h": 60,
                    "ox": 5,
                    "oy": 14,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta4_13.png": {
                    "x": 766,
                    "y": 989,
                    "w": 68,
                    "h": 60,
                    "ox": 5,
                    "oy": 14,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta4_14.png": {
                    "x": 562,
                    "y": 1129,
                    "w": 68,
                    "h": 62,
                    "ox": 5,
                    "oy": 12,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta4_15.png": {
                    "x": 562,
                    "y": 1059,
                    "w": 68,
                    "h": 62,
                    "ox": 5,
                    "oy": 12,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta4_16.png": {
                    "x": 562,
                    "y": 989,
                    "w": 68,
                    "h": 62,
                    "ox": 5,
                    "oy": 12,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta4_17.png": {
                    "x": 911,
                    "y": 1111,
                    "w": 68,
                    "h": 62,
                    "ox": 5,
                    "oy": 12,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta4_2.png": {
                    "x": 546,
                    "y": 567,
                    "w": 74,
                    "h": 70,
                    "ox": 5,
                    "oy": 4,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta4_3.png": {
                    "x": 396,
                    "y": 567,
                    "w": 74,
                    "h": 74,
                    "ox": 6,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta4_4.png": {
                    "x": 320,
                    "y": 567,
                    "w": 74,
                    "h": 74,
                    "ox": 6,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta4_5.png": {
                    "x": 244,
                    "y": 567,
                    "w": 74,
                    "h": 74,
                    "ox": 6,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta4_6.png": {
                    "x": 911,
                    "y": 1175,
                    "w": 68,
                    "h": 56,
                    "ox": 5,
                    "oy": 18,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedBombSta4_7.png": {
                    "x": 686,
                    "y": 1115,
                    "w": 68,
                    "h": 58,
                    "ox": 5,
                    "oy": 16,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta4_8.png": {
                    "x": 626,
                    "y": 1115,
                    "w": 68,
                    "h": 58,
                    "ox": 5,
                    "oy": 16,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "fesRedBombSta4_9.png": {
                    "x": 696,
                    "y": 989,
                    "w": 68,
                    "h": 60,
                    "ox": 5,
                    "oy": 14,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "fesRedDown.png": {
                    "x": 769,
                    "y": 62,
                    "w": 237,
                    "h": 235,
                    "ox": 0,
                    "oy": 0,
                    "sw": 237,
                    "sh": 237,
                    "ro": false
                },
                "festivalBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 563,
                    "h": 765,
                    "ox": 0,
                    "oy": 0,
                    "sw": 563,
                    "sh": 765,
                    "ro": true
                },
                "festivalTargetBg.png": {
                    "x": 144,
                    "y": 567,
                    "w": 77,
                    "h": 98,
                    "ox": 0,
                    "oy": 0,
                    "sw": 77,
                    "sh": 98,
                    "ro": true
                },
                "lineLight1.png": {
                    "x": 502,
                    "y": 934,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "lineLight10.png": {
                    "x": 858,
                    "y": 647,
                    "w": 285,
                    "h": 56,
                    "ox": 1,
                    "oy": 2,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "lineLight11.png": {
                    "x": 144,
                    "y": 647,
                    "w": 287,
                    "h": 52,
                    "ox": 1,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight12.png": {
                    "x": 769,
                    "y": 2,
                    "w": 239,
                    "h": 58,
                    "ox": 15,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight13.png": {
                    "x": 502,
                    "y": 934,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "lineLight2.png": {
                    "x": 502,
                    "y": 934,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "lineLight3.png": {
                    "x": 442,
                    "y": 934,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                },
                "lineLight4.png": {
                    "x": 562,
                    "y": 929,
                    "w": 287,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight5.png": {
                    "x": 435,
                    "y": 763,
                    "w": 291,
                    "h": 56,
                    "ox": 2,
                    "oy": 2,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight6.png": {
                    "x": 435,
                    "y": 703,
                    "w": 291,
                    "h": 58,
                    "ox": 2,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight7.png": {
                    "x": 433,
                    "y": 643,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight8.png": {
                    "x": 433,
                    "y": 643,
                    "w": 293,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": false
                },
                "lineLight9.png": {
                    "x": 851,
                    "y": 934,
                    "w": 273,
                    "h": 58,
                    "ox": 16,
                    "oy": 0,
                    "sw": 293,
                    "sh": 58,
                    "ro": true
                }
            }
        },
        {
            "keys": "dis_ele0_0.png,dis_ele0_1.png,dis_ele0_10.png,dis_ele0_11.png,dis_ele0_12.png,dis_ele0_13.png,dis_ele0_14.png,dis_ele0_2.png,dis_ele0_3.png,dis_ele0_4.png,dis_ele0_5.png,dis_ele0_6.png,dis_ele0_7.png,dis_ele0_8.png,dis_ele0_9.png,dis_ele1_0.png,dis_ele1_1.png,dis_ele1_10.png,dis_ele1_11.png,dis_ele1_12.png,dis_ele1_13.png,dis_ele1_14.png,dis_ele1_2.png,dis_ele1_3.png,dis_ele1_4.png,dis_ele1_5.png,dis_ele1_6.png,dis_ele1_7.png,dis_ele1_8.png,dis_ele1_9.png,dis_ele2_0.png,dis_ele2_1.png,dis_ele2_10.png,dis_ele2_11.png,dis_ele2_12.png,dis_ele2_13.png,dis_ele2_14.png,dis_ele2_2.png,dis_ele2_3.png,dis_ele2_4.png,dis_ele2_5.png,dis_ele2_6.png,dis_ele2_7.png,dis_ele2_8.png,dis_ele2_9.png,dis_ele3_0.png,dis_ele3_1.png,dis_ele3_10.png,dis_ele3_11.png,dis_ele3_12.png,dis_ele3_13.png,dis_ele3_14.png,dis_ele3_2.png,dis_ele3_3.png,dis_ele3_4.png,dis_ele3_5.png,dis_ele3_6.png,dis_ele3_7.png,dis_ele3_8.png,dis_ele3_9.png,dis_ele4_0.png,dis_ele4_1.png,dis_ele4_10.png,dis_ele4_11.png,dis_ele4_12.png,dis_ele4_13.png,dis_ele4_14.png,dis_ele4_2.png,dis_ele4_3.png,dis_ele4_4.png,dis_ele4_5.png,dis_ele4_6.png,dis_ele4_7.png,dis_ele4_8.png,dis_ele4_9.png",
            "name": "fiveVerHorDis",
            "atlas": {
                "dis_ele0_0.png": {
                    "x": 104,
                    "y": 1848,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_1.png": {
                    "x": 104,
                    "y": 1754,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_10.png": {
                    "x": 104,
                    "y": 410,
                    "w": 100,
                    "h": 92,
                    "ox": 0,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele0_11.png": {
                    "x": 104,
                    "y": 2242,
                    "w": 98,
                    "h": 90,
                    "ox": 1,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele0_12.png": {
                    "x": 104,
                    "y": 3170,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_13.png": {
                    "x": 104,
                    "y": 3078,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_14.png": {
                    "x": 102,
                    "y": 3622,
                    "w": 88,
                    "h": 88,
                    "ox": 6,
                    "oy": 6,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_2.png": {
                    "x": 104,
                    "y": 904,
                    "w": 92,
                    "h": 96,
                    "ox": 4,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_3.png": {
                    "x": 2,
                    "y": 2960,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_4.png": {
                    "x": 2,
                    "y": 2858,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_5.png": {
                    "x": 2,
                    "y": 2756,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_6.png": {
                    "x": 2,
                    "y": 2654,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_7.png": {
                    "x": 2,
                    "y": 2552,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_8.png": {
                    "x": 2,
                    "y": 2450,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele0_9.png": {
                    "x": 2,
                    "y": 3454,
                    "w": 100,
                    "h": 96,
                    "ox": 0,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_0.png": {
                    "x": 104,
                    "y": 1660,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_1.png": {
                    "x": 104,
                    "y": 1566,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_10.png": {
                    "x": 104,
                    "y": 308,
                    "w": 100,
                    "h": 92,
                    "ox": 0,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele1_11.png": {
                    "x": 104,
                    "y": 2142,
                    "w": 98,
                    "h": 90,
                    "ox": 1,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele1_12.png": {
                    "x": 104,
                    "y": 2986,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_13.png": {
                    "x": 104,
                    "y": 2894,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_14.png": {
                    "x": 104,
                    "y": 3532,
                    "w": 88,
                    "h": 88,
                    "ox": 6,
                    "oy": 6,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_2.png": {
                    "x": 104,
                    "y": 806,
                    "w": 92,
                    "h": 96,
                    "ox": 4,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_3.png": {
                    "x": 2,
                    "y": 2348,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_4.png": {
                    "x": 2,
                    "y": 2246,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_5.png": {
                    "x": 2,
                    "y": 2144,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_6.png": {
                    "x": 2,
                    "y": 2042,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_7.png": {
                    "x": 2,
                    "y": 1940,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_8.png": {
                    "x": 2,
                    "y": 1838,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele1_9.png": {
                    "x": 2,
                    "y": 3356,
                    "w": 100,
                    "h": 96,
                    "ox": 0,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_0.png": {
                    "x": 104,
                    "y": 1472,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_1.png": {
                    "x": 104,
                    "y": 1378,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_10.png": {
                    "x": 104,
                    "y": 206,
                    "w": 100,
                    "h": 92,
                    "ox": 0,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele2_11.png": {
                    "x": 104,
                    "y": 2042,
                    "w": 98,
                    "h": 90,
                    "ox": 1,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele2_12.png": {
                    "x": 104,
                    "y": 2802,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_13.png": {
                    "x": 104,
                    "y": 2710,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_14.png": {
                    "x": 104,
                    "y": 3442,
                    "w": 88,
                    "h": 88,
                    "ox": 6,
                    "oy": 6,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_2.png": {
                    "x": 104,
                    "y": 708,
                    "w": 92,
                    "h": 96,
                    "ox": 4,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_3.png": {
                    "x": 2,
                    "y": 1736,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_4.png": {
                    "x": 2,
                    "y": 1634,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_5.png": {
                    "x": 2,
                    "y": 1532,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_6.png": {
                    "x": 2,
                    "y": 1430,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_7.png": {
                    "x": 2,
                    "y": 1328,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_8.png": {
                    "x": 2,
                    "y": 1226,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele2_9.png": {
                    "x": 2,
                    "y": 3258,
                    "w": 100,
                    "h": 96,
                    "ox": 0,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_0.png": {
                    "x": 104,
                    "y": 1284,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_1.png": {
                    "x": 104,
                    "y": 1190,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_10.png": {
                    "x": 104,
                    "y": 104,
                    "w": 100,
                    "h": 92,
                    "ox": 0,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele3_11.png": {
                    "x": 2,
                    "y": 3552,
                    "w": 98,
                    "h": 90,
                    "ox": 1,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_12.png": {
                    "x": 104,
                    "y": 2618,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_13.png": {
                    "x": 104,
                    "y": 2526,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_14.png": {
                    "x": 104,
                    "y": 3352,
                    "w": 88,
                    "h": 88,
                    "ox": 6,
                    "oy": 6,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_2.png": {
                    "x": 104,
                    "y": 610,
                    "w": 92,
                    "h": 96,
                    "ox": 4,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_3.png": {
                    "x": 2,
                    "y": 1124,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_4.png": {
                    "x": 2,
                    "y": 1022,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_5.png": {
                    "x": 2,
                    "y": 920,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_6.png": {
                    "x": 2,
                    "y": 818,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_7.png": {
                    "x": 2,
                    "y": 716,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_8.png": {
                    "x": 2,
                    "y": 614,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele3_9.png": {
                    "x": 2,
                    "y": 3160,
                    "w": 100,
                    "h": 96,
                    "ox": 0,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_0.png": {
                    "x": 104,
                    "y": 1096,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_1.png": {
                    "x": 104,
                    "y": 1002,
                    "w": 92,
                    "h": 92,
                    "ox": 4,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_10.png": {
                    "x": 104,
                    "y": 2,
                    "w": 100,
                    "h": 92,
                    "ox": 0,
                    "oy": 4,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele4_11.png": {
                    "x": 104,
                    "y": 1942,
                    "w": 98,
                    "h": 90,
                    "ox": 1,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "dis_ele4_12.png": {
                    "x": 104,
                    "y": 2434,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_13.png": {
                    "x": 104,
                    "y": 2342,
                    "w": 90,
                    "h": 90,
                    "ox": 5,
                    "oy": 5,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_14.png": {
                    "x": 104,
                    "y": 3262,
                    "w": 88,
                    "h": 88,
                    "ox": 6,
                    "oy": 6,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_2.png": {
                    "x": 104,
                    "y": 512,
                    "w": 92,
                    "h": 96,
                    "ox": 4,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_3.png": {
                    "x": 2,
                    "y": 512,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_4.png": {
                    "x": 2,
                    "y": 410,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_5.png": {
                    "x": 2,
                    "y": 308,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_6.png": {
                    "x": 2,
                    "y": 206,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_7.png": {
                    "x": 2,
                    "y": 104,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_8.png": {
                    "x": 2,
                    "y": 2,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "dis_ele4_9.png": {
                    "x": 2,
                    "y": 3062,
                    "w": 100,
                    "h": 96,
                    "ox": 0,
                    "oy": 2,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                }
            }
        },
        {
            "keys": "loadingBg.jpg,loadingPro0.png,loadingPro1.png,loadingPro10.png,loadingPro11.png,loadingPro2.png,loadingPro3.png,loadingPro4.png,loadingPro5.png,loadingPro6.png,loadingPro7.png,loadingPro8.png,loadingPro9.png,proDown.png",
            "name": "loadingScene",
            "atlas": {
                "loadingPro0.png": {
                    "x": 3391,
                    "y": 44,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro1.png": {
                    "x": 2829,
                    "y": 44,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro10.png": {
                    "x": 3391,
                    "y": 2,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro11.png": {
                    "x": 2829,
                    "y": 2,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro2.png": {
                    "x": 2267,
                    "y": 44,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro3.png": {
                    "x": 2267,
                    "y": 2,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro4.png": {
                    "x": 1705,
                    "y": 44,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro5.png": {
                    "x": 1705,
                    "y": 2,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro6.png": {
                    "x": 1143,
                    "y": 44,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro7.png": {
                    "x": 1143,
                    "y": 2,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro8.png": {
                    "x": 581,
                    "y": 44,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "loadingPro9.png": {
                    "x": 581,
                    "y": 2,
                    "w": 560,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 560,
                    "sh": 40,
                    "ro": false
                },
                "proDown.png": {
                    "x": 2,
                    "y": 2,
                    "w": 577,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 577,
                    "sh": 48,
                    "ro": false
                }
            }
        },
        {
            "keys": "cur_light_1.png,cur_light_2.png,guide_hand.png,guide_light.png,lightImg.png,mapGuide.png,map_avatar_bg.png,map_bg1.jpg,map_bg2.jpg,map_bg3.jpg,map_check_disable.png,map_check_enable.png,map_check_enable_cur.png,map_energyAdd.png,map_energyBg.png,map_prizeBtn.png,map_ruleBtn.png,map_star_disable.png,map_star_enable.png,map_taskBtn.png,map_taskBtn_tip.png",
            "name": "map",
            "atlas": {
                "cur_light_1.png": {
                    "x": 2,
                    "y": 650,
                    "w": 187,
                    "h": 115,
                    "ox": 0,
                    "oy": 0,
                    "sw": 197,
                    "sh": 123,
                    "ro": false
                },
                "cur_light_2.png": {
                    "x": 322,
                    "y": 650,
                    "w": 127,
                    "h": 101,
                    "ox": 36,
                    "oy": 9,
                    "sw": 197,
                    "sh": 123,
                    "ro": false
                },
                "guide_hand.png": {
                    "x": 451,
                    "y": 650,
                    "w": 90,
                    "h": 91,
                    "ox": 0,
                    "oy": 0,
                    "sw": 90,
                    "sh": 91,
                    "ro": false
                },
                "guide_light.png": {
                    "x": 505,
                    "y": 743,
                    "w": 40,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 40,
                    "sh": 40,
                    "ro": false
                },
                "lightImg.png": {
                    "x": 370,
                    "y": 879,
                    "w": 28,
                    "h": 42,
                    "ox": 0,
                    "oy": 0,
                    "sw": 28,
                    "sh": 42,
                    "ro": true
                },
                "mapGuide.png": {
                    "x": 2,
                    "y": 2,
                    "w": 561,
                    "h": 646,
                    "ox": 0,
                    "oy": 0,
                    "sw": 561,
                    "sh": 646,
                    "ro": false
                },
                "map_avatar_bg.png": {
                    "x": 473,
                    "y": 797,
                    "w": 87,
                    "h": 92,
                    "ox": 4,
                    "oy": 10,
                    "sw": 95,
                    "sh": 104,
                    "ro": false
                },
                "map_check_disable.png": {
                    "x": 370,
                    "y": 797,
                    "w": 101,
                    "h": 80,
                    "ox": 3,
                    "oy": 17,
                    "sw": 109,
                    "sh": 104,
                    "ro": false
                },
                "map_check_enable.png": {
                    "x": 105,
                    "y": 836,
                    "w": 101,
                    "h": 80,
                    "ox": 3,
                    "oy": 16,
                    "sw": 109,
                    "sh": 104,
                    "ro": false
                },
                "map_check_enable_cur.png": {
                    "x": 2,
                    "y": 836,
                    "w": 101,
                    "h": 80,
                    "ox": 3,
                    "oy": 17,
                    "sw": 109,
                    "sh": 104,
                    "ro": false
                },
                "map_energyAdd.png": {
                    "x": 414,
                    "y": 879,
                    "w": 35,
                    "h": 33,
                    "ox": 0,
                    "oy": 0,
                    "sw": 35,
                    "sh": 33,
                    "ro": false
                },
                "map_energyBg.png": {
                    "x": 2,
                    "y": 767,
                    "w": 186,
                    "h": 67,
                    "ox": 0,
                    "oy": 0,
                    "sw": 186,
                    "sh": 67,
                    "ro": false
                },
                "map_prizeBtn.png": {
                    "x": 208,
                    "y": 832,
                    "w": 160,
                    "h": 60,
                    "ox": 0,
                    "oy": 0,
                    "sw": 160,
                    "sh": 60,
                    "ro": false
                },
                "map_ruleBtn.png": {
                    "x": 190,
                    "y": 770,
                    "w": 160,
                    "h": 60,
                    "ox": 0,
                    "oy": 0,
                    "sw": 160,
                    "sh": 60,
                    "ro": false
                },
                "map_star_disable.png": {
                    "x": 479,
                    "y": 891,
                    "w": 25,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 24,
                    "ro": true
                },
                "map_star_enable.png": {
                    "x": 451,
                    "y": 891,
                    "w": 26,
                    "h": 25,
                    "ox": 0,
                    "oy": 0,
                    "sw": 26,
                    "sh": 25,
                    "ro": false
                },
                "map_taskBtn.png": {
                    "x": 191,
                    "y": 650,
                    "w": 118,
                    "h": 129,
                    "ox": 0,
                    "oy": 0,
                    "sw": 118,
                    "sh": 129,
                    "ro": true
                },
                "map_taskBtn_tip.png": {
                    "x": 352,
                    "y": 753,
                    "w": 151,
                    "h": 42,
                    "ox": 0,
                    "oy": 0,
                    "sw": 151,
                    "sh": 42,
                    "ro": false
                }
            }
        },
        {
            "keys": "Aroma_1_0.png,Aroma_1_1.png,Aroma_1_10.png,Aroma_1_11.png,Aroma_1_12.png,Aroma_1_13.png,Aroma_1_14.png,Aroma_1_15.png,Aroma_1_16.png,Aroma_1_17.png,Aroma_1_18.png,Aroma_1_2.png,Aroma_1_3.png,Aroma_1_4.png,Aroma_1_5.png,Aroma_1_6.png,Aroma_1_7.png,Aroma_1_8.png,Aroma_1_9.png",
            "name": "mapAroma1",
            "atlas": {
                "Aroma_1_0.png": {
                    "x": 2362,
                    "y": 476,
                    "w": 1,
                    "h": 1,
                    "ox": 0,
                    "oy": 0,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_1.png": {
                    "x": 2067,
                    "y": 241,
                    "w": 293,
                    "h": 235,
                    "ox": 0,
                    "oy": 4,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_10.png": {
                    "x": 2067,
                    "y": 2,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_11.png": {
                    "x": 1772,
                    "y": 241,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_12.png": {
                    "x": 1772,
                    "y": 2,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_13.png": {
                    "x": 1477,
                    "y": 241,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_14.png": {
                    "x": 1477,
                    "y": 2,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_15.png": {
                    "x": 1182,
                    "y": 241,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_16.png": {
                    "x": 2362,
                    "y": 239,
                    "w": 293,
                    "h": 235,
                    "ox": 0,
                    "oy": 4,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_17.png": {
                    "x": 1182,
                    "y": 2,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_18.png": {
                    "x": 887,
                    "y": 241,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_2.png": {
                    "x": 2362,
                    "y": 2,
                    "w": 293,
                    "h": 235,
                    "ox": 0,
                    "oy": 4,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_3.png": {
                    "x": 887,
                    "y": 2,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_4.png": {
                    "x": 592,
                    "y": 241,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_5.png": {
                    "x": 592,
                    "y": 2,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_6.png": {
                    "x": 297,
                    "y": 241,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_7.png": {
                    "x": 297,
                    "y": 2,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_8.png": {
                    "x": 2,
                    "y": 241,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                },
                "Aroma_1_9.png": {
                    "x": 2,
                    "y": 2,
                    "w": 293,
                    "h": 237,
                    "ox": 0,
                    "oy": 2,
                    "sw": 293,
                    "sh": 239,
                    "ro": false
                }
            }
        },
        {
            "keys": "map_cat_0.png,map_cat_1.png,map_cat_10.png,map_cat_11.png,map_cat_12.png,map_cat_13.png,map_cat_14.png,map_cat_15.png,map_cat_16.png,map_cat_17.png,map_cat_18.png,map_cat_19.png,map_cat_2.png,map_cat_20.png,map_cat_21.png,map_cat_22.png,map_cat_23.png,map_cat_24.png,map_cat_25.png,map_cat_26.png,map_cat_27.png,map_cat_28.png,map_cat_29.png,map_cat_3.png,map_cat_30.png,map_cat_31.png,map_cat_32.png,map_cat_33.png,map_cat_34.png,map_cat_4.png,map_cat_5.png,map_cat_6.png,map_cat_7.png,map_cat_8.png,map_cat_9.png",
            "name": "mapCat",
            "atlas": {
                "map_cat_0.png": {
                    "x": 590,
                    "y": 2,
                    "w": 96,
                    "h": 60,
                    "ox": 10,
                    "oy": 17,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_1.png": {
                    "x": 492,
                    "y": 2,
                    "w": 96,
                    "h": 60,
                    "ox": 10,
                    "oy": 17,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_10.png": {
                    "x": 2714,
                    "y": 2,
                    "w": 104,
                    "h": 56,
                    "ox": 10,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_11.png": {
                    "x": 2608,
                    "y": 2,
                    "w": 104,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_12.png": {
                    "x": 2288,
                    "y": 2,
                    "w": 106,
                    "h": 56,
                    "ox": 10,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_13.png": {
                    "x": 2180,
                    "y": 2,
                    "w": 106,
                    "h": 56,
                    "ox": 10,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_14.png": {
                    "x": 2072,
                    "y": 2,
                    "w": 106,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_15.png": {
                    "x": 1746,
                    "y": 2,
                    "w": 108,
                    "h": 56,
                    "ox": 10,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_16.png": {
                    "x": 688,
                    "y": 2,
                    "w": 108,
                    "h": 58,
                    "ox": 11,
                    "oy": 19,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_17.png": {
                    "x": 1636,
                    "y": 2,
                    "w": 108,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_18.png": {
                    "x": 1526,
                    "y": 2,
                    "w": 108,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_19.png": {
                    "x": 1416,
                    "y": 2,
                    "w": 108,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_2.png": {
                    "x": 394,
                    "y": 2,
                    "w": 96,
                    "h": 60,
                    "ox": 10,
                    "oy": 17,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_20.png": {
                    "x": 1306,
                    "y": 2,
                    "w": 108,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_21.png": {
                    "x": 1196,
                    "y": 2,
                    "w": 108,
                    "h": 56,
                    "ox": 10,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_22.png": {
                    "x": 1964,
                    "y": 2,
                    "w": 106,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_23.png": {
                    "x": 1856,
                    "y": 2,
                    "w": 106,
                    "h": 56,
                    "ox": 10,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_24.png": {
                    "x": 2502,
                    "y": 2,
                    "w": 104,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_25.png": {
                    "x": 2396,
                    "y": 2,
                    "w": 104,
                    "h": 56,
                    "ox": 10,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_26.png": {
                    "x": 3132,
                    "y": 2,
                    "w": 102,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_27.png": {
                    "x": 3028,
                    "y": 2,
                    "w": 102,
                    "h": 56,
                    "ox": 10,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_28.png": {
                    "x": 3338,
                    "y": 2,
                    "w": 100,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_29.png": {
                    "x": 3540,
                    "y": 2,
                    "w": 98,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_3.png": {
                    "x": 296,
                    "y": 2,
                    "w": 96,
                    "h": 60,
                    "ox": 11,
                    "oy": 17,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_30.png": {
                    "x": 998,
                    "y": 2,
                    "w": 98,
                    "h": 58,
                    "ox": 10,
                    "oy": 19,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_31.png": {
                    "x": 1098,
                    "y": 2,
                    "w": 96,
                    "h": 58,
                    "ox": 11,
                    "oy": 19,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_32.png": {
                    "x": 198,
                    "y": 2,
                    "w": 96,
                    "h": 60,
                    "ox": 11,
                    "oy": 17,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_33.png": {
                    "x": 100,
                    "y": 2,
                    "w": 96,
                    "h": 60,
                    "ox": 10,
                    "oy": 17,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_34.png": {
                    "x": 2,
                    "y": 2,
                    "w": 96,
                    "h": 60,
                    "ox": 10,
                    "oy": 17,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_4.png": {
                    "x": 898,
                    "y": 2,
                    "w": 98,
                    "h": 58,
                    "ox": 10,
                    "oy": 19,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_5.png": {
                    "x": 798,
                    "y": 2,
                    "w": 98,
                    "h": 58,
                    "ox": 10,
                    "oy": 19,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_6.png": {
                    "x": 3440,
                    "y": 2,
                    "w": 98,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_7.png": {
                    "x": 3236,
                    "y": 2,
                    "w": 100,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_8.png": {
                    "x": 2924,
                    "y": 2,
                    "w": 102,
                    "h": 56,
                    "ox": 10,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                },
                "map_cat_9.png": {
                    "x": 2820,
                    "y": 2,
                    "w": 102,
                    "h": 56,
                    "ox": 11,
                    "oy": 21,
                    "sw": 120,
                    "sh": 100,
                    "ro": false
                }
            }
        },
        {
            "keys": "cloud.png,top_foot.png,热气球.png,薯片店.png",
            "name": "mapEffect",
            "atlas": {
                "cloud.png": {
                    "x": 2,
                    "y": 2,
                    "w": 692,
                    "h": 373,
                    "ox": 0,
                    "oy": 0,
                    "sw": 692,
                    "sh": 373,
                    "ro": false
                },
                "top_foot.png": {
                    "x": 696,
                    "y": 302,
                    "w": 165,
                    "h": 366,
                    "ox": 0,
                    "oy": 30,
                    "sw": 165,
                    "sh": 396,
                    "ro": true
                },
                "热气球.png": {
                    "x": 1082,
                    "y": 2,
                    "w": 231,
                    "h": 417,
                    "ox": 0,
                    "oy": 0,
                    "sw": 231,
                    "sh": 417,
                    "ro": false
                },
                "薯片店.png": {
                    "x": 696,
                    "y": 2,
                    "w": 298,
                    "h": 384,
                    "ox": 0,
                    "oy": 0,
                    "sw": 298,
                    "sh": 384,
                    "ro": true
                }
            }
        },
        {
            "keys": "tinyBalloon_0.png,tinyBalloon_1.png,tinyBalloon_10.png,tinyBalloon_11.png,tinyBalloon_12.png,tinyBalloon_13.png,tinyBalloon_14.png,tinyBalloon_15.png,tinyBalloon_16.png,tinyBalloon_17.png,tinyBalloon_18.png,tinyBalloon_19.png,tinyBalloon_2.png,tinyBalloon_20.png,tinyBalloon_21.png,tinyBalloon_22.png,tinyBalloon_23.png,tinyBalloon_24.png,tinyBalloon_25.png,tinyBalloon_26.png,tinyBalloon_27.png,tinyBalloon_28.png,tinyBalloon_29.png,tinyBalloon_3.png,tinyBalloon_30.png,tinyBalloon_31.png,tinyBalloon_32.png,tinyBalloon_33.png,tinyBalloon_34.png,tinyBalloon_35.png,tinyBalloon_36.png,tinyBalloon_37.png,tinyBalloon_38.png,tinyBalloon_39.png,tinyBalloon_4.png,tinyBalloon_40.png,tinyBalloon_41.png,tinyBalloon_5.png,tinyBalloon_6.png,tinyBalloon_7.png,tinyBalloon_8.png,tinyBalloon_9.png",
            "name": "mapTinyBalloon",
            "atlas": {
                "tinyBalloon_0.png": {
                    "x": 502,
                    "y": 2,
                    "w": 98,
                    "h": 150,
                    "ox": 24,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_1.png": {
                    "x": 402,
                    "y": 2,
                    "w": 98,
                    "h": 150,
                    "ox": 24,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_10.png": {
                    "x": 988,
                    "y": 2,
                    "w": 92,
                    "h": 150,
                    "ox": 28,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_11.png": {
                    "x": 1174,
                    "y": 2,
                    "w": 90,
                    "h": 150,
                    "ox": 29,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_12.png": {
                    "x": 1082,
                    "y": 2,
                    "w": 90,
                    "h": 150,
                    "ox": 29,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_13.png": {
                    "x": 1266,
                    "y": 2,
                    "w": 88,
                    "h": 150,
                    "ox": 30,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_14.png": {
                    "x": 1356,
                    "y": 2,
                    "w": 86,
                    "h": 150,
                    "ox": 32,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_15.png": {
                    "x": 1530,
                    "y": 2,
                    "w": 84,
                    "h": 150,
                    "ox": 33,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_16.png": {
                    "x": 1444,
                    "y": 2,
                    "w": 84,
                    "h": 150,
                    "ox": 33,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_17.png": {
                    "x": 1952,
                    "y": 2,
                    "w": 82,
                    "h": 150,
                    "ox": 34,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_18.png": {
                    "x": 2610,
                    "y": 2,
                    "w": 80,
                    "h": 150,
                    "ox": 35,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_19.png": {
                    "x": 2528,
                    "y": 2,
                    "w": 80,
                    "h": 150,
                    "ox": 35,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_2.png": {
                    "x": 302,
                    "y": 2,
                    "w": 98,
                    "h": 150,
                    "ox": 24,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_20.png": {
                    "x": 2446,
                    "y": 2,
                    "w": 80,
                    "h": 150,
                    "ox": 34,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_21.png": {
                    "x": 2364,
                    "y": 2,
                    "w": 80,
                    "h": 150,
                    "ox": 34,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_22.png": {
                    "x": 2282,
                    "y": 2,
                    "w": 80,
                    "h": 150,
                    "ox": 33,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_23.png": {
                    "x": 3412,
                    "y": 2,
                    "w": 78,
                    "h": 150,
                    "ox": 34,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_24.png": {
                    "x": 3332,
                    "y": 2,
                    "w": 78,
                    "h": 150,
                    "ox": 34,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_25.png": {
                    "x": 3252,
                    "y": 2,
                    "w": 78,
                    "h": 150,
                    "ox": 33,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_26.png": {
                    "x": 3172,
                    "y": 2,
                    "w": 78,
                    "h": 150,
                    "ox": 32,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_27.png": {
                    "x": 3092,
                    "y": 2,
                    "w": 78,
                    "h": 150,
                    "ox": 32,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_28.png": {
                    "x": 3012,
                    "y": 2,
                    "w": 78,
                    "h": 150,
                    "ox": 31,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_29.png": {
                    "x": 2932,
                    "y": 2,
                    "w": 78,
                    "h": 150,
                    "ox": 31,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_3.png": {
                    "x": 202,
                    "y": 2,
                    "w": 98,
                    "h": 150,
                    "ox": 24,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_30.png": {
                    "x": 3570,
                    "y": 2,
                    "w": 76,
                    "h": 150,
                    "ox": 32,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_31.png": {
                    "x": 2852,
                    "y": 2,
                    "w": 78,
                    "h": 150,
                    "ox": 30,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_32.png": {
                    "x": 3492,
                    "y": 2,
                    "w": 76,
                    "h": 150,
                    "ox": 31,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_33.png": {
                    "x": 2772,
                    "y": 2,
                    "w": 78,
                    "h": 150,
                    "ox": 30,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_34.png": {
                    "x": 2692,
                    "y": 2,
                    "w": 78,
                    "h": 150,
                    "ox": 31,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_35.png": {
                    "x": 2200,
                    "y": 2,
                    "w": 80,
                    "h": 150,
                    "ox": 29,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_36.png": {
                    "x": 2118,
                    "y": 2,
                    "w": 80,
                    "h": 150,
                    "ox": 30,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_37.png": {
                    "x": 2036,
                    "y": 2,
                    "w": 80,
                    "h": 150,
                    "ox": 30,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_38.png": {
                    "x": 1868,
                    "y": 2,
                    "w": 82,
                    "h": 150,
                    "ox": 29,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_39.png": {
                    "x": 1784,
                    "y": 2,
                    "w": 82,
                    "h": 150,
                    "ox": 29,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_4.png": {
                    "x": 102,
                    "y": 2,
                    "w": 98,
                    "h": 150,
                    "ox": 24,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_40.png": {
                    "x": 1700,
                    "y": 2,
                    "w": 82,
                    "h": 150,
                    "ox": 29,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_41.png": {
                    "x": 1616,
                    "y": 2,
                    "w": 82,
                    "h": 150,
                    "ox": 29,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_5.png": {
                    "x": 2,
                    "y": 2,
                    "w": 98,
                    "h": 150,
                    "ox": 24,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_6.png": {
                    "x": 700,
                    "y": 2,
                    "w": 96,
                    "h": 150,
                    "ox": 25,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_7.png": {
                    "x": 602,
                    "y": 2,
                    "w": 96,
                    "h": 150,
                    "ox": 25,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_8.png": {
                    "x": 798,
                    "y": 2,
                    "w": 94,
                    "h": 150,
                    "ox": 27,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                },
                "tinyBalloon_9.png": {
                    "x": 894,
                    "y": 2,
                    "w": 92,
                    "h": 150,
                    "ox": 28,
                    "oy": 34,
                    "sw": 150,
                    "sh": 190,
                    "ro": false
                }
            }
        },
        {
            "keys": "map_tree_0.png,map_tree_1.png,map_tree_10.png,map_tree_11.png,map_tree_12.png,map_tree_13.png,map_tree_14.png,map_tree_15.png,map_tree_16.png,map_tree_17.png,map_tree_18.png,map_tree_19.png,map_tree_2.png,map_tree_20.png,map_tree_21.png,map_tree_22.png,map_tree_23.png,map_tree_24.png,map_tree_25.png,map_tree_26.png,map_tree_27.png,map_tree_28.png,map_tree_29.png,map_tree_3.png,map_tree_30.png,map_tree_31.png,map_tree_32.png,map_tree_4.png,map_tree_5.png,map_tree_6.png,map_tree_7.png,map_tree_8.png,map_tree_9.png",
            "name": "mapTree",
            "atlas": {
                "map_tree_0.png": {
                    "x": 1086,
                    "y": 2,
                    "w": 214,
                    "h": 242,
                    "ox": 57,
                    "oy": 43,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_1.png": {
                    "x": 220,
                    "y": 2,
                    "w": 216,
                    "h": 242,
                    "ox": 56,
                    "oy": 43,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_10.png": {
                    "x": 868,
                    "y": 246,
                    "w": 214,
                    "h": 242,
                    "ox": 65,
                    "oy": 43,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_11.png": {
                    "x": 1940,
                    "y": 246,
                    "w": 212,
                    "h": 240,
                    "ox": 68,
                    "oy": 45,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_12.png": {
                    "x": 1944,
                    "y": 2,
                    "w": 212,
                    "h": 242,
                    "ox": 69,
                    "oy": 44,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_13.png": {
                    "x": 1726,
                    "y": 246,
                    "w": 212,
                    "h": 242,
                    "ox": 70,
                    "oy": 44,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_14.png": {
                    "x": 1730,
                    "y": 2,
                    "w": 212,
                    "h": 242,
                    "ox": 70,
                    "oy": 44,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_15.png": {
                    "x": 1512,
                    "y": 246,
                    "w": 212,
                    "h": 242,
                    "ox": 71,
                    "oy": 44,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_16.png": {
                    "x": 1516,
                    "y": 2,
                    "w": 212,
                    "h": 242,
                    "ox": 71,
                    "oy": 44,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_17.png": {
                    "x": 1298,
                    "y": 246,
                    "w": 212,
                    "h": 242,
                    "ox": 71,
                    "oy": 44,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_18.png": {
                    "x": 1302,
                    "y": 2,
                    "w": 212,
                    "h": 242,
                    "ox": 72,
                    "oy": 44,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_19.png": {
                    "x": 1084,
                    "y": 246,
                    "w": 212,
                    "h": 242,
                    "ox": 72,
                    "oy": 44,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_2.png": {
                    "x": 2,
                    "y": 246,
                    "w": 216,
                    "h": 242,
                    "ox": 56,
                    "oy": 43,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_20.png": {
                    "x": 3426,
                    "y": 244,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_21.png": {
                    "x": 3214,
                    "y": 244,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_22.png": {
                    "x": 3002,
                    "y": 244,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_23.png": {
                    "x": 2790,
                    "y": 244,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_24.png": {
                    "x": 2578,
                    "y": 244,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_25.png": {
                    "x": 2366,
                    "y": 244,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_26.png": {
                    "x": 2154,
                    "y": 246,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_27.png": {
                    "x": 3218,
                    "y": 2,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_28.png": {
                    "x": 3006,
                    "y": 2,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_29.png": {
                    "x": 2794,
                    "y": 2,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_3.png": {
                    "x": 870,
                    "y": 2,
                    "w": 214,
                    "h": 242,
                    "ox": 58,
                    "oy": 43,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_30.png": {
                    "x": 2582,
                    "y": 2,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_31.png": {
                    "x": 2370,
                    "y": 2,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_32.png": {
                    "x": 2158,
                    "y": 2,
                    "w": 210,
                    "h": 240,
                    "ox": 74,
                    "oy": 46,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_4.png": {
                    "x": 652,
                    "y": 246,
                    "w": 214,
                    "h": 242,
                    "ox": 58,
                    "oy": 43,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_5.png": {
                    "x": 654,
                    "y": 2,
                    "w": 214,
                    "h": 242,
                    "ox": 59,
                    "oy": 43,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_6.png": {
                    "x": 2,
                    "y": 2,
                    "w": 216,
                    "h": 242,
                    "ox": 59,
                    "oy": 43,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_7.png": {
                    "x": 436,
                    "y": 246,
                    "w": 214,
                    "h": 242,
                    "ox": 62,
                    "oy": 43,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_8.png": {
                    "x": 438,
                    "y": 2,
                    "w": 214,
                    "h": 242,
                    "ox": 63,
                    "oy": 43,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                },
                "map_tree_9.png": {
                    "x": 220,
                    "y": 246,
                    "w": 214,
                    "h": 242,
                    "ox": 64,
                    "oy": 43,
                    "sw": 300,
                    "sh": 300,
                    "ro": false
                }
            }
        },
        {
            "keys": "bonusFra0.png,bonusFra1.png,bonusFra10.png,bonusFra11.png,bonusFra2.png,bonusFra3.png,bonusFra4.png,bonusFra5.png,bonusFra6.png,bonusFra7.png,bonusFra8.png,bonusFra9.png,boom0.png,boom1.png,boom10.png,boom11.png,boom12.png,boom13.png,boom14.png,boom15.png,boom16.png,boom17.png,boom18.png,boom19.png,boom2.png,boom20.png,boom3.png,boom4.png,boom5.png,boom6.png,boom7.png,boom8.png,boom9.png,bubbleStar1.png,bubbleStar10.png,bubbleStar11.png,bubbleStar12.png,bubbleStar13.png,bubbleStar14.png,bubbleStar15.png,bubbleStar16.png,bubbleStar17.png,bubbleStar18.png,bubbleStar19.png,bubbleStar2.png,bubbleStar3.png,bubbleStar4.png,bubbleStar5.png,bubbleStar6.png,bubbleStar7.png,bubbleStar8.png,bubbleStar9.png,exLighting0.png,exLighting10.png,exLighting13.png,exLighting15.png,exLighting17.png,exLighting18.png,exLighting2.png,exLighting20.png,exLighting22.png,exLighting24.png,exLighting26.png,exLighting28.png,exLighting31.png,exLighting33.png,exLighting4.png,exLighting6.png,exLighting8.png,stepAni1.png,stepAni10.png,stepAni11.png,stepAni2.png,stepAni3.png,stepAni4.png,stepAni5.png,stepAni6.png,stepAni7.png,stepAni8.png,stepAni9.png",
            "name": "playFrameAni",
            "atlas": {
                "bonusFra0.png": {
                    "x": 500,
                    "y": 1426,
                    "w": 42,
                    "h": 42,
                    "ox": 38,
                    "oy": 38,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra1.png": {
                    "x": 958,
                    "y": 1052,
                    "w": 60,
                    "h": 60,
                    "ox": 30,
                    "oy": 30,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra10.png": {
                    "x": 796,
                    "y": 2202,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra11.png": {
                    "x": 674,
                    "y": 2332,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra2.png": {
                    "x": 918,
                    "y": 2272,
                    "w": 80,
                    "h": 80,
                    "ox": 20,
                    "oy": 20,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra3.png": {
                    "x": 908,
                    "y": 2076,
                    "w": 98,
                    "h": 98,
                    "ox": 11,
                    "oy": 11,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra4.png": {
                    "x": 796,
                    "y": 2324,
                    "w": 112,
                    "h": 112,
                    "ox": 4,
                    "oy": 4,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra5.png": {
                    "x": 674,
                    "y": 2210,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra6.png": {
                    "x": 552,
                    "y": 2332,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra7.png": {
                    "x": 552,
                    "y": 2210,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra8.png": {
                    "x": 256,
                    "y": 2278,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "bonusFra9.png": {
                    "x": 256,
                    "y": 2156,
                    "w": 120,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 120,
                    "ro": false
                },
                "boom0.png": {
                    "x": 778,
                    "y": 1596,
                    "w": 54,
                    "h": 54,
                    "ox": 102,
                    "oy": 102,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom1.png": {
                    "x": 768,
                    "y": 1052,
                    "w": 92,
                    "h": 92,
                    "ox": 83,
                    "oy": 83,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom10.png": {
                    "x": 2,
                    "y": 2166,
                    "w": 252,
                    "h": 252,
                    "ox": 4,
                    "oy": 4,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom11.png": {
                    "x": 302,
                    "y": 1774,
                    "w": 248,
                    "h": 248,
                    "ox": 5,
                    "oy": 5,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom12.png": {
                    "x": 378,
                    "y": 2190,
                    "w": 158,
                    "h": 172,
                    "ox": 53,
                    "oy": 45,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom13.png": {
                    "x": 734,
                    "y": 2040,
                    "w": 160,
                    "h": 172,
                    "ox": 51,
                    "oy": 45,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom14.png": {
                    "x": 552,
                    "y": 2040,
                    "w": 168,
                    "h": 180,
                    "ox": 47,
                    "oy": 41,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom15.png": {
                    "x": 754,
                    "y": 1848,
                    "w": 176,
                    "h": 190,
                    "ox": 43,
                    "oy": 36,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom16.png": {
                    "x": 552,
                    "y": 1854,
                    "w": 184,
                    "h": 200,
                    "ox": 39,
                    "oy": 31,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom17.png": {
                    "x": 806,
                    "y": 220,
                    "w": 188,
                    "h": 208,
                    "ox": 37,
                    "oy": 27,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom18.png": {
                    "x": 806,
                    "y": 430,
                    "w": 190,
                    "h": 206,
                    "ox": 36,
                    "oy": 28,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom19.png": {
                    "x": 552,
                    "y": 1652,
                    "w": 188,
                    "h": 200,
                    "ox": 37,
                    "oy": 31,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom2.png": {
                    "x": 254,
                    "y": 2024,
                    "w": 130,
                    "h": 130,
                    "ox": 64,
                    "oy": 64,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom20.png": {
                    "x": 806,
                    "y": 638,
                    "w": 176,
                    "h": 190,
                    "ox": 42,
                    "oy": 36,
                    "sw": 260,
                    "sh": 260,
                    "ro": true
                },
                "boom3.png": {
                    "x": 386,
                    "y": 2024,
                    "w": 164,
                    "h": 164,
                    "ox": 48,
                    "oy": 48,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom4.png": {
                    "x": 742,
                    "y": 1652,
                    "w": 194,
                    "h": 194,
                    "ox": 33,
                    "oy": 33,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom5.png": {
                    "x": 806,
                    "y": 2,
                    "w": 216,
                    "h": 216,
                    "ox": 22,
                    "oy": 22,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom6.png": {
                    "x": 552,
                    "y": 1426,
                    "w": 224,
                    "h": 224,
                    "ox": 18,
                    "oy": 18,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom7.png": {
                    "x": 768,
                    "y": 816,
                    "w": 234,
                    "h": 234,
                    "ox": 13,
                    "oy": 13,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom8.png": {
                    "x": 690,
                    "y": 1150,
                    "w": 242,
                    "h": 242,
                    "ox": 9,
                    "oy": 9,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "boom9.png": {
                    "x": 302,
                    "y": 1524,
                    "w": 248,
                    "h": 248,
                    "ox": 6,
                    "oy": 6,
                    "sw": 260,
                    "sh": 260,
                    "ro": false
                },
                "bubbleStar1.png": {
                    "x": 254,
                    "y": 2012,
                    "w": 18,
                    "h": 10,
                    "ox": 32,
                    "oy": 67,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar10.png": {
                    "x": 254,
                    "y": 1968,
                    "w": 46,
                    "h": 42,
                    "ox": 18,
                    "oy": 27,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar11.png": {
                    "x": 254,
                    "y": 1922,
                    "w": 46,
                    "h": 44,
                    "ox": 19,
                    "oy": 20,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar12.png": {
                    "x": 254,
                    "y": 1874,
                    "w": 46,
                    "h": 46,
                    "ox": 19,
                    "oy": 13,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar13.png": {
                    "x": 768,
                    "y": 748,
                    "w": 42,
                    "h": 28,
                    "ox": 21,
                    "oy": 27,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar14.png": {
                    "x": 690,
                    "y": 1394,
                    "w": 38,
                    "h": 30,
                    "ox": 24,
                    "oy": 21,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar15.png": {
                    "x": 730,
                    "y": 1394,
                    "w": 32,
                    "h": 30,
                    "ox": 27,
                    "oy": 17,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar16.png": {
                    "x": 1006,
                    "y": 1302,
                    "w": 24,
                    "h": 16,
                    "ox": 33,
                    "oy": 26,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar17.png": {
                    "x": 1006,
                    "y": 1328,
                    "w": 18,
                    "h": 16,
                    "ox": 32,
                    "oy": 20,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar18.png": {
                    "x": 796,
                    "y": 2438,
                    "w": 14,
                    "h": 14,
                    "ox": 32,
                    "oy": 17,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar19.png": {
                    "x": 378,
                    "y": 2156,
                    "w": 6,
                    "h": 6,
                    "ox": 34,
                    "oy": 19,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar2.png": {
                    "x": 764,
                    "y": 1394,
                    "w": 24,
                    "h": 12,
                    "ox": 30,
                    "oy": 62,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar3.png": {
                    "x": 50,
                    "y": 2420,
                    "w": 32,
                    "h": 20,
                    "ox": 25,
                    "oy": 59,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar4.png": {
                    "x": 984,
                    "y": 1726,
                    "w": 38,
                    "h": 24,
                    "ox": 22,
                    "oy": 53,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar5.png": {
                    "x": 994,
                    "y": 2222,
                    "w": 42,
                    "h": 28,
                    "ox": 21,
                    "oy": 49,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar6.png": {
                    "x": 994,
                    "y": 2176,
                    "w": 44,
                    "h": 28,
                    "ox": 20,
                    "oy": 46,
                    "sw": 90,
                    "sh": 90,
                    "ro": true
                },
                "bubbleStar7.png": {
                    "x": 2,
                    "y": 2420,
                    "w": 46,
                    "h": 32,
                    "ox": 19,
                    "oy": 44,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar8.png": {
                    "x": 834,
                    "y": 1596,
                    "w": 46,
                    "h": 38,
                    "ox": 19,
                    "oy": 39,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "bubbleStar9.png": {
                    "x": 938,
                    "y": 1726,
                    "w": 44,
                    "h": 40,
                    "ox": 19,
                    "oy": 33,
                    "sw": 90,
                    "sh": 90,
                    "ro": false
                },
                "exLighting0.png": {
                    "x": 938,
                    "y": 1130,
                    "w": 76,
                    "h": 84,
                    "ox": 7,
                    "oy": 7,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting10.png": {
                    "x": 934,
                    "y": 1208,
                    "w": 92,
                    "h": 74,
                    "ox": 4,
                    "oy": 10,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting13.png": {
                    "x": 932,
                    "y": 1926,
                    "w": 90,
                    "h": 76,
                    "ox": 2,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting15.png": {
                    "x": 934,
                    "y": 1394,
                    "w": 82,
                    "h": 76,
                    "ox": 4,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting17.png": {
                    "x": 934,
                    "y": 1478,
                    "w": 78,
                    "h": 82,
                    "ox": 7,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting18.png": {
                    "x": 474,
                    "y": 2350,
                    "w": 76,
                    "h": 84,
                    "ox": 7,
                    "oy": 7,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting2.png": {
                    "x": 938,
                    "y": 1644,
                    "w": 78,
                    "h": 80,
                    "ox": 2,
                    "oy": 11,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting20.png": {
                    "x": 934,
                    "y": 1562,
                    "w": 78,
                    "h": 80,
                    "ox": 2,
                    "oy": 11,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting22.png": {
                    "x": 862,
                    "y": 1052,
                    "w": 94,
                    "h": 76,
                    "ox": 0,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting24.png": {
                    "x": 918,
                    "y": 2176,
                    "w": 94,
                    "h": 74,
                    "ox": 0,
                    "oy": 14,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting26.png": {
                    "x": 934,
                    "y": 1302,
                    "w": 90,
                    "h": 70,
                    "ox": 4,
                    "oy": 17,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting28.png": {
                    "x": 910,
                    "y": 2354,
                    "w": 92,
                    "h": 74,
                    "ox": 4,
                    "oy": 10,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting31.png": {
                    "x": 932,
                    "y": 1848,
                    "w": 90,
                    "h": 76,
                    "ox": 2,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting33.png": {
                    "x": 934,
                    "y": 1394,
                    "w": 82,
                    "h": 76,
                    "ox": 4,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": true
                },
                "exLighting4.png": {
                    "x": 404,
                    "y": 1426,
                    "w": 94,
                    "h": 76,
                    "ox": 0,
                    "oy": 12,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting6.png": {
                    "x": 378,
                    "y": 2350,
                    "w": 94,
                    "h": 74,
                    "ox": 0,
                    "oy": 14,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "exLighting8.png": {
                    "x": 932,
                    "y": 2004,
                    "w": 90,
                    "h": 70,
                    "ox": 4,
                    "oy": 17,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                },
                "stepAni1.png": {
                    "x": 2,
                    "y": 1874,
                    "w": 250,
                    "h": 290,
                    "ox": 0,
                    "oy": 110,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni10.png": {
                    "x": 404,
                    "y": 1150,
                    "w": 284,
                    "h": 274,
                    "ox": 116,
                    "oy": 65,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni11.png": {
                    "x": 778,
                    "y": 1394,
                    "w": 154,
                    "h": 200,
                    "ox": 225,
                    "oy": 78,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni2.png": {
                    "x": 404,
                    "y": 748,
                    "w": 362,
                    "h": 400,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni3.png": {
                    "x": 2,
                    "y": 2,
                    "w": 400,
                    "h": 400,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni4.png": {
                    "x": 2,
                    "y": 404,
                    "w": 400,
                    "h": 382,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni5.png": {
                    "x": 404,
                    "y": 2,
                    "w": 400,
                    "h": 378,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni6.png": {
                    "x": 2,
                    "y": 1158,
                    "w": 400,
                    "h": 364,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni7.png": {
                    "x": 2,
                    "y": 788,
                    "w": 400,
                    "h": 368,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni8.png": {
                    "x": 404,
                    "y": 382,
                    "w": 400,
                    "h": 364,
                    "ox": 0,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                },
                "stepAni9.png": {
                    "x": 2,
                    "y": 1524,
                    "w": 298,
                    "h": 348,
                    "ox": 102,
                    "oy": 0,
                    "sw": 400,
                    "sh": 400,
                    "ro": false
                }
            }
        },
        {
            "keys": "amazing.png,blueDoorBg.png,bonusShoot.png,brownBallFace.png,bubleEle0.png,bubleEle1.png,bubleEle2.png,bubleEle3.png,bubleEle4.png,chooseRect.png,eggPiece1.png,eggPiece2.png,eggPiece3.png,eggPiece4.png,eggPiece5.png,eggStatus0.png,eggStatus1.png,eggStatus2.png,ele0Exp.png,ele0Line.png,ele1Exp.png,ele1Line.png,ele2Exp.png,ele2Line.png,ele3Exp.png,ele3Line.png,ele4Exp.png,ele4Line.png,eyeDownLeft.png,eyeDownRight.png,eyeSingle.png,festivalLoading.png,gameGuide1.png,gameGuideBoard.png,great.png,greenCircleDown.png,greenCircleUp.png,greyBallFace.png,guidePropBoom.png,guidePropCow.png,guidePropHammer.png,guidePropHand.png,guidePropMsgPanel.png,guidePropShoe.png,hairballDisBg.png,hairballPiece1.png,hairballPiece2.png,hairballPiece3.png,hairballPiece4.png,hairballPiece5.png,hairballPiece6.png,hairballPiece7.png,hairballPiece8.png,hairballPiece9.png,ice2.png,ice3.png,ice4.png,ice5.jpg,ice5.png,ice6.png,jellyArrow.png,leftArrow.png,lightedStar.png,lineLight.png,lockVine.png,magicLion.png,magicLionBg.png,main_mapbottom.png,musicOff.png,musicOn.png,playBg.jpg,prop_count_bg.png,rectLat.png,rectLatWhite.png,redDoorBg.png,rightArrow.png,rightMark.png,rock2.png,rock3.png,rock4.png,rock5.png,rock6.png,settingBg.png,starProgress.png,table.png,topBg.png,unlightedStar.png,wonderful.png,yellowCircleDown.png,yellowCircleUp.png,yellowDoorBg.png",
            "name": "playScene",
            "atlas": {
                "amazing.png": {
                    "x": 638,
                    "y": 842,
                    "w": 427,
                    "h": 132,
                    "ox": 16,
                    "oy": 5,
                    "sw": 459,
                    "sh": 142,
                    "ro": false
                },
                "blueDoorBg.png": {
                    "x": 1874,
                    "y": 328,
                    "w": 94,
                    "h": 95,
                    "ox": 0,
                    "oy": 0,
                    "sw": 94,
                    "sh": 95,
                    "ro": false
                },
                "bonusShoot.png": {
                    "x": 2008,
                    "y": 186,
                    "w": 95,
                    "h": 37,
                    "ox": 0,
                    "oy": 0,
                    "sw": 95,
                    "sh": 37,
                    "ro": true
                },
                "brownBallFace.png": {
                    "x": 1645,
                    "y": 907,
                    "w": 76,
                    "h": 72,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "bubleEle0.png": {
                    "x": 1885,
                    "y": 830,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "bubleEle1.png": {
                    "x": 1885,
                    "y": 750,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "bubleEle2.png": {
                    "x": 1879,
                    "y": 670,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "bubleEle3.png": {
                    "x": 1873,
                    "y": 590,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "bubleEle4.png": {
                    "x": 1874,
                    "y": 510,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "chooseRect.png": {
                    "x": 1874,
                    "y": 425,
                    "w": 86,
                    "h": 83,
                    "ox": 0,
                    "oy": 0,
                    "sw": 86,
                    "sh": 83,
                    "ro": false
                },
                "eggPiece1.png": {
                    "x": 1466,
                    "y": 812,
                    "w": 13,
                    "h": 16,
                    "ox": 0,
                    "oy": 0,
                    "sw": 13,
                    "sh": 16,
                    "ro": false
                },
                "eggPiece2.png": {
                    "x": 1291,
                    "y": 635,
                    "w": 18,
                    "h": 13,
                    "ox": 0,
                    "oy": 0,
                    "sw": 18,
                    "sh": 13,
                    "ro": false
                },
                "eggPiece3.png": {
                    "x": 1963,
                    "y": 954,
                    "w": 34,
                    "h": 33,
                    "ox": 0,
                    "oy": 0,
                    "sw": 34,
                    "sh": 33,
                    "ro": false
                },
                "eggPiece4.png": {
                    "x": 1691,
                    "y": 645,
                    "w": 16,
                    "h": 17,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 17,
                    "ro": false
                },
                "eggPiece5.png": {
                    "x": 1562,
                    "y": 715,
                    "w": 22,
                    "h": 27,
                    "ox": 0,
                    "oy": 0,
                    "sw": 22,
                    "sh": 27,
                    "ro": true
                },
                "eggStatus0.png": {
                    "x": 1563,
                    "y": 894,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "eggStatus1.png": {
                    "x": 1481,
                    "y": 894,
                    "w": 80,
                    "h": 76,
                    "ox": 0,
                    "oy": 2,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "eggStatus2.png": {
                    "x": 1645,
                    "y": 743,
                    "w": 80,
                    "h": 70,
                    "ox": 0,
                    "oy": 8,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele0Exp.png": {
                    "x": 1723,
                    "y": 774,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele0Line.png": {
                    "x": 559,
                    "y": 883,
                    "w": 76,
                    "h": 80,
                    "ox": 1,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele1Exp.png": {
                    "x": 1797,
                    "y": 675,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele1Line.png": {
                    "x": 1791,
                    "y": 593,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele2Exp.png": {
                    "x": 406,
                    "y": 925,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele2Line.png": {
                    "x": 1791,
                    "y": 511,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele3Exp.png": {
                    "x": 1645,
                    "y": 825,
                    "w": 76,
                    "h": 80,
                    "ox": 2,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele3Line.png": {
                    "x": 1709,
                    "y": 616,
                    "w": 74,
                    "h": 80,
                    "ox": 2,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": true
                },
                "ele4Exp.png": {
                    "x": 1709,
                    "y": 534,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ele4Line.png": {
                    "x": 1717,
                    "y": 692,
                    "w": 78,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "eyeDownLeft.png": {
                    "x": 257,
                    "y": 959,
                    "w": 22,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 22,
                    "sh": 21,
                    "ro": false
                },
                "eyeDownRight.png": {
                    "x": 1746,
                    "y": 511,
                    "w": 22,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 22,
                    "sh": 21,
                    "ro": false
                },
                "eyeSingle.png": {
                    "x": 2,
                    "y": 1002,
                    "w": 12,
                    "h": 11,
                    "ox": 0,
                    "oy": 0,
                    "sw": 12,
                    "sh": 11,
                    "ro": false
                },
                "festivalLoading.png": {
                    "x": 2,
                    "y": 883,
                    "w": 555,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 555,
                    "sh": 40,
                    "ro": false
                },
                "gameGuide1.png": {
                    "x": 2,
                    "y": 2,
                    "w": 634,
                    "h": 879,
                    "ox": 0,
                    "oy": 0,
                    "sw": 634,
                    "sh": 879,
                    "ro": false
                },
                "gameGuideBoard.png": {
                    "x": 1390,
                    "y": 2,
                    "w": 623,
                    "h": 182,
                    "ox": 0,
                    "oy": 0,
                    "sw": 623,
                    "sh": 182,
                    "ro": false
                },
                "great.png": {
                    "x": 1099,
                    "y": 708,
                    "w": 365,
                    "h": 142,
                    "ox": 47,
                    "oy": 0,
                    "sw": 459,
                    "sh": 142,
                    "ro": false
                },
                "greenCircleDown.png": {
                    "x": 1177,
                    "y": 852,
                    "w": 108,
                    "h": 106,
                    "ox": 0,
                    "oy": 1,
                    "sw": 108,
                    "sh": 108,
                    "ro": false
                },
                "greenCircleUp.png": {
                    "x": 1746,
                    "y": 380,
                    "w": 129,
                    "h": 126,
                    "ox": 0,
                    "oy": 0,
                    "sw": 129,
                    "sh": 126,
                    "ro": true
                },
                "greyBallFace.png": {
                    "x": 1723,
                    "y": 936,
                    "w": 76,
                    "h": 74,
                    "ox": 2,
                    "oy": 6,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "guidePropBoom.png": {
                    "x": 1398,
                    "y": 852,
                    "w": 81,
                    "h": 99,
                    "ox": 0,
                    "oy": 0,
                    "sw": 81,
                    "sh": 99,
                    "ro": false
                },
                "guidePropCow.png": {
                    "x": 1291,
                    "y": 380,
                    "w": 253,
                    "h": 299,
                    "ox": 0,
                    "oy": 0,
                    "sw": 253,
                    "sh": 299,
                    "ro": true
                },
                "guidePropHammer.png": {
                    "x": 1592,
                    "y": 534,
                    "w": 109,
                    "h": 115,
                    "ox": 0,
                    "oy": 0,
                    "sw": 109,
                    "sh": 115,
                    "ro": true
                },
                "guidePropHand.png": {
                    "x": 1562,
                    "y": 743,
                    "w": 81,
                    "h": 67,
                    "ox": 0,
                    "oy": 0,
                    "sw": 81,
                    "sh": 67,
                    "ro": false
                },
                "guidePropMsgPanel.png": {
                    "x": 1390,
                    "y": 186,
                    "w": 470,
                    "h": 192,
                    "ox": 0,
                    "oy": 0,
                    "sw": 470,
                    "sh": 192,
                    "ro": false
                },
                "guidePropShoe.png": {
                    "x": 1287,
                    "y": 852,
                    "w": 102,
                    "h": 109,
                    "ox": 0,
                    "oy": 0,
                    "sw": 102,
                    "sh": 109,
                    "ro": true
                },
                "hairballDisBg.png": {
                    "x": 1398,
                    "y": 953,
                    "w": 72,
                    "h": 60,
                    "ox": 4,
                    "oy": 8,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "hairballPiece1.png": {
                    "x": 2015,
                    "y": 86,
                    "w": 39,
                    "h": 22,
                    "ox": 0,
                    "oy": 0,
                    "sw": 39,
                    "sh": 22,
                    "ro": true
                },
                "hairballPiece2.png": {
                    "x": 488,
                    "y": 974,
                    "w": 39,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 39,
                    "sh": 23,
                    "ro": true
                },
                "hairballPiece3.png": {
                    "x": 220,
                    "y": 959,
                    "w": 35,
                    "h": 22,
                    "ox": 0,
                    "oy": 0,
                    "sw": 35,
                    "sh": 22,
                    "ro": false
                },
                "hairballPiece4.png": {
                    "x": 513,
                    "y": 974,
                    "w": 39,
                    "h": 22,
                    "ox": 0,
                    "oy": 0,
                    "sw": 39,
                    "sh": 22,
                    "ro": true
                },
                "hairballPiece5.png": {
                    "x": 537,
                    "y": 925,
                    "w": 25,
                    "h": 17,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 17,
                    "ro": true
                },
                "hairballPiece6.png": {
                    "x": 2015,
                    "y": 44,
                    "w": 40,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 40,
                    "sh": 26,
                    "ro": true
                },
                "hairballPiece7.png": {
                    "x": 2015,
                    "y": 127,
                    "w": 31,
                    "h": 22,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 22,
                    "ro": true
                },
                "hairballPiece8.png": {
                    "x": 537,
                    "y": 976,
                    "w": 37,
                    "h": 28,
                    "ox": 0,
                    "oy": 0,
                    "sw": 37,
                    "sh": 28,
                    "ro": true
                },
                "hairballPiece9.png": {
                    "x": 567,
                    "y": 976,
                    "w": 37,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 37,
                    "sh": 23,
                    "ro": true
                },
                "ice2.png": {
                    "x": 1883,
                    "y": 917,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ice3.png": {
                    "x": 1803,
                    "y": 917,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ice4.png": {
                    "x": 1962,
                    "y": 484,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ice5.png": {
                    "x": 1805,
                    "y": 837,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "ice6.png": {
                    "x": 1805,
                    "y": 757,
                    "w": 78,
                    "h": 78,
                    "ox": 1,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "jellyArrow.png": {
                    "x": 176,
                    "y": 959,
                    "w": 42,
                    "h": 23,
                    "ox": 0,
                    "oy": 0,
                    "sw": 42,
                    "sh": 23,
                    "ro": false
                },
                "leftArrow.png": {
                    "x": 134,
                    "y": 959,
                    "w": 28,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 28,
                    "sh": 40,
                    "ro": true
                },
                "lightedStar.png": {
                    "x": 1999,
                    "y": 954,
                    "w": 33,
                    "h": 34,
                    "ox": 0,
                    "oy": 0,
                    "sw": 33,
                    "sh": 34,
                    "ro": true
                },
                "lineLight.png": {
                    "x": 638,
                    "y": 650,
                    "w": 56,
                    "h": 750,
                    "ox": 0,
                    "oy": 0,
                    "sw": 56,
                    "sh": 750,
                    "ro": true
                },
                "lockVine.png": {
                    "x": 1563,
                    "y": 812,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "magicLion.png": {
                    "x": 1481,
                    "y": 812,
                    "w": 80,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "magicLionBg.png": {
                    "x": 1592,
                    "y": 380,
                    "w": 152,
                    "h": 152,
                    "ox": 14,
                    "oy": 12,
                    "sw": 180,
                    "sh": 176,
                    "ro": false
                },
                "main_mapbottom.png": {
                    "x": 2,
                    "y": 959,
                    "w": 80,
                    "h": 41,
                    "ox": 0,
                    "oy": 0,
                    "sw": 80,
                    "sh": 41,
                    "ro": false
                },
                "musicOff.png": {
                    "x": 1970,
                    "y": 406,
                    "w": 76,
                    "h": 75,
                    "ox": 0,
                    "oy": 0,
                    "sw": 76,
                    "sh": 75,
                    "ro": true
                },
                "musicOn.png": {
                    "x": 1970,
                    "y": 328,
                    "w": 76,
                    "h": 75,
                    "ox": 0,
                    "oy": 0,
                    "sw": 76,
                    "sh": 75,
                    "ro": true
                },
                "prop_count_bg.png": {
                    "x": 488,
                    "y": 925,
                    "w": 47,
                    "h": 47,
                    "ox": 0,
                    "oy": 0,
                    "sw": 47,
                    "sh": 47,
                    "ro": false
                },
                "rectLat.png": {
                    "x": 1723,
                    "y": 856,
                    "w": 78,
                    "h": 78,
                    "ox": 0,
                    "oy": 0,
                    "sw": 78,
                    "sh": 78,
                    "ro": false
                },
                "rectLatWhite.png": {
                    "x": 1512,
                    "y": 635,
                    "w": 78,
                    "h": 78,
                    "ox": 0,
                    "oy": 0,
                    "sw": 78,
                    "sh": 78,
                    "ro": false
                },
                "redDoorBg.png": {
                    "x": 1592,
                    "y": 645,
                    "w": 96,
                    "h": 97,
                    "ox": 0,
                    "oy": 0,
                    "sw": 96,
                    "sh": 97,
                    "ro": true
                },
                "rightArrow.png": {
                    "x": 2015,
                    "y": 2,
                    "w": 28,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 28,
                    "sh": 40,
                    "ro": false
                },
                "rightMark.png": {
                    "x": 84,
                    "y": 959,
                    "w": 48,
                    "h": 37,
                    "ox": 0,
                    "oy": 0,
                    "sw": 48,
                    "sh": 37,
                    "ro": false
                },
                "rock2.png": {
                    "x": 1965,
                    "y": 876,
                    "w": 76,
                    "h": 76,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "rock3.png": {
                    "x": 1965,
                    "y": 798,
                    "w": 76,
                    "h": 76,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "rock4.png": {
                    "x": 1965,
                    "y": 720,
                    "w": 76,
                    "h": 76,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "rock5.png": {
                    "x": 1959,
                    "y": 642,
                    "w": 76,
                    "h": 76,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "rock6.png": {
                    "x": 1954,
                    "y": 564,
                    "w": 76,
                    "h": 76,
                    "ox": 1,
                    "oy": 1,
                    "sw": 80,
                    "sh": 80,
                    "ro": false
                },
                "settingBg.png": {
                    "x": 1390,
                    "y": 635,
                    "w": 71,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 71,
                    "sh": 120,
                    "ro": true
                },
                "starProgress.png": {
                    "x": 2,
                    "y": 925,
                    "w": 402,
                    "h": 32,
                    "ox": 0,
                    "oy": 0,
                    "sw": 402,
                    "sh": 32,
                    "ro": false
                },
                "table.png": {
                    "x": 638,
                    "y": 2,
                    "w": 750,
                    "h": 368,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 368,
                    "ro": false
                },
                "topBg.png": {
                    "x": 638,
                    "y": 372,
                    "w": 651,
                    "h": 276,
                    "ox": 0,
                    "oy": 0,
                    "sw": 651,
                    "sh": 276,
                    "ro": false
                },
                "unlightedStar.png": {
                    "x": 2008,
                    "y": 283,
                    "w": 37,
                    "h": 37,
                    "ox": 0,
                    "oy": 0,
                    "sw": 37,
                    "sh": 37,
                    "ro": false
                },
                "wonderful.png": {
                    "x": 638,
                    "y": 708,
                    "w": 459,
                    "h": 132,
                    "ox": 0,
                    "oy": 5,
                    "sw": 459,
                    "sh": 142,
                    "ro": false
                },
                "yellowCircleDown.png": {
                    "x": 1067,
                    "y": 852,
                    "w": 108,
                    "h": 106,
                    "ox": 0,
                    "oy": 0,
                    "sw": 108,
                    "sh": 106,
                    "ro": false
                },
                "yellowCircleUp.png": {
                    "x": 1862,
                    "y": 186,
                    "w": 144,
                    "h": 140,
                    "ox": 0,
                    "oy": 0,
                    "sw": 144,
                    "sh": 140,
                    "ro": false
                },
                "yellowDoorBg.png": {
                    "x": 1466,
                    "y": 715,
                    "w": 94,
                    "h": 95,
                    "ox": 0,
                    "oy": 0,
                    "sw": 94,
                    "sh": 95,
                    "ro": false
                }
            }
        },
        {
            "keys": "chapterNum0.png,chapterNum1.png,chapterNum2.png,chapterNum3.png,chapterNum4.png,chapterNum5.png,chapterNum6.png,chapterNum7.png,chapterNum8.png,chapterNum9.png,chapterNum关.png,chapterNum第.png,propNum0.png,propNum1.png,propNum2.png,propNum3.png,propNum4.png,propNum5.png,propNum6.png,propNum7.png,propNum8.png,propNum9.png,scoreNum0.png,scoreNum1.png,scoreNum2.png,scoreNum3.png,scoreNum4.png,scoreNum5.png,scoreNum6.png,scoreNum7.png,scoreNum8.png,scoreNum9.png,scoreNum关.png,scoreNum冒号.png,scoreNum分.png,scoreNum数.png,scoreNum通.png,stepNum0.png,stepNum1.png,stepNum2.png,stepNum3.png,stepNum4.png,stepNum5.png,stepNum6.png,stepNum7.png,stepNum8.png,stepNum9.png,tarNum0.png,tarNum1.png,tarNum2.png,tarNum3.png,tarNum4.png,tarNum5.png,tarNum6.png,tarNum7.png,tarNum8.png,tarNum9.png",
            "name": "playerFont",
            "atlas": {
                "chapterNum0.png": {
                    "x": 768,
                    "y": 2,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": false
                },
                "chapterNum1.png": {
                    "x": 792,
                    "y": 30,
                    "w": 18,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 18,
                    "sh": 34,
                    "ro": true
                },
                "chapterNum2.png": {
                    "x": 744,
                    "y": 2,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": false
                },
                "chapterNum3.png": {
                    "x": 720,
                    "y": 2,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": false
                },
                "chapterNum4.png": {
                    "x": 574,
                    "y": 2,
                    "w": 24,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 24,
                    "sh": 34,
                    "ro": false
                },
                "chapterNum5.png": {
                    "x": 696,
                    "y": 2,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": false
                },
                "chapterNum6.png": {
                    "x": 672,
                    "y": 2,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": false
                },
                "chapterNum7.png": {
                    "x": 648,
                    "y": 2,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": false
                },
                "chapterNum8.png": {
                    "x": 624,
                    "y": 2,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": false
                },
                "chapterNum9.png": {
                    "x": 600,
                    "y": 2,
                    "w": 22,
                    "h": 28,
                    "ox": 0,
                    "oy": 2,
                    "sw": 22,
                    "sh": 34,
                    "ro": false
                },
                "chapterNum关.png": {
                    "x": 407,
                    "y": 2,
                    "w": 33,
                    "h": 34,
                    "ox": 0,
                    "oy": 0,
                    "sw": 33,
                    "sh": 34,
                    "ro": false
                },
                "chapterNum第.png": {
                    "x": 371,
                    "y": 2,
                    "w": 34,
                    "h": 34,
                    "ox": 0,
                    "oy": 0,
                    "sw": 34,
                    "sh": 34,
                    "ro": false
                },
                "propNum0.png": {
                    "x": 670,
                    "y": 32,
                    "w": 15,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 15,
                    "sh": 30,
                    "ro": true
                },
                "propNum1.png": {
                    "x": 371,
                    "y": 38,
                    "w": 10,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 10,
                    "sh": 30,
                    "ro": true
                },
                "propNum2.png": {
                    "x": 766,
                    "y": 32,
                    "w": 14,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 14,
                    "sh": 30,
                    "ro": true
                },
                "propNum3.png": {
                    "x": 646,
                    "y": 32,
                    "w": 15,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 15,
                    "sh": 30,
                    "ro": true
                },
                "propNum4.png": {
                    "x": 602,
                    "y": 32,
                    "w": 16,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 16,
                    "sh": 30,
                    "ro": true
                },
                "propNum5.png": {
                    "x": 742,
                    "y": 32,
                    "w": 14,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 14,
                    "sh": 30,
                    "ro": true
                },
                "propNum6.png": {
                    "x": 532,
                    "y": 33,
                    "w": 15,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 15,
                    "sh": 30,
                    "ro": true
                },
                "propNum7.png": {
                    "x": 718,
                    "y": 32,
                    "w": 14,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 14,
                    "sh": 30,
                    "ro": true
                },
                "propNum8.png": {
                    "x": 508,
                    "y": 33,
                    "w": 15,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 15,
                    "sh": 30,
                    "ro": true
                },
                "propNum9.png": {
                    "x": 694,
                    "y": 32,
                    "w": 14,
                    "h": 22,
                    "ox": 0,
                    "oy": 3,
                    "sw": 14,
                    "sh": 30,
                    "ro": true
                },
                "scoreNum0.png": {
                    "x": 970,
                    "y": 2,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum1.png": {
                    "x": 574,
                    "y": 32,
                    "w": 16,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 28,
                    "ro": true
                },
                "scoreNum2.png": {
                    "x": 948,
                    "y": 2,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum3.png": {
                    "x": 926,
                    "y": 2,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum4.png": {
                    "x": 815,
                    "y": 2,
                    "w": 21,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 21,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum5.png": {
                    "x": 904,
                    "y": 2,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum6.png": {
                    "x": 882,
                    "y": 2,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum7.png": {
                    "x": 860,
                    "y": 2,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum8.png": {
                    "x": 838,
                    "y": 2,
                    "w": 20,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 20,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum9.png": {
                    "x": 792,
                    "y": 2,
                    "w": 21,
                    "h": 26,
                    "ox": 0,
                    "oy": 0,
                    "sw": 21,
                    "sh": 28,
                    "ro": false
                },
                "scoreNum关.png": {
                    "x": 541,
                    "y": 2,
                    "w": 31,
                    "h": 29,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 31,
                    "ro": false
                },
                "scoreNum冒号.png": {
                    "x": 971,
                    "y": 30,
                    "w": 12,
                    "h": 23,
                    "ox": 0,
                    "oy": 3,
                    "sw": 20,
                    "sh": 31,
                    "ro": true
                },
                "scoreNum分.png": {
                    "x": 475,
                    "y": 2,
                    "w": 31,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 31,
                    "ro": false
                },
                "scoreNum数.png": {
                    "x": 442,
                    "y": 2,
                    "w": 31,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 31,
                    "ro": false
                },
                "scoreNum通.png": {
                    "x": 508,
                    "y": 2,
                    "w": 31,
                    "h": 29,
                    "ox": 0,
                    "oy": 0,
                    "sw": 31,
                    "sh": 31,
                    "ro": false
                },
                "stepNum0.png": {
                    "x": 304,
                    "y": 2,
                    "w": 35,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 35,
                    "sh": 50,
                    "ro": false
                },
                "stepNum1.png": {
                    "x": 341,
                    "y": 2,
                    "w": 28,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 28,
                    "sh": 50,
                    "ro": false
                },
                "stepNum2.png": {
                    "x": 267,
                    "y": 2,
                    "w": 35,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 35,
                    "sh": 50,
                    "ro": false
                },
                "stepNum3.png": {
                    "x": 230,
                    "y": 2,
                    "w": 35,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 35,
                    "sh": 50,
                    "ro": false
                },
                "stepNum4.png": {
                    "x": 2,
                    "y": 2,
                    "w": 38,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 38,
                    "sh": 50,
                    "ro": false
                },
                "stepNum5.png": {
                    "x": 118,
                    "y": 2,
                    "w": 36,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 36,
                    "sh": 50,
                    "ro": false
                },
                "stepNum6.png": {
                    "x": 80,
                    "y": 2,
                    "w": 36,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 36,
                    "sh": 50,
                    "ro": false
                },
                "stepNum7.png": {
                    "x": 193,
                    "y": 2,
                    "w": 35,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 35,
                    "sh": 50,
                    "ro": false
                },
                "stepNum8.png": {
                    "x": 156,
                    "y": 2,
                    "w": 35,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 35,
                    "sh": 50,
                    "ro": false
                },
                "stepNum9.png": {
                    "x": 42,
                    "y": 2,
                    "w": 36,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 36,
                    "sh": 50,
                    "ro": false
                },
                "tarNum0.png": {
                    "x": 941,
                    "y": 30,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                },
                "tarNum1.png": {
                    "x": 958,
                    "y": 30,
                    "w": 11,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 11,
                    "sh": 20,
                    "ro": false
                },
                "tarNum2.png": {
                    "x": 924,
                    "y": 30,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                },
                "tarNum3.png": {
                    "x": 907,
                    "y": 30,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                },
                "tarNum4.png": {
                    "x": 626,
                    "y": 32,
                    "w": 16,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 16,
                    "sh": 20,
                    "ro": true
                },
                "tarNum5.png": {
                    "x": 890,
                    "y": 30,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                },
                "tarNum6.png": {
                    "x": 873,
                    "y": 30,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                },
                "tarNum7.png": {
                    "x": 856,
                    "y": 30,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                },
                "tarNum8.png": {
                    "x": 839,
                    "y": 30,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                },
                "tarNum9.png": {
                    "x": 822,
                    "y": 30,
                    "w": 15,
                    "h": 18,
                    "ox": 0,
                    "oy": 1,
                    "sw": 15,
                    "sh": 20,
                    "ro": false
                }
            }
        },
        {
            "keys": "0d37cb05-b970-43a7-9bcc-b617756885ff.png,0ea400c4-35c5-48c2-970d-f7f942f236d0.png,0fa7d552-2406-43f0-b943-a02e7306ba7b.png,121c1dcf-3439-46c3-94b1-2dc0a2328292.png,1f062bf4-e898-4aca-93ff-64dc7ac39b55.png,24e778ec-7b78-46e1-9305-a41d4dd2660b.png,25b1766e-ae87-4b86-8706-d0422eed8402.png,299d34f5-0947-408e-ad03-f591b54435f1.png,30994ee9-dfce-4815-8830-5f59a3581532.png,3d81bb8a-d507-46cf-aadf-acc264251d15.png,44143eac-1ebb-4c6f-a712-23bccad2d8e7.png,446172d9-8cae-41f8-879b-36d9c0505746.png,4740ad76-b823-4229-8896-3a5268d519c6.png,49f443bf-ce54-4c09-9d7d-85084f2fec65.png,528f8387-a46a-41c5-bfd4-c3534cb6226f.png,5596d058-d177-42c9-a5f2-5737fb2c2ede.png,61ff6238-9225-4a1a-b401-65cb5ace0417.png,776414a4-6190-4826-b502-58020d623d45.png,7ce1df43-a1b0-4506-8076-c8fed4dcd39c.png,8794ea27-6e1b-4fc9-b7a0-dc4c682832b7.png,8d7b922a-1c6c-4377-9098-c1514e0b512c.png,9444e747-9e09-4452-93df-a470dac6f201.png,9eeccbcd-988c-49ea-aed8-737c910ca214.png,a52128bc-3b0a-421c-944a-7bdc4a6c14b7.png,a5faf813-2707-49fe-9595-c74db99bbdab.png,a618d9b6-b2ce-4b02-8219-c92a1fae1c15.png,af26b6bf-0409-4d11-853c-6b39b2bb8761.png,b978ea1a-c871-4246-b100-5cc182d1cf73.png,c0acb40f-4193-4d77-afcf-a9e76821dbbf.png,c4b17d9a-4622-4ff3-9949-cc8cce0c69b9.png,c4ef35a4-9645-43d1-a59e-15d1b2267fa0.png,cbb513ad-909c-4f19-9d2d-ae1a76d4ff63.png,d00a6100-05af-4477-ab25-c1dfd6081e3c.png,e412ed05-1dc0-4424-bcd5-0f77dddc81c0.png,f563a30f-a00b-4230-8304-856d0168f325.png,fadc7c50-c964-4b48-824f-9f0d31a070d4.png,ffbcdc34-5b73-4c17-9bab-2d2d7009c6f2.png",
            "name": "pop_laoding_bg",
            "atlas": {
                "0d37cb05-b970-43a7-9bcc-b617756885ff.png": {
                    "x": 377,
                    "y": 1853,
                    "w": 102,
                    "h": 87,
                    "ox": 0,
                    "oy": 0,
                    "sw": 102,
                    "sh": 87,
                    "ro": false
                },
                "0ea400c4-35c5-48c2-970d-f7f942f236d0.png": {
                    "x": 341,
                    "y": 624,
                    "w": 165,
                    "h": 40,
                    "ox": 0,
                    "oy": 0,
                    "sw": 165,
                    "sh": 40,
                    "ro": false
                },
                "0fa7d552-2406-43f0-b943-a02e7306ba7b.png": {
                    "x": 2,
                    "y": 844,
                    "w": 750,
                    "h": 272,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 272,
                    "ro": true
                },
                "121c1dcf-3439-46c3-94b1-2dc0a2328292.png": {
                    "x": 194,
                    "y": 1596,
                    "w": 268,
                    "h": 255,
                    "ox": 0,
                    "oy": 0,
                    "sw": 268,
                    "sh": 255,
                    "ro": false
                },
                "1f062bf4-e898-4aca-93ff-64dc7ac39b55.png": {
                    "x": 391,
                    "y": 225,
                    "w": 173,
                    "h": 114,
                    "ox": 0,
                    "oy": 0,
                    "sw": 173,
                    "sh": 114,
                    "ro": true
                },
                "24e778ec-7b78-46e1-9305-a41d4dd2660b.png": {
                    "x": 482,
                    "y": 74,
                    "w": 24,
                    "h": 19,
                    "ox": 0,
                    "oy": 0,
                    "sw": 24,
                    "sh": 19,
                    "ro": false
                },
                "25b1766e-ae87-4b86-8706-d0422eed8402.png": {
                    "x": 366,
                    "y": 2130,
                    "w": 67,
                    "h": 76,
                    "ox": 0,
                    "oy": 0,
                    "sw": 67,
                    "sh": 76,
                    "ro": false
                },
                "299d34f5-0947-408e-ad03-f591b54435f1.png": {
                    "x": 194,
                    "y": 1944,
                    "w": 144,
                    "h": 167,
                    "ox": 0,
                    "oy": 0,
                    "sw": 144,
                    "sh": 167,
                    "ro": true
                },
                "30994ee9-dfce-4815-8830-5f59a3581532.png": {
                    "x": 377,
                    "y": 1942,
                    "w": 100,
                    "h": 88,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 88,
                    "ro": false
                },
                "3d81bb8a-d507-46cf-aadf-acc264251d15.png": {
                    "x": 363,
                    "y": 2032,
                    "w": 96,
                    "h": 133,
                    "ox": 0,
                    "oy": 0,
                    "sw": 96,
                    "sh": 133,
                    "ro": true
                },
                "44143eac-1ebb-4c6f-a712-23bccad2d8e7.png": {
                    "x": 276,
                    "y": 1380,
                    "w": 209,
                    "h": 206,
                    "ox": 0,
                    "oy": 0,
                    "sw": 209,
                    "sh": 206,
                    "ro": false
                },
                "446172d9-8cae-41f8-879b-36d9c0505746.png": {
                    "x": 194,
                    "y": 1853,
                    "w": 181,
                    "h": 89,
                    "ox": 0,
                    "oy": 0,
                    "sw": 181,
                    "sh": 89,
                    "ro": false
                },
                "4740ad76-b823-4229-8896-3a5268d519c6.png": {
                    "x": 276,
                    "y": 1276,
                    "w": 30,
                    "h": 51,
                    "ox": 0,
                    "oy": 0,
                    "sw": 30,
                    "sh": 51,
                    "ro": true
                },
                "49f443bf-ce54-4c09-9d7d-85084f2fec65.png": {
                    "x": 391,
                    "y": 400,
                    "w": 118,
                    "h": 111,
                    "ox": 0,
                    "oy": 0,
                    "sw": 118,
                    "sh": 111,
                    "ro": true
                },
                "528f8387-a46a-41c5-bfd4-c3534cb6226f.png": {
                    "x": 2,
                    "y": 1596,
                    "w": 590,
                    "h": 190,
                    "ox": 0,
                    "oy": 0,
                    "sw": 590,
                    "sh": 190,
                    "ro": true
                },
                "5596d058-d177-42c9-a5f2-5737fb2c2ede.png": {
                    "x": 276,
                    "y": 1194,
                    "w": 51,
                    "h": 80,
                    "ox": 0,
                    "oy": 0,
                    "sw": 51,
                    "sh": 80,
                    "ro": false
                },
                "61ff6238-9225-4a1a-b401-65cb5ace0417.png": {
                    "x": 341,
                    "y": 530,
                    "w": 40,
                    "h": 35,
                    "ox": 0,
                    "oy": 0,
                    "sw": 40,
                    "sh": 35,
                    "ro": false
                },
                "776414a4-6190-4826-b502-58020d623d45.png": {
                    "x": 194,
                    "y": 2130,
                    "w": 82,
                    "h": 90,
                    "ox": 0,
                    "oy": 0,
                    "sw": 82,
                    "sh": 90,
                    "ro": true
                },
                "7ce1df43-a1b0-4506-8076-c8fed4dcd39c.png": {
                    "x": 482,
                    "y": 51,
                    "w": 24,
                    "h": 21,
                    "ox": 0,
                    "oy": 0,
                    "sw": 24,
                    "sh": 21,
                    "ro": false
                },
                "8794ea27-6e1b-4fc9-b7a0-dc4c682832b7.png": {
                    "x": 286,
                    "y": 2130,
                    "w": 82,
                    "h": 78,
                    "ox": 0,
                    "oy": 0,
                    "sw": 82,
                    "sh": 78,
                    "ro": true
                },
                "8d7b922a-1c6c-4377-9098-c1514e0b512c.png": {
                    "x": 2,
                    "y": 2,
                    "w": 478,
                    "h": 221,
                    "ox": 0,
                    "oy": 2,
                    "sw": 480,
                    "sh": 223,
                    "ro": false
                },
                "9444e747-9e09-4452-93df-a470dac6f201.png": {
                    "x": 482,
                    "y": 2,
                    "w": 47,
                    "h": 24,
                    "ox": 0,
                    "oy": 0,
                    "sw": 47,
                    "sh": 24,
                    "ro": true
                },
                "9eeccbcd-988c-49ea-aed8-737c910ca214.png": {
                    "x": 276,
                    "y": 844,
                    "w": 103,
                    "h": 63,
                    "ox": 0,
                    "oy": 0,
                    "sw": 103,
                    "sh": 63,
                    "ro": true
                },
                "a52128bc-3b0a-421c-944a-7bdc4a6c14b7.png": {
                    "x": 276,
                    "y": 1034,
                    "w": 74,
                    "h": 53,
                    "ox": 0,
                    "oy": 0,
                    "sw": 74,
                    "sh": 53,
                    "ro": true
                },
                "a5faf813-2707-49fe-9595-c74db99bbdab.png": {
                    "x": 276,
                    "y": 949,
                    "w": 54,
                    "h": 83,
                    "ox": 0,
                    "oy": 0,
                    "sw": 54,
                    "sh": 83,
                    "ro": false
                },
                "a618d9b6-b2ce-4b02-8219-c92a1fae1c15.png": {
                    "x": 2,
                    "y": 2188,
                    "w": 28,
                    "h": 25,
                    "ox": 0,
                    "oy": 0,
                    "sw": 28,
                    "sh": 25,
                    "ro": false
                },
                "af26b6bf-0409-4d11-853c-6b39b2bb8761.png": {
                    "x": 2,
                    "y": 530,
                    "w": 337,
                    "h": 312,
                    "ox": 0,
                    "oy": 0,
                    "sw": 337,
                    "sh": 312,
                    "ro": false
                },
                "b978ea1a-c871-4246-b100-5cc182d1cf73.png": {
                    "x": 276,
                    "y": 1308,
                    "w": 50,
                    "h": 64,
                    "ox": 0,
                    "oy": 0,
                    "sw": 50,
                    "sh": 64,
                    "ro": false
                },
                "c0acb40f-4193-4d77-afcf-a9e76821dbbf.png": {
                    "x": 341,
                    "y": 822,
                    "w": 556,
                    "h": 158,
                    "ox": 0,
                    "oy": 0,
                    "sw": 556,
                    "sh": 158,
                    "ro": true
                },
                "c4b17d9a-4622-4ff3-9949-cc8cce0c69b9.png": {
                    "x": 276,
                    "y": 1110,
                    "w": 51,
                    "h": 82,
                    "ox": 0,
                    "oy": 0,
                    "sw": 51,
                    "sh": 82,
                    "ro": false
                },
                "c4ef35a4-9645-43d1-a59e-15d1b2267fa0.png": {
                    "x": 482,
                    "y": 138,
                    "w": 16,
                    "h": 15,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 15,
                    "ro": false
                },
                "cbb513ad-909c-4f19-9d2d-ae1a76d4ff63.png": {
                    "x": 341,
                    "y": 567,
                    "w": 55,
                    "h": 31,
                    "ox": 0,
                    "oy": 0,
                    "sw": 55,
                    "sh": 31,
                    "ro": true
                },
                "d00a6100-05af-4477-ab25-c1dfd6081e3c.png": {
                    "x": 482,
                    "y": 95,
                    "w": 23,
                    "h": 41,
                    "ox": 0,
                    "oy": 0,
                    "sw": 23,
                    "sh": 41,
                    "ro": false
                },
                "e412ed05-1dc0-4424-bcd5-0f77dddc81c0.png": {
                    "x": 2,
                    "y": 225,
                    "w": 387,
                    "h": 303,
                    "ox": 0,
                    "oy": 0,
                    "sw": 387,
                    "sh": 303,
                    "ro": false
                },
                "f563a30f-a00b-4230-8304-856d0168f325.png": {
                    "x": 341,
                    "y": 666,
                    "w": 154,
                    "h": 164,
                    "ox": 0,
                    "oy": 0,
                    "sw": 154,
                    "sh": 164,
                    "ro": true
                },
                "fadc7c50-c964-4b48-824f-9f0d31a070d4.png": {
                    "x": 391,
                    "y": 520,
                    "w": 108,
                    "h": 102,
                    "ox": 0,
                    "oy": 0,
                    "sw": 108,
                    "sh": 102,
                    "ro": false
                },
                "ffbcdc34-5b73-4c17-9bab-2d2d7009c6f2.png": {
                    "x": 464,
                    "y": 1588,
                    "w": 39,
                    "h": 33,
                    "ox": 0,
                    "oy": 0,
                    "sw": 39,
                    "sh": 33,
                    "ro": false
                }
            }
        },
        {
            "keys": "ea362f0b-b2c8-4d39-bbf2-d8a60962d6e0.png,ee8ac4e5-73d7-421b-bcc5-3fbf2781e3f3.png,fd21b9df-66ff-4c4c-9beb-8d70be581fde.png",
            "name": "pop_loading_title",
            "atlas": {
                "ea362f0b-b2c8-4d39-bbf2-d8a60962d6e0.png": {
                    "x": 159,
                    "y": 323,
                    "w": 33,
                    "h": 38,
                    "ox": 0,
                    "oy": 0,
                    "sw": 33,
                    "sh": 38,
                    "ro": false
                },
                "ee8ac4e5-73d7-421b-bcc5-3fbf2781e3f3.png": {
                    "x": 2,
                    "y": 2,
                    "w": 477,
                    "h": 319,
                    "ox": 0,
                    "oy": 0,
                    "sw": 477,
                    "sh": 319,
                    "ro": false
                },
                "fd21b9df-66ff-4c4c-9beb-8d70be581fde.png": {
                    "x": 2,
                    "y": 323,
                    "w": 137,
                    "h": 155,
                    "ox": 0,
                    "oy": 0,
                    "sw": 137,
                    "sh": 155,
                    "ro": true
                }
            }
        },
        {
            "keys": "star_light_0.png,star_light_1.png,star_light_10.png,star_light_11.png,star_light_12.png,star_light_13.png,star_light_14.png,star_light_15.png,star_light_2.png,star_light_3.png,star_light_4.png,star_light_5.png,star_light_6.png,star_light_7.png,star_light_8.png,star_light_9.png",
            "name": "starLight",
            "atlas": {
                "star_light_0.png": {
                    "x": 414,
                    "y": 322,
                    "w": 324,
                    "h": 324,
                    "ox": 88,
                    "oy": 88,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_1.png": {
                    "x": 1068,
                    "y": 328,
                    "w": 326,
                    "h": 326,
                    "ox": 87,
                    "oy": 87,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_10.png": {
                    "x": 5,
                    "y": 2,
                    "w": 386,
                    "h": 318,
                    "ox": 31,
                    "oy": 91,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_11.png": {
                    "x": 769,
                    "y": 2,
                    "w": 396,
                    "h": 320,
                    "ox": 25,
                    "oy": 89,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_12.png": {
                    "x": 2,
                    "y": 322,
                    "w": 410,
                    "h": 324,
                    "ox": 16,
                    "oy": 86,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_13.png": {
                    "x": 688,
                    "y": 656,
                    "w": 416,
                    "h": 330,
                    "ox": 13,
                    "oy": 84,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_14.png": {
                    "x": 1396,
                    "y": 328,
                    "w": 414,
                    "h": 328,
                    "ox": 13,
                    "oy": 85,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_15.png": {
                    "x": 2,
                    "y": 2,
                    "w": 1,
                    "h": 1,
                    "ox": 0,
                    "oy": 0,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_2.png": {
                    "x": 740,
                    "y": 324,
                    "w": 326,
                    "h": 326,
                    "ox": 87,
                    "oy": 87,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_3.png": {
                    "x": 1493,
                    "y": 2,
                    "w": 324,
                    "h": 324,
                    "ox": 88,
                    "oy": 88,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_4.png": {
                    "x": 1167,
                    "y": 2,
                    "w": 324,
                    "h": 324,
                    "ox": 88,
                    "oy": 88,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_5.png": {
                    "x": 2,
                    "y": 648,
                    "w": 336,
                    "h": 328,
                    "ox": 78,
                    "oy": 86,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_6.png": {
                    "x": 340,
                    "y": 648,
                    "w": 346,
                    "h": 332,
                    "ox": 70,
                    "oy": 84,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_7.png": {
                    "x": 1106,
                    "y": 658,
                    "w": 358,
                    "h": 336,
                    "ox": 60,
                    "oy": 82,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_8.png": {
                    "x": 1466,
                    "y": 658,
                    "w": 368,
                    "h": 336,
                    "ox": 50,
                    "oy": 82,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                },
                "star_light_9.png": {
                    "x": 393,
                    "y": 2,
                    "w": 374,
                    "h": 318,
                    "ox": 38,
                    "oy": 90,
                    "sw": 500,
                    "sh": 500,
                    "ro": false
                }
            }
        }
    ],
    "path": "https://yun.duiba.com.cn/db_games/activity/babycare_xiaoxiao/1603366873/resource/"
};


/***/ }),

/***/ "./src/SkinJson.ts":
/*!*************************!*\
  !*** ./src/SkinJson.ts ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SkinJson = {
    "type": "container",
    "children": [
        {
            "name": "SuccessNoPrizePanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "闯关成功Bg",
                    "x": 53,
                    "y": 209,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "闯关成功Bg.png"
                    }
                },
                {
                    "name": "继续闯关大",
                    "x": 157,
                    "y": 940,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "继续闯关大.png"
                    },
                    "id": "totalContinueBtn"
                },
                {
                    "name": "继续闯关小",
                    "x": 388,
                    "y": 940,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "继续闯关小.png"
                    },
                    "id": "continueBtn"
                },
                {
                    "name": "闯关成功不满星按钮",
                    "x": 98,
                    "y": 940,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "闯关成功不满星按钮.png"
                    },
                    "id": "againBtn"
                },
                {
                    "name": "提示文案",
                    "x": 299,
                    "y": 820,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "闯关成功！",
                        "bold": true,
                        "size": 36,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "tipsTex"
                },
                {
                    "name": "关闭按钮",
                    "x": 625,
                    "y": 431,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "SuccessPrizePanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "闯关成功",
                    "x": 53,
                    "y": 209,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "闯关成功.png"
                    }
                },
                {
                    "name": "提示文案",
                    "x": 182,
                    "y": 790,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "太厉害了！获得奖励：",
                        "size": 34,
                        "fillColor": "#df5942",
                        "bold": true
                    },
                    "id": "tipsTex"
                },
                {
                    "name": "红包奖励",
                    "x": 130,
                    "y": 835,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": ""
                    },
                    "id": "prizeImg"
                },
                {
                    "name": "提示文案",
                    "x": 182,
                    "y": 1098,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "奖品可以在“我的奖品”页面查看",
                        "size": 24,
                        "fillColor": "#df5942",
                        "bold": true
                    },
                    "id": "tipsTex2"
                },
                {
                    "name": "关闭按钮",
                    "x": 625,
                    "y": 431,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "NoStepPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "步数耗尽Bg",
                    "x": 43,
                    "y": 543,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "步数耗尽Bg.png"
                    }
                },
                {
                    "name": "提示文案",
                    "x": 123,
                    "y": 743,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "消耗20积分可复活 ，步数+5\n确认复活吗？",
                        "size": 36,
                        "fillColor": "#df5942",
                        "textAlpha": 1,
                        "bold": true
                    },
                    "id": "tipsTex"
                },
                {
                    "name": "关闭按钮",
                    "x": 615,
                    "y": 504,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "步数耗尽复活",
                    "x": 376,
                    "y": 914,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "步数耗尽复活.png"
                    },
                    "id": "liveBtn"
                },
                {
                    "name": "步数耗尽结束按钮",
                    "x": 88,
                    "y": 914,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "步数耗尽结束按钮.png"
                    },
                    "id": "overBtn"
                }
            ]
        },
        {
            "name": "FailedPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "失败Bg",
                    "x": 53,
                    "y": 470,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "失败Bg.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 625,
                    "y": 431,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "失败重新闯关",
                    "x": 165,
                    "y": 774,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "失败重新闯关.png"
                    },
                    "id": "againBtn"
                }
            ]
        },
        {
            "name": "StartPanelPrize",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "关卡弹窗Bg",
                    "x": 53,
                    "y": 209,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "关卡弹窗Bg.png"
                    }
                },
                {
                    "name": "关卡数",
                    "x": 310,
                    "y": 492,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "第 6 关",
                        "size": 40,
                        "fillColor": "#ffffff",
                        "textAlpha": 1,
                        "bold": true
                    },
                    "id": "checkTex"
                },
                {
                    "name": "提示文案",
                    "x": 128,
                    "y": 830,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "通关即可抽取大奖，分数越高几率越大哦～",
                        "size": 28,
                        "bold": true,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "tipsTex"
                },
                {
                    "name": "开始闯关要能量",
                    "x": 165,
                    "y": 1097,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "开始闯关要能量.png"
                    },
                    "id": "startBtn"
                },
                {
                    "name": "开始闯关不要能量",
                    "x": 165,
                    "y": 1097,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "开始闯关不要能量.png"
                    },
                    "id": "startBtn2"
                },
                {
                    "name": "prize",
                    "x": 130,
                    "y": 880,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": ""
                    },
                    "id": "prizeImg"
                },
                {
                    "name": "关闭按钮",
                    "x": 625,
                    "y": 431,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "NoEnergyPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "体力不足Bg",
                    "x": 35,
                    "y": 510,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "体力不足Bg.png"
                    }
                },
                {
                    "name": "体力不足按钮",
                    "x": 145,
                    "y": 889,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "体力不足按钮.png"
                    },
                    "id": "okBtn"
                },
                {
                    "name": "关闭按钮",
                    "x": 607,
                    "y": 471,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "RulePanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "活动规则背景",
                    "x": 55,
                    "y": 438,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "活动规则背景.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 410,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "TaskPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "任务背景",
                    "x": 0.5,
                    "y": 338,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "任务背景.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 643,
                    "y": 504,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "closeBtn2.png"
                    },
                    "id": "closeBtn"
                }
            ]
        },
        {
            "name": "FreePowerPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "圆圈",
                    "x": 53,
                    "y": 470,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "圆圈.png"
                    }
                },
                {
                    "name": "关闭按钮",
                    "x": 625,
                    "y": 431,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "开心收下",
                    "x": 165,
                    "y": 1012,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "开心收下.png"
                    },
                    "id": "acceptBtn"
                }
            ]
        },
        {
            "name": "UseToolPanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "使用道具背景",
                    "x": 55,
                    "y": 498,
                    "alpha": 1,
                    "type": "sprite",
                    "props": {
                        "source": "使用道具背景.png"
                    }
                },
                {
                    "name": "文案",
                    "x": 168,
                    "y": 619,
                    "alpha": 1,
                    "type": "text",
                    "props": {
                        "text": "确认使用步数道具+10步吗？",
                        "size": 34,
                        "fillColor": "#df5942",
                        "textAlpha": 1
                    },
                    "id": "msgTxt"
                },
                {
                    "name": "关闭按钮",
                    "x": 631,
                    "y": 470,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "关闭按钮.png"
                    },
                    "id": "closeBtn"
                },
                {
                    "name": "确定",
                    "x": 383,
                    "y": 745,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "确定.png"
                    },
                    "id": "sureBtn"
                },
                {
                    "name": "再想想",
                    "x": 93,
                    "y": 745,
                    "alpha": 1,
                    "type": "button",
                    "props": {
                        "tUp": "再想想.png"
                    },
                    "id": "consideBtn"
                }
            ]
        }
    ]
};


/***/ }),

/***/ "./src/TaoBaoNet.ts":
/*!**************************!*\
  !*** ./src/TaoBaoNet.ts ***!
  \**************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var Main_1 = __webpack_require__(/*! ./Main */ "./src/Main.ts");
var TbNetName;
(function (TbNetName) {
    TbNetName["trackingReport"] = "squirrelsAdoptRest2c.trackingReport";
    TbNetName["addStats"] = "popmartXXL2c.addStats";
    TbNetName["receiveEnamePrize"] = "popmartXXL2c.receiveEnamePrize";
    TbNetName["drawLotteryPrize"] = "popmartXXL2c.drawLotteryPrize";
    TbNetName["getToolsInfo"] = "popmartXXL2c.getToolsInfo";
    TbNetName["getPower"] = "popmartXXL2c.getRemainTimes";
    TbNetName["doHelp"] = "popmartXXL2c.doHelp";
    TbNetName["getActivityBaseInfoById"] = "popmartXXL2c.getActivityBaseInfoById";
    TbNetName["consumerTools"] = "popmartXXL2c.consumerTools";
    TbNetName["gameOver"] = "popmartXXL2c.gameOver";
    TbNetName["receiveTaskRewards"] = "popmartXXL2c.receiveTaskRewards";
    TbNetName["dojoin"] = "popmartXXL2c.doJoin";
    TbNetName["completeTask"] = "popmartXXL2c.completeTask";
    TbNetName["doFollowTask"] = "popmartXXL2c.doFollowTask";
    TbNetName["getTaskList"] = "popmartXXL2c.getTaskList";
    TbNetName["authorize"] = "mine.authorize";
    TbNetName["favorShop"] = "mine.favorShop";
    TbNetName["getUserAddress"] = "mine.getUserAddress";
    TbNetName["getAdoptName"] = "mine.getAdoptName";
    TbNetName["getAppData"] = "mine.getAppData";
    TbNetName["navigateToOutside"] = "mine.navigateToOutside";
    TbNetName["navigateTo"] = "mine.navigateTo";
    TbNetName["navigateBack"] = "mine.navigateBack";
    TbNetName["showSharePanel"] = "mine.showSharePanel";
    TbNetName["openDetail"] = "mine.openDetail";
    TbNetName["reportAnalytics"] = "mine.reportAnalytics";
    TbNetName["openMusic"] = "mine.openMusic";
})(TbNetName = exports.TbNetName || (exports.TbNetName = {}));
var dataRecord = {};
var fc;
function sendTbNet(netName, parameter, callback, hideMsg) {
    if (hideMsg === void 0) { hideMsg = false; }
    return new Promise(function (resolve, reject) {
        if (!my) {
            var url = "../../mock/miniTb/" + netName + ".json";
            fetchAsync(url)
                .then(function (data) {
                dataRecord[netName] = data;
                if (!hideMsg && !data.success)
                    ctrls_1.showToast(data.message || "网络异常");
                callback && callback(data.success, data);
                resolve(data);
                console.log("\n%c[ mock ]\n"
                    + ("NAME  : " + netName + " \n")
                    + "STATE : %o \n"
                    + "PARAM : %o \n"
                    + "%cDATA  : %o \n", "" + (data.success ? 'color:green' : 'color:red'), data.success, parameter, "" + (data.success ? 'color:green' : 'color:red'), data);
            }, function () {
            });
            return;
        }
        var fun = function (e) {
            Main_1.GDispatcher.removeEventListener(netName, fun);
            var d = e.data;
            console.log("\n%c[ request ]\n"
                + ("NAME  : " + netName + " \n")
                + "STATE : %o \n"
                + "PARAM : %o \n"
                + "%cDATA  : %o \n", "" + (d.success ? 'color:green' : 'color:red'), d.success, parameter, "" + (d.success ? 'color:green' : 'color:red'), d);
            dataRecord[netName] = d;
            if (!hideMsg && !d.success)
                ctrls_1.showToast(d.message || "网络超时");
            callback && callback(d.success, d);
            resolve(d);
        };
        Main_1.GDispatcher.addEventListener(netName, fun);
        Main_1.GDispatcher.dispatchEvent({ type: "onMessage" }, { netName: netName, parameter: parameter });
    });
}
exports.sendTbNet = sendTbNet;
function getTbData(netName) {
    return dataRecord[netName] || null;
}
exports.getTbData = getTbData;
function destroyNetData() {
    dataRecord = {};
}
exports.destroyNetData = destroyNetData;
function fetchAsync(url) {
    return __awaiter(this, void 0, void 0, function () {
        var response, data;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, fetch(url)];
                case 1:
                    response = _a.sent();
                    return [4, response.json()];
                case 2:
                    data = _a.sent();
                    return [2, data];
            }
        });
    });
}
var codeMsg = {
    "210001": "服务器异常",
    "210002": "用户不存在",
    "210003": "邀请已达上限",
    "210004": "无法邀请自己",
    "210006": "该活动ID无效",
    "210009": "该活动暂未开始",
    "210010": "该分享ID不存在",
    "210012": "该用户暂未获奖",
    "210013": "领取失败",
    "210015": "该活动已删除",
    "210016": "该活动已经结束",
    "210017": "该奖品已达领取上线",
    "210018": "请先分享好友",
    "210019": "暂有奖品未领取",
    "210020": "暂有奖品未完成",
    "210021": "请先玩一局游戏",
    "210022": "请先选择奖品",
    "210023": "领取失败，库存不足",
    "210024": "请先成为会员",
    "210025": "奖品已经过期",
    "210026": "不能重复助力",
    "210028": "请至我的奖品页重新领取",
};


/***/ }),

/***/ "./src/Tools.ts":
/*!**********************!*\
  !*** ./src/Tools.ts ***!
  \**********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../module/views/layers */ "./module/views/layers.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var FailedPanel_1 = __webpack_require__(/*! ./panels/FailedPanel */ "./src/panels/FailedPanel.ts");
var SuccessPrizePanel_1 = __webpack_require__(/*! ./panels/SuccessPrizePanel */ "./src/panels/SuccessPrizePanel.ts");
var SuccessNoPrizePanel_1 = __webpack_require__(/*! ./panels/SuccessNoPrizePanel */ "./src/panels/SuccessNoPrizePanel.ts");
var Tools = (function () {
    function Tools() {
    }
    Tools.getAppData = function () {
        return __awaiter(this, void 0, void 0, function () {
            var data;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getAppData)];
                    case 1:
                        data = (_a.sent()).data;
                        Tools.globalData = data;
                        return [2];
                }
            });
        });
    };
    Tools.getBaseInfo = function () {
        return new Promise(function (r) {
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getActivityBaseInfoById, {}, function (s, res) {
                if (s && res && res.data) {
                    var data = Tools.baseInfo = res.data;
                    if (res.data.tools) {
                        Tools.propInfo.booms = data.tools.booms || 0;
                        Tools.propInfo.steps = data.tools.steps || 0;
                        Tools.propInfo.hammers = data.tools.hammers || 0;
                    }
                    Tools.propInfo.power = data.power || 0;
                    if (my && my.getServerTime) {
                        my.getServerTime({
                            success: function (t) {
                                Tools.actEnd = (+res.data.endTime <= +t.time);
                                Tools.actStart = (+t.time >= +res.data.startTime);
                            },
                            failed: function () {
                                Tools.actEnd = (+res.data.endTime <= Date.now());
                                Tools.actStart = (Date.now() >= +res.data.startTime);
                            }
                        });
                    }
                    else {
                        Tools.actEnd = (+res.data.endTime <= Date.now());
                        Tools.actStart = (Date.now() >= +res.data.startTime);
                    }
                }
                r(s);
            });
        });
    };
    Tools.consumerTools = function (type) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.consumerTools, { type: type }, function (s, res) {
                if (s) {
                    _this.propInfo[type] -= 1;
                    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getToolsInfo, {}, function (st, rt) {
                        if (!st) {
                            resolve(true);
                            return;
                        }
                        _this.propInfo.booms = Tools.propInfo.booms = +rt.data.tools.booms;
                        _this.propInfo.steps = Tools.propInfo.steps = +rt.data.tools.steps;
                        _this.propInfo.hammers = Tools.propInfo.hammers = +rt.data.tools.hammers;
                        resolve(true);
                    });
                }
                else {
                    resolve(false);
                }
            });
        });
    };
    Tools.gameOver = function (data) {
        if (!data.isVisitSuccess) {
            ctrls_1.showPanel(FailedPanel_1.FailedPanel, data);
        }
        else if ((data.prize && data.prize.image)
            || (data.tool && data.tool.type)) {
            ctrls_1.showPanel(SuccessPrizePanel_1.SuccessPrizePanel, data);
        }
        else {
            ctrls_1.showPanel(SuccessNoPrizePanel_1.SuccessNoPrizePanel, data);
        }
    };
    Tools.checkPermission = function () {
        return __awaiter(this, void 0, void 0, function () {
            var tbMy, cloud, url, urls;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        tbMy = my;
                        if (!tbMy)
                            return [2];
                        cloud = getApp().cloud;
                        url = "cloud://B4F0300E5148F478B506DEDC26EA4C6C//butterfly0.svga";
                        return [4, cloud.file.getTempFileURL({ fileId: [url] })];
                    case 1:
                        urls = _a.sent();
                        url = urls[0].url.replace('-internal', '');
                        tbMy.downloadFile({
                            url: url,
                            success: function (res) {
                                var i = res.apFilePath;
                                tbMy.getFileSystemManager().readFile({
                                    filePath: i,
                                    success: function (r) {
                                    },
                                    fail: function (res) {
                                    }
                                });
                            },
                            fail: function (res) {
                            },
                        });
                        return [2];
                }
            });
        });
    };
    Tools.getSprite = function (imageName, x, y) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var sprite = new FYGE.Sprite(RES_1.RES.getRes(imageName));
        sprite.x = x;
        sprite.y = y;
        return sprite;
    };
    Tools.getText = function (txt, size, color, align, textWidth, x, y) {
        if (color === void 0) { color = "#000000"; }
        if (align === void 0) { align = FYGE.TEXT_ALIGN.LEFT; }
        if (textWidth === void 0) { textWidth = 0; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var text = new FYGE.TextField();
        text.fillColor = color;
        text.size = size;
        text.textWidth = textWidth;
        text.textAlign = align;
        text.x = x;
        text.y = y;
        text.text = txt;
        return text;
    };
    Tools.getRect = function (width, height, color, alpha, radius, x, y) {
        if (color === void 0) { color = 0xff0000; }
        if (alpha === void 0) { alpha = 1; }
        if (radius === void 0) { radius = 0; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var g = new FYGE.Graphics();
        g.beginFill(color);
        g.alpha = alpha;
        if (!radius) {
            g.drawRect(0, 0, width, height);
        }
        else {
            g.drawRoundedRect(0, 0, width, height, radius);
        }
        g.endFill();
        g.position.set(x, y);
        return g;
    };
    Tools.getCircle = function (radius, color, alpha, x, y) {
        if (radius === void 0) { radius = 10; }
        if (color === void 0) { color = 0xff0000; }
        if (alpha === void 0) { alpha = 1; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var g = new FYGE.Graphics();
        g.beginFill(color);
        g.alpha = alpha;
        g.drawCircle(0, 0, radius);
        g.endFill();
        g.position.set(x, y);
        return g;
    };
    Tools.getAdjustHeight = function (maxDis, minDis, type) {
        if (type === void 0) { type = "bot"; }
        var offsetY = (function () {
            if (type == "top")
                return 0;
            if (type == "bot")
                return layers_1.layers.stageOffsetY * 2;
            return layers_1.layers.stageOffsetY;
        })();
        if (layers_1.layers.stageHeight <= 1206)
            return minDis + offsetY;
        return (layers_1.layers.stageHeight - 1206) / (1624 - 1206) * (maxDis - minDis) + minDis + offsetY;
    };
    Tools.changeTextAlign = function (text, align, textWidth) {
        if (align == FYGE.TEXT_ALIGN.LEFT)
            return;
        text.textAlign = align;
        if (!textWidth)
            return;
        if (align == FYGE.TEXT_ALIGN.CENTER)
            text.x -= (textWidth - text.textWidth) / 2;
        if (align == FYGE.TEXT_ALIGN.RIGHT)
            text.x -= textWidth - text.textWidth;
        text.textWidth = textWidth;
    };
    Tools.customToast = function (target, call, time, showTime) {
        if (call === void 0) { call = function () { return 0; }; }
        if (time === void 0) { time = 2000; }
        if (showTime === void 0) { showTime = 300; }
        Tween.get(target)
            .set({ alpha: 0, visible: true })
            .to({ alpha: 1 }, showTime, Ease.quadIn)
            .wait(time)
            .to({ alpha: 0 }, showTime, Ease.quadOut)
            .set({ alpha: 0, visible: false })
            .call(function () {
            call();
        });
    };
    Tools.btnDelay = function (target, delay) {
        if (delay === void 0) { delay = 2000; }
        target.mouseEnable = false;
        target.mouseChildren = false;
        setTimeout(function () {
            target.mouseEnable = true;
            target.mouseChildren = true;
        }, delay);
    };
    Tools.getNumTextures = function (name) {
        var arr = {};
        for (var i = 0; i <= 9; i++)
            arr[i] = RES_1.RES.getRes(name + i + ".png");
        return arr;
    };
    Tools.cacheKey = "guideThreeSquirrels";
    Tools.propInfo = {
        hammers: 0,
        steps: 0,
        booms: 0,
        power: 0,
    };
    Tools.actEnd = false;
    Tools.actStart = true;
    return Tools;
}());
exports.Tools = Tools;


/***/ }),

/***/ "./src/common/G_EVENT.ts":
/*!*******************************!*\
  !*** ./src/common/G_EVENT.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var G_EVENT;
(function (G_EVENT) {
    G_EVENT["ON_SHOW"] = "onShow";
    G_EVENT["ON_HIDE"] = "onHide";
    G_EVENT["UPDATE_TASK"] = "UpdateTask";
})(G_EVENT = exports.G_EVENT || (exports.G_EVENT = {}));


/***/ }),

/***/ "./src/common/ProgressBarS.ts":
/*!************************************!*\
  !*** ./src/common/ProgressBarS.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var ProgressBarS = (function () {
    function ProgressBarS(upImage, txt) {
        this._value = 0;
        this.maxLength = upImage.width;
        this.upImage = upImage;
        this.progressTxt = txt;
        this.oriX = upImage.x;
        var delta = 0;
        if (upImage instanceof FYGE.FrameAni)
            delta = 0.5;
        this.upImage.mask = this.upImage.parent.addChild(new FYGE.Graphics())
            .beginFill(0xf8c862)
            .drawRoundedRect(upImage.x - upImage.width * delta, upImage.y - upImage.height * delta, upImage.width, upImage.height, 111)
            .endFill();
        this.value = 0;
    }
    Object.defineProperty(ProgressBarS.prototype, "value", {
        get: function () {
            return this._value;
        },
        set: function (v) {
            if (v < 0)
                v = 0;
            if (v > 1)
                v = 1;
            this._value = v;
            if (this.progressTxt)
                this.progressTxt.text = ((v * 100) >> 0) + "%";
            this.upImage.x = this.oriX - (1 - this._value) * this.maxLength;
        },
        enumerable: true,
        configurable: true
    });
    return ProgressBarS;
}());
exports.ProgressBarS = ProgressBarS;


/***/ }),

/***/ "./src/lotties/bonus.ts":
/*!******************************!*\
  !*** ./src/lotties/bonus.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.bonus = {
    "v": "5.6.10",
    "fr": 30,
    "ip": 0,
    "op": 57,
    "w": 650,
    "h": 524,
    "nm": "bonus",
    "layers": [
        {
            "ind": 2,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "72913f3a-3287-4d53-9dec-12dcd0930a77",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                94.462
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                63.706
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                20.906
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                323.486,
                                416.068,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                322.85,
                                408.124,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                321.193,
                                387.395,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                318.824,
                                357.778,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                315.998,
                                322.443,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                312.932,
                                284.111,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                309.822,
                                245.227,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                306.85,
                                208.067,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                304.197,
                                174.891,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                302.046,
                                147.996,
                                0
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                300.592,
                                129.819,
                                0
                            ]
                        },
                        {
                            "t": 11,
                            "s": [
                                300.054,
                                123.095,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                299.644,
                                117.958,
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                299.233,
                                112.826,
                                0
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                298.821,
                                107.677,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                298.41,
                                102.537,
                                0
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                297.999,
                                97.4,
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                297.588,
                                92.259,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = value;"
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        169.629,
                        169.629,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 3,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "72913f3a-3287-4d53-9dec-12dcd0930a77",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                94.462
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                63.706
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                20.906
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                333.463,
                                420.487,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                336.79,
                                414.782,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                345.469,
                                399.898,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                357.871,
                                378.63,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                372.666,
                                353.257,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                388.717,
                                325.731,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                404.999,
                                297.809,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                420.559,
                                271.125,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                434.451,
                                247.302,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                445.712,
                                227.99,
                                0
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                453.324,
                                214.937,
                                0
                            ]
                        },
                        {
                            "t": 11,
                            "s": [
                                456.139,
                                210.109,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                458.291,
                                206.419,
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                460.439,
                                202.735,
                                0
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                462.595,
                                199.037,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                464.747,
                                195.346,
                                0
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                466.899,
                                191.657,
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                469.051,
                                187.966,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        119.259,
                        119.259,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 4,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "72913f3a-3287-4d53-9dec-12dcd0930a77",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                94.462
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                63.706
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                20.906
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                325.856,
                                433.915,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                329.275,
                                429.579,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                338.195,
                                418.267,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                350.94,
                                402.104,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                366.146,
                                382.821,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                382.641,
                                361.901,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                399.374,
                                340.681,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                415.366,
                                320.402,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                429.642,
                                302.297,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                441.216,
                                287.619,
                                0
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                449.038,
                                277.699,
                                0
                            ]
                        },
                        {
                            "t": 11,
                            "s": [
                                451.932,
                                274.03,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                454.143,
                                271.226,
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                456.351,
                                268.426,
                                0
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                458.567,
                                265.616,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                460.779,
                                262.811,
                                0
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                462.99,
                                260.007,
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                465.202,
                                257.202,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        91.938,
                        91.938,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 5,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "72913f3a-3287-4d53-9dec-12dcd0930a77",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                94.462
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                63.706
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                20.906
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                324.824,
                                445.535,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                324.925,
                                439.49,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                325.188,
                                423.717,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                325.564,
                                401.179,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                326.012,
                                374.292,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                326.498,
                                345.123,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                326.991,
                                315.535,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                327.463,
                                287.258,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                327.883,
                                262.014,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                328.225,
                                241.548,
                                0
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                328.455,
                                227.716,
                                0
                            ]
                        },
                        {
                            "t": 11,
                            "s": [
                                328.54,
                                222.6,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                328.606,
                                218.69,
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                328.671,
                                214.786,
                                0
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                328.736,
                                210.868,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                328.801,
                                206.956,
                                0
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                328.866,
                                203.047,
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                328.931,
                                199.136,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        143.155,
                        143.155,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 6,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "72913f3a-3287-4d53-9dec-12dcd0930a77",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                94.462
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                63.706
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                20.906
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                315.43,
                                418.295,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                311.555,
                                411.531,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                301.444,
                                393.884,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                286.998,
                                368.667,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                269.763,
                                338.583,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                251.066,
                                305.947,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                232.1,
                                272.842,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                213.974,
                                241.204,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                197.792,
                                212.958,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                184.674,
                                190.06,
                                0
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                175.808,
                                174.584,
                                0
                            ]
                        },
                        {
                            "t": 11,
                            "s": [
                                172.528,
                                168.859,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                170.022,
                                164.485,
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                167.519,
                                160.116,
                                0
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                165.008,
                                155.733,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                162.5,
                                151.356,
                                0
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                159.995,
                                146.982,
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                157.487,
                                142.606,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        161.88,
                        161.88,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 7,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "72913f3a-3287-4d53-9dec-12dcd0930a77",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                94.462
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                63.706
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                20.906
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                322.626,
                                435.803,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                330.195,
                                433.243,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                349.944,
                                426.565,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                378.161,
                                417.023,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                411.825,
                                405.639,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                448.345,
                                393.289,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                485.39,
                                380.762,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                520.794,
                                368.789,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                552.401,
                                358.101,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                578.024,
                                349.436,
                                0
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                595.342,
                                343.579,
                                0
                            ]
                        },
                        {
                            "t": 11,
                            "s": [
                                601.748,
                                341.413,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                606.643,
                                339.758,
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                611.532,
                                338.105,
                                0
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                616.437,
                                336.446,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                621.334,
                                334.79,
                                0
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                626.229,
                                333.135,
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                631.126,
                                331.479,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        83.392,
                        83.392,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 8,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "72913f3a-3287-4d53-9dec-12dcd0930a77",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                94.462
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                63.706
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                20.906
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                310.863,
                                433.981,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                316.127,
                                434.36,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                329.862,
                                435.351,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                349.487,
                                436.766,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                372.899,
                                438.454,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                398.298,
                                440.285,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                424.062,
                                442.143,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                448.685,
                                443.919,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                470.667,
                                445.504,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                488.487,
                                446.789,
                                0
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                500.531,
                                447.657,
                                0
                            ]
                        },
                        {
                            "t": 11,
                            "s": [
                                504.987,
                                447.979,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                508.391,
                                448.224,
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                511.791,
                                448.469,
                                0
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                515.202,
                                448.715,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                518.608,
                                448.961,
                                0
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                522.012,
                                449.206,
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                525.418,
                                449.452,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        153.428,
                        153.428,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 9,
            "ty": 2,
            "nm": "light_star.png",
            "refId": "72913f3a-3287-4d53-9dec-12dcd0930a77",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 11,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                94.462
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                81.377
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                63.706
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                43.094
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                20.906
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                -240
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                337.813,
                                444.261,
                                0
                            ]
                        },
                        {
                            "t": 1,
                            "s": [
                                331.652,
                                439.808,
                                0
                            ]
                        },
                        {
                            "t": 2,
                            "s": [
                                315.576,
                                428.188,
                                0
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                292.605,
                                411.585,
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                265.201,
                                391.777,
                                0
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                235.472,
                                370.289,
                                0
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                205.315,
                                348.491,
                                0
                            ]
                        },
                        {
                            "t": 7,
                            "s": [
                                176.495,
                                327.66,
                                0
                            ]
                        },
                        {
                            "t": 8,
                            "s": [
                                150.765,
                                309.062,
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                129.907,
                                293.986,
                                0
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                115.809,
                                283.796,
                                0
                            ]
                        },
                        {
                            "t": 11,
                            "s": [
                                110.594,
                                280.026,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                106.609,
                                277.146,
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                102.63,
                                274.27,
                                0
                            ]
                        },
                        {
                            "t": 14,
                            "s": [
                                98.636,
                                271.384,
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                94.65,
                                268.502,
                                0
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                90.666,
                                265.622,
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                86.679,
                                262.741,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        37.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        189.626,
                        189.626,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 60
        },
        {
            "ind": 10,
            "ty": 2,
            "nm": "img_label.png",
            "refId": "b5fd8b69-afc7-437a-a905-00895c2d22fc",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 54,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        325,
                        422,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        243,
                        52.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0,
                                0,
                                100
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                128,
                                120,
                                100
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                90,
                                90,
                                100
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 54,
                            "s": [
                                128,
                                0,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 120
        },
        {
            "ind": 11,
            "ty": 2,
            "nm": "铃铛.png",
            "parent": 12,
            "refId": "67159d75-5c21-4e5b-9236-5c8d4a95820f",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        54.75,
                        77,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        7.5,
                        6.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 12,
            "ty": 2,
            "nm": "猫头.png",
            "refId": "d7f99e60-cd13-4e4d-aea9-77a3ccb11107",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                37
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                -12
                            ]
                        },
                        {
                            "t": 18,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                383.25,
                                423,
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                400.25,
                                368,
                                0
                            ]
                        },
                        {
                            "t": 18,
                            "s": [
                                400.25,
                                368,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        58.5,
                        79,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                59,
                                59,
                                100
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                113,
                                113,
                                100
                            ]
                        },
                        {
                            "t": 18,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 13,
            "ty": 2,
            "nm": "右耳.png",
            "parent": 12,
            "refId": "a0c39e69-7c6d-4657-b955-8881a5925c32",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 4,
                            "s": [
                                31
                            ]
                        },
                        {
                            "t": 26,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 4,
                            "s": [
                                52.176,
                                23.391,
                                0
                            ]
                        },
                        {
                            "t": 26,
                            "s": [
                                52.75,
                                15,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        21,
                        45.25,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 14,
            "ty": 2,
            "nm": "左耳.png",
            "parent": 12,
            "refId": "ddf3a45c-d782-42f3-8516-ee70d71936bc",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 4,
                            "s": [
                                -25
                            ]
                        },
                        {
                            "t": 26,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 4,
                            "s": [
                                14.636,
                                43.736,
                                0
                            ]
                        },
                        {
                            "t": 26,
                            "s": [
                                6.5,
                                43.5,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        40.75,
                        21.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 15,
            "ty": 2,
            "nm": "人右手.png",
            "parent": 18,
            "refId": "dd03474f-5b55-49a2-beaa-28196529272a",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 5,
                            "s": [
                                44
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        120.5,
                        193.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        15.5,
                        13.75,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 16,
            "ty": 2,
            "nm": "猫身体.png",
            "parent": 12,
            "refId": "d4b4ea28-d1ee-4d23-8d9c-154b15db39ec",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        49.25,
                        96.625,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        27.5,
                        38,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 17,
            "ty": 2,
            "nm": "吊牌.png",
            "parent": 18,
            "refId": "de5f62aa-2655-4aac-a792-a8c34c916ba1",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 5,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 11,
                            "s": [
                                20
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                -20
                            ]
                        },
                        {
                            "t": 20,
                            "s": [
                                6
                            ]
                        },
                        {
                            "t": 23,
                            "s": [
                                5
                            ]
                        },
                        {
                            "t": 26,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        80.625,
                        175.25,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        26.75,
                        4.25,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 18,
            "ty": 2,
            "nm": "人物.png",
            "refId": "ec84570e-381b-4967-8a65-a5615d7cc9c8",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                -22
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                4
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                -7
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                293.25,
                                411.5,
                                0
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                303.75,
                                378,
                                0
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                303.75,
                                378,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        89.5,
                        222.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                69,
                                69,
                                100
                            ]
                        },
                        {
                            "t": 13,
                            "s": [
                                116,
                                116,
                                100
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                109,
                                109,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 19,
            "ty": 2,
            "nm": "彩虹_1.png",
            "refId": "55910cee-07e1-4f38-93e3-93d26a9c58d5",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        325,
                        363.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        103,
                        69,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 20,
            "ty": 2,
            "nm": "彩虹_2.png",
            "refId": "65198343-f322-4b14-8bda-869cc254bd6d",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        325,
                        352,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        126,
                        80.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 6,
            "op": 51
        },
        {
            "ind": 21,
            "ty": 2,
            "nm": "彩虹_3.png",
            "refId": "ebd5a2df-8698-488e-9c53-d8539842cf43",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 12,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        325,
                        341.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        147,
                        91,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 12,
            "op": 51
        },
        {
            "ind": 22,
            "ty": 2,
            "nm": "彩虹_4.png",
            "refId": "390c5e0f-8f18-4b68-a08d-e7e92afec39b",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 18,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 22,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        325,
                        331,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        168,
                        101.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 18,
            "op": 51
        },
        {
            "ind": 23,
            "ty": 2,
            "nm": "bg_light.png",
            "refId": "1f439912-6c0b-4ebe-bd58-4b2585e10b5e",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        327,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        324,
                        405.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                40,
                                30,
                                100
                            ]
                        },
                        {
                            "t": 3,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 51,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0,
                                30,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 84
        },
        {
            "ind": 24,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "ae162876-c68f-4f10-a1c7-f19aca284f86",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                -47
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                -12
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                70,
                                70,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                20,
                                70,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 51,
            "op": 72
        },
        {
            "ind": 25,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "ae162876-c68f-4f10-a1c7-f19aca284f86",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                -25
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                -6
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                120,
                                110,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                20,
                                110,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 51,
            "op": 72
        },
        {
            "ind": 26,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "ae162876-c68f-4f10-a1c7-f19aca284f86",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                20,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 51,
            "op": 72
        },
        {
            "ind": 27,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "ae162876-c68f-4f10-a1c7-f19aca284f86",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                22
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                6
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                80,
                                80,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                20,
                                80,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 51,
            "op": 72
        },
        {
            "ind": 28,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "ae162876-c68f-4f10-a1c7-f19aca284f86",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                44
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                12
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 51,
                            "s": [
                                110,
                                105,
                                100
                            ]
                        },
                        {
                            "t": 57,
                            "s": [
                                20,
                                105,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 51,
            "op": 72
        },
        {
            "ind": 29,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "ae162876-c68f-4f10-a1c7-f19aca284f86",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "r": {
                    "a": 0,
                    "k": -47
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                70,
                                25,
                                100
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                70,
                                70,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 30,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "ae162876-c68f-4f10-a1c7-f19aca284f86",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "r": {
                    "a": 0,
                    "k": -25
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                120,
                                40,
                                100
                            ]
                        },
                        {
                            "t": 6,
                            "s": [
                                120,
                                110,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 31,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "ae162876-c68f-4f10-a1c7-f19aca284f86",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                100,
                                30,
                                100
                            ]
                        },
                        {
                            "t": 5,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 32,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "ae162876-c68f-4f10-a1c7-f19aca284f86",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "r": {
                    "a": 0,
                    "k": 22
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                80,
                                30,
                                100
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                80,
                                80,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        },
        {
            "ind": 33,
            "ty": 2,
            "nm": "bonus_light_1.png",
            "refId": "ae162876-c68f-4f10-a1c7-f19aca284f86",
            "ks": {
                "o": {
                    "a": 1,
                    "k": [
                        {
                            "t": 9,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 21,
                            "s": [
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 2);"
                },
                "r": {
                    "a": 0,
                    "k": 44
                },
                "p": {
                    "a": 0,
                    "k": [
                        315,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        60.5,
                        367.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                110,
                                40,
                                100
                            ]
                        },
                        {
                            "t": 4,
                            "s": [
                                110,
                                105,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 51
        }
    ],
    "markers": [
        {
            "tm": 9,
            "cm": "1",
            "dr": 0
        },
        {
            "tm": 48,
            "cm": "2",
            "dr": 0
        },
        {
            "tm": 57,
            "cm": "3",
            "dr": 0
        }
    ]
};


/***/ }),

/***/ "./src/lotties/pop_laoding_bg.ts":
/*!***************************************!*\
  !*** ./src/lotties/pop_laoding_bg.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.pop_laoding_bg = {
    "v": "5.6.10",
    "fr": 30,
    "ip": 0,
    "op": 60,
    "w": 750,
    "h": 1624,
    "nm": "pop_laoding_bg",
    "layers": [
        {
            "ind": 1,
            "ty": 2,
            "nm": "leg_l",
            "parent": 6,
            "refId": "49f443bf-ce54-4c09-9d7d-85084f2fec65",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                -9
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        21,
                        147.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        86,
                        22.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 2,
            "ty": 2,
            "nm": "leg_r",
            "parent": 6,
            "refId": "3d81bb8a-d507-46cf-aadf-acc264251d15",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                -11
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        114,
                        135,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        66,
                        18,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 3,
            "ty": 2,
            "nm": "cloth",
            "parent": 6,
            "refId": "1f062bf4-e898-4aca-93ff-64dc7ac39b55",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        65.5,
                        139,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        86.5,
                        57,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 4,
            "ty": 2,
            "nm": "arm_r",
            "parent": 6,
            "refId": "446172d9-8cae-41f8-879b-36d9c0505746",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                -6
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        125.5,
                        24.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        164.5,
                        34.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 5,
            "ty": 2,
            "nm": "tie",
            "parent": 6,
            "refId": "a52128bc-3b0a-421c-944a-7bdc4a6c14b7",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        51,
                        6.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        28,
                        27.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 6,
            "ty": 2,
            "nm": "body",
            "refId": "299d34f5-0947-408e-ad03-f591b54435f1",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                378,
                                999.5,
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                378,
                                1009.5,
                                0
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                378,
                                999.5,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        70,
                        124.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 7,
            "ty": 2,
            "nm": "cake",
            "parent": 6,
            "refId": "fadc7c50-c964-4b48-824f-9f0d31a070d4",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                -26,
                                -48,
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                -26,
                                -35,
                                0
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                -26,
                                -48,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        54,
                        51,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 8,
            "ty": 2,
            "nm": "nose",
            "parent": 6,
            "refId": "7ce1df43-a1b0-4506-8076-c8fed4dcd39c",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        42,
                        -60.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        12,
                        10.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 9,
            "ty": 2,
            "nm": "eye_l",
            "parent": 8,
            "refId": "c4b17d9a-4622-4ff3-9949-cc8cce0c69b9",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        -22.99,
                        -18.306,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        26.01,
                        50.694,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 30,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 32,
                            "s": [
                                100,
                                0,
                                100
                            ]
                        },
                        {
                            "t": 34,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 10,
            "ty": 2,
            "nm": "eye_r",
            "parent": 8,
            "refId": "30994ee9-dfce-4815-8830-5f59a3581532",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        100.102,
                        10.163,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        55.102,
                        52.163,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 30,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 32,
                            "s": [
                                100,
                                0,
                                100
                            ]
                        },
                        {
                            "t": 34,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 11,
            "ty": 2,
            "nm": "mouth",
            "parent": 8,
            "refId": "9444e747-9e09-4452-93df-a470dac6f201",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        10.5,
                        31,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        23.5,
                        12,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 12,
            "ty": 2,
            "nm": "haed",
            "parent": 6,
            "refId": "af26b6bf-0409-4d11-853c-6b39b2bb8761",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        61.5,
                        -4,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        124.5,
                        280,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 13,
            "ty": 2,
            "nm": "tail_1",
            "parent": 6,
            "refId": "776414a4-6190-4826-b502-58020d623d45",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                7
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        128.5,
                        110.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        16.5,
                        53.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 14,
            "ty": 2,
            "nm": "tail_2",
            "parent": 6,
            "refId": "25b1766e-ae87-4b86-8706-d0422eed8402",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                -9
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        135.5,
                        132.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        21.5,
                        19.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 15,
            "ty": 2,
            "nm": "arm_l",
            "parent": 6,
            "refId": "8794ea27-6e1b-4fc9-b7a0-dc4c682832b7",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                -14
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        13,
                        31.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        74,
                        34.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 16,
            "ty": 2,
            "nm": "quan.png",
            "refId": "121c1dcf-3439-46c3-94b1-2dc0a2328292",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                -1
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        639,
                        1320,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        161.7,
                        179.692,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 17,
            "ty": 2,
            "nm": "cherry.png",
            "parent": 19,
            "refId": "f563a30f-a00b-4230-8304-856d0168f325",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        325.5,
                        -29.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        77,
                        82,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 18,
            "ty": 2,
            "nm": "lemmon.png",
            "parent": 19,
            "refId": "44143eac-1ebb-4c6f-a712-23bccad2d8e7",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        31.5,
                        218.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        104.5,
                        103,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                100,
                                102,
                                100
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 19,
            "ty": 2,
            "nm": "dong.png",
            "refId": "e412ed05-1dc0-4424-bcd5-0f77dddc81c0",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        387,
                        1212,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        193.5,
                        268.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                102,
                                96,
                                100
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 20,
            "ty": 2,
            "nm": "plate.png",
            "refId": "c0acb40f-4193-4d77-afcf-a9e76821dbbf",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        385,
                        1215,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        278,
                        79,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 21,
            "ty": 2,
            "nm": "eye_l 2",
            "parent": 23,
            "refId": "d00a6100-05af-4477-ab25-c1dfd6081e3c",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        -8.682,
                        -8.488,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        10.318,
                        27.512,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 22,
            "ty": 2,
            "nm": "eye_r 2",
            "parent": 23,
            "refId": "61ff6238-9225-4a1a-b401-65cb5ace0417",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        42.786,
                        13.802,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        16.786,
                        19.802,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 23,
            "ty": 2,
            "nm": "nose 2",
            "parent": 25,
            "refId": "c4ef35a4-9645-43d1-a59e-15d1b2267fa0",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        31,
                        54.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        8,
                        7.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 24,
            "ty": 2,
            "nm": "ear_r",
            "parent": 25,
            "refId": "b978ea1a-c871-4246-b100-5cc182d1cf73",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 15,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                -3
                            ]
                        },
                        {
                            "t": 19,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 15,
                            "s": [
                                88,
                                28.5,
                                0
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                86.75,
                                26.25,
                                0
                            ]
                        },
                        {
                            "t": 19,
                            "s": [
                                88,
                                28.5,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        13,
                        38.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 15,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 17,
                            "s": [
                                96,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 19,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 25,
            "ty": 2,
            "nm": "head",
            "parent": 32,
            "refId": "0d37cb05-b970-43a7-9bcc-b617756885ff",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 30,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                -8
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        64,
                        9,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        40,
                        72,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 26,
            "ty": 2,
            "nm": "hair",
            "parent": 25,
            "refId": "a618d9b6-b2ce-4b02-8219-c92a1fae1c15",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        68,
                        2.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        14,
                        12.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 27,
            "ty": 2,
            "nm": "ear_l",
            "parent": 25,
            "refId": "a5faf813-2707-49fe-9595-c74db99bbdab",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        34,
                        1.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        27,
                        41.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 28,
            "ty": 2,
            "nm": "arm_l 2",
            "parent": 32,
            "refId": "4740ad76-b823-4229-8896-3a5268d519c6",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 30,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 37,
                            "s": [
                                -51
                            ]
                        },
                        {
                            "t": 41,
                            "s": [
                                -36
                            ]
                        },
                        {
                            "t": 45,
                            "s": [
                                -51
                            ]
                        },
                        {
                            "t": 49,
                            "s": [
                                -36
                            ]
                        },
                        {
                            "t": 53,
                            "s": [
                                -51
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        60.705,
                        36.471,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        11,
                        11,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 29,
            "ty": 2,
            "nm": "dang",
            "parent": 32,
            "refId": "24e778ec-7b78-46e1-9305-a41d4dd2660b",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        78,
                        33.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        12,
                        9.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 30,
            "ty": 2,
            "nm": "leg",
            "parent": 32,
            "refId": "cbb513ad-909c-4f19-9d2d-ae1a76d4ff63",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 30,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                12
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        15.5,
                        50,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        15.5,
                        7,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 31,
            "ty": 2,
            "nm": "arm_r 2",
            "parent": 32,
            "refId": "ffbcdc34-5b73-4c17-9bab-2d2d7009c6f2",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 30,
                            "s": [
                                26
                            ]
                        },
                        {
                            "t": 37,
                            "s": [
                                -20
                            ]
                        },
                        {
                            "t": 41,
                            "s": [
                                -40
                            ]
                        },
                        {
                            "t": 45,
                            "s": [
                                -20
                            ]
                        },
                        {
                            "t": 49,
                            "s": [
                                -40
                            ]
                        },
                        {
                            "t": 53,
                            "s": [
                                -20
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                26
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        90.343,
                        29.461,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        8.343,
                        6.461,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 32,
            "ty": 2,
            "nm": "body 2",
            "refId": "9eeccbcd-988c-49ea-aed8-737c910ca214",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 30,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                -12
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        613,
                        1012.5,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        17,
                        49.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 30,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "t": 37,
                            "s": [
                                103,
                                103,
                                100
                            ]
                        },
                        {
                            "t": 53,
                            "s": [
                                103,
                                103,
                                100
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 33,
            "ty": 2,
            "nm": "tail",
            "parent": 32,
            "refId": "5596d058-d177-42c9-a5f2-5737fb2c2ede",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                12
                            ]
                        },
                        {
                            "t": 18,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 27,
                            "s": [
                                12
                            ]
                        },
                        {
                            "t": 36,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        9.5,
                        52,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        42.5,
                        70,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 34,
            "ty": 2,
            "nm": "shadow",
            "refId": "0ea400c4-35c5-48c2-970d-f7f942f236d0",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 50.196
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        659.5,
                        1021,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        82.5,
                        20,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 61
        },
        {
            "ind": 35,
            "ty": 2,
            "nm": "cloud_1.png",
            "refId": "528f8387-a46a-41c5-bfd4-c3534cb6226f",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                455,
                                1529,
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                469,
                                1539,
                                0
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                455,
                                1529,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        295,
                        95,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 36,
            "ty": 2,
            "nm": "cloud_2.png",
            "refId": "8d7b922a-1c6c-4377-9098-c1514e0b512c",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                240,
                                1512.5,
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                236,
                                1514.5,
                                0
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                240,
                                1512.5,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        240,
                        111.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        },
        {
            "ind": 37,
            "ty": 2,
            "nm": "cloud_3.png",
            "refId": "0fa7d552-2406-43f0-b943-a02e7306ba7b",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                375,
                                1488,
                                0
                            ]
                        },
                        {
                            "t": 30,
                            "s": [
                                377,
                                1472,
                                0
                            ]
                        },
                        {
                            "t": 60,
                            "s": [
                                375,
                                1488,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        375,
                        136,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 180
        }
    ],
    "markers": []
};


/***/ }),

/***/ "./src/lotties/pop_loading_title.ts":
/*!******************************************!*\
  !*** ./src/lotties/pop_loading_title.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.pop_loading_title = {
    "v": "5.6.10",
    "fr": 30,
    "ip": 0,
    "op": 30,
    "w": 750,
    "h": 1624,
    "nm": "pop_loading_title",
    "layers": [
        {
            "ind": 1,
            "ty": 2,
            "nm": "cat.png",
            "parent": 3,
            "refId": "ea362f0b-b2c8-4d39-bbf2-d8a60962d6e0",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 1,
                    "k": [
                        {
                            "t": 12,
                            "s": [
                                -16
                            ]
                        },
                        {
                            "t": 18,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "p": {
                    "a": 0,
                    "k": [
                        59,
                        102.75,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        24,
                        0.25,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 12,
            "op": 186
        },
        {
            "ind": 2,
            "ty": 2,
            "nm": "logo.png",
            "refId": "ee8ac4e5-73d7-421b-bcc5-3fbf2781e3f3",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 0,
                    "k": [
                        387,
                        419,
                        0
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        238.5,
                        159.5,
                        0
                    ]
                },
                "s": {
                    "a": 1,
                    "k": [
                        {
                            "t": 3,
                            "s": [
                                50,
                                50,
                                100
                            ]
                        },
                        {
                            "t": 9,
                            "s": [
                                110,
                                94,
                                100
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                96,
                                102,
                                100
                            ]
                        },
                        {
                            "t": 15,
                            "s": [
                                102,
                                99,
                                100
                            ]
                        },
                        {
                            "t": 18,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ]
                }
            },
            "ip": 3,
            "op": 183
        },
        {
            "ind": 3,
            "ty": 2,
            "nm": "cat_main.png",
            "parent": 2,
            "refId": "fd21b9df-66ff-4c4c-9beb-8d70be581fde",
            "ks": {
                "o": {
                    "a": 0,
                    "k": 100
                },
                "r": {
                    "a": 0,
                    "k": 0
                },
                "p": {
                    "a": 1,
                    "k": [
                        {
                            "t": 6,
                            "s": [
                                389.5,
                                164.5,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                469.5,
                                104.5,
                                0
                            ]
                        }
                    ]
                },
                "a": {
                    "a": 0,
                    "k": [
                        68.5,
                        77.5,
                        0
                    ]
                },
                "s": {
                    "a": 0,
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 6,
            "op": 186
        }
    ],
    "markers": []
};


/***/ }),

/***/ "./src/panels/FailedPanel.ts":
/*!***********************************!*\
  !*** ./src/panels/FailedPanel.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var MouseEvent = FYGE.MouseEvent;
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ../scene/map/MapScene */ "./src/scene/map/MapScene.ts");
var FailedPanel = (function (_super) {
    __extends(FailedPanel, _super);
    function FailedPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(FailedPanel.prototype, "groupNames", {
        get: function () {
            return ["FailedPanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FailedPanel.prototype, "skinName", {
        get: function () {
            return "FailedPanel";
        },
        enumerable: true,
        configurable: true
    });
    FailedPanel.prototype.initUi = function () {
    };
    FailedPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    FailedPanel.prototype.hidePanel = function () {
        ctrls_1.changeScene(MapScene_1.MapScene);
        _super.prototype.hidePanel.call(this);
    };
    FailedPanel.prototype.again = function () {
        ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level });
        _super.prototype.hidePanel.call(this);
    };
    FailedPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.againBtn.addEventListener(MouseEvent.CLICK, this.again, this);
    };
    FailedPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.againBtn.removeEventListener(MouseEvent.CLICK, this.again, this);
    };
    return FailedPanel;
}(Panel_1.Panel));
exports.FailedPanel = FailedPanel;


/***/ }),

/***/ "./src/panels/FesRedPrizePanel.ts":
/*!****************************************!*\
  !*** ./src/panels/FesRedPrizePanel.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var Sprite = FYGE.Sprite;
var MouseEvent = FYGE.MouseEvent;
var Button = FYGE.Button;
var FesRedPrizePanel = (function (_super) {
    __extends(FesRedPrizePanel, _super);
    function FesRedPrizePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(FesRedPrizePanel.prototype, "groupNames", {
        get: function () {
            return ['FesRedPrizePanel'];
        },
        enumerable: true,
        configurable: true
    });
    FesRedPrizePanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    FesRedPrizePanel.prototype.initUi = function () {
        this.addChild(Tools_1.Tools.getSprite('FesRedPrizeBg.png'))
            .position.set(53, 209);
        this.addChild(new Button(RES_1.RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(625, 431);
        this.addChild(new Button(RES_1.RES.getRes('开心收下.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(165, 1045);
        var res = TaoBaoNet_1.getTbData(TaoBaoNet_1.TbNetName.drawLotteryPrize);
        this.img = this.addChild(Sprite.fromUrl(res.data.image));
        this.img.anchorTexture.x = 0.5;
        this.img.position.set(375, 693);
        this.img.width = this.img.height = 252;
    };
    FesRedPrizePanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    FesRedPrizePanel.prototype.hidePanel = function () {
        _super.prototype.hidePanel.call(this);
        this.data.callback && this.data.callback();
    };
    FesRedPrizePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
    };
    FesRedPrizePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return FesRedPrizePanel;
}(Panel_1.Panel));
exports.FesRedPrizePanel = FesRedPrizePanel;


/***/ }),

/***/ "./src/panels/FreePowerPanel.ts":
/*!**************************************!*\
  !*** ./src/panels/FreePowerPanel.ts ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var Main_1 = __webpack_require__(/*! ../Main */ "./src/Main.ts");
var FreePowerPanel = (function (_super) {
    __extends(FreePowerPanel, _super);
    function FreePowerPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(FreePowerPanel.prototype, "groupNames", {
        get: function () { return ["FreePowerPanel"]; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FreePowerPanel.prototype, "skinName", {
        get: function () { return "FreePowerPanel"; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FreePowerPanel.prototype, "closeBtns", {
        get: function () {
            return [this.closeBtn, this.acceptBtn];
        },
        enumerable: true,
        configurable: true
    });
    FreePowerPanel.prototype.hidePanel = function () {
        _super.prototype.hidePanel.call(this);
        Main_1.GDispatcher.dispatchEvent("showRemindIcon");
    };
    return FreePowerPanel;
}(Panel_1.Panel));
exports.FreePowerPanel = FreePowerPanel;


/***/ }),

/***/ "./src/panels/NoEnergyPanel.ts":
/*!*************************************!*\
  !*** ./src/panels/NoEnergyPanel.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var MouseEvent = FYGE.MouseEvent;
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var TaskPanel_1 = __webpack_require__(/*! ./TaskPanel */ "./src/panels/TaskPanel.ts");
var NoEnergyPanel = (function (_super) {
    __extends(NoEnergyPanel, _super);
    function NoEnergyPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(NoEnergyPanel.prototype, "groupNames", {
        get: function () {
            return ["NoEnergyPanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NoEnergyPanel.prototype, "skinName", {
        get: function () {
            return "NoEnergyPanel";
        },
        enumerable: true,
        configurable: true
    });
    NoEnergyPanel.prototype.initUi = function () {
    };
    NoEnergyPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    NoEnergyPanel.prototype.initEvents = function () {
        var _this = this;
        _super.prototype.initEvents.call(this);
        this.okBtn.addEventListener(MouseEvent.CLICK, function () {
            ctrls_1.showPanel(TaskPanel_1.TaskPanel);
            _this.hidePanel();
        }, this);
    };
    NoEnergyPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return NoEnergyPanel;
}(Panel_1.Panel));
exports.NoEnergyPanel = NoEnergyPanel;


/***/ }),

/***/ "./src/panels/NoStepPanel.ts":
/*!***********************************!*\
  !*** ./src/panels/NoStepPanel.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var NoStepPanel = (function (_super) {
    __extends(NoStepPanel, _super);
    function NoStepPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(NoStepPanel.prototype, "groupNames", {
        get: function () {
            return ["NoStepPanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NoStepPanel.prototype, "skinName", {
        get: function () {
            return "NoStepPanel";
        },
        enumerable: true,
        configurable: true
    });
    NoStepPanel.prototype.initUi = function () {
        this.tipsTex.textAlign = FYGE.TEXT_ALIGN.CENTER;
        this.tipsTex.textWidth = 500;
        this.tipsTex.x = (750 - 500) / 2;
        this.tipsTex.text = "是否使用步数道具\n增加5次步数";
    };
    NoStepPanel.prototype.initEvents = function () {
        var _this = this;
        [this.closeBtn, this.overBtn].forEach(function (e) {
            e.addEventListener(FYGE.MouseEvent.CLICK, function () {
                ctrls_1.getCurrentScene().submit(false);
                _this.hidePanel();
            }, _this);
        });
        this.liveBtn.addEventListener(FYGE.MouseEvent.CLICK, function () {
            _this.data.reviveFun();
            _this.hidePanel();
        }, this);
    };
    NoStepPanel.prototype.removeEvents = function () {
    };
    return NoStepPanel;
}(Panel_1.Panel));
exports.NoStepPanel = NoStepPanel;


/***/ }),

/***/ "./src/panels/RulePanel.ts":
/*!*********************************!*\
  !*** ./src/panels/RulePanel.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var TEXT_lINETYPE = FYGE.TEXT_lINETYPE;
var ScrollPage = FYGE.ScrollPage;
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var Button = FYGE.Button;
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var MouseEvent = FYGE.MouseEvent;
var RulePanel = (function (_super) {
    __extends(RulePanel, _super);
    function RulePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(RulePanel.prototype, "groupNames", {
        get: function () {
            return ["RulePanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RulePanel.prototype, "skinName", {
        get: function () {
            return "RulePanel";
        },
        enumerable: true,
        configurable: true
    });
    RulePanel.prototype.initUi = function () {
    };
    RulePanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
        var rule = Tools_1.Tools.baseInfo.rule;
        this.ruleTex = this.addChild(Tools_1.Tools.getText(rule, 26, '#892a1a', FYGE.TEXT_ALIGN.LEFT, 570));
        this.ruleTex.lineType = TEXT_lINETYPE.MULTI;
        this.scroll = this.addChild(new ScrollPage(570, 425, this.ruleTex.textHeight + 30));
        this.scroll.position.set(100, 549);
        this.scroll.view.addChild(this.ruleTex);
        this.addChild(new Button(RES_1.RES.getRes('liaojiele.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(165, 995);
    };
    RulePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
    };
    RulePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return RulePanel;
}(Panel_1.Panel));
exports.RulePanel = RulePanel;


/***/ }),

/***/ "./src/panels/StartPanelPrize.ts":
/*!***************************************!*\
  !*** ./src/panels/StartPanelPrize.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var MouseEvent = FYGE.MouseEvent;
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var PlayScene_1 = __webpack_require__(/*! ../scene/PlayScene */ "./src/scene/PlayScene.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var Texture = FYGE.Texture;
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var NoEnergyPanel_1 = __webpack_require__(/*! ./NoEnergyPanel */ "./src/panels/NoEnergyPanel.ts");
var Container = FYGE.Container;
var getChapter_1 = __webpack_require__(/*! ../something/chapters/getChapter */ "./src/something/chapters/getChapter.ts");
var StartPanelPrize = (function (_super) {
    __extends(StartPanelPrize, _super);
    function StartPanelPrize() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(StartPanelPrize.prototype, "groupNames", {
        get: function () {
            return ["StartPanelPrize"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(StartPanelPrize.prototype, "skinName", {
        get: function () {
            return "StartPanelPrize";
        },
        enumerable: true,
        configurable: true
    });
    StartPanelPrize.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    StartPanelPrize.prototype.initUi = function () {
        var level = this.data.level;
        this.checkTex.textWidth = 750;
        this.checkTex.textAlign = TEXT_ALIGN.CENTER;
        this.checkTex.x = 0;
        this.checkTex.text = "\u7B2C\t" + level + "\t\u5173";
        this.checkTex.strokeColor = '#c95122';
        this.checkTex.stroke = 3;
        this.startBtn.visible = true;
        this.startBtn2.visible = false;
        this.addChild(new StartTarget(level))
            .position.set(0, 652);
        var prizeLevel = 50;
        if (level > 50 && level <= 100) {
            prizeLevel = 100;
        }
        else if (level > 100) {
            prizeLevel = 120;
        }
        this.prizeImg.texture = Texture.fromUrl(Tools_1.Tools.baseInfo.levelPrize["level" + prizeLevel]);
        this.prizeImg.anchorTexture.x = 0.5;
        this.prizeImg.x = 750 / 2;
    };
    StartPanelPrize.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    StartPanelPrize.prototype.startGame = function () {
        var _this = this;
        var _a = this.data, level = _a.level, isPlayed = _a.isPlayed;
        this.enableMouseEvt(false);
        if (!isPlayed && Tools_1.Tools.propInfo.power <= 0) {
            this.enableMouseEvt(true);
            ctrls_1.showPanel(NoEnergyPanel_1.NoEnergyPanel);
            this.hidePanel();
            return;
        }
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.dojoin, { level: level }, function (success, res) {
            _this.enableMouseEvt(true);
            if (!success)
                return;
            Tools_1.Tools.propInfo.power = res.data.power;
            ctrls_1.changeScene(PlayScene_1.PlayScene, {
                chapter: level,
                isGiftPrizeLevel: res.data.isGiftPrizeLevel
            });
            _this.hidePanel();
        });
    };
    StartPanelPrize.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.startBtn.addEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.addEventListener(MouseEvent.CLICK, this.startGame, this);
    };
    StartPanelPrize.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.startBtn.removeEventListener(MouseEvent.CLICK, this.startGame, this);
        this.startBtn2.removeEventListener(MouseEvent.CLICK, this.startGame, this);
    };
    return StartPanelPrize;
}(Panel_1.Panel));
exports.StartPanelPrize = StartPanelPrize;
var pos = [
    [325],
    [240, 410],
    [180, 325, 470],
];
var StartTarget = (function (_super) {
    __extends(StartTarget, _super);
    function StartTarget(checkNum) {
        var _this = _super.call(this) || this;
        var passTarget = getChapter_1.getChapterData(checkNum).passTarget;
        if (passTarget.type == 0) {
        }
        else if (passTarget.type == 1) {
            passTarget.elements.forEach(function (v, i) {
                var targetItem = _this.addChild(new StartTargetItem(v));
                targetItem.x = pos[passTarget.elements.length - 1][i];
                setTimeout(function () {
                    targetItem.playEffect();
                }, i * 200);
            });
        }
        return _this;
    }
    return StartTarget;
}(Container));
exports.StartTarget = StartTarget;
var StartTargetItem = (function (_super) {
    __extends(StartTargetItem, _super);
    function StartTargetItem(data) {
        var _this = _super.call(this) || this;
        var targetImg = _this.addChild(Tools_1.Tools.getSprite("ele" + data.type + ".png"));
        targetImg.width = targetImg.height = 100;
        var targetTex = _this.addChild(Tools_1.Tools.getText("" + data.count, 30, '#ffffff', TEXT_ALIGN.CENTER, 100, 0, 108));
        targetTex.strokeColor = '#eb5b57';
        targetTex.stroke = 3;
        _this.anchor.set(50, 79);
        _this.scale.set(0, 0);
        return _this;
    }
    StartTargetItem.prototype.playEffect = function () {
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 500, Ease.backOut);
    };
    return StartTargetItem;
}(Container));
exports.StartTargetItem = StartTargetItem;


/***/ }),

/***/ "./src/panels/SuccessNoPrizePanel.ts":
/*!*******************************************!*\
  !*** ./src/panels/SuccessNoPrizePanel.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var Container = FYGE.Container;
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var FrameAni = FYGE.FrameAni;
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var MouseEvent = FYGE.MouseEvent;
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ../scene/map/MapScene */ "./src/scene/map/MapScene.ts");
var SuccessNoPrizePanel = (function (_super) {
    __extends(SuccessNoPrizePanel, _super);
    function SuccessNoPrizePanel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.starGroup = null;
        return _this;
    }
    Object.defineProperty(SuccessNoPrizePanel.prototype, "groupNames", {
        get: function () {
            return ['SuccessPanel', 'starLight'];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SuccessNoPrizePanel.prototype, "skinName", {
        get: function () {
            return "SuccessNoPrizePanel";
        },
        enumerable: true,
        configurable: true
    });
    SuccessNoPrizePanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    SuccessNoPrizePanel.prototype.initUi = function () {
        this.tipsTex.textAlign = TEXT_ALIGN.CENTER;
        this.tipsTex.textWidth = 750;
        this.tipsTex.x = 0;
        this.starGroup = this.addChild(new SuccessStarGroup());
        this.starGroup.position.set(375, 660);
        this.starGroup.play(this.data.stars);
        if (this.data.stars >= 3) {
            this.againBtn.visible = false;
            this.continueBtn.visible = false;
        }
        else {
            this.totalContinueBtn.visible = false;
        }
    };
    SuccessNoPrizePanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    SuccessNoPrizePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.againBtn.addEventListener(MouseEvent.CLICK, this.again, this);
        this.continueBtn.addEventListener(MouseEvent.CLICK, this.continue, this);
        this.totalContinueBtn.addEventListener(MouseEvent.CLICK, this.continue, this);
    };
    SuccessNoPrizePanel.prototype.again = function () {
        ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level });
        _super.prototype.hidePanel.call(this);
    };
    SuccessNoPrizePanel.prototype.continue = function () {
        if (this.data.level == 120) {
            ctrls_1.changeScene(MapScene_1.MapScene);
        }
        else {
            ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level + 1 });
        }
        _super.prototype.hidePanel.call(this);
    };
    SuccessNoPrizePanel.prototype.hidePanel = function () {
        ctrls_1.changeScene(MapScene_1.MapScene);
        _super.prototype.hidePanel.call(this);
    };
    SuccessNoPrizePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.againBtn.removeEventListener(MouseEvent.CLICK, this.again, this);
        this.continueBtn.removeEventListener(MouseEvent.CLICK, this.continue, this);
        this.totalContinueBtn.removeEventListener(MouseEvent.CLICK, this.continue, this);
    };
    return SuccessNoPrizePanel;
}(Panel_1.Panel));
exports.SuccessNoPrizePanel = SuccessNoPrizePanel;
var SuccessStarGroup = (function (_super) {
    __extends(SuccessStarGroup, _super);
    function SuccessStarGroup() {
        var _this = _super.call(this) || this;
        _this.leftStarDis = null;
        _this.midStarDis = null;
        _this.rightStarDis = null;
        _this.leftStarEn = null;
        _this.midStarEn = null;
        _this.rightStarEn = null;
        _this.leftStarAni = null;
        _this.midStarAni = null;
        _this.rightStarAni = null;
        _this.leftStarDis = _this.addChild(Tools_1.Tools.getSprite('star_dis.png'));
        _this.midStarDis = _this.addChild(Tools_1.Tools.getSprite('star_dis.png'));
        _this.rightStarDis = _this.addChild(Tools_1.Tools.getSprite('star_dis.png'));
        _this.leftStarEn = _this.addChild(Tools_1.Tools.getSprite('star_en.png'));
        _this.midStarEn = _this.addChild(Tools_1.Tools.getSprite('star_en.png'));
        _this.rightStarEn = _this.addChild(Tools_1.Tools.getSprite('star_en.png'));
        _this.leftStarDis.anchorTexture.set(0.5, 0.5);
        _this.midStarDis.anchorTexture.set(0.5, 0.5);
        _this.rightStarDis.anchorTexture.set(0.5, 0.5);
        _this.leftStarEn.anchorTexture.set(0.5, 0.5);
        _this.midStarEn.anchorTexture.set(0.5, 0.5);
        _this.rightStarEn.anchorTexture.set(0.5, 0.5);
        _this.leftStarDis.position.set(-158, 36);
        _this.leftStarDis.rotation = -25;
        _this.leftStarDis.scale.set(0.81, 0.81);
        _this.leftStarEn.position.set(-157, 41);
        _this.leftStarEn.rotation = -25;
        _this.leftStarEn.scale.set(0.81, 0.81);
        _this.midStarEn.y = 5;
        _this.rightStarDis.position.set(157, 37);
        _this.rightStarDis.rotation = 25;
        _this.rightStarDis.scale.set(0.81, 0.81);
        _this.rightStarEn.position.set(156, 41);
        _this.rightStarEn.rotation = 25;
        _this.rightStarEn.scale.set(0.81, 0.81);
        _this.leftStarEn.scale.set(0, 0);
        _this.midStarEn.scale.set(0, 0);
        _this.rightStarEn.scale.set(0, 0);
        var starAniFrame = new Array(16);
        for (var i = 0; i < 15; i++) {
            starAniFrame[i] = RES_1.RES.getRes("star_light_" + i + ".png");
        }
        starAniFrame[15] = null;
        _this.leftStarAni = _this.addChild(new FrameAni(starAniFrame));
        _this.leftStarAni.visible = false;
        _this.leftStarAni.position.set(-158, 44);
        _this.midStarAni = _this.addChild(new FrameAni(starAniFrame));
        _this.midStarAni.visible = false;
        _this.midStarAni.y = 8;
        _this.rightStarAni = _this.addChild(new FrameAni(starAniFrame));
        _this.rightStarAni.visible = false;
        _this.rightStarAni.position.set(158, 42);
        return _this;
    }
    SuccessStarGroup.prototype.play = function (count, wait) {
        var _this = this;
        if (wait === void 0) { wait = 600; }
        var time1 = 200;
        var time2 = 100;
        var max = 3;
        var interval = 100;
        if (count < 1) {
            return;
        }
        Tween.get(this.leftStarEn)
            .wait(wait)
            .set({ scaleX: max, scaleY: max })
            .to({ scaleX: 0.648, scaleY: 0.648 }, time1, Ease.quadOut)
            .call(function () {
            _this.leftStarAni.visible = true;
            _this.leftStarAni.play(1);
        })
            .to({ scaleX: 0.81, scaleY: 0.81 }, time2, Ease.quadOut)
            .wait(interval)
            .call(function () {
            if (count <= 1)
                return;
            Tween.get(_this.midStarEn)
                .set({ scaleX: max, scaleY: max })
                .to({ scaleX: 0.8, scaleY: 0.8 }, time1, Ease.quadOut)
                .call(function () {
                _this.midStarAni.visible = true;
                _this.midStarAni.play(1);
            })
                .to({ scaleX: 1, scaleY: 1 }, time2, Ease.quadOut)
                .wait(interval)
                .call(function () {
                if (count <= 2)
                    return;
                Tween.get(_this.rightStarEn)
                    .set({ scaleX: max, scaleY: max })
                    .to({ scaleX: 0.648, scaleY: 0.648 }, time1, Ease.quadOut)
                    .call(function () {
                    _this.rightStarAni.visible = true;
                    _this.rightStarAni.play(1);
                })
                    .to({ scaleX: 0.81, scaleY: 0.81 }, time2, Ease.quadOut);
            });
        });
    };
    return SuccessStarGroup;
}(Container));
exports.SuccessStarGroup = SuccessStarGroup;


/***/ }),

/***/ "./src/panels/SuccessPrizePanel.ts":
/*!*****************************************!*\
  !*** ./src/panels/SuccessPrizePanel.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var _a;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var SuccessNoPrizePanel_1 = __webpack_require__(/*! ./SuccessNoPrizePanel */ "./src/panels/SuccessNoPrizePanel.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var PropType_1 = __webpack_require__(/*! ../something/enum/PropType */ "./src/something/enum/PropType.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ../scene/map/MapScene */ "./src/scene/map/MapScene.ts");
var MouseEvent = FYGE.MouseEvent;
var Button = FYGE.Button;
var Texture = FYGE.Texture;
var propImg = (_a = {},
    _a[PropType_1.PropType.BOOMS] = 'boomBtn.png',
    _a[PropType_1.PropType.HAMMERS] = 'hammerBtn.png',
    _a[PropType_1.PropType.STEPS] = 'stepBtn.png',
    _a[PropType_1.PropType.POWER] = 'power.png',
    _a);
var SuccessPrizePanel = (function (_super) {
    __extends(SuccessPrizePanel, _super);
    function SuccessPrizePanel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.starGroup = null;
        return _this;
    }
    Object.defineProperty(SuccessPrizePanel.prototype, "groupNames", {
        get: function () {
            return ['SuccessPanel', 'starLight'];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SuccessPrizePanel.prototype, "skinName", {
        get: function () {
            return "SuccessPrizePanel";
        },
        enumerable: true,
        configurable: true
    });
    SuccessPrizePanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    SuccessPrizePanel.prototype.initUi = function () {
        var _a = this.data, stars = _a.stars, tool = _a.tool, prize = _a.prize;
        this.tipsTex.textWidth = 750;
        this.tipsTex.x = 0;
        this.tipsTex.textAlign = TEXT_ALIGN.CENTER;
        this.tipsTex2.textWidth = 750;
        this.tipsTex2.x = 0;
        this.tipsTex2.textAlign = TEXT_ALIGN.CENTER;
        this.starGroup = this.addChild(new SuccessNoPrizePanel_1.SuccessStarGroup());
        this.starGroup.position.set(375, 663);
        this.prizeImg.anchorTexture.x = 0.5;
        this.prizeImg.x = 370;
        this.starGroup.play(stars);
        if (tool && tool.type) {
            this.tipsTex.text = '\t闯关成功！获得奖励：';
            this.prizeImg.scale.set(1.8, 1.8);
            this.prizeImg.texture = RES_1.RES.getRes(propImg[tool.type]);
            if (stars == 3) {
                this.tipsTex2.visible = false;
                this.prizeImg.y = 879;
                this.addChild(new Button(RES_1.RES.getRes('继续闯关大.png')))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(163, 1109);
            }
            else {
                this.tipsTex2.text = '满星通关可抽取更大奖励哦';
                this.addChild(new Button(RES_1.RES.getRes('继续闯关小.png')))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(388, 1145);
                this.addChild(new Button(RES_1.RES.getRes('闯关成功不满星按钮.png')))
                    .addEventListener(MouseEvent.CLICK, this.again, this)
                    .position.set(100, 1145);
            }
        }
        else if (prize && prize.image) {
            this.prizeImg.texture = Texture.fromUrl(prize.image);
            this.tipsTex2.text = '奖品可以在“我的奖品”页面查看';
            this.addChild(new Button(RES_1.RES.getRes('继续闯关红.png')))
                .addEventListener(MouseEvent.CLICK, this.continue, this)
                .position.set(100, 1145);
            this.addChild(new Button(RES_1.RES.getRes('查看奖品.png')))
                .addEventListener(MouseEvent.CLICK, this.lookPrize, this)
                .position.set(388, 1145);
        }
    };
    SuccessPrizePanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
    };
    SuccessPrizePanel.prototype.lookPrize = function () {
        ctrls_1.changeScene(MapScene_1.MapScene, { doSomething: 'toMyPrize' });
        _super.prototype.hidePanel.call(this);
    };
    SuccessPrizePanel.prototype.again = function () {
        ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level });
        _super.prototype.hidePanel.call(this);
    };
    SuccessPrizePanel.prototype.continue = function () {
        if (this.data.level == 120) {
            ctrls_1.changeScene(MapScene_1.MapScene);
        }
        else {
            ctrls_1.changeScene(MapScene_1.MapScene, { level: this.data.level + 1 });
        }
        _super.prototype.hidePanel.call(this);
    };
    SuccessPrizePanel.prototype.hidePanel = function () {
        ctrls_1.changeScene(MapScene_1.MapScene);
        _super.prototype.hidePanel.call(this);
    };
    SuccessPrizePanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
    };
    SuccessPrizePanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
    };
    return SuccessPrizePanel;
}(Panel_1.Panel));
exports.SuccessPrizePanel = SuccessPrizePanel;


/***/ }),

/***/ "./src/panels/TaskPanel.ts":
/*!*********************************!*\
  !*** ./src/panels/TaskPanel.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var _a;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var layers_1 = __webpack_require__(/*! ../../module/views/layers */ "./module/views/layers.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var Main_1 = __webpack_require__(/*! ../Main */ "./src/Main.ts");
var G_EVENT_1 = __webpack_require__(/*! ../common/G_EVENT */ "./src/common/G_EVENT.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var Item_1 = __webpack_require__(/*! ../../module/views/Item */ "./module/views/Item.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var Button = FYGE.Button;
var ScrollList = FYGE.ScrollList;
var Sprite = FYGE.Sprite;
var MouseEvent = FYGE.MouseEvent;
var TaskType;
(function (TaskType) {
    TaskType["member"] = "member";
    TaskType["follow"] = "follow";
    TaskType["invites"] = "invites";
    TaskType["orderGoods"] = "orderGoods";
    TaskType["browseGoods"] = "browseGoods";
})(TaskType = exports.TaskType || (exports.TaskType = {}));
var taskItemData = (_a = {},
    _a[TaskType.member] = {
        key: TaskType.member,
        title: '加入会员',
        desc: '加入会员得${rewards}体力'
    },
    _a[TaskType.follow] = {
        key: TaskType.follow,
        title: '关注店铺',
        desc: '关注店铺得${rewards}体力'
    },
    _a[TaskType.invites] = {
        key: TaskType.invites,
        title: '邀请好友(${done}/${total})',
        desc: '每邀请一个好友，可获得${rewards}体力'
    },
    _a[TaskType.orderGoods] = {
        key: TaskType.orderGoods,
        title: '完成下单(${done}/${total})',
        desc: '完成下单即可获得${rewards}体力'
    },
    _a[TaskType.browseGoods] = {
        key: TaskType.browseGoods,
        title: '每日浏览商品(${done}/${total})',
        desc: '浏览指定商品即可获得${rewards}体力'
    },
    _a);
var TaskPanel = (function (_super) {
    __extends(TaskPanel, _super);
    function TaskPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(TaskPanel.prototype, "groupNames", {
        get: function () {
            return ["TaskPanel"];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TaskPanel.prototype, "skinName", {
        get: function () {
            return "TaskPanel";
        },
        enumerable: true,
        configurable: true
    });
    TaskPanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.y = layers_1.layers.stageHeight + this.height;
        Tween.get(this)
            .to({ y: 80 - layers_1.layers.stageOffsetY }, 500, Ease.quartOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    TaskPanel.prototype.initUi = function () {
        this.scroll = this.addChild(new ScrollList(TaskItem, 700, 180, 700, 878));
        this.scroll.position.set(25, 670);
    };
    TaskPanel.prototype.start = function (data) {
        _super.prototype.start.call(this);
        this.updateTask();
    };
    TaskPanel.prototype.updateTask = function () {
        var _this = this;
        ctrls_1.showWaiting();
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getTaskList, {}, function (success, res) {
            ctrls_1.hideWaiting();
            if (!success)
                return;
            console.log(res);
            for (var i = res.data.length - 1; i >= 0; i--) {
                var v = res.data[i];
                if ((v.taskType == TaskType.member || v.taskType == TaskType.follow)
                    && v.status == 3) {
                    res.data.splice(i, 1);
                }
            }
            console.log(res.data);
            _this.scroll.updateData(res.data, true);
        });
    };
    TaskPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.ON_SHOW, this.updateTask, this);
        Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.UPDATE_TASK, this.updateTask, this);
    };
    TaskPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.ON_SHOW, this.updateTask, this);
        Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.UPDATE_TASK, this.updateTask, this);
    };
    return TaskPanel;
}(Panel_1.Panel));
exports.TaskPanel = TaskPanel;
var TaskItem = (function (_super) {
    __extends(TaskItem, _super);
    function TaskItem() {
        return _super.call(this) || this;
    }
    TaskItem.prototype.initUi = function (data) {
        this.addChild(Tools_1.Tools.getSprite('task_item_bg.png'));
        this.icon = this.addChild(new Sprite());
        this.icon.position.set(25, 30);
        this.title = this.addChild(Tools_1.Tools.getText('关注店铺', 30, '#df5942'));
        this.title.bold = true;
        this.title.position.set(146, 46);
        this.desc = this.addChild(Tools_1.Tools.getText('加入会员得x体力', 24, '#666666'));
        this.desc.bold = true;
        this.desc.position.set(145, 92);
        this.getBtn = this.addChild(new Button(RES_1.RES.getRes('task_get_btn.png')));
        this.taskBtn = this.addChild(new Button(RES_1.RES.getRes("\u53BB\u5B8C\u6210.png"), RES_1.RES.getRes("\u53BB\u5B8C\u6210.png"), RES_1.RES.getRes("\u53BB\u5B8C\u6210\u7070.png")));
        this.getBtn.position.set(501, 43);
        this.taskBtn.position.set(501, 43);
        this.getBtn.addEventListener(MouseEvent.CLICK, this.clickGet, this);
        this.taskBtn.addEventListener(MouseEvent.CLICK, this.clickTask, this);
    };
    TaskItem.prototype.initData = function (id, data) {
        if (id < 0 || !data)
            return;
        this.data = data;
        var rewards = data.rewards, taskType = data.taskType, completeTimes = data.completeTimes, waitReceive = data.waitReceive, todayCompleteTimes = data.todayCompleteTimes, times = data.times, status = data.status;
        this.icon.texture = RES_1.RES.getRes(taskType + "_icon.png");
        this.title.text = taskItemData[taskType].title
            .replace('${done}', todayCompleteTimes)
            .replace('${total}', times);
        this.desc.text = taskItemData[taskType].desc
            .replace('${rewards}', rewards);
        this.taskBtn.changeTexture(RES_1.RES.getRes(taskType + "_btn_en.png"), RES_1.RES.getRes(taskType + "_btn_en.png"), RES_1.RES.getRes(taskType + "_btn_dis.png"));
        if (+status == 2) {
            this.getBtn.visible = true;
            this.taskBtn.visible = false;
        }
        else if (+status == 3) {
            this.getBtn.visible = false;
            this.taskBtn.visible = true;
            this.taskBtn.enabled = false;
        }
        else if (+status == 1) {
            this.getBtn.visible = false;
            this.taskBtn.visible = true;
            this.taskBtn.enabled = true;
        }
    };
    TaskItem.prototype.clickGet = function () {
        var _this = this;
        this.getBtn.mouseEnable = false;
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.receiveTaskRewards, { taskType: this.data.taskType }, function (success, res) {
            _this.getBtn.mouseEnable = true;
            if (!success)
                return;
            ctrls_1.showToast("\u4EFB\u52A1\u5B8C\u6210\uFF0C\u4F53\u529B\u503C+" + res.data.power + "\uFF01");
            Tools_1.Tools.propInfo.power += res.data.power;
            ctrls_1.getCurrentScene().updateScene();
            Main_1.GDispatcher.dispatchEvent(G_EVENT_1.G_EVENT.UPDATE_TASK);
        });
    };
    TaskItem.prototype.clickTask = function () {
        var _this = this;
        switch (this.data.taskType) {
            case TaskType.member:
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateToOutside, { url: this.data.url });
                break;
            case TaskType.browseGoods:
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateTo, {
                    url: '/pages/goodsPage/goodsPage?taskType=browseGoods&itemIds=' + this.data.itemIds
                });
                break;
            case TaskType.follow:
                Main_1.GDispatcher.removeAllEventListenerByType(TaoBaoNet_1.TbNetName.favorShop);
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.favorShop, {}, function (fs, fr) {
                    if (!fs)
                        return;
                    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.doFollowTask, { taskType: _this.data.taskType }, function (cs, cr) { return Main_1.GDispatcher.dispatchEvent(G_EVENT_1.G_EVENT.UPDATE_TASK); });
                }, true);
                break;
            case TaskType.invites:
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.addStats, { type: 'invite' }, function () {
                }, true);
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.showSharePanel, { openId: Tools_1.Tools.globalData.openId }, function () {
                }, true);
                break;
            case TaskType.orderGoods:
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateToOutside, { url: 'https://popmart.m.tmall.com' });
                break;
        }
    };
    return TaskItem;
}(Item_1.Item));


/***/ }),

/***/ "./src/scene/LoadingScene.ts":
/*!***********************************!*\
  !*** ./src/scene/LoadingScene.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var ProgressBarS_1 = __webpack_require__(/*! ../common/ProgressBarS */ "./src/common/ProgressBarS.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var MapScene_1 = __webpack_require__(/*! ./map/MapScene */ "./src/scene/map/MapScene.ts");
var layers_1 = __webpack_require__(/*! ../../module/views/layers */ "./module/views/layers.ts");
var GTool_1 = __webpack_require__(/*! ../../module/tools/GTool */ "./module/tools/GTool.ts");
var Lottie_1 = __webpack_require__(/*! ../Lottie */ "./src/Lottie.ts");
var pop_laoding_bg_1 = __webpack_require__(/*! ../lotties/pop_laoding_bg */ "./src/lotties/pop_laoding_bg.ts");
var pop_loading_title_1 = __webpack_require__(/*! ../lotties/pop_loading_title */ "./src/lotties/pop_loading_title.ts");
var Sprite = FYGE.Sprite;
var FrameAni = FYGE.FrameAni;
var LoadingScene = (function (_super) {
    __extends(LoadingScene, _super);
    function LoadingScene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(LoadingScene.prototype, "groupNames", {
        get: function () {
            return ["loadingScene", 'pop_laoding_bg', 'pop_loading_title'];
        },
        enumerable: true,
        configurable: true
    });
    LoadingScene.prototype.initUi = function () {
        this.y = -layers_1.layers.stageOffsetY;
        this.addChild(Sprite.fromFrame("loadingBg.jpg"));
        var loadingBg = this.addChild(new Lottie_1.Lottie(pop_laoding_bg_1.pop_laoding_bg));
        loadingBg.play(-1);
        var loadingTitle = this.addChild(new Lottie_1.Lottie(pop_loading_title_1.pop_loading_title));
        loadingTitle.play(1);
        this.addChild(Sprite.fromFrame("proDown.png"))
            .position.set((750 - 577) / 2, 1288 - 24);
        var arr = [];
        for (var i = 0; i <= 11; i++)
            arr.push(RES_1.RES.getRes("loadingPro" + i + ".png"));
        var pro = this.addChild(new FrameAni(arr));
        pro.play(0);
        pro.position.set(375, 1288);
        this.progressBar = new ProgressBarS_1.ProgressBarS(pro);
        this.addChild(Tools_1.Tools.getText(GTool_1.GTool.randomT([
            '游戏加载中...'
        ]), 28, "#ae3830", FYGE.TEXT_ALIGN.CENTER, 500, (750 - 500) / 2, 1288 - 24 + 18 + 48));
    };
    LoadingScene.prototype.start = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _super.prototype.start.call(this);
                        this.addEventListener(FYGE.Event.PROGRESS, this.progressEvent, this);
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.2);
                        return [4, Tools_1.Tools.getAppData()];
                    case 1:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.3);
                        return [4, Tools_1.Tools.getBaseInfo()];
                    case 2:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.5);
                        return [4, RES_1.RES.loadGroup("map")];
                    case 3:
                        _a.sent();
                        return [4, RES_1.RES.loadGroup("mapEffect")];
                    case 4:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.6);
                        return [4, RES_1.RES.loadGroup("mapTree")];
                    case 5:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.7);
                        return [4, RES_1.RES.loadGroup("mapCat")];
                    case 6:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.8);
                        return [4, RES_1.RES.loadGroup("mapAroma1")];
                    case 7:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 0.9);
                        return [4, RES_1.RES.loadGroup("mapTinyBalloon")];
                    case 8:
                        _a.sent();
                        this.dispatchEvent(FYGE.Event.PROGRESS, 1);
                        return [2];
                }
            });
        });
    };
    LoadingScene.prototype.progressEvent = function (e) {
        var _this = this;
        var pro = e.data;
        FYGE.Tween.get(this.progressBar, null, null, true)
            .to({ value: pro }, 2000)
            .call(function () {
            if (pro >= 1) {
                _this.removeEventListener(FYGE.Event.PROGRESS, _this.progressEvent, _this);
                ctrls_1.changeScene(MapScene_1.MapScene, { from: "loading" });
            }
        });
    };
    LoadingScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    return LoadingScene;
}(Scene_1.Scene));
exports.LoadingScene = LoadingScene;


/***/ }),

/***/ "./src/scene/PlayScene.ts":
/*!********************************!*\
  !*** ./src/scene/PlayScene.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var BonusShootAni_1 = __webpack_require__(/*! ../something/anis/BonusShootAni */ "./src/something/anis/BonusShootAni.ts");
var BoomAni_1 = __webpack_require__(/*! ../something/anis/BoomAni */ "./src/something/anis/BoomAni.ts");
var CrossAni_1 = __webpack_require__(/*! ../something/anis/CrossAni */ "./src/something/anis/CrossAni.ts");
var EleDisAni_1 = __webpack_require__(/*! ../something/anis/EleDisAni */ "./src/something/anis/EleDisAni.ts");
var FlyTargetAni_1 = __webpack_require__(/*! ../something/anis/FlyTargetAni */ "./src/something/anis/FlyTargetAni.ts");
var HorizontalAni_1 = __webpack_require__(/*! ../something/anis/HorizontalAni */ "./src/something/anis/HorizontalAni.ts");
var IceAni_1 = __webpack_require__(/*! ../something/anis/IceAni */ "./src/something/anis/IceAni.ts");
var MagicLionAni_1 = __webpack_require__(/*! ../something/anis/MagicLionAni */ "./src/something/anis/MagicLionAni.ts");
var MagicRotateAni_1 = __webpack_require__(/*! ../something/anis/MagicRotateAni */ "./src/something/anis/MagicRotateAni.ts");
var RockAni_1 = __webpack_require__(/*! ../something/anis/RockAni */ "./src/something/anis/RockAni.ts");
var ScoreAni_1 = __webpack_require__(/*! ../something/anis/ScoreAni */ "./src/something/anis/ScoreAni.ts");
var ThreeCrossAni_1 = __webpack_require__(/*! ../something/anis/ThreeCrossAni */ "./src/something/anis/ThreeCrossAni.ts");
var VerticalAni_1 = __webpack_require__(/*! ../something/anis/VerticalAni */ "./src/something/anis/VerticalAni.ts");
var Element_1 = __webpack_require__(/*! ../something/class/Element */ "./src/something/class/Element.ts");
var Ice_1 = __webpack_require__(/*! ../something/class/Ice */ "./src/something/class/Ice.ts");
var Lattice_1 = __webpack_require__(/*! ../something/class/Lattice */ "./src/something/class/Lattice.ts");
var EffectType_1 = __webpack_require__(/*! ../something/enum/EffectType */ "./src/something/enum/EffectType.ts");
var ElementType_1 = __webpack_require__(/*! ../something/enum/ElementType */ "./src/something/enum/ElementType.ts");
var PassType_1 = __webpack_require__(/*! ../something/enum/PassType */ "./src/something/enum/PassType.ts");
var RecoverName_1 = __webpack_require__(/*! ../something/enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var aaa_1 = __webpack_require__(/*! ../something/logic/aaa */ "./src/something/logic/aaa.ts");
var Pool_1 = __webpack_require__(/*! ../something/Pool */ "./src/something/Pool.ts");
var Tool_1 = __webpack_require__(/*! ../something/Tool */ "./src/something/Tool.ts");
var ElementTargets_1 = __webpack_require__(/*! ../something/uis/ElementTargets */ "./src/something/uis/ElementTargets.ts");
var PropGuide_1 = __webpack_require__(/*! ../something/uis/PropGuide */ "./src/something/uis/PropGuide.ts");
var ScoreProgress_1 = __webpack_require__(/*! ../something/uis/ScoreProgress */ "./src/something/uis/ScoreProgress.ts");
var StepAni_1 = __webpack_require__(/*! ../something/anis/StepAni */ "./src/something/anis/StepAni.ts");
var AiControl_1 = __webpack_require__(/*! ../something/logic/AiControl */ "./src/something/logic/AiControl.ts");
var JellyDisAni_1 = __webpack_require__(/*! ../something/anis/JellyDisAni */ "./src/something/anis/JellyDisAni.ts");
var EggBrokenAni_1 = __webpack_require__(/*! ../something/anis/EggBrokenAni */ "./src/something/anis/EggBrokenAni.ts");
var FallAniData_1 = __webpack_require__(/*! ../something/interface/FallAniData */ "./src/something/interface/FallAniData.ts");
var EleMaskAni_1 = __webpack_require__(/*! ../something/anis/EleMaskAni */ "./src/something/anis/EleMaskAni.ts");
var getChapter_1 = __webpack_require__(/*! ../something/chapters/getChapter */ "./src/something/chapters/getChapter.ts");
var StateType_1 = __webpack_require__(/*! ../something/enum/StateType */ "./src/something/enum/StateType.ts");
var HairballGreyDisAni_1 = __webpack_require__(/*! ../something/anis/HairballGreyDisAni */ "./src/something/anis/HairballGreyDisAni.ts");
var EleDownAni_1 = __webpack_require__(/*! ../something/anis/EleDownAni */ "./src/something/anis/EleDownAni.ts");
var GameGuide_1 = __webpack_require__(/*! ../something/uis/GameGuide */ "./src/something/uis/GameGuide.ts");
var PropBtnCon_1 = __webpack_require__(/*! ../something/uis/PropBtnCon */ "./src/something/uis/PropBtnCon.ts");
var FestivalTarget_1 = __webpack_require__(/*! ../something/uis/FestivalTarget */ "./src/something/uis/FestivalTarget.ts");
var FesRedBombShowAni_1 = __webpack_require__(/*! ../something/anisCall/FesRedBombShowAni */ "./src/something/anisCall/FesRedBombShowAni.ts");
var RectsWaveAni_1 = __webpack_require__(/*! ../something/anisCall/RectsWaveAni */ "./src/something/anisCall/RectsWaveAni.ts");
var Door_1 = __webpack_require__(/*! ../something/class/Door */ "./src/something/class/Door.ts");
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var GTool_1 = __webpack_require__(/*! ../../module/tools/GTool */ "./module/tools/GTool.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var PropType_1 = __webpack_require__(/*! ../something/enum/PropType */ "./src/something/enum/PropType.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var layers_1 = __webpack_require__(/*! ../../module/views/layers */ "./module/views/layers.ts");
var Lottie_1 = __webpack_require__(/*! ../Lottie */ "./src/Lottie.ts");
var GameToast_1 = __webpack_require__(/*! ../something/uis/GameToast */ "./src/something/uis/GameToast.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var MapScene_1 = __webpack_require__(/*! ./map/MapScene */ "./src/scene/map/MapScene.ts");
var NoStepPanel_1 = __webpack_require__(/*! ../panels/NoStepPanel */ "./src/panels/NoStepPanel.ts");
var FirstPropGift_1 = __webpack_require__(/*! ../something/uis/FirstPropGift */ "./src/something/uis/FirstPropGift.ts");
var bonus_1 = __webpack_require__(/*! ../lotties/bonus */ "./src/lotties/bonus.ts");
var Main_1 = __webpack_require__(/*! ../Main */ "./src/Main.ts");
var G_EVENT_1 = __webpack_require__(/*! ../common/G_EVENT */ "./src/common/G_EVENT.ts");
var Tween = FYGE.Tween;
var BitmapRecycle_1 = __webpack_require__(/*! ../something/class/BitmapRecycle */ "./src/something/class/BitmapRecycle.ts");
var FesRedPrizePanel_1 = __webpack_require__(/*! ../panels/FesRedPrizePanel */ "./src/panels/FesRedPrizePanel.ts");
var FrameAni = FYGE.FrameAni;
var Container = FYGE.Container;
var Ease = FYGE.Ease;
var Graphics = FYGE.Graphics;
var aniClass = {
    "BoomAni": BoomAni_1.BoomAni,
    "IceAni": IceAni_1.IceAni,
    "RockAni": RockAni_1.RockAni,
    "HorizontalAni": HorizontalAni_1.HorizontalAni,
    "VerticalAni": VerticalAni_1.VerticalAni,
    "CrossAni": CrossAni_1.CrossAni,
    "ThreeCrossAni": ThreeCrossAni_1.ThreeCrossAni,
    "MagicLionAni": MagicLionAni_1.MagicLionAni,
    "StepAni": StepAni_1.StepAni,
    "JellyDisAni": JellyDisAni_1.JellyDisAni,
    "EggBrokenAni": EggBrokenAni_1.EggBrokenAni,
    "HairballGreyDisAni": HairballGreyDisAni_1.HairballGreyDisAni,
};
exports.baseScore = 20;
exports.effectBaseTimes = {
    0: 2.5,
    1: 2.5,
    2: 5,
    3: 15,
    LL: 10,
    EL: 20,
    EE: 25,
    MM: 50
};
var svgaParser;
var movieClips = {
    wonderful: null,
    amazing: null,
    great: null,
    bonusTime: null
};
var redBombPanelName = "redBombPanelName";
var fesChapterData = new (Array.bind.apply(Array, [void 0].concat(new Array(117))))().map(function (a, i) { return i + 4; });
var festivalIndex = 40;
var PlayScene = (function (_super) {
    __extends(PlayScene, _super);
    function PlayScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.emptys = [];
        _this.eliminatedElements = [];
        _this.noActionCount = 0;
        _this.isShowWarning = false;
        _this.magicRotateData = [];
        _this.commonContinuityTimes = 0;
        _this.effectContinuityTimes = 0;
        _this.lollipopCount = 0;
        _this.hasPassed = false;
        _this.isCountingTime = false;
        _this.festivalTargetNum = AiControl_1.fesELeSmallNum;
        _this.scoreAnis = [];
        _this.connectState = 2;
        _this.addedStepWarning = false;
        _this.recordOnce = {
            boom: false,
            hammer: false,
            step: false,
            failStep: false
        };
        return _this;
    }
    Object.defineProperty(PlayScene.prototype, "groupNames", {
        get: function () {
            return [
                "playScene",
                "playFrameAni",
                "playerFont",
                "fiveVerHorDis",
                'festival',
                'MagicAni'
            ];
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PlayScene.prototype, "steps", {
        get: function () {
            return this._steps;
        },
        set: function (value) {
            if (value == this._steps)
                return;
            this._steps = value;
            this.stepNumber.text = "" + value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PlayScene.prototype, "score", {
        get: function () {
            return this._score;
        },
        set: function (value) {
            if (value == this._score)
                return;
            this._score = value;
            FYGE.Tween.removeTweens(this.scoreProgress);
            FYGE.Tween.get(this.scoreProgress, {}, null, true)
                .to({ score: value }, 300);
        },
        enumerable: true,
        configurable: true
    });
    PlayScene.prototype.initUi = function () {
        this.addChild(FYGE.Sprite.fromFrame("playBg.jpg")).position.set(0, -layers_1.layers.stageOffsetY);
        this.addChild(FYGE.Sprite.fromFrame("topBg.png")).position.set(50, 9);
        var commonTextArr = {};
        for (var i = 0; i < 10; i++)
            commonTextArr[i] = RES_1.RES.getRes("scoreNum" + i + ".png");
        ["通", "关", "分", "数"].forEach(function (e) {
            commonTextArr[e] = RES_1.RES.getRes("scoreNum" + e + ".png");
        });
        commonTextArr["："] = RES_1.RES.getRes("scoreNum冒号.png");
        this.targetScoreTxt = this.addChild(new FYGE.BitmapText(commonTextArr));
        this.targetScoreTxt.position.set(375, 193);
        this.musicBtn = this.addChild(new MusicBtn());
        this.musicBtn.position.set(618, 16);
    };
    PlayScene.prototype.start = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _super.prototype.start.call(this);
                        this.chapter = (data && data.chapter) ? data.chapter : 1;
                        this.chapterData = getChapter_1.getChapterData(this.chapter);
                        this.initTarget();
                        Tool_1.Tool.init(Tool_1.Tool.getColOddEven(this.chapterData.map.lattices), !!(this.passElements && this.passElements[ElementType_1.ElementType.LOLLIPOP]));
                        this.initScene();
                        this.enableMouseEvt(false);
                        this.initLattices();
                        this.initRecycle();
                        this.initElement();
                        this.initBaseElement();
                        return [4, this.initFestivalEle()];
                    case 1:
                        if (!(_a.sent())) {
                            if (this.threeMatch()) {
                                this.eliminate();
                            }
                            else {
                                this.warningCop = Tool_1.Tool.dieMapCheck(this.lattices);
                                if (!this.warningCop) {
                                    this.upsetElement();
                                }
                                else {
                                    this.enableMouseEvt(true);
                                    if (this.chapter == 1 && Tools_1.Tools.globalData.isFirstLogin) {
                                        this.addChild(new FirstPropGift_1.FirstPropGift())
                                            .once(FYGE.MouseEvent.CLICK, function (e) {
                                            Tools_1.Tools.globalData.isFirstLogin = false;
                                            _this.removeChild(e.target);
                                            _this.initGuide();
                                        }, this);
                                    }
                                    else {
                                        this.initGuide();
                                    }
                                }
                            }
                        }
                        this.initSvgas();
                        AiControl_1.AiControl.ins.init(this.lattices);
                        return [2];
                }
            });
        });
    };
    PlayScene.prototype.initSvgas = function () {
        return __awaiter(this, void 0, void 0, function () {
            var bonusTime;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, RES_1.RES.loadGroup("bonus")];
                    case 1:
                        _a.sent();
                        bonusTime = new Lottie_1.Lottie(bonus_1.bonus);
                        bonusTime.position.set((750 - bonusTime.videoWidth) / 2, (1624 - bonusTime.videoHeight) / 2 - layers_1.layers.stageOffsetY);
                        movieClips.bonusTime = bonusTime;
                        ["great", "wonderful", "amazing"].forEach(function (e) {
                            var g = new GameToast_1.GameToast(e + ".png");
                            g.position.set(375, 1624 / 2 - layers_1.layers.stageOffsetY);
                            movieClips[e] = g;
                        });
                        return [2];
                }
            });
        });
    };
    PlayScene.prototype.initScene = function () {
        var chapterTex = Tools_1.Tools.getNumTextures("chapterNum");
        ["第", "关"].forEach(function (e) {
            chapterTex[e] = RES_1.RES.getRes("chapterNum" + e + ".png");
        });
        var chapterTxt = this.addChild(new FYGE.BitmapText(chapterTex));
        chapterTxt.text = "第" + (this.chapter >> 0) + "关";
        chapterTxt.position.set(535, 58);
        this.stepNumber = this.addChild(new FYGE.BitmapText(Tools_1.Tools.getNumTextures("stepNum")));
        this.stepNumber.position.set(375, 20);
        this.steps = this.chapterData.stepCount;
        this.scoreProgress = this.addChild(new ScoreProgress_1.ScoreProgress(this.chapterData.starScores));
        this.scoreProgress.position.set(175, 113);
        this.score = 0;
        var path = aaa_1.generateMapBg(this.chapterData.map.lattices);
        var bg = aaa_1.drawBg(path, this.chapterData.map.lattices);
        this.addChild(bg);
        this.map = bg;
        this.elementContainer = new FYGE.Container();
        this.addChild(this.elementContainer);
        var mask = aaa_1.drawShape(path);
        this.elementContainer.mask = mask;
        mask.updateShape();
        this.addChild(mask);
        this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
        this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
        this.propBtnCon = new PropBtnCon_1.PropBtnCon();
        this.propBtnCon.y = 238 + Tool_1.Tool.gameAreaHeight + 10;
        this.addChild(this.propBtnCon);
        this.propBtnCon.boomBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onTap_boomBtn, this);
        this.propBtnCon.hammerBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onTap_hammerBtn, this);
        this.propBtnCon.stepBtn.addEventListener(FYGE.MouseEvent.CLICK, this.onTap_stepBtn, this);
        this.updateScene();
        var textureChoosed = RES_1.RES.getRes("chooseRect.png");
        this.choosed = new FYGE.Sprite(textureChoosed);
        this.choosed.anchorTexture.set(0.5, 0.5);
        this.propGuide = new PropGuide_1.PropGuide(this.propBtnCon.y + 2);
    };
    PlayScene.prototype.initTarget = function () {
        if (this.chapterData.passTarget.type == PassType_1.PassType.ELEMENT_TARGET) {
            this.hasEliminatedElements = [];
            this.passElements = [];
            for (var m = 0; m < this.chapterData.passTarget.elements.length; m++) {
                var element = this.chapterData.passTarget.elements[m];
                this.passElements[element.type] = element.count;
                this.hasEliminatedElements[element.type] = 0;
            }
            this.elementTargets = new ElementTargets_1.ElementTargets(this.passElements);
            this.elementTargets.x = 375;
            this.elementTargets.y = 180;
            this.addChild(this.elementTargets);
            this.targetScoreTxt.visible = false;
        }
        else {
            this.passElements = null;
            this.targetScoreTxt.visible = true;
            this.targetScoreTxt.text = "目标分数：" + this.chapterData.passTarget.score;
        }
    };
    PlayScene.prototype.initRecycle = function () {
        this.recycleIndexs = [];
        if (this.passElements && this.passElements[ElementType_1.ElementType.LOLLIPOP]) {
            var recycles = this.chapterData.map.recycles;
            if (!recycles || !recycles.length) {
                var endRowNumHash = {}, endRowNum = 0;
                for (var i = 0; i < this.chapterData.map.lattices.length; i++) {
                    var d = this.chapterData.map.lattices[i];
                    if (!d)
                        continue;
                    var rc = Tool_1.Tool.indexToRc(i);
                    var row = rc[0], col = rc[1];
                    if (!endRowNumHash[col]) {
                        endRowNumHash[col] = { row: row, index: i };
                    }
                    if (row > endRowNumHash[col].row) {
                        endRowNumHash[col] = { row: row, index: i };
                    }
                    endRowNum = Math.max(rc[0], endRowNum);
                }
                this.recycleIndexs = [];
                for (var key in endRowNumHash) {
                    var _a = endRowNumHash[key], index = _a.index, row = _a.row;
                    if (endRowNum == row)
                        this.recycleIndexs.push(index);
                }
            }
            else {
                this.recycleIndexs = recycles.slice();
            }
            var texture = RES_1.RES.getRes('main_mapbottom.png');
            var imgs = new FYGE.Container;
            for (var m = 0; m < this.recycleIndexs.length; m++) {
                var p = Tool_1.Tool.getPositionByIndex(this.recycleIndexs[m]);
                var img = new FYGE.Sprite(texture);
                img.x = p[0];
                img.y = p[1];
                imgs.addChild(img);
            }
            imgs.x = -texture.width / 2;
            imgs.y = Tool_1.Tool.height / 2 - 2;
            this.map.addChildAt(imgs, 0);
        }
    };
    PlayScene.prototype.initLattices = function () {
        var latticesD = this.chapterData.map.lattices;
        this.lattices = [];
        for (var i = 0; i < latticesD.length; i++) {
            if (!latticesD[i])
                continue;
            this.lattices[i] = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.LATTICE);
            if (!this.lattices[i]) {
                this.lattices[i] = new Lattice_1.Lattice(i);
            }
            else {
                this.lattices[i].reset(i);
            }
            var p = Tool_1.Tool.getPositionByIndex(i);
            var dooreData = [4, 5, 6, 51, 61];
            if (dooreData.indexOf(latticesD[i]) >= 0) {
                var door = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.DOOR);
                var closed_1 = (latticesD[i] + "").length != 2;
                if (!door) {
                    door = new Door_1.Door(closed_1);
                }
                else {
                    door.reset(closed_1);
                }
                this.map.addChild(door);
                this.lattices[i].door = door;
                door.x = p[0];
                door.y = p[1];
            }
            var iceData = [2, 3, 5, 6, 51, 61];
            if (iceData.indexOf(latticesD[i]) >= 0) {
                var iceCount = (function (n) {
                    if (n == 2 || n == 3)
                        return n - 1;
                    if (n == 5 || n == 6)
                        return n - 4;
                    return parseInt((n + "").split("")[0]) - 4;
                })(latticesD[i]);
                var ice = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.ICE);
                if (!ice) {
                    ice = new Ice_1.Ice(iceCount);
                }
                else {
                    ice.reset(iceCount);
                }
                this.map.addChild(ice);
                this.lattices[i].ice = ice;
                ice.x = p[0];
                ice.y = p[1];
                if (latticesD[i] != 2 && latticesD[i] != 3 && (latticesD[i] + "").length == 1) {
                    ice.visible = false;
                }
            }
        }
        var genLatDatas = this.chapterData.map.generateLats || [];
        this.generateIndexs = Tool_1.Tool.setGenerateLats(this.lattices, genLatDatas);
        var downMax = 0;
        var upMax = 0;
        var hasSmallToBig;
        var hasBigToSmall;
        var connectedLats = this.chapterData.map.connectedLats || [];
        for (var i = 0; i < connectedLats.length; i++) {
            var connectedLat = connectedLats[i];
            if (!connectedLat || !connectedLat.length)
                continue;
            this.lattices[connectedLat[0]].down = connectedLat[1];
            this.lattices[connectedLat[1]].up = connectedLat[0];
            var colUp = Tool_1.Tool.indexToRc(connectedLat[0])[1];
            var colDown = Tool_1.Tool.indexToRc(connectedLat[1])[1];
            downMax = Math.max(downMax, colDown);
            upMax = Math.max(upMax, colUp);
            if (colUp > colDown)
                hasBigToSmall = true;
            else if (colUp < colDown)
                hasSmallToBig = true;
        }
        if (hasBigToSmall && hasSmallToBig) {
            if (downMax > upMax) {
                this.connectState = 3;
            }
            else {
                this.connectState = 4;
            }
        }
        else if (hasBigToSmall) {
            this.connectState = 2;
        }
        else if (hasSmallToBig) {
            this.connectState = 1;
        }
    };
    PlayScene.prototype.initElement = function () {
        var elements = this.chapterData.map.elements || Tool_1.Tool.setNumber01(this.chapterData.map.lattices.slice());
        for (var i = 0; i < elements.length; i++) {
            if (!this.lattices[i])
                continue;
            var ele = void 0;
            switch (elements[i]) {
                case 0:
                    this.emptys.push(i);
                    break;
                case 1:
                case 4:
                case 7:
                case 8:
                case 9:
                case 10:
                    var type = Tool_1.Tool.returnType(i, this.lattices, this.chapterData.baseElementTypes);
                    ele = Tool_1.Tool.getElement(type);
                    if (elements[i] == 4) {
                        ele.setState(StateType_1.StateType.LOCK, true);
                    }
                    else if (elements[i] == 7) {
                        ele.setState(StateType_1.StateType.BUBBLE, true, type);
                    }
                    else if (elements[i] == 8) {
                        ele.setState(StateType_1.StateType.HAIRBALLGREY, true);
                    }
                    else if (elements[i] == 9) {
                        ele.setState(StateType_1.StateType.HAIRBALLBROWN, true);
                    }
                    else if (elements[i] == 10) {
                        ele.setState(StateType_1.StateType.HAIRBALLBLACK, true);
                    }
                    break;
                case 3:
                    this.lollipopCount++;
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.LOLLIPOP);
                    break;
                case 2:
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.ROCK);
                    break;
                case 5:
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.JELLY);
                    break;
                case 6:
                    ele = Tool_1.Tool.getElement(ElementType_1.ElementType.CHICKEN_EGG);
                    break;
                default:
                    this.emptys.push(i);
                    break;
            }
            if (ele) {
                var p = Tool_1.Tool.getPositionByIndex(i);
                ele.x = p[0];
                ele.y = p[1];
                this.elementContainer.addChild(ele);
                this.lattices[i].element = ele;
            }
            if (this.lattices[i].doorClosed) {
                if (this.lattices[i].element) {
                    this.lattices[i].element.visible = false;
                }
                else {
                    Tool_1.Tool.removeEle(i, this.emptys);
                }
            }
        }
        if (this.passElements &&
            this.passElements[ElementType_1.ElementType.LOLLIPOP] &&
            !this.lollipopCount) {
            this.lollipopMark = true;
        }
    };
    PlayScene.prototype.initBaseElement = function () {
        var elements = this.chapterData.map.baseElements;
        if (!elements || !elements.length)
            return;
        for (var i = 0; i < elements.length; i++) {
            if (!Tool_1.Tool.judgeBaseEle(this.lattices[i]))
                continue;
            if (!elements[i])
                continue;
            var arr = Tool_1.Tool.returnTO(elements[i]);
            var baseType = arr[1] ? arr[1] - 1 : null;
            if (ElementType_1.FiveBaseElementTypes.indexOf(baseType) == -1 && baseType != null)
                continue;
            var ele = this.lattices[i].element;
            if (ElementType_1.FiveBaseElementTypes.indexOf(ele.type) == -1)
                continue;
            if (baseType != null)
                ele.resetType(baseType);
            if (!ele.hasState(StateType_1.StateType.BUBBLE))
                ele.effectType = arr[0] ? arr[0] - 1 : null;
        }
    };
    PlayScene.prototype.initGuide = function () {
        var gameGuideChapterNum = [1, 2, 3, 5, 8, 9, 10, 12, 17, 25, 41, 61, 101, 121];
        if (gameGuideChapterNum.indexOf(this.chapter >> 0) > -1) {
            if (!GTool_1.GTool.readCache(Tools_1.Tools.cacheKey + this.chapter)) {
                this.gameGuide = new GameGuide_1.GameGuide(this);
                this.addChild(this.gameGuide);
                this.gameGuide.show();
            }
        }
    };
    PlayScene.prototype.startLoading = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var node = new Container();
            node.addChild(Tools_1.Tools.getSprite('playBg.jpg'));
            var tip = Tools_1.Tools.getSprite('festivalBg.png');
            tip.position.set(94, 246);
            node.addChild(tip);
            var loading = node.addChild(Tools_1.Tools.getSprite('festivalLoading.png'));
            loading.position.set(-457, 966);
            var g = _this.addChild(new Graphics());
            g.beginFill(0xffffff);
            g.drawRoundedRect(98, 966, 556, 40, 40);
            g.endFill();
            loading.mask = g;
            node.addChild(loading);
            node.addChild(g);
            _this.addChild(node);
            Tween.get(loading)
                .set({ x: -457 })
                .to({ x: 98 }, 2500, Ease.quadInOut)
                .wait(300)
                .call(function () {
                _this.removeChild(node);
                resolve(true);
            });
        });
    };
    PlayScene.prototype.initFestivalEle = function () {
        return __awaiter(this, void 0, void 0, function () {
            var p, ele, ani;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(fesChapterData.indexOf(this.chapter >> 0) > -1
                            && this.data.isGiftPrizeLevel
                            && this.lattices[festivalIndex] &&
                            (Tool_1.Tool.judgeSetFesEle(this.lattices[festivalIndex]) || !this.lattices[festivalIndex].element))) return [3, 2];
                        return [4, this.startLoading()];
                    case 1:
                        _a.sent();
                        p = Tool_1.Tool.getPositionByIndex(festivalIndex);
                        this.festivalTarget = new FestivalTarget_1.FestivalTarget(this.festivalTargetNum);
                        this.festivalTarget.x = 580;
                        this.festivalTarget.y = 115;
                        this.addChildAt(this.festivalTarget, 1);
                        this.festivalTarget.visible = false;
                        if (this.lattices[festivalIndex].element) {
                            this.lattices[festivalIndex].element.reset(ElementType_1.ElementType.FESTIVALELE_BIG);
                        }
                        else {
                            ele = Tool_1.Tool.getElement(ElementType_1.ElementType.FESTIVALELE_BIG);
                            ele.x = p[0];
                            ele.y = p[1];
                            this.elementContainer.addChild(ele);
                            this.lattices[festivalIndex].element = ele;
                            Tool_1.Tool.removeEle(festivalIndex, this.emptys);
                        }
                        ani = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.FESREDBOMBSHOW_ANI);
                        if (!ani)
                            ani = new FesRedBombShowAni_1.FesRedBombShowAni();
                        this.addChild(ani);
                        this.lattices[festivalIndex].element.visible = false;
                        ani.play(p, function () {
                            _this.lattices[festivalIndex].element.visible = true;
                            RectsWaveAni_1.RectsWaveAni(_this.lattices, _this.map);
                            if (_this.threeMatch()) {
                                _this.eliminate();
                            }
                            else {
                                _this.warningCop = Tool_1.Tool.dieMapCheck(_this.lattices);
                                if (!_this.warningCop) {
                                    _this.upsetElement();
                                }
                                else {
                                    _this.enableMouseEvt(true);
                                }
                            }
                        });
                        return [2, true];
                    case 2: return [2, false];
                }
            });
        });
    };
    PlayScene.prototype.updateScene = function () {
        this.propBtnCon.boomCount = Tools_1.Tools.propInfo.booms;
        this.propBtnCon.hammerCount = Tools_1.Tools.propInfo.hammers;
        this.propBtnCon.stepCount = Tools_1.Tools.propInfo.steps;
    };
    PlayScene.prototype.initEvents = function () {
        this.addEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
    };
    PlayScene.prototype.removeEvents = function () {
        this.removeEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
        this.propBtnCon.boomBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onTap_boomBtn, this);
        this.propBtnCon.hammerBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onTap_hammerBtn, this);
        this.propBtnCon.stepBtn.removeEventListener(FYGE.MouseEvent.CLICK, this.onTap_stepBtn, this);
        this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
        this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
    };
    PlayScene.prototype.onEnterFrame = function () {
        if (this.mouseEnable && !this.gameGuide) {
            this.noActionCount++;
        }
        else {
            this.noActionCount = 0;
        }
        if (this.noActionCount >= 6 * 60 && !this.isShowWarning) {
            this.noActionCount = 0;
            this.isShowWarning = true;
            this.warningAni();
        }
    };
    PlayScene.prototype.warningAni = function () {
        var a = this.warningCop[0];
        var b = this.warningCop[1];
        var ax = a.x;
        var ay = a.y;
        var bx = b.x;
        var by = b.y;
        FYGE.Tween.get(a, { loop: true })
            .to({ x: (bx - ax) / 10 + ax, y: (by - ay) / 10 + ay }, 100)
            .to({ x: ax, y: ay }, 100)
            .wait(200)
            .to({ x: (bx - ax) / 10 + ax, y: (by - ay) / 10 + ay }, 100)
            .to({ x: ax, y: ay }, 100)
            .wait(400);
        FYGE.Tween.get(b, { loop: true })
            .to({ x: (ax - bx) / 10 + bx, y: (ay - by) / 10 + by }, 100)
            .to({ x: bx, y: by }, 100)
            .wait(200)
            .to({ x: (ax - bx) / 10 + bx, y: (ay - by) / 10 + by }, 100)
            .to({ x: bx, y: by }, 100)
            .wait(400);
    };
    PlayScene.prototype.resetWarning = function () {
        if (!this.warningCop)
            return;
        FYGE.Tween.removeTweens(this.warningCop[0]);
        FYGE.Tween.removeTweens(this.warningCop[1]);
        var a = this.warningCop[0];
        var b = this.warningCop[1];
        var aIndex = a.index;
        var bIndex = b.index;
        var ap = Tool_1.Tool.getPositionByIndex(aIndex);
        var bp = Tool_1.Tool.getPositionByIndex(bIndex);
        a.x = ap[0];
        a.y = ap[1];
        b.x = bp[0];
        b.y = bp[1];
    };
    PlayScene.prototype.onTap_boomBtn = function () {
        this.propBtnCon.boomCount ?
            this.useProp(PropType_1.PropType.BOOMS) :
            ctrls_1.showToast('道具不足');
    };
    PlayScene.prototype.onTap_hammerBtn = function () {
        this.propBtnCon.hammerCount ?
            this.useProp(PropType_1.PropType.HAMMERS) :
            ctrls_1.showToast('道具不足');
    };
    PlayScene.prototype.onTap_stepBtn = function () {
        this.propBtnCon.stepCount ?
            this.useProp(PropType_1.PropType.STEPS) :
            ctrls_1.showToast('道具不足');
    };
    PlayScene.prototype.useProp = function (prop) {
        var _this = this;
        this.removeEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
        if (this.isShowWarning) {
            this.isShowWarning = false;
            this.resetWarning();
        }
        this.addChild(this.propGuide);
        this.propGuide.init(prop);
        if (prop == PropType_1.PropType.BOOMS || prop == PropType_1.PropType.HAMMERS) {
            this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
            this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
            if (this.SELECTED && this.choosed.parent) {
                this.choosed.parent.removeChild(this.choosed);
            }
            var fun_1;
            this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, fun_1 = function (e) {
                var ele = e.currentTarget.parent.parent;
                if (ele instanceof Element_1.Element &&
                    ele.type != ElementType_1.ElementType.LOLLIPOP) {
                    this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, fun_1, this);
                    var index = ele.index;
                    this.sendPropUse(prop, index);
                }
            }, this);
            this.propGuide.once(FYGE.MouseEvent.CLICK, function () {
                _this.removeChild(_this.propGuide);
                _this.elementContainer.removeEventListener(FYGE.MouseEvent.MOUSE_DOWN, fun_1, _this);
                _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.onEnterFrame, _this);
                _this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, _this.mouseDownE, _this);
                _this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, _this.mouseMoveE, _this);
            }, this);
        }
        else {
            if (!this.stepCircle) {
                this.stepCircle = new FYGE.Graphics()
                    .beginFill(0xff0000)
                    .drawCircle(BonusShootAni_1.stepPosition[0], BonusShootAni_1.stepPosition[1], 55)
                    .endFill()
                    .addEventListener(FYGE.MouseEvent.CLICK, function () {
                    _this.sendPropUse(PropType_1.PropType.STEPS);
                }, this);
                this.stepCircle.alpha = 0;
            }
            this.addChild(this.stepCircle);
            this.propGuide.once(FYGE.MouseEvent.CLICK, function () {
                _this.removeChild(_this.propGuide);
                _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.onEnterFrame, _this);
                if (_this.stepCircle.parent)
                    _this.removeChild(_this.stepCircle);
            }, this);
        }
    };
    PlayScene.prototype.sendPropUse = function (prop, index) {
        return __awaiter(this, void 0, void 0, function () {
            var s, rc, p, i, lat;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.propGuide.removeAllEventListener();
                        this.removeChild(this.propGuide);
                        ctrls_1.showWaiting();
                        return [4, Tools_1.Tools.consumerTools(prop)];
                    case 1:
                        s = _a.sent();
                        ctrls_1.hideWaiting();
                        this.addEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame, this);
                        if (prop == PropType_1.PropType.BOOMS || prop == PropType_1.PropType.HAMMERS) {
                            this.enableMouseEvt(false);
                            this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_DOWN, this.mouseDownE, this);
                            this.elementContainer.addEventListener(FYGE.MouseEvent.MOUSE_MOVE, this.mouseMoveE, this);
                        }
                        else {
                            this.removeChild(this.stepCircle);
                        }
                        if (s) {
                            switch (prop) {
                                case PropType_1.PropType.BOOMS:
                                    rc = Tool_1.Tool.indexToRc(index);
                                    p = Tool_1.Tool.getPositionByIndex(index);
                                    this.playAni(RecoverName_1.RecoverName.CROSS_ANI, p);
                                    for (i = 0; i < this.lattices.length; i++) {
                                        lat = this.lattices[i];
                                        if (Tool_1.Tool.judgeEliminate(lat) && (lat.row == rc[0] || lat.column == rc[1])) {
                                            if (this.eliminatedElements.indexOf(i) == -1) {
                                                this.eliminatedElements.push(i);
                                                if (Tool_1.Tool.judgeHasScore(lat.element)) {
                                                    this.pushScoreAni(exports.baseScore * exports.effectBaseTimes.LL, Tool_1.Tool.getPositionByIndex(i));
                                                }
                                            }
                                        }
                                    }
                                    setTimeout(function () {
                                        _this.eliminate();
                                    }, 200);
                                    this.isMouseAction = true;
                                    break;
                                case PropType_1.PropType.HAMMERS:
                                    this.eliminatedElements.push(index);
                                    if (Tool_1.Tool.judgeHasScore(this.lattices[index].element)) {
                                        this.pushScoreAni(exports.baseScore * (exports.effectBaseTimes[this.lattices[index].element.effectType] || 1), Tool_1.Tool.getPositionByIndex(index));
                                    }
                                    this.eliminate();
                                    this.isMouseAction = true;
                                    break;
                                case PropType_1.PropType.STEPS:
                                    this.playAni(RecoverName_1.RecoverName.STEP_ANI, [BonusShootAni_1.stepPosition[0] - 40, BonusShootAni_1.stepPosition[1] + 20]);
                                    setTimeout(function () {
                                        _this.steps += 5;
                                    }, 333);
                                    break;
                            }
                            this.updateScene();
                        }
                        else {
                            this.enableMouseEvt(true);
                        }
                        return [2];
                }
            });
        });
    };
    PlayScene.prototype.mouseDownE = function (e) {
        var ele = e.currentTarget.parent.parent;
        var self = this;
        if (ele && ele instanceof Element_1.Element) {
            this.isShowWarning = false;
            this.noActionCount = 0;
            this.resetWarning();
            if (!Tool_1.Tool.judgeChosen(ele))
                return;
            if (self.SELECTED && Tool_1.Tool.checkNeb(ele, self.SELECTED)) {
                self.exchangeElementAni(self.SELECTED, ele, self.callbackEx);
                self.SELECTED.removeChild(self.choosed);
                self.SELECTED = null;
            }
            else {
                self.SELECTED = ele;
                if (self.SELECTED.effectType == EffectType_1.EffectType.MAGICLION) {
                    self.elementContainer.addChildAt(self.SELECTED, 0);
                }
                else {
                    self.elementContainer.addChild(self.SELECTED);
                }
                self.SELECTED.addChild(self.choosed);
            }
        }
    };
    PlayScene.prototype.mouseMoveE = function (e) {
        if (this.SELECTED && e.currentTarget.parent.parent instanceof Element_1.Element) {
            var ele = e.currentTarget.parent.parent;
            if (!Tool_1.Tool.judgeChosen(ele))
                return;
            if (Tool_1.Tool.checkNeb(ele, this.SELECTED)) {
                this.exchangeElementAni(this.SELECTED, ele, this.callbackEx);
                this.SELECTED.removeChild(this.choosed);
                this.SELECTED = null;
            }
        }
    };
    PlayScene.prototype.callbackEx = function (s, o) {
        this.exchangeData(s, o);
        if (this.simpleMatch(s, o)) {
            this.isMouseAction = true;
            if (this.gameGuide)
                this.gameGuide.hideSelf();
            this.steps--;
            this.oneStepScore = 0;
            this.eliminate();
            var aarr = [s, o];
            for (var i = 0; i < aarr.length; i++) {
                var ele = aarr[i];
                if (ele.type == ElementType_1.ElementType.LOLLIPOP && this.recycleIndexs.indexOf(ele.index) > -1) {
                    this.recoverEle(ele.index);
                    this.lollipopCount--;
                    if (this.passElements &&
                        this.passElements[ElementType_1.ElementType.LOLLIPOP] &&
                        this.lollipopCount < this.passElements[ElementType_1.ElementType.LOLLIPOP]) {
                        this.lollipopMark = true;
                    }
                }
            }
        }
        else {
            this.exchangeData(s, o);
            this.exchangeElementAni(s, o);
        }
    };
    PlayScene.prototype.exchangeElementAni = function (s, o, callback) {
        var _this = this;
        this.enableMouseEvt(false);
        FYGE.Tween.get(s)
            .to({ x: o.x, y: o.y }, 166)
            .call(function () {
            if (callback) {
                callback.bind(_this)(s, o);
            }
            else {
                _this.enableMouseEvt(true);
            }
        });
        FYGE.Tween.get(o)
            .to({ x: s.x, y: s.y }, 166);
    };
    PlayScene.prototype.exchangeData = function (a, b) {
        var latA = this.lattices[a.index];
        var latB = this.lattices[b.index];
        latA.element = b;
        latB.element = a;
    };
    PlayScene.prototype.fall = function (callback) {
        var _this = this;
        Tool_1.Tool.removeReapty(this.emptys);
        if (Tool_1.Tool.judgeOutOne(this.emptys, this.lattices)) {
            var anis = this.fallVerticalEx();
            if (!anis.length) {
                anis = this.fallSkewEx();
                if (!anis.length) {
                    callback();
                }
                else {
                    this.fallAniSuper(anis, function () {
                        _this.fall(callback);
                    });
                }
            }
            else {
                this.fallAniSuper(anis, function () {
                    _this.fall(callback);
                }, true);
            }
        }
        else {
            var anis = this.fallVertical();
            anis = anis.concat(this.fallSkewEx());
            if (!anis.length) {
                callback();
            }
            else {
                this.fallAniSuper(anis, function () {
                    _this.fall(callback);
                });
            }
        }
    };
    PlayScene.prototype.fallVertical = function () {
        var anis = [];
        for (var m = 0; m < Tool_1.Tool.colNum; m++) {
            for (var n = Tool_1.Tool.rowNum - 1; n >= 0; n--) {
                var index = Tool_1.Tool.rcToIndex(n, m);
                var lat = this.lattices[index];
                if (Tool_1.Tool.judgeFall(lat)) {
                    var latDown, indexDown, connects = [];
                    if (lat.down != null) {
                        latDown = this.lattices[lat.down];
                        indexDown = lat.down;
                        connects.push({ index: indexDown, type: FallAniData_1.FallType.THROUGH });
                    }
                    else {
                        latDown = this.lattices[index + Tool_1.Tool.colNum];
                        indexDown = index + Tool_1.Tool.colNum;
                        connects.push({ index: indexDown, type: FallAniData_1.FallType.STRIGHT });
                    }
                    var emptyIndex = this.emptys.indexOf(indexDown);
                    if (emptyIndex > -1) {
                        anis.push({ ele: lat.element, indexs: connects });
                        this.emptys.splice(emptyIndex, 1);
                        this.emptys.push(index);
                        lat.element = null;
                    }
                }
                else {
                    if (lat &&
                        !lat.element &&
                        lat.isGenerate &&
                        !Tool_1.Tool.judgeFall(this.lattices[index - Tool_1.Tool.colNum])) {
                        anis.push({ ele: null, indexs: [{ index: index, type: FallAniData_1.FallType.STRIGHT }] });
                        Tool_1.Tool.removeEle(index, this.emptys);
                    }
                }
            }
        }
        return anis;
    };
    PlayScene.prototype.fallVerticalEx = function () {
        var _this = this;
        var anis = [];
        var operation = function (m) {
            for (var n = Tool_1.Tool.rowNum - 1; n >= 0; n--) {
                var index = Tool_1.Tool.rcToIndex(n, m);
                var lat = _this.lattices[index];
                if (Tool_1.Tool.judgeFall(lat)) {
                    var indexs = Tool_1.Tool.findBottom(lat, _this.emptys, _this.lattices);
                    if (indexs != null) {
                        var downIndex = indexs[indexs.length - 1].index;
                        anis.push({ ele: lat.element, indexs: indexs });
                        Tool_1.Tool.removeEle(downIndex, _this.emptys);
                        _this.emptys.push(index);
                        lat.element = null;
                    }
                }
                else {
                }
            }
            if (_this.generateIndexs[m]) {
                for (var aaa = 0; aaa < _this.generateIndexs[m].length; aaa++) {
                    var index = _this.generateIndexs[m][aaa].index;
                    var lat = _this.lattices[index];
                    if (lat && !lat.element && lat.isGenerate) {
                        var downIndex = index;
                        var type = FallAniData_1.FallType.STRIGHT;
                        var connects = [];
                        var anisOther = [];
                        while (_this.emptys.indexOf(downIndex) > -1) {
                            connects.push({
                                index: downIndex,
                                type: type,
                            });
                            anis.push({
                                ele: null,
                                indexs: connects.slice()
                            });
                            Tool_1.Tool.removeEle(downIndex, _this.emptys);
                            if (_this.lattices[downIndex].down != null) {
                                downIndex = _this.lattices[downIndex].down;
                                type = FallAniData_1.FallType.THROUGH;
                            }
                            else {
                                downIndex += Tool_1.Tool.colNum;
                                type = FallAniData_1.FallType.STRIGHT;
                            }
                        }
                        var len = anis.length;
                        for (var i = len - 1; i >= len - connects.length; i--) {
                            anis[i].wait = (len - 1 - i) * Tool_1.Tool.latDeltaTime * 2 / 3;
                        }
                    }
                }
            }
        };
        if (this.connectState == 1) {
            for (var m = Tool_1.Tool.colNum; m >= 0; m--)
                operation(m);
        }
        else if (this.connectState == 2) {
            for (var m = 0; m < Tool_1.Tool.colNum; m++)
                operation(m);
        }
        else if (this.connectState == 3) {
            for (var m = Tool_1.Tool.colNum; m >= 0; m--)
                operation(m);
            for (var m = 0; m < Tool_1.Tool.colNum; m++)
                operation(m);
        }
        else if (this.connectState == 4) {
            for (var m = 0; m < Tool_1.Tool.colNum; m++)
                operation(m);
            for (var m = Tool_1.Tool.colNum; m >= 0; m--)
                operation(m);
        }
        return anis;
    };
    PlayScene.prototype.fallSkewEx = function () {
        var _this = this;
        var anis = [];
        var emptys = this.emptys;
        emptys.sort(function (a, b) {
            return a < b ? 1 : -1;
        });
        var _loop_1 = function (i) {
            var indexMy = emptys[i];
            var lat = this_1.lattices[indexMy];
            var latFall;
            var indexFall;
            var type = FallAniData_1.FallType.STRIGHT;
            if (lat.up) {
                var latUnUp = this_1.lattices[lat.up];
                if (Tool_1.Tool.judgeFall(latUnUp)) {
                    latFall = latUnUp;
                    indexFall = lat.up;
                    type = FallAniData_1.FallType.THROUGH;
                }
            }
            if (!latFall && Tool_1.Tool.indexToRc(indexMy)[0] != 0) {
                var latUp = this_1.lattices[indexMy - Tool_1.Tool.colNum];
                if (Tool_1.Tool.judgeFall(latUp)) {
                    latFall = latUp;
                    indexFall = indexMy - Tool_1.Tool.colNum;
                }
            }
            var findLeft = function () {
                if (!latFall && Tool_1.Tool.indexToRc(indexMy)[1] != 0) {
                    var latLeftUp = _this.lattices[indexMy - Tool_1.Tool.colNum - 1];
                    if (Tool_1.Tool.judgeFall(latLeftUp)) {
                        latFall = latLeftUp;
                        indexFall = indexMy - Tool_1.Tool.colNum - 1;
                    }
                }
            };
            var findRight = function () {
                if (!latFall && Tool_1.Tool.indexToRc(indexMy)[1] != Tool_1.Tool.colNum - 1) {
                    var latRightUp = _this.lattices[indexMy - Tool_1.Tool.colNum + 1];
                    if (Tool_1.Tool.judgeFall(latRightUp)) {
                        latFall = latRightUp;
                        indexFall = indexMy - Tool_1.Tool.colNum + 1;
                    }
                }
            };
            if (Math.random() > 0.5) {
                findLeft();
                findRight();
            }
            else {
                findRight();
                findLeft();
            }
            if (latFall) {
                anis.push({ ele: latFall.element, indexs: [{ index: indexMy, type: type }] });
                emptys.splice(i, 1);
                emptys.splice(i + 1, 0, indexFall);
                latFall.element = null;
                i--;
            }
            else {
                if (lat.isGenerate) {
                    anis.push({ ele: null, indexs: [{ index: indexMy, type: FallAniData_1.FallType.STRIGHT }] });
                    emptys.splice(i, 1);
                    i--;
                }
            }
            out_i_1 = i;
        };
        var this_1 = this, out_i_1;
        for (var i = 0; i < emptys.length; i++) {
            _loop_1(i);
            i = out_i_1;
        }
        return anis;
    };
    PlayScene.prototype.fallAniSuper = function (anis, callback, isVertical) {
        var _this = this;
        if (isVertical === void 0) { isVertical = false; }
        var deltaTime = Tool_1.Tool.latDeltaTime;
        if (isVertical) {
            deltaTime = Tool_1.Tool.latDeltaTime * 2 / 3;
        }
        var count = 0;
        var countAll = anis.length;
        var _loop_2 = function (i) {
            var ani = anis[i];
            var ele = ani.ele;
            var wait_1 = ani.wait || 0;
            var indexs = ani.indexs;
            var oriRow = void 0;
            var oriCol = void 0;
            var endIndex = indexs[indexs.length - 1].index;
            var tween = void 0;
            if (!ele) {
                var firstIndex = indexs.shift();
                ele = this_2.createELement(firstIndex.index);
                this_2.elementContainer.addChild(ele);
                oriRow = Tool_1.Tool.indexToRc(firstIndex.index)[0];
                var fp = Tool_1.Tool.getPositionByIndex(firstIndex.index);
                ele.x = fp[0];
                ele.y = fp[1] - Tool_1.Tool.height;
                tween = FYGE.Tween.get(ele);
                if (wait_1)
                    tween.wait(wait_1);
                if (this_2.lattices[firstIndex.index - Tool_1.Tool.colNum]) {
                    var mask_1 = Tool_1.Tool.getRectMask();
                    mask_1.x = fp[0];
                    mask_1.y = fp[1];
                    this_2.elementContainer.addChild(mask_1);
                    ele.mask = mask_1;
                    tween.to({ x: fp[0], y: fp[1] }, deltaTime)
                        .call(function () {
                        ele.mask = null;
                        mask_1.recover();
                    });
                }
                else {
                    tween.to({ x: fp[0], y: fp[1] }, deltaTime);
                }
                wait_1 += deltaTime;
            }
            else {
                oriRow = ele.row;
                tween = FYGE.Tween.get(ele);
            }
            var lastX = void 0, lastY = void 0;
            for (var j = 0; j < indexs.length; j++) {
                var index = indexs[j].index;
                var type = indexs[j].type;
                var p = Tool_1.Tool.getPositionByIndex(index);
                if (type == FallAniData_1.FallType.THROUGH) {
                    var indexUp = this_2.lattices[index].up;
                    var downPos = Tool_1.Tool.getPositionByIndex(index);
                    var upPos = Tool_1.Tool.getPositionByIndex(indexUp);
                    if (this_2.lattices[indexUp + Tool_1.Tool.colNum]) {
                        EleMaskAni_1.EleMaskAni(ele, upPos, wait_1, this_2.elementContainer, true, deltaTime);
                        tween.set({ alpha: 0 })
                            .wait(deltaTime)
                            .set({ alpha: 1 });
                    }
                    else {
                        tween.to({ x: upPos[0], y: upPos[1] + Tool_1.Tool.height }, deltaTime);
                    }
                    if (this_2.lattices[index - Tool_1.Tool.colNum]) {
                        EleMaskAni_1.EleMaskAni(ele, downPos, wait_1, this_2.elementContainer, false, deltaTime);
                    }
                    else {
                        EleDownAni_1.EleDownAni(ele, downPos, wait_1, this_2.elementContainer, false, deltaTime);
                    }
                    oriRow = Tool_1.Tool.indexToRc(index)[0];
                    lastX = downPos[0];
                    lastY = downPos[1];
                    wait_1 += deltaTime;
                }
                else {
                    var delta = Tool_1.Tool.indexToRc(index)[0] - oriRow;
                    if (delta > 0) {
                        oriRow = Tool_1.Tool.indexToRc(index)[0];
                        if (lastX != null) {
                            tween.set({ x: lastX, y: lastY });
                        }
                        tween.to({ x: p[0], y: p[1] }, delta * deltaTime);
                        wait_1 += delta * deltaTime;
                        lastX = null;
                    }
                }
            }
            var showFallAni = (function () {
                return false;
            })();
            var lat = this_2.lattices[endIndex];
            lat.element = ele;
            tween.call(function () {
                var endP = Tool_1.Tool.getPositionByIndex(endIndex);
                ele.x = endP[0];
                ele.y = endP[1];
                if (ele.type == ElementType_1.ElementType.LOLLIPOP && _this.recycleIndexs.indexOf(endIndex) > -1) {
                    _this.recoverEle(endIndex);
                    _this.lollipopCount--;
                    if (_this.passElements &&
                        _this.passElements[ElementType_1.ElementType.LOLLIPOP] &&
                        _this.lollipopCount < _this.passElements[ElementType_1.ElementType.LOLLIPOP]) {
                        _this.lollipopMark = true;
                    }
                }
                else if (showFallAni) {
                    ele.fallAni();
                }
                if (++count == countAll)
                    callback();
            });
        };
        var this_2 = this;
        for (var i = anis.length - 1; i >= 0; i--) {
            _loop_2(i);
        }
    };
    PlayScene.prototype.createELement = function (index) {
        var type;
        var effectType = null;
        if (this.lollipopMark) {
            this.lollipopMark = false;
            type = ElementType_1.ElementType.LOLLIPOP;
            this.lollipopCount++;
        }
        else {
            var baseElementTypes = this.chapterData.baseElementTypes.slice();
            var col = Tool_1.Tool.indexToRc(index)[1];
            var data = this.generateIndexs[col].filter(function (d) {
                return d.index == index;
            })[0];
            if (data) {
                var one = data.cus.shift();
                if (one) {
                    var oneData = Tool_1.Tool.praseEleNumber(one);
                    type = oneData[0] === null ? Tool_1.Tool.randomT(baseElementTypes) : oneData[0];
                    effectType = oneData[1];
                }
                else {
                    if (!data.type || !data.type.length) {
                        type = Tool_1.Tool.randomT(baseElementTypes);
                    }
                    else {
                        var code = Tool_1.Tool.randomT(data.type);
                        if (code) {
                            var codeData = Tool_1.Tool.praseEleNumber(code);
                            type = codeData[0] === null ? Tool_1.Tool.randomT(baseElementTypes) : codeData[0];
                            effectType = codeData[1];
                        }
                        else {
                            type = Tool_1.Tool.randomT(baseElementTypes);
                        }
                    }
                }
            }
            else {
                type = Tool_1.Tool.randomT(baseElementTypes);
            }
        }
        var ele = Tool_1.Tool.getElement(type);
        if (!this.hasPassed)
            ele.effectType = effectType;
        if (type != ElementType_1.ElementType.LOLLIPOP &&
            effectType == null &&
            this.chapterData.bubbleProbability &&
            Math.random() < this.chapterData.bubbleProbability) {
            ele.setState(StateType_1.StateType.BUBBLE, true, type);
        }
        return ele;
    };
    PlayScene.prototype.simpleMatch = function (s, o) {
        if (s.effectType != null && o.effectType != null) {
            this.isManual = true;
            this.eliminatedElements.push(s.index, o.index);
            this.effectContinuityTimes++;
            return true;
        }
        if (s.effectType == EffectType_1.EffectType.MAGICLION || o.effectType == EffectType_1.EffectType.MAGICLION) {
            if (s.type == ElementType_1.ElementType.LOLLIPOP || o.type == ElementType_1.ElementType.LOLLIPOP) {
                return false;
            }
            else {
                this.isManual = true;
                this.eliminatedElements.push(s.index, o.index);
                this.effectContinuityTimes++;
                return true;
            }
        }
        return this.threeMatch(s, o);
    };
    PlayScene.prototype.threeMatch = function (s, o) {
        for (var i = 0; i < Tool_1.Tool.rowNum; i++) {
            var arr = [];
            for (var g = 0; g < Tool_1.Tool.colNum; g++) {
                arr.push(i * Tool_1.Tool.colNum + g);
            }
            var re = Tool_1.Tool.fn(arr, this.lattices);
            for (var j = 0; j < re.length; j++) {
                var len = re[j].length;
                if (len >= 3) {
                    for (var k = 0; k < len; k++) {
                        var ele = this.lattices[re[j][k]].element;
                        this.eliminatedElements.push(re[j][k]);
                        if (len >= 5) {
                            if (k == 2) {
                                ele.temEffectType = EffectType_1.EffectType.MAGICLION;
                                this.elementContainer.addChildAt(ele, 0);
                            }
                        }
                        else if (len == 4) {
                            if ([s, o].indexOf(ele) > -1) {
                                ele.temEffectType = EffectType_1.EffectType.VERTICAL;
                            }
                            else if (!s && k == 2) {
                                ele.temEffectType = EffectType_1.EffectType.VERTICAL;
                            }
                        }
                    }
                }
            }
        }
        for (var m = 0; m < Tool_1.Tool.colNum; m++) {
            var arr = [];
            for (var g = 0; g < Tool_1.Tool.rowNum; g++) {
                arr.push(Tool_1.Tool.colNum * g + m);
            }
            var re = Tool_1.Tool.fn(arr, this.lattices);
            for (var j = 0; j < re.length; j++) {
                var len = re[j].length;
                if (len >= 3) {
                    for (var k = 0; k < len; k++) {
                        var ele = this.lattices[re[j][k]].element;
                        if (len >= 5) {
                            if (k == 2) {
                                if (ele.temEffectType != EffectType_1.EffectType.MAGICLION) {
                                    ele.temEffectType = EffectType_1.EffectType.MAGICLION;
                                    this.elementContainer.addChildAt(ele, 0);
                                    if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                        this.eliminatedElements.push(re[j][k]);
                                    }
                                }
                            }
                            else {
                                if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                    this.eliminatedElements.push(re[j][k]);
                                }
                                else {
                                    if (ele.temEffectType != EffectType_1.EffectType.MAGICLION)
                                        ele.temEffectType = EffectType_1.EffectType.EXPLOSIVE;
                                }
                            }
                        }
                        else if (len == 4) {
                            if ([s, o].indexOf(ele) > -1) {
                                ele.temEffectType = EffectType_1.EffectType.HORIZONTAL;
                            }
                            else if (!s && k == 2) {
                                ele.temEffectType = EffectType_1.EffectType.HORIZONTAL;
                            }
                            if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                this.eliminatedElements.push(re[j][k]);
                            }
                            else {
                                if (ele.temEffectType != EffectType_1.EffectType.MAGICLION)
                                    ele.temEffectType = EffectType_1.EffectType.EXPLOSIVE;
                            }
                        }
                        else {
                            if (this.eliminatedElements.indexOf(re[j][k]) == -1) {
                                this.eliminatedElements.push(re[j][k]);
                            }
                            else {
                                if (ele.temEffectType != EffectType_1.EffectType.MAGICLION)
                                    ele.temEffectType = EffectType_1.EffectType.EXPLOSIVE;
                            }
                        }
                    }
                }
            }
        }
        if (this.eliminatedElements.length && !this.hasPassed)
            this.commonContinuityTimes++;
        for (var aa = 0; aa < this.eliminatedElements.length; aa++) {
            var index = this.eliminatedElements[aa];
            if (Tool_1.Tool.judgeHasScore(this.lattices[index].element)) {
                this.pushScoreAni(exports.baseScore * this.commonContinuityTimes, Tool_1.Tool.getPositionByIndex(index));
            }
        }
        return this.eliminatedElements.length > 0;
    };
    PlayScene.prototype.eliminate = function () {
        var _this = this;
        if (this.isManual) {
            this.isManual = false;
            this.effectCombination();
        }
        else {
            this.rotateEliminate();
            var effectIndexs = this.commonEliminate();
            var scoreAll = 0;
            for (var i = 0; i < this.scoreAnis.length; i++) {
                var scoreAni = this.scoreAnis[i];
                scoreAll += scoreAni.score;
            }
            this.scoreAnis.length = 0;
            this.score += scoreAll;
            this.oneStepScore += scoreAll;
            this.effectEliminate(effectIndexs);
        }
        if (this.eliminatedElements.length) {
            setTimeout(function () {
                _this.eliminate();
            }, 200);
        }
        else {
            setTimeout(function () {
                _this.fall(function () {
                    _this.fallCallback();
                });
            }, 200);
        }
    };
    PlayScene.prototype.fallCallback = function () {
        var _this = this;
        if (this.threeMatch()) {
            this.eliminate();
            return;
        }
        AiControl_1.AiControl.ins.doorMotion(this, function () {
            AiControl_1.AiControl.ins.eggMotion(_this, function () {
                AiControl_1.AiControl.ins.hairballMotion(_this, function () {
                    AiControl_1.AiControl.ins.fesEleMotion(_this, function () {
                        if (_this.hasPassed) {
                            if (!_this.isCountingTime) {
                                _this.terminateSteps();
                            }
                            else {
                                _this.submit();
                            }
                            return;
                        }
                        _this.hasPassed = _this.judgePass();
                        if (_this.hasPassed) {
                            _this.commonContinuityTimes = 1;
                            _this.effectContinuityTimes = 1;
                            _this.addChild(movieClips.bonusTime);
                            movieClips.bonusTime.play(1, function () {
                                _this.removeChild(movieClips.bonusTime);
                                RectsWaveAni_1.RectsWaveAni(_this.lattices, _this.map, function () {
                                    _this.terminateSteps();
                                });
                            });
                            return;
                        }
                        _this.oneStepScoreToast();
                        _this.commonContinuityTimes = 0;
                        _this.effectContinuityTimes = 0;
                        if (_this.steps == 0) {
                            if (!_this.addedStepWarning && !!Tools_1.Tools.propInfo.steps) {
                                _this.addedStepWarning = true;
                                ctrls_1.showPanel(NoStepPanel_1.NoStepPanel, {
                                    reviveFun: function () { return __awaiter(_this, void 0, void 0, function () {
                                        var s, count_1, countAll_1;
                                        var _this = this;
                                        return __generator(this, function (_a) {
                                            switch (_a.label) {
                                                case 0:
                                                    ctrls_1.showWaiting();
                                                    return [4, Tools_1.Tools.consumerTools(PropType_1.PropType.STEPS)];
                                                case 1:
                                                    s = _a.sent();
                                                    ctrls_1.hideWaiting();
                                                    if (!s) {
                                                        this.submit(false);
                                                    }
                                                    else {
                                                        count_1 = 0;
                                                        countAll_1 = 2;
                                                        AiControl_1.AiControl.ins.jellyMotion(this, function () {
                                                            if (++count_1 === countAll_1)
                                                                _this.aiMotionCheckDieMap();
                                                        });
                                                        AiControl_1.AiControl.ins.bubbleMotion(this, function () {
                                                            if (++count_1 === countAll_1)
                                                                _this.aiMotionCheckDieMap();
                                                        });
                                                        this.playAni(RecoverName_1.RecoverName.STEP_ANI, [BonusShootAni_1.stepPosition[0] - 40, BonusShootAni_1.stepPosition[1] + 20]);
                                                        setTimeout(function () {
                                                            _this.steps += 5;
                                                        }, 333);
                                                        this.updateScene();
                                                    }
                                                    return [2];
                                            }
                                        });
                                    }); }
                                });
                            }
                            else {
                                _this.submit(false);
                            }
                            return;
                        }
                        var count = 0;
                        var countAll = 2;
                        AiControl_1.AiControl.ins.jellyMotion(_this, function () {
                            if (++count === countAll)
                                _this.aiMotionCheckDieMap();
                        });
                        AiControl_1.AiControl.ins.bubbleMotion(_this, function () {
                            if (++count === countAll)
                                _this.aiMotionCheckDieMap();
                        });
                    });
                });
            });
        });
    };
    PlayScene.prototype.aiMotionCheckDieMap = function () {
        var _this = this;
        this.warningCop = Tool_1.Tool.dieMapCheck(this.lattices);
        if (!this.warningCop) {
            if (Tool_1.Tool.alreadyDie(this.lattices)) {
                ctrls_1.showToast("元素已无法消除");
                setTimeout(function () {
                    _this.submit(false);
                }, 1000);
            }
            else {
                ctrls_1.showToast("没有可以消除的元素");
                setTimeout(function () {
                    _this.upsetElement();
                }, 1000);
            }
        }
        else {
            if (this.gameGuide) {
                this.addChild(this.gameGuide);
                this.gameGuide.show();
            }
            this.enableMouseEvt(true);
            this.openRedBombPanel();
        }
    };
    PlayScene.prototype.effectCombination = function () {
        var one = this.eliminatedElements[0];
        var two = this.eliminatedElements[1];
        var lat1 = this.lattices[one];
        var lat2 = this.lattices[two];
        var ele1 = this.lattices[one].element;
        var ele2 = this.lattices[two].element;
        this.eliminatedElements = [];
        if (ele1.effectType == EffectType_1.EffectType.MAGICLION &&
            ele2.effectType == EffectType_1.EffectType.MAGICLION) {
            this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, Tool_1.Tool.getPositionByIndex(one));
            this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, Tool_1.Tool.getPositionByIndex(two));
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.MM, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if ((ele1.effectType == EffectType_1.EffectType.MAGICLION || ele2.effectType == EffectType_1.EffectType.MAGICLION)) {
            var magic = void 0, other = void 0;
            var magicIndex = void 0;
            if (ele1.effectType == EffectType_1.EffectType.MAGICLION) {
                magic = ele1;
                other = ele2;
                magicIndex = one;
            }
            else {
                magic = ele2;
                other = ele1;
                magicIndex = two;
            }
            this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, Tool_1.Tool.getPositionByIndex(magicIndex));
            this.recoverEle(magicIndex);
            var rotateData = {
                p: Tool_1.Tool.getPositionByIndex(magicIndex),
                elementsIndex: [],
                type: other.type,
            };
            this.magicRotateData = [rotateData];
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeMagicEliminate(lat) &&
                    lat.element.type == other.type) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (other.effectType != null) {
                        if (other.effectType == EffectType_1.EffectType.EXPLOSIVE) {
                            lat.element.effectType = EffectType_1.EffectType.EXPLOSIVE;
                        }
                        else {
                            lat.element.effectType = Math.random() > 0.5 ? EffectType_1.EffectType.HORIZONTAL : EffectType_1.EffectType.VERTICAL;
                        }
                    }
                    else {
                        if (Tool_1.Tool.judgeMagicRotate(lat.element)) {
                            rotateData.elementsIndex.push(i);
                        }
                    }
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["3"], Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if (ele1.effectType < 2 && ele2.effectType < 2) {
            var p = Tool_1.Tool.getPositionByIndex(one);
            this.playAni(RecoverName_1.RecoverName.CROSS_ANI, p);
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat) && (lat.row == lat1.row || lat.column == lat1.column)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.LL, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if ((ele1.effectType < 2 || ele2.effectType < 2) &&
            (ele1.effectType == EffectType_1.EffectType.EXPLOSIVE || ele2.effectType == EffectType_1.EffectType.EXPLOSIVE)) {
            var p = Tool_1.Tool.getPositionByIndex(one);
            this.playAni(RecoverName_1.RecoverName.THREECROSS_ANI, p);
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat) &&
                    (Math.abs(lat.row - lat1.row) < 2 || Math.abs(lat.column - lat1.column) < 2)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.EL, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
        else if (ele1.effectType == EffectType_1.EffectType.EXPLOSIVE && ele2.effectType == EffectType_1.EffectType.EXPLOSIVE) {
            var p = Tool_1.Tool.getPositionByIndex(one);
            var boomAni = this.playAni(RecoverName_1.RecoverName.BOOM_ANI, p);
            boomAni.scaleX = boomAni.scaleY = 2;
            this.recoverEle(one);
            this.recoverEle(two);
            for (var i = 0; i < this.lattices.length; i++) {
                var lat = this.lattices[i];
                if (Tool_1.Tool.judgeEliminate(lat) &&
                    (Math.abs(lat.row - lat1.row) < 3 && Math.abs(lat.column - lat1.column) < 3)) {
                    if (this.eliminatedElements.indexOf(i) == -1)
                        this.eliminatedElements.push(i);
                    if (Tool_1.Tool.judgeHasScore(lat.element)) {
                        this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes.EE, Tool_1.Tool.getPositionByIndex(i));
                    }
                }
            }
        }
    };
    PlayScene.prototype.rotateEliminate = function () {
        for (var m = 0; m < this.magicRotateData.length; m++) {
            var indexs = this.magicRotateData[m].elementsIndex;
            var position = this.magicRotateData[m].p;
            for (var n = 0; n < indexs.length; n++) {
                var roIndex = indexs[n];
                var roEle = this.lattices[roIndex].element;
                if (this.lattices[roIndex].element.temEffectType != null)
                    continue;
                MagicRotateAni_1.MagicRotateAni(roEle, position, this);
                this.recoverEle(roIndex);
                Tool_1.Tool.removeEle(roIndex, this.eliminatedElements);
            }
        }
        this.magicRotateData.length = 0;
    };
    PlayScene.prototype.commonEliminate = function () {
        var effectIndexs = [];
        for (var i = this.eliminatedElements.length - 1; i >= 0; i--) {
            var index = this.eliminatedElements[i];
            var lat = this.lattices[index];
            var ele = lat.element;
            var p = Tool_1.Tool.getPositionByIndex(index);
            if (!ele) {
            }
            else if (ele.hasState(StateType_1.StateType.LOCK)) {
                ele.setState(StateType_1.StateType.LOCK, false);
            }
            else if (ele.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
                var hairballBrownState = ele.getState(StateType_1.StateType.HAIRBALLBROWN);
                hairballBrownState.isActive = true;
            }
            else if (ele.hasState(StateType_1.StateType.HAIRBALLGREY)) {
                this.playAni(RecoverName_1.RecoverName.HAIRBALLGREYDIS_ANI, p);
                ele.setState(StateType_1.StateType.HAIRBALLGREY, false);
                this.goElementTarget(ElementType_1.ElementType.HAIRBALLGREY, [ele.x, ele.y]);
            }
            else if (ele.hasState(StateType_1.StateType.HAIRBALLGREY)) {
                var blackballBrownState = ele.getState(StateType_1.StateType.HAIRBALLBLACK);
                if (blackballBrownState.isAwake) {
                    blackballBrownState.isAwake = false;
                }
                else {
                    this.playAni(RecoverName_1.RecoverName.HAIRBALLBLACKDIS_ANI, p);
                    ele.setState(StateType_1.StateType.HAIRBALLBLACK, false);
                    this.goElementTarget(ElementType_1.ElementType.HAIRBALLBLACK, [ele.x, ele.y]);
                }
            }
            else if (ele.effectType != null) {
                effectIndexs.push(index);
            }
            else {
                if (ele.temEffectType != null) {
                    ele.effectType = ele.temEffectType;
                    ele.temEffectType = null;
                    if (ele.hasState(StateType_1.StateType.BUBBLE)) {
                        ele.setState(StateType_1.StateType.BUBBLE, false);
                    }
                    this.goElementTarget(ele.type, [ele.x, ele.y]);
                    this.checkNebAll(this.lattices[index]);
                }
                else {
                    if (ElementType_1.FiveBaseElementTypes.indexOf(ele.type) >= 0) {
                        this.addChild(EleDisAni_1.EleDisAni(ele.type)).position.set(ele.x, ele.y);
                        this.recoverEle(index);
                    }
                    else if (ele.type == ElementType_1.ElementType.ROCK) {
                        this.removeRock(index);
                        this.goElementTarget(ele.type, [ele.x, ele.y]);
                    }
                    else if (ele.type == ElementType_1.ElementType.JELLY) {
                        this.removeJelly(index);
                        this.goElementTarget(ele.type, [ele.x, ele.y]);
                    }
                    else if (ele.type == ElementType_1.ElementType.CHICKEN_EGG) {
                        ele.chickenEgg.statusNum--;
                        ele.chickenEgg.shakeAni();
                        this.playAni(RecoverName_1.RecoverName.EGGBROKEN_ANI, p);
                    }
                    else if (ele.type == ElementType_1.ElementType.FESTIVALELE_BIG) {
                        ele.festivalEle.statusNum--;
                    }
                    else if (ele.type == ElementType_1.ElementType.FESTIVALELE_SMALL) {
                        this.removeFestivalEleSmall(index);
                    }
                }
            }
            this.eliminatedElements.splice(i, 1);
        }
        return effectIndexs;
    };
    PlayScene.prototype.effectEliminate = function (effectIndexs) {
        var _this = this;
        if (effectIndexs.length && !this.hasPassed)
            this.effectContinuityTimes++;
        var judgeExclude = function (i) {
            return _this.eliminatedElements.indexOf(i) < 0 && effectIndexs.indexOf(i) < 0;
        };
        for (var j = 0; j < effectIndexs.length; j++) {
            var index = effectIndexs[j];
            var lat = this.lattices[index];
            var ele = lat.element;
            var p = Tool_1.Tool.getPositionByIndex(index);
            switch (ele.effectType) {
                case EffectType_1.EffectType.MAGICLION:
                    this.playAni(RecoverName_1.RecoverName.MAGICLION_ANI, p);
                    this.recoverEle(index);
                    var types = this.chapterData.baseElementTypes.slice();
                    for (var iii = 0; iii < this.magicRotateData.length; iii++) {
                        Tool_1.Tool.removeEle(this.magicRotateData[iii].type, types);
                    }
                    var type = types.length ? Tool_1.Tool.randomT(types) : Tool_1.Tool.randomT(this.chapterData.baseElementTypes);
                    var rotateData = {
                        p: Tool_1.Tool.getPositionByIndex(index),
                        elementsIndex: [],
                        type: type,
                    };
                    this.magicRotateData.push(rotateData);
                    for (var i = 0; i < this.lattices.length; i++) {
                        if (Tool_1.Tool.judgeMagicEliminate(this.lattices[i]) &&
                            this.lattices[i].element.type == type &&
                            judgeExclude(i)) {
                            this.eliminatedElements.push(i);
                            if (Tool_1.Tool.judgeMagicRotate(this.lattices[i].element)) {
                                rotateData.elementsIndex.push(i);
                            }
                            if (Tool_1.Tool.judgeHasScore(this.lattices[i].element)) {
                                this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["3"], Tool_1.Tool.getPositionByIndex(i));
                            }
                        }
                    }
                    break;
                case EffectType_1.EffectType.EXPLOSIVE:
                    var boomAni = this.playAni(RecoverName_1.RecoverName.BOOM_ANI, p);
                    boomAni.scaleX = boomAni.scaleY = 1;
                    this.recoverEle(index);
                    Tool_1.Tool.getExplosiveIndexes(lat, this.lattices).forEach(function (i) {
                        if (judgeExclude(i)) {
                            _this.eliminatedElements.push(i);
                            if (Tool_1.Tool.judgeHasScore(_this.lattices[i].element)) {
                                _this.pushScoreAni(exports.baseScore * _this.effectContinuityTimes * exports.effectBaseTimes["2"], Tool_1.Tool.getPositionByIndex(i));
                            }
                        }
                    });
                    break;
                case EffectType_1.EffectType.HORIZONTAL:
                    var row = lat.row;
                    this.playAni(RecoverName_1.RecoverName.HORIZONTAL_ANI, p);
                    this.recoverEle(index);
                    for (var i = 0; i < Tool_1.Tool.colNum; i++) {
                        var ein = Tool_1.Tool.rcToIndex(row, i);
                        if (Tool_1.Tool.judgeEliminate(this.lattices[ein]) &&
                            judgeExclude(ein)) {
                            this.eliminatedElements.push(ein);
                            if (Tool_1.Tool.judgeHasScore(this.lattices[ein].element)) {
                                this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["0"], Tool_1.Tool.getPositionByIndex(ein));
                            }
                        }
                    }
                    break;
                case EffectType_1.EffectType.VERTICAL:
                    var col = lat.column;
                    this.playAni(RecoverName_1.RecoverName.VERTICAL_ANI, p);
                    this.recoverEle(index);
                    for (var i = 0; i < Tool_1.Tool.rowNum; i++) {
                        var ein = Tool_1.Tool.rcToIndex(i, col);
                        if (Tool_1.Tool.judgeEliminate(this.lattices[ein]) &&
                            judgeExclude(ein)) {
                            this.eliminatedElements.push(ein);
                            if (Tool_1.Tool.judgeHasScore(this.lattices[ein].element)) {
                                this.pushScoreAni(exports.baseScore * this.effectContinuityTimes * exports.effectBaseTimes["1"], Tool_1.Tool.getPositionByIndex(ein));
                            }
                        }
                    }
                    break;
            }
        }
    };
    PlayScene.prototype.judgePass = function () {
        if (this.passElements) {
            for (var i = 0; i < this.passElements.length; i++) {
                if (this.passElements[i]) {
                    return false;
                }
            }
            return true;
        }
        else {
            return this.score > this.chapterData.passTarget.score;
        }
    };
    PlayScene.prototype.terminateSteps = function () {
        var _this = this;
        var effectElements = [], elements = [];
        for (var i = Tool_1.Tool.colNum * Tool_1.Tool.rowNum - 1; i >= 0; i--) {
            var lat = this.lattices[i];
            if (Tool_1.Tool.judgeBaseEle(lat)) {
                if (lat.element.effectType != null) {
                    effectElements.push(i);
                }
                else {
                    elements.push(lat.element);
                }
            }
        }
        if (effectElements.length) {
            Array.prototype.push.apply(this.eliminatedElements, effectElements);
            this.eliminate();
        }
        else {
            if (this.steps == 0 || elements.length == 0) {
                this.score += 1000 * this.steps;
                this.steps = 0;
                this.submit();
                return;
            }
            this.isCountingTime = true;
            var countAll_2 = Math.min(this.steps, elements.length);
            var count_2 = 0;
            var deltaCount = 0;
            var _loop_3 = function () {
                var rand = Math.floor(Math.random() * elements.length);
                var ele = elements.splice(rand, 1)[0];
                if (!ele)
                    return "break";
                deltaCount++;
                var bonusShootAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BONUSSHOOT_ANI);
                if (!bonusShootAni) {
                    bonusShootAni = new BonusShootAni_1.BonusShootAni();
                }
                setTimeout(function () {
                    _this.steps--;
                    _this.score += 1000;
                    _this.addChild(bonusShootAni);
                    bonusShootAni.play([ele.x, ele.y], function () {
                        ele.effectType = Math.random() > 0.5 ? EffectType_1.EffectType.HORIZONTAL : EffectType_1.EffectType.VERTICAL;
                        ele.removeAllState();
                        _this.eliminatedElements.push(ele.index);
                        _this.pushScoreAni(exports.baseScore * 1.5, [ele.x, ele.y]);
                        if (++count_2 == countAll_2) {
                            _this.eliminate();
                            if (_this.steps) {
                                _this.score += 1000 * _this.steps;
                                _this.steps = 0;
                            }
                        }
                    });
                }, 150 * deltaCount);
            };
            while (deltaCount < countAll_2) {
                var state_1 = _loop_3();
                if (state_1 === "break")
                    break;
            }
        }
    };
    PlayScene.prototype.pushScoreAni = function (score, p) {
        var scoreAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.SCORE_ANI);
        if (!scoreAni) {
            scoreAni = new ScoreAni_1.ScoreAni();
        }
        scoreAni.score = score;
        scoreAni.x = p[0];
        scoreAni.y = p[1];
        this.scoreAnis.push(scoreAni);
    };
    PlayScene.prototype.oneStepScoreToast = function () {
        var _this = this;
        var sv;
        if (this.oneStepScore > 5000) {
            sv = "wonderful";
        }
        else if (this.oneStepScore > 3000) {
            sv = "amazing";
        }
        else if (this.oneStepScore > 1000) {
            sv = "great";
        }
        if (sv && movieClips[sv]) {
            this.addChild(movieClips[sv]);
            movieClips[sv].play(1, function () {
                _this.removeChild(movieClips[sv]);
            });
        }
        this.oneStepScore = 0;
    };
    PlayScene.prototype.upsetElement = function () {
        var _this = this;
        var lats = [];
        var anis = [];
        for (var i = 0; i < this.lattices.length; i++) {
            var lat = this.lattices[i];
            if (Tool_1.Tool.judgeUpsetMove(lat))
                lats.push(lat);
        }
        var latsCopy = lats.slice();
        for (var i = 0; i < lats.length; i++) {
            var ele = lats[i].element;
            var rand = Math.floor(Math.random() * latsCopy.length);
            var lat = latsCopy.splice(rand, 1)[0];
            anis.push([ele, lat.index]);
        }
        var count = 0;
        var countAll = anis.length;
        for (var i = 0; i < countAll; i++) {
            var ele = anis[i][0];
            var index = anis[i][1];
            var p = Tool_1.Tool.getPositionByIndex(index);
            var lat = this.lattices[index];
            lat.element = ele;
            FYGE.Tween.get(ele)
                .to({ x: p[0], y: p[1] }, 500)
                .call(function () {
                if (++count == countAll) {
                    if (_this.threeMatch()) {
                        _this.eliminate();
                    }
                    else {
                        _this.warningCop = Tool_1.Tool.dieMapCheck(_this.lattices);
                        if (!_this.warningCop) {
                            _this.upsetElement();
                        }
                        else {
                            _this.enableMouseEvt(true);
                            _this.openRedBombPanel();
                        }
                    }
                }
            });
        }
    };
    PlayScene.prototype.recoverEle = function (index) {
        var ele = this.removeOperation(index);
        if (ele.type != ElementType_1.ElementType.LOLLIPOP)
            this.checkNebAll(this.lattices[index]);
        this.goElementTarget(ele.type, [ele.x, ele.y]);
    };
    PlayScene.prototype.getSubmitJson = function () {
        var json = {};
        return JSON.stringify(json);
    };
    PlayScene.prototype.submit = function (suc) {
        var _this = this;
        if (suc === void 0) { suc = true; }
        if (this.openRedBombPanel(function () {
            _this.submit(suc);
        }))
            return;
        var params = {
            level: this.data.chapter,
            score: this.score,
            stars: this.scoreProgress.starCount,
            isVisitSuccess: suc,
        };
        ctrls_1.showWaiting();
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.gameOver, params, function (s, res) {
            ctrls_1.hideWaiting();
            if (s) {
                if (suc) {
                    var prizeLevel = 50;
                    if (_this.data.chapter > 50 && _this.data.chapter <= 100) {
                        prizeLevel = 100;
                    }
                    else if (_this.data.chapter > 100) {
                        prizeLevel = 120;
                    }
                    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.drawLotteryPrize, {
                        prizeDataType: prizeLevel,
                        level: _this.data.chapter,
                        stars: _this.scoreProgress.starCount,
                    }, function (ds, dr) {
                        if (!ds || !dr.data || dr.data.type == 5) {
                            Tools_1.Tools.gameOver(Object.assign(res.data || {}, params));
                            return;
                        }
                        var data = {};
                        if (dr.data.type == 6) {
                            data.tool = {
                                type: dr.data.toolType
                            };
                        }
                        else {
                            data.prize = {
                                image: dr.data.image
                            };
                        }
                        Tools_1.Tools.gameOver(Object.assign(data, params));
                    });
                }
                else {
                    Tools_1.Tools.gameOver(Object.assign(res.data || {}, params));
                }
            }
            else {
                if (res.data) {
                    ctrls_1.showToast("网络开小差了\n再次连接中");
                    ctrls_1.wait(function () {
                        _this.submit(suc);
                    }, 1300);
                }
                else {
                    ctrls_1.showToast(res.message || "活动太火爆了\n请稍后再来");
                    ctrls_1.wait(function () {
                        ctrls_1.changeScene(MapScene_1.MapScene);
                    }, 1300);
                }
            }
        }, true);
    };
    PlayScene.prototype.openRedBombPanel = function (callback) {
        if (callback === void 0) { callback = null; }
        if (this.redBombPanelMark) {
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.drawLotteryPrize, {
                level: this.chapter,
                prizeDataType: 1
            }, function (success, res) {
                if (success && res.data) {
                    ctrls_1.showPanel(FesRedPrizePanel_1.FesRedPrizePanel, { callback: callback });
                }
                else {
                    callback();
                }
            });
            this.redBombPanelMark = false;
            return true;
        }
        return false;
    };
    PlayScene.prototype.returnPanels = function (panelName, data) {
        var panels = [], params = [];
        if (this.redBombPanelMark) {
            panels.push(redBombPanelName);
            params.push(null);
            this.redBombPanelMark = false;
        }
        panels.push(panelName);
        params.push(data);
        return [panels, params];
    };
    PlayScene.prototype.playAni = function (name, p) {
        var ani = Pool_1.Pool.takeOut(name);
        if (!ani) {
            ani = new aniClass[name]();
        }
        ani.x = p[0];
        ani.y = p[1];
        ani.play();
        this.addChild(ani);
        return ani;
    };
    PlayScene.prototype.iceBroken = function (lat) {
        if (lat && lat.ice) {
            var ice = lat.ice;
            ice.countNum--;
            if (ice.countNum == 0) {
                this.map.removeChild(ice);
                Pool_1.Pool.recover(RecoverName_1.RecoverName.ICE, ice);
                lat.ice = null;
                this.goElementTarget(ElementType_1.ElementType.ICE, [ice.x, ice.y]);
            }
            else {
                ice.alpha = 0.6;
            }
            var p = Tool_1.Tool.getPositionByIndex(lat.index);
            this.playAni(RecoverName_1.RecoverName.ICE_ANI, p);
        }
    };
    PlayScene.prototype.goElementTarget = function (type, fromP) {
        var _this = this;
        if (!this.passElements)
            return;
        if (this.passElements[type] != undefined) {
            if (this.passElements[type] != 0) {
                this.passElements[type]--;
                var p = this.elementTargets.targets[type].localToGlobal({ x: 40 * 0.8, y: 40 * 0.8 });
                this.addChild(FlyTargetAni_1.FlyTargetAni(type, fromP, [p.x, p.y - layers_1.layers.stageOffsetY], function () {
                    _this.elementTargets.targets[type].count--;
                }));
            }
            this.hasEliminatedElements[type]++;
        }
    };
    PlayScene.prototype.checkNebEle = function (lat, checkFun) {
        var indexMy = lat.index;
        var indexs = [
            indexMy - Tool_1.Tool.colNum,
            indexMy + Tool_1.Tool.colNum,
        ];
        if (lat.column > 0) {
            indexs.push(indexMy - 1);
        }
        if (lat.column < Tool_1.Tool.colNum - 1) {
            indexs.push(indexMy + 1);
        }
        for (var i = 0; i < indexs.length; i++) {
            var index = indexs[i];
            var lat_1 = this.lattices[index];
            if (lat_1 && lat_1.element && !lat_1.doorClosed && checkFun(lat_1)) {
                if (this.eliminatedElements.indexOf(index) == -1)
                    this.eliminatedElements.push(index);
            }
        }
    };
    PlayScene.prototype.checkNebAll = function (latttice) {
        this.iceBroken(latttice);
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.ROCK;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.JELLY;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.CHICKEN_EGG;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.hasState(StateType_1.StateType.HAIRBALLGREY);
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK);
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.FESTIVALELE_BIG;
        });
        this.checkNebEle(latttice, function (lat) {
            return lat.element.type == ElementType_1.ElementType.FESTIVALELE_SMALL;
        });
    };
    PlayScene.prototype.removeRock = function (index) {
        this.removeOperation(index);
        this.playAni(RecoverName_1.RecoverName.ROCK_ANI, Tool_1.Tool.getPositionByIndex(index));
    };
    PlayScene.prototype.removeJelly = function (index) {
        this.jellyBrokenMark = true;
        this.removeOperation(index);
        this.playAni(RecoverName_1.RecoverName.JELLYDIS_ANI, Tool_1.Tool.getPositionByIndex(index));
    };
    PlayScene.prototype.removeFestivalEleSmall = function (index) {
        var _this = this;
        var ele = this.removeOperation(index);
        if (this.festivalTargetNum) {
            this.festivalTargetNum--;
            var texture = RES_1.RES.getRes("ele" + ElementType_1.ElementType.FESTIVALELE_SMALL + ".png");
            var eleC_1 = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BITMAPRECYCLE);
            if (!eleC_1) {
                eleC_1 = new BitmapRecycle_1.BitmapRecycle(texture);
            }
            else {
                eleC_1.reset(texture);
            }
            eleC_1.position.set(ele.x, ele.y);
            this.addChild(eleC_1);
            Tween.get(eleC_1)
                .to({ scaleX: 0, scaleY: 0 }, 270, Ease.backIn)
                .call(function () {
                _this.removeChild(eleC_1);
                _this.festivalTarget.count--;
            });
            if (this.festivalTargetNum <= 0) {
                this.redBombPanelMark = true;
            }
        }
    };
    PlayScene.prototype.removeOperation = function (index) {
        if (!this.lattices[index] || !this.lattices[index].element)
            return null;
        var ele = this.lattices[index].element;
        this.emptys.push(index);
        this.elementContainer.removeChild(ele);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, ele);
        this.lattices[index].element = null;
        return ele;
    };
    PlayScene.prototype.redBombLightAni = function (index, callback) {
        var node = new Container();
        var down = new FYGE.Sprite(RES_1.RES.getRes("fesRedDown.png"));
        down.anchorTexture.set(0.5, 0.5);
        down.scale.set(0.31, 0.31);
        node.addChild(down);
        var ani2Texture = [];
        for (var i = 0; i < 18; i++) {
            ani2Texture.push(RES_1.RES.getRes("fesRedBombSta4_" + i + ".png"));
        }
        var ani2 = node.addChild(new FrameAni(ani2Texture));
        var p = Tool_1.Tool.getPositionByIndex(index);
        this.addChild(node);
        node.x = p[0];
        node.y = p[1];
        ani2.play(1, function () {
            setTimeout(function () {
                callback(node);
            }, 80);
        });
    };
    return PlayScene;
}(Scene_1.Scene));
exports.PlayScene = PlayScene;
var isOn = true;
var MusicBtn = (function (_super) {
    __extends(MusicBtn, _super);
    function MusicBtn() {
        var _this = this;
        var t = RES_1.RES.getRes("musicOn.png");
        _this = _super.call(this, t) || this;
        _this.addEventListener(FYGE.MouseEvent.CLICK, function () {
            isOn = !isOn;
            _this.texture = RES_1.RES.getRes(isOn ? "musicOn.png" : "musicOff.png");
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: isOn });
        }, _this);
        if (isOn)
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: true });
        Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.ON_SHOW, _this.onShow, _this);
        Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.ON_HIDE, _this.onHide, _this);
        return _this;
    }
    MusicBtn.prototype.onShow = function () {
        if (isOn)
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: true });
    };
    MusicBtn.prototype.onHide = function () {
        if (isOn)
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: false });
    };
    MusicBtn.prototype.destroy = function () {
        Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.ON_SHOW, this.onShow, this);
        Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.ON_HIDE, this.onHide, this);
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMusic, { isOn: false });
        _super.prototype.destroy.call(this);
    };
    return MusicBtn;
}(FYGE.Sprite));


/***/ }),

/***/ "./src/scene/map/CheckBtn.ts":
/*!***********************************!*\
  !*** ./src/scene/map/CheckBtn.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Button = FYGE.Button;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Container = FYGE.Container;
var Sprite = FYGE.Sprite;
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var MouseEvent = FYGE.MouseEvent;
var Point = FYGE.Point;
var Tween = FYGE.Tween;
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var StartPanelPrize_1 = __webpack_require__(/*! ../../panels/StartPanelPrize */ "./src/panels/StartPanelPrize.ts");
var CHECK_TYPE;
(function (CHECK_TYPE) {
    CHECK_TYPE[CHECK_TYPE["COM"] = 0] = "COM";
    CHECK_TYPE[CHECK_TYPE["CUR"] = 1] = "CUR";
})(CHECK_TYPE = exports.CHECK_TYPE || (exports.CHECK_TYPE = {}));
var CheckBtn = (function (_super) {
    __extends(CheckBtn, _super);
    function CheckBtn(data) {
        var _this = _super.call(this) || this;
        _this.checkData = {
            level: 1,
            scores: 0,
            stars: 0,
            isVisitSuccess: false,
            isPlayed: false,
        };
        _this.btn = null;
        _this.checkLabel = null;
        _this.star = null;
        _this.checkNum = null;
        _this.checkCurEffect = null;
        _this._data = null;
        _this._starCount = 0;
        _this._enabled = true;
        _this._type = CHECK_TYPE.COM;
        _this.initUi(data);
        return _this;
    }
    Object.defineProperty(CheckBtn.prototype, "data", {
        set: function (data) {
            this._data = data;
            this.checkData.isPlayed = true;
            if (!data)
                return;
            if (!data.isVisitSuccess)
                return;
            this.enabled = data.isVisitSuccess;
            this.starCount = data.stars;
            this.checkData = data;
            this.checkData.isPlayed = true;
            this._sendAwardType = data.sendAwardType;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "sendAwardType", {
        get: function () {
            return this._sendAwardType;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "starCount", {
        get: function () {
            return this._starCount;
        },
        set: function (count) {
            if (count > 3) {
                count = 3;
            }
            else if (count < 1) {
                count = 1;
            }
            if (this._starCount == count)
                return;
            this._starCount = count;
            this.star.forEach(function (value, index) {
                value.enabled = (index < count);
            });
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "enabled", {
        set: function (enabled) {
            if (this._enabled == enabled)
                return;
            this._enabled = enabled;
            this.btn.enabled = enabled;
            this.star.forEach(function (v) { return v.visible = enabled; });
            this.checkLabel.visible = enabled;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CheckBtn.prototype, "type", {
        set: function (type) {
            if (this._type == type)
                return;
            this._type = type;
            switch (type) {
                case CHECK_TYPE.COM:
                    this.btn.changeTexture(RES_1.RES.getRes('map_check_enable.png'), RES_1.RES.getRes('map_check_enable.png'), RES_1.RES.getRes('map_check_disable.png'));
                    this.checkLabel.strokeColor = '#316ec6';
                    this.checkCurEffect.visible = false;
                    this.checkCurEffect.stop();
                    break;
                case CHECK_TYPE.CUR:
                    this.btn.changeTexture(RES_1.RES.getRes('map_check_enable_cur.png'), RES_1.RES.getRes('map_check_enable_cur.png'), RES_1.RES.getRes('map_check_disable.png'));
                    this.checkLabel.strokeColor = '#a55507';
                    this.checkCurEffect.visible = true;
                    this.checkCurEffect.play();
                    break;
            }
        },
        enumerable: true,
        configurable: true
    });
    CheckBtn.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(), new Point());
        var bp = this.localToGlobal(new Point(0, 120), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up) || this.stage.viewRect.isPointIn(bp);
    };
    CheckBtn.prototype.initUi = function (data) {
        this.btn = this.addChild(new Button(RES_1.RES.getRes('map_check_enable.png'), RES_1.RES.getRes('map_check_enable.png'), RES_1.RES.getRes('map_check_disable.png')));
        var star1 = this.addChild(new CheckStar());
        star1.position.set(16, 84);
        var star2 = this.addChild(new CheckStar());
        star2.position.set(42, 91);
        var star3 = this.addChild(new CheckStar());
        star3.position.set(67, 84);
        this.star = [star1, star2, star3];
        this.checkNum = data.check;
        this.checkData.level = data.check;
        this.checkLabel = this.btn.addChild(Tools_1.Tools.getText(data.check, 30, '#ffffff', TEXT_ALIGN.CENTER, 90, 8, 33));
        this.checkLabel.stroke = 2;
        this.checkLabel.strokeColor = '#d69422';
        this.checkCurEffect = this.addChild(new CheckCurEffect());
        this.checkCurEffect.visible = false;
        this.enabled = false;
        this.btn.addEventListener(MouseEvent.CLICK, this.clickStart, this);
    };
    CheckBtn.prototype.clickStart = function () {
        if (!Tools_1.Tools.actStart) {
            ctrls_1.showToast('活动未开始');
            return;
        }
        if (Tools_1.Tools.actEnd) {
            ctrls_1.showToast('活动已结束');
            return;
        }
        Tools_1.Tools.btnDelay(this, 200);
        console.log("\u5173\u5361:" + this.checkNum);
        ctrls_1.showPanel(StartPanelPrize_1.StartPanelPrize, this.checkData);
    };
    return CheckBtn;
}(Container));
exports.default = CheckBtn;
var CheckStar = (function (_super) {
    __extends(CheckStar, _super);
    function CheckStar() {
        var _this = _super.call(this, RES_1.RES.getRes('map_star_disable.png')) || this;
        _this._enabled = false;
        CheckStar.starDisableTexture = RES_1.RES.getRes('map_star_disable.png');
        CheckStar.starEnableTexture = RES_1.RES.getRes('map_star_enable.png');
        return _this;
    }
    Object.defineProperty(CheckStar.prototype, "enabled", {
        set: function (enabled) {
            this._enabled = enabled;
            this.texture = enabled ? CheckStar.starEnableTexture : CheckStar.starDisableTexture;
        },
        enumerable: true,
        configurable: true
    });
    CheckStar.starEnableTexture = null;
    CheckStar.starDisableTexture = null;
    return CheckStar;
}(Sprite));
var CheckCurEffect = (function (_super) {
    __extends(CheckCurEffect, _super);
    function CheckCurEffect() {
        var _this = _super.call(this) || this;
        _this.light1 = null;
        _this.light2 = null;
        _this.light1 = _this.addChild(Tools_1.Tools.getSprite('cur_light_1.png'));
        _this.light2 = _this.addChild(Tools_1.Tools.getSprite('cur_light_2.png'));
        _this.light1.anchorTexture.set(0.5, 0.5);
        _this.light2.anchorTexture.set(0.5, 0.5);
        _this.position.set(55, 50);
        _this.mouseEnable = _this.mouseChildren = false;
        return _this;
    }
    CheckCurEffect.prototype.play = function () {
        Tween.get(this.light1, { loop: true })
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1.5, scaleY: 1.5 }, 1300)
            .wait(700);
        Tween.get(this.light1, { loop: true })
            .set({ alpha: 1 })
            .wait(700)
            .to({ alpha: 0 }, 600)
            .wait(700);
        Tween.get(this.light2, { loop: true })
            .set({ scaleX: 0.8, scaleY: 0.8 })
            .to({ scaleX: 1.3, scaleY: 1.3 }, 1000)
            .wait(1000);
        Tween.get(this.light2, { loop: true })
            .set({ alpha: 0 })
            .to({ alpha: 1 }, 400)
            .to({ alpha: 0 }, 600)
            .wait(1000);
        return this;
    };
    CheckCurEffect.prototype.stop = function () {
        Tween.removeTweens(this.light1);
        Tween.removeTweens(this.light2);
        return this;
    };
    return CheckCurEffect;
}(Container));


/***/ }),

/***/ "./src/scene/map/MapBottom.ts":
/*!************************************!*\
  !*** ./src/scene/map/MapBottom.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MapPart_1 = __webpack_require__(/*! ./MapPart */ "./src/scene/map/MapPart.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Point = FYGE.Point;
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var MapBottom = (function (_super) {
    __extends(MapBottom, _super);
    function MapBottom(data) {
        var _this = _super.call(this, data) || this;
        _this.btnPos = [
            [358, 420],
            [241, 367],
            [256, 262],
            [337, 172],
            [307, 68],
            [207, 4],
        ];
        _this.data = data;
        _this.bg.texture = RES_1.RES.getRes('map_bg1.jpg');
        _this.initIcon();
        return _this;
    }
    MapBottom.prototype.initEffect = function () {
        var balloon = this.addChild(Tools_1.Tools.getSprite('热气球.png'));
        balloon.position.set(19, 40);
        Tween.get(balloon, { loop: true })
            .to({ y: -10 }, 2500, Ease.quadInOut)
            .to({ y: 40 }, 2500, Ease.quadInOut);
    };
    MapBottom.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(0, -10), new Point());
        var bp = this.localToGlobal(new Point(0, MapBottom.HEIGHT + 10), new Point());
        var ucp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4), new Point());
        var bcp = this.localToGlobal(new Point(0, MapBottom.HEIGHT / 4 * 3), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp);
    };
    MapBottom.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    MapBottom.HEIGHT = 623;
    MapBottom.totalCount = 6;
    return MapBottom;
}(MapPart_1.default));
exports.default = MapBottom;


/***/ }),

/***/ "./src/scene/map/MapMid.ts":
/*!*********************************!*\
  !*** ./src/scene/map/MapMid.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MapPart_1 = __webpack_require__(/*! ./MapPart */ "./src/scene/map/MapPart.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Point = FYGE.Point;
var FrameAni = FYGE.FrameAni;
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var MapMid = (function (_super) {
    __extends(MapMid, _super);
    function MapMid(data) {
        var _this = _super.call(this, data) || this;
        _this.btnPos = [
            [125, 2090],
            [56, 1969],
            [223, 1872],
            [316, 1741],
            [293, 1590],
            [289, 1423],
            [395, 1322],
            [437, 1193],
            [367, 1056],
            [307, 883],
            [218, 773],
            [340, 696],
            [429, 602],
            [412, 478],
            [306, 395],
            [238, 272],
            [296, 150],
            [265, 5],
        ];
        _this.data = data;
        _this.bg.texture = RES_1.RES.getRes('map_bg2.jpg');
        _this.initIcon();
        return _this;
    }
    MapMid.prototype.initEffect = function () {
        var mapCatTexture = [];
        for (var i = 0; i < 35; i++) {
            mapCatTexture.push(RES_1.RES.getRes("map_cat_" + i + ".png"));
        }
        var mapCat = this.addChild(new FrameAni(mapCatTexture));
        mapCat.position.set(650, 420);
        mapCat.play(-1);
        var tinyBalloonTexture = [];
        for (var i = 0; i <= 41; i++) {
            tinyBalloonTexture.push(RES_1.RES.getRes("tinyBalloon_" + i + ".png"));
        }
        for (var i = 41; i >= 0; i--) {
            tinyBalloonTexture.push(RES_1.RES.getRes("tinyBalloon_" + i + ".png"));
        }
        var tinyBalloon = this.addChild(new FrameAni(tinyBalloonTexture));
        tinyBalloon.position.set(180, 640);
        tinyBalloon.play(-1);
        var treeTexture = [];
        for (var i = 0; i <= 32; i++) {
            treeTexture.push(RES_1.RES.getRes("map_tree_" + i + ".png"));
        }
        for (var i = 32; i >= 0; i--) {
            treeTexture.push(RES_1.RES.getRes("map_tree_" + i + ".png"));
        }
        for (var i = 65; i < 120; i++) {
            treeTexture.push(RES_1.RES.getRes("map_tree_" + 0 + ".png"));
        }
        var treeEffect1 = this.addChild(new FrameAni(treeTexture));
        treeEffect1.frameRate = 20;
        treeEffect1.position.set(735, 400);
        treeEffect1.play(-1);
        var treeEffect2 = this.addChild(new FrameAni(treeTexture));
        treeEffect2.frameRate = 20;
        treeEffect2.position.set(30, 765);
        treeEffect2.scaleX = -1;
        this.timeOutArr.push(setTimeout(function () {
            treeEffect2.play(-1);
        }, 1200));
        var treeEffect3 = this.addChild(new FrameAni(treeTexture));
        treeEffect3.frameRate = 20;
        treeEffect3.position.set(30, 1590);
        treeEffect3.scaleX = -1;
        treeEffect3.play(-1);
        this.timeOutArr.push(setTimeout(function () {
            treeEffect3.play(-1);
        }, 2000));
        var treeEffect4 = this.addChild(new FrameAni(treeTexture));
        treeEffect4.frameRate = 20;
        treeEffect4.position.set(740, 1780);
        treeEffect4.scaleX = -1;
        treeEffect4.play(-1);
        this.timeOutArr.push(setTimeout(function () {
            treeEffect4.play(-1);
        }, 2500));
        this.addChild(Tools_1.Tools.getSprite('薯片店.png', -80, 1570));
        var aromaTexture = [];
        for (var i = 0; i <= 18; i++) {
            aromaTexture.push(RES_1.RES.getRes("Aroma_1_" + i + ".png"));
        }
        for (var i = 19; i <= 100; i++) {
            aromaTexture.push(null);
        }
        var aroma = this.addChild(new FrameAni(aromaTexture));
        aroma.position.set(55, 1460);
        aroma.play(-1);
    };
    MapMid.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(0, -10), new Point());
        var bp = this.localToGlobal(new Point(0, MapMid.HEIGHT + 10), new Point());
        var ucp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4), new Point());
        var bcp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4 * 3), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp);
    };
    MapMid.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.timeOutArr.forEach(function (v) { return clearTimeout(v); });
    };
    MapMid.HEIGHT = 2222;
    MapMid.totalCount = 18;
    return MapMid;
}(MapPart_1.default));
exports.default = MapMid;


/***/ }),

/***/ "./src/scene/map/MapPart.ts":
/*!**********************************!*\
  !*** ./src/scene/map/MapPart.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Sprite = FYGE.Sprite;
var CheckBtn_1 = __webpack_require__(/*! ./CheckBtn */ "./src/scene/map/CheckBtn.ts");
var MapScene_1 = __webpack_require__(/*! ./MapScene */ "./src/scene/map/MapScene.ts");
var Container = FYGE.Container;
var MapPart = (function (_super) {
    __extends(MapPart, _super);
    function MapPart(data) {
        var _this = _super.call(this) || this;
        _this.data = null;
        _this.btnPos = [];
        _this.bg = null;
        _this.timeOutArr = [];
        _this.bg = _this.addChild(new Sprite());
        _this.data = data;
        _this.initEffect();
        return _this;
    }
    MapPart.prototype.initEffect = function () {
    };
    MapPart.prototype.initIcon = function () {
        for (var i = this.data.length - 1; i >= 0; i--) {
            var value = this.data[i];
            var nBtn = this.addChild(new CheckBtn_1.default(value));
            nBtn.position.set(this.btnPos[i][0] + 5, this.btnPos[i][1] - 10);
            MapScene_1.MapScene.checkArr[value.check] = nBtn;
        }
    };
    MapPart.totalCount = 0;
    return MapPart;
}(Container));
exports.default = MapPart;


/***/ }),

/***/ "./src/scene/map/MapScene.ts":
/*!***********************************!*\
  !*** ./src/scene/map/MapScene.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Scene_1 = __webpack_require__(/*! ../../../module/views/Scene */ "./module/views/Scene.ts");
var MapBottom_1 = __webpack_require__(/*! ./MapBottom */ "./src/scene/map/MapBottom.ts");
var MapTop_1 = __webpack_require__(/*! ./MapTop */ "./src/scene/map/MapTop.ts");
var MapUI_1 = __webpack_require__(/*! ./MapUI */ "./src/scene/map/MapUI.ts");
var MapMid_1 = __webpack_require__(/*! ./MapMid */ "./src/scene/map/MapMid.ts");
var CheckBtn_1 = __webpack_require__(/*! ./CheckBtn */ "./src/scene/map/CheckBtn.ts");
var layers_1 = __webpack_require__(/*! ../../../module/views/layers */ "./module/views/layers.ts");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var ScrollPage = FYGE.ScrollPage;
var Container = FYGE.Container;
var Graphics = FYGE.Graphics;
var Sprite = FYGE.Sprite;
var Texture = FYGE.Texture;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var FreePowerPanel_1 = __webpack_require__(/*! ../../panels/FreePowerPanel */ "./src/panels/FreePowerPanel.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../../TaoBaoNet */ "./src/TaoBaoNet.ts");
var Main_1 = __webpack_require__(/*! ../../Main */ "./src/Main.ts");
var G_EVENT_1 = __webpack_require__(/*! ../../common/G_EVENT */ "./src/common/G_EVENT.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var MapScene = (function (_super) {
    __extends(MapScene, _super);
    function MapScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.mapContainer = null;
        _this.scrollPage = null;
        _this.uiLayer = null;
        _this.mapAvatar = null;
        return _this;
    }
    MapScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    Object.defineProperty(MapScene.prototype, "groupNames", {
        get: function () {
            return [
                'map',
            ];
        },
        enumerable: true,
        configurable: true
    });
    MapScene.prototype.initUi = function () {
        _super.prototype.initUi.call(this);
        this.scrollPage = this.addChild(new ScrollPage(750, layers_1.layers.stageHeight, 888, true, true));
        this.mapContainer = this.scrollPage.view.addChild(new Container());
        this.initMap();
        this.updateMapCheck();
        if (Tools_1.Tools.globalData.loginAddPower && !Tools_1.Tools.globalData.isFirstLogin) {
            ctrls_1.showPanel(FreePowerPanel_1.FreePowerPanel);
            Tools_1.Tools.globalData.loginAddPower = false;
        }
        if (this.data && this.data.doSomething && this.data.doSomething == 'toMyPrize') {
            setTimeout(function () {
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateTo, { url: '/pages/myprize/myprize' }, function () {
                }, true);
            }, 100);
        }
    };
    MapScene.prototype.updateMapCheck = function () {
        var _this = this;
        if (this.data && this.data.from == 'loading') {
            this.uiLayer = this.addChild(new MapUI_1.default());
            this.initMapByData();
            if (Tools_1.Tools.globalData.isFirstLogin) {
                this.initGuide();
            }
        }
        else {
            Tools_1.Tools.getBaseInfo().then(function (success) {
                if (success) {
                    _this.uiLayer = _this.addChild(new MapUI_1.default());
                    _this.initMapByData();
                }
            });
        }
    };
    MapScene.prototype.initGuide = function () {
        var guide = this.addChild(new Container());
        guide.y = -layers_1.layers.stageOffsetY;
        var g = guide.addChild(new Graphics());
        g.beginFill(0, 0.6);
        g.drawRect(0, 0, 750, 1624);
        g.endFill();
        var mapGuide = guide.addChild(Tools_1.Tools.getSprite('mapGuide.png'));
        mapGuide.anchorTexture.set(0.5, 0.5);
        mapGuide.position.set(375, 650);
        mapGuide.mouseEnable = false;
        var guide_check = guide.addChild(new CheckBtn_1.default({ check: 1 }));
        guide_check.enabled = true;
        guide_check.type = CheckBtn_1.CHECK_TYPE.CUR;
        guide_check.position.set(MapScene.checkArr[1].x, MapScene.checkArr[1].y + 140 * layers_1.layers.stageOffsetY / 812);
        guide_check.addChild(new MapAvatar());
        var guide_hand = guide.addChild(Tools_1.Tools.getSprite('guide_hand.png'));
        guide_hand.position.set(guide_check.x + 90, guide_check.y + 40);
        guide_hand.mouseEnable = guide_hand.mouseChildren = false;
        guide.alpha = 0;
        Tween.get(guide)
            .to({ alpha: 1 }, 600, Ease.quadInOut);
    };
    MapScene.prototype.initMapByData = function (data) {
        if (data === void 0) { data = Tools_1.Tools.baseInfo; }
        this.uiLayer.energyBox.count = Tools_1.Tools.propInfo.power;
        var currentLevel = data.currentLevel || 1;
        for (var i = 1; i < currentLevel; i++) {
            MapScene.checkArr[i].type = CheckBtn_1.CHECK_TYPE.COM;
            MapScene.checkArr[i].enabled = true;
        }
        if (currentLevel < 121 && currentLevel > 0) {
            MapScene.checkArr[currentLevel].type = CheckBtn_1.CHECK_TYPE.CUR;
            MapScene.checkArr[currentLevel].enabled = true;
            !this.mapAvatar && (this.mapAvatar = this.addChild(new MapAvatar()));
            this.mapAvatar.parent && this.mapAvatar.parent.removeChild(this.mapAvatar);
            MapScene.checkArr[currentLevel].addChild(this.mapAvatar);
        }
        for (var i = currentLevel + 1; i < 121; i++) {
            MapScene.checkArr[i].type = CheckBtn_1.CHECK_TYPE.COM;
            MapScene.checkArr[i].enabled = false;
        }
        if (!Array.isArray(data.records))
            data.records = [];
        data.records.forEach(function (v) {
            MapScene.checkArr[v.level].data = v;
        });
        if (this.data && this.data.level) {
            this.scrollToCheck(this.data.level);
            MapScene.checkArr[this.data.level].clickStart();
        }
        else {
            this.scrollToCheck(currentLevel);
        }
    };
    MapScene.prototype.initMap = function () {
        var arr = new Array(120);
        for (var i = 0; i < 120; i++) {
            arr[i] = { check: i + 1 };
        }
        arr.reverse();
        var topData = arr.splice(120 - MapTop_1.default.totalCount, MapTop_1.default.totalCount);
        var bottomData = arr.splice(0, MapBottom_1.default.totalCount);
        var midData = arr;
        var maxHeight = MapTop_1.default.HEIGHT;
        this.mapContainer.addChild(new MapTop_1.default(topData));
        for (var i = midData.length / MapMid_1.default.totalCount - 1; i >= 0; i--) {
            var data = midData.splice(i * MapMid_1.default.totalCount, MapMid_1.default.totalCount);
            var nMid = new MapMid_1.default(data);
            this.mapContainer.addChild(nMid);
            nMid.y = maxHeight;
            maxHeight += MapMid_1.default.HEIGHT;
        }
        var bottom = new MapBottom_1.default(bottomData);
        this.mapContainer.addChild(bottom);
        bottom.y = maxHeight;
        maxHeight += MapBottom_1.default.HEIGHT;
        this.scrollPage.maxDistance = maxHeight;
        this.scrollPage.scrollTo(maxHeight, 0);
        this.scrollToCheck(1);
    };
    MapScene.prototype.scrollToCheck = function (checkNum, time) {
        if (time === void 0) { time = 0; }
        if (checkNum < 1) {
            checkNum = 1;
        }
        else if (checkNum > 120) {
            checkNum = 120;
        }
        var check = MapScene.checkArr[checkNum];
        var checkY = check.y + check.parent.y - layers_1.layers.stageHeight / 2 + 50;
        this.scrollPage.scrollTo(checkY, time);
    };
    MapScene.prototype.updateScene = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                _super.prototype.updateScene.call(this);
                this.uiLayer.updateUI();
                return [2];
            });
        });
    };
    MapScene.prototype.start = function (data) {
        _super.prototype.start.call(this, data);
        if (Tools_1.Tools.globalData.inviteId) {
            TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.doHelp, { inviteId: Tools_1.Tools.globalData.inviteId }, function (success, res) {
                Tools_1.Tools.globalData.inviteId = null;
                if (success)
                    ctrls_1.showToast('助力成功');
            });
        }
        RES_1.RES.destroyGroup('loadingScene');
        var duration = 1500;
        Tween.get(FYGE)
            .wait(500)
            .call(function () {
            RES_1.RES.loadGroup('SuccessPanel');
            RES_1.RES.loadGroup('TaskPanel');
        })
            .wait(duration)
            .call(function () { return RES_1.RES.loadGroup('playScene'); })
            .wait(duration)
            .call(function () { return RES_1.RES.loadGroup('playFrameAni'); })
            .wait(duration)
            .call(function () { return RES_1.RES.loadGroup('playerFont'); })
            .wait(duration)
            .call(function () { return RES_1.RES.loadGroup('fiveVerHorDis'); })
            .wait(duration)
            .call(function () { return RES_1.RES.loadGroup('festival'); })
            .wait(duration)
            .call(function () { return RES_1.RES.loadGroup('MagicAni'); });
    };
    MapScene.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.ON_SHOW, this.updateScene, this);
    };
    MapScene.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.ON_SHOW, this.updateScene, this);
    };
    MapScene.checkArr = [];
    return MapScene;
}(Scene_1.Scene));
exports.MapScene = MapScene;
var MapAvatar = (function (_super) {
    __extends(MapAvatar, _super);
    function MapAvatar() {
        var _this = _super.call(this) || this;
        _this.avatarImg = null;
        _this.addChild(Tools_1.Tools.getSprite('map_avatar_bg.png'))
            .anchorTexture.set(0.5, 1);
        _this.position.set(54, 32);
        _this.mouseChildren = _this.mouseEnable = false;
        var mask = _this.addChild(new Graphics());
        mask.drawCircle(1, -52, 35);
        _this.avatarImg = _this.addChild(new Sprite(Texture.fromUrl(Tools_1.Tools.globalData.avatar)));
        _this.avatarImg.width = _this.avatarImg.height = 72;
        _this.avatarImg.position.set(-36, -87.5);
        _this.avatarImg.mask = mask;
        return _this;
    }
    return MapAvatar;
}(Container));
exports.MapAvatar = MapAvatar;


/***/ }),

/***/ "./src/scene/map/MapTop.ts":
/*!*********************************!*\
  !*** ./src/scene/map/MapTop.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var MapPart_1 = __webpack_require__(/*! ./MapPart */ "./src/scene/map/MapPart.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Point = FYGE.Point;
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var FrameAni = FYGE.FrameAni;
var Tween = FYGE.Tween;
var MapTop = (function (_super) {
    __extends(MapTop, _super);
    function MapTop(data) {
        var _this = _super.call(this, data) || this;
        _this.btnPos = [
            [374, 1114],
            [255, 1066],
            [196, 960],
            [312, 905],
            [392, 814],
            [492, 747],
        ];
        _this.data = data;
        _this.bg.texture = RES_1.RES.getRes('map_bg3.jpg');
        _this.initIcon();
        return _this;
    }
    MapTop.prototype.initEffect = function () {
        var treeTexture = [];
        for (var i = 0; i < 32; i++) {
            treeTexture.push(RES_1.RES.getRes("map_tree_" + i + ".png"));
        }
        for (var i = 32; i >= 0; i--) {
            treeTexture.push(RES_1.RES.getRes("map_tree_" + i + ".png"));
        }
        for (var i = 65; i < 120; i++) {
            treeTexture.push(RES_1.RES.getRes("map_tree_" + 0 + ".png"));
        }
        var treeEffect1 = this.addChild(new FrameAni(treeTexture));
        treeEffect1.frameRate = 20;
        treeEffect1.position.set(85, 913);
        treeEffect1.scaleX = -1;
        treeEffect1.play(-1);
        var treeEffect2 = this.addChild(new FrameAni(treeTexture));
        treeEffect2.position.set(729, 1068);
        treeEffect2.frameRate = 20;
        this.timeOutArr.push(setTimeout(function () {
            treeEffect2.play(-1);
        }, 1000));
        var foot = this.addChild(Tools_1.Tools.getSprite('top_foot.png'));
        foot.position.set(-24, 758);
        var cloud = this.addChild(Tools_1.Tools.getSprite('cloud.png'));
        cloud.position.set(750, 50);
        Tween.get(cloud, { loop: true })
            .set({ x: 750 })
            .to({ x: -692 }, 50000)
            .wait(1000);
    };
    MapTop.prototype.update = function () {
        _super.prototype.update.call(this);
        var up = this.localToGlobal(new Point(0, -10), new Point());
        var bp = this.localToGlobal(new Point(0, MapTop.HEIGHT + 10), new Point());
        var ucp = this.localToGlobal(new Point(0, MapTop.HEIGHT / 4), new Point());
        var bcp = this.localToGlobal(new Point(0, MapTop.HEIGHT / 4 * 3), new Point());
        this.alpha = this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp);
    };
    MapTop.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.timeOutArr.forEach(function (v) { return clearTimeout(v); });
    };
    MapTop.HEIGHT = 1218;
    MapTop.totalCount = 6;
    return MapTop;
}(MapPart_1.default));
exports.default = MapTop;


/***/ }),

/***/ "./src/scene/map/MapUI.ts":
/*!********************************!*\
  !*** ./src/scene/map/MapUI.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Container = FYGE.Container;
var Button = FYGE.Button;
var TextField = FYGE.TextField;
var MouseEvent = FYGE.MouseEvent;
var VERTICAL_ALIGN = FYGE.VERTICAL_ALIGN;
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var RulePanel_1 = __webpack_require__(/*! ../../panels/RulePanel */ "./src/panels/RulePanel.ts");
var TaskPanel_1 = __webpack_require__(/*! ../../panels/TaskPanel */ "./src/panels/TaskPanel.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../../TaoBaoNet */ "./src/TaoBaoNet.ts");
var MapUI = (function (_super) {
    __extends(MapUI, _super);
    function MapUI() {
        var _this = _super.call(this) || this;
        _this.energyBox = null;
        _this.myPrizeBtn = null;
        _this.ruleBtn = null;
        _this.taskBtn = null;
        _this.initUi();
        _this.initEvent();
        return _this;
    }
    MapUI.prototype.initEvent = function () {
        this.ruleBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.addEventListener(MouseEvent.CLICK, this.clickBtn, this);
    };
    MapUI.prototype.removeEvent = function () {
        this.ruleBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.myPrizeBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
        this.taskBtn.removeEventListener(MouseEvent.CLICK, this.clickBtn, this);
    };
    MapUI.prototype.clickBtn = function (e) {
        switch (e.target) {
            case this.ruleBtn:
                ctrls_1.showPanel(RulePanel_1.RulePanel);
                break;
            case this.myPrizeBtn:
                console.log('我的奖品');
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateTo, { url: '/pages/myprize/myprize' }, function () {
                }, true);
                break;
            case this.taskBtn:
                if (!Tools_1.Tools.actStart) {
                    ctrls_1.showToast('活动未开始');
                    return;
                }
                if (Tools_1.Tools.actEnd) {
                    ctrls_1.showToast('活动已结束');
                    return;
                }
                ctrls_1.showPanel(TaskPanel_1.TaskPanel);
                break;
        }
    };
    MapUI.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.removeEvent();
    };
    MapUI.prototype.initUi = function () {
        this.myPrizeBtn = this.addChild(new Button(RES_1.RES.getRes('map_prizeBtn.png')));
        this.myPrizeBtn.position.set(16, 135);
        this.ruleBtn = this.addChild(new Button(RES_1.RES.getRes('map_ruleBtn.png')));
        this.ruleBtn.position.set(16, 57);
        this.taskBtn = this.addChild(new Button(RES_1.RES.getRes('map_taskBtn.png')));
        this.taskBtn.position.set(605, 145);
        this.taskBtn.addChild(Tools_1.Tools.getSprite('map_taskBtn_tip.png', -131, 8));
        this.energyBox = this.addChild(new EnergyBox({}));
    };
    MapUI.prototype.updateUI = function () {
        var _this = this;
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getPower, {}, function (success, res) {
            _this.energyBox.count = Tools_1.Tools.propInfo.power;
            if (!success)
                return;
            _this.energyBox.count = Tools_1.Tools.propInfo.power = res.data.power;
        });
    };
    return MapUI;
}(Container));
exports.default = MapUI;
var EnergyBox = (function (_super) {
    __extends(EnergyBox, _super);
    function EnergyBox(data) {
        var _this = _super.call(this) || this;
        _this.countLabel = null;
        _this.lightImg = null;
        _this._count = 0;
        _this.initUi(data);
        return _this;
    }
    Object.defineProperty(EnergyBox.prototype, "count", {
        set: function (count) {
            this._count = count;
            this.countLabel.text = '' + count;
            this.doAlign();
        },
        enumerable: true,
        configurable: true
    });
    EnergyBox.prototype.initUi = function (data) {
        this.position.set(549, 59);
        this.addChild(Tools_1.Tools.getSprite('map_energyBg.png'));
        this.countLabel = this.addChild(new TextField());
        this.countLabel.size = 30;
        this.countLabel.fillColor = '#ffffff';
        this.countLabel.textAlign = TEXT_ALIGN.CENTER;
        this.countLabel.y = 1;
        this.countLabel.textHeight = this.height;
        this.countLabel.verticalAlign = VERTICAL_ALIGN.MIDDLE;
        this.countLabel.strokeColor = '#1c7ab8';
        this.countLabel.bold = true;
        this.countLabel.stroke = 3;
        this.lightImg = this.addChild(Tools_1.Tools.getSprite('lightImg.png'));
        this.lightImg.y = 16;
        this.doAlign();
    };
    EnergyBox.prototype.doAlign = function () {
        var tW = this.countLabel.textWidth;
        var iW = this.lightImg.width;
        this.lightImg.x = (this.width - (tW + iW + 6)) / 2 + 2;
        this.countLabel.x = this.lightImg.x + this.lightImg.width + 6;
    };
    EnergyBox.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    return EnergyBox;
}(Container));


/***/ }),

/***/ "./src/something/Pool.ts":
/*!*******************************!*\
  !*** ./src/something/Pool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Pool = (function () {
    function Pool() {
    }
    Pool.takeOut = function (name) {
        if (this.pool[name] && this.pool[name].length) {
            return this.pool[name].shift();
        }
        return null;
    };
    Pool.recover = function (name, obj) {
        if (!this.pool[name]) {
            this.pool[name] = [];
        }
        this.pool[name].push(obj);
    };
    Pool.pool = {};
    return Pool;
}());
exports.Pool = Pool;


/***/ }),

/***/ "./src/something/Tool.ts":
/*!*******************************!*\
  !*** ./src/something/Tool.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Element_1 = __webpack_require__(/*! ./class/Element */ "./src/something/class/Element.ts");
var ElementType_1 = __webpack_require__(/*! ./enum/ElementType */ "./src/something/enum/ElementType.ts");
var EffectType_1 = __webpack_require__(/*! ./enum/EffectType */ "./src/something/enum/EffectType.ts");
var Pool_1 = __webpack_require__(/*! ./Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ./enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RectMask_1 = __webpack_require__(/*! ./class/RectMask */ "./src/something/class/RectMask.ts");
var FallAniData_1 = __webpack_require__(/*! ./interface/FallAniData */ "./src/something/interface/FallAniData.ts");
var StateType_1 = __webpack_require__(/*! ./enum/StateType */ "./src/something/enum/StateType.ts");
var offsetYTwo = [];
var gameAreaHeightTwo = [];
function initClientScale() {
    var sysInfo;
    if (my)
        sysInfo = my.getSystemInfoSync();
    var stageHeight = sysInfo ? sysInfo.windowHeight / sysInfo.windowWidth * 750 :
        document.body.clientHeight / document.body.clientWidth * 750;
    var middleHeight = 80 * 9;
    var topHeight = 238;
    var botHeight = 140 + 20;
    var smallestHeight = topHeight + middleHeight + botHeight;
    if (stageHeight < smallestHeight) {
        offsetYTwo[0] = topHeight;
        offsetYTwo[1] = topHeight;
        gameAreaHeightTwo[0] = middleHeight;
        gameAreaHeightTwo[1] = middleHeight + 45;
    }
    else {
        offsetYTwo[0] = topHeight + (stageHeight - smallestHeight) / 2;
        offsetYTwo[1] = topHeight + (stageHeight - smallestHeight - 45) / 2;
        gameAreaHeightTwo[0] = stageHeight - topHeight - botHeight;
        ;
        gameAreaHeightTwo[1] = stageHeight - topHeight - botHeight;
    }
}
var Tool = (function () {
    function Tool() {
    }
    Tool.init = function (isTwo, hasLollipop) {
        if (isTwo === void 0) { isTwo = false; }
        if (hasLollipop === void 0) { hasLollipop = false; }
        if (!offsetYTwo.length)
            initClientScale();
        var ooox = isTwo ? 55 : 15;
        var oooy = hasLollipop ? offsetYTwo[1] : offsetYTwo[0];
        this.gameAreaHeight = hasLollipop ? gameAreaHeightTwo[1] : gameAreaHeightTwo[0];
        if (this.offsetX == ooox && this.offsetY == oooy)
            return;
        this.offsetX = ooox;
        this.offsetY = oooy;
        var spaceX = this.width, spaceY = this.height, offsetX = this.offsetX + this.width / 2, offsetY = this.offsetY + this.height / 2;
        for (var i = 0; i < this.rowNum; i++) {
            for (var j = 0; j < this.colNum; j++) {
                this.rcToIndexMap["" + i + j] = i * this.colNum + j;
                this.indexToRcMap[i * this.colNum + j] = [i, j];
                this.rowColPositions["" + i + j] = [offsetX + j * spaceX, offsetY + i * spaceY];
                this.indexPositions[i * this.colNum + j] = [offsetX + j * spaceX, offsetY + i * spaceY];
            }
        }
        var rowNum = Tool.rowNum + 1;
        var colNum = Tool.colNum + 1;
        var offsetX = Tool.offsetX;
        var offsetY = Tool.offsetY;
        for (var i = 0; i < rowNum; i++) {
            for (var j = 0; j < colNum; j++) {
                this.indexToRcMap10[i * colNum + j] = [i, j];
                this.indexPositions10[i * colNum + j] = [offsetX + j * Tool.width, offsetY + i * Tool.height];
            }
        }
    };
    Tool.rcToIndex = function (row, col) {
        var key = "" + row + col;
        return this.rcToIndexMap[key];
    };
    Tool.indexToRc = function (index) {
        return this.indexToRcMap[index];
    };
    Tool.getPositionByRc = function (row, col) {
        var key = "" + row + col;
        return this.rowColPositions[key];
    };
    Tool.getPositionByIndex = function (index) {
        return this.indexPositions[index];
    };
    Tool.indexToRc10 = function (index) {
        return this.indexToRcMap10[index];
    };
    Tool.getPositionByIndex10 = function (index) {
        return this.indexPositions10[index];
    };
    Tool.getColOddEven = function (lattices) {
        var left = 0;
        for (var i = 0; i < Tool.colNum; i++) {
            var mark = false;
            for (var j = 0; j < Tool.rowNum; j++) {
                if (lattices[j * this.colNum + i]) {
                    mark = true;
                    break;
                }
            }
            if (mark) {
                break;
            }
            else {
                left++;
            }
        }
        var right = 0;
        for (var i = Tool.colNum - 1; i >= 0; i--) {
            var mark = false;
            for (var j = 0; j < Tool.rowNum; j++) {
                if (lattices[j * this.colNum + i]) {
                    mark = true;
                    break;
                }
            }
            if (mark) {
                break;
            }
            else {
                right++;
            }
        }
        return (left + right) % 2 != 0;
    };
    Tool.checkNeb = function (a, b) {
        if (Math.abs(a.row - b.row) == 1 && Math.abs(a.column - b.column) == 0) {
            return true;
        }
        else if (Math.abs(a.row - b.row) == 0 && Math.abs(a.column - b.column) == 1) {
            return true;
        }
        return false;
    };
    Tool.insert = function (num, arr) {
        for (var i = arr.length - 1; i >= 0; i--) {
            if (num > arr[i]) {
                arr.splice(i + 1, 0, num);
                break;
            }
        }
    };
    Tool.insertEX = function (num, arr) {
        for (var i = 0; i < arr.length; i++) {
            if (num > arr[i]) {
                arr.splice(i, 0, num);
                return;
            }
        }
        arr.push(num);
    };
    Tool.judgeFall = function (lat) {
        if (!lat || !lat.element) {
            return false;
        }
        else if (lat.element.type == ElementType_1.ElementType.ROCK ||
            lat.element.hasState(StateType_1.StateType.LOCK) ||
            lat.element.type == ElementType_1.ElementType.JELLY ||
            lat.element.type == ElementType_1.ElementType.CHICKEN_EGG ||
            lat.element.type == ElementType_1.ElementType.FESTIVALELE_BIG ||
            lat.doorClosed) {
            return false;
        }
        else {
            return true;
        }
    };
    Tool.judgeMove = function (lat) {
        if (this.judgeFall(lat) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN) &&
            lat.element.type != ElementType_1.ElementType.FESTIVALELE_SMALL) {
            return true;
        }
        return false;
    };
    Tool.judgeMatch = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            lat.element.effectType != EffectType_1.EffectType.MAGICLION &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return true;
        }
        return false;
    };
    Tool.judgeEliminate = function (lat) {
        if (!lat || !lat.element) {
            return false;
        }
        else if (lat.element.type == ElementType_1.ElementType.LOLLIPOP ||
            lat.doorClosed) {
            return false;
        }
        else {
            return true;
        }
    };
    Tool.judgeBaseEle = function (lat) {
        if (lat &&
            lat.element &&
            ElementType_1.FiveBaseElementTypes.indexOf(lat.element.type) >= 0) {
            return true;
        }
        return false;
    };
    Tool.judgeUpsetMove = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            !lat.element.hasState(StateType_1.StateType.LOCK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return true;
        }
        return false;
    };
    Tool.judgeSetFesEle = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
            !lat.element.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return true;
        }
        return false;
    };
    Tool.judgeSetChicken = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.element.hasAnyState() &&
            lat.element.type !== ElementType_1.ElementType.CHICKEN &&
            !lat.doorClosed) {
            return true;
        }
        return false;
    };
    Tool.judgeMagicEliminate = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.doorClosed &&
            lat.element.effectType != EffectType_1.EffectType.MAGICLION) {
            return true;
        }
        return false;
    };
    Tool.judgeAiActionDirection = function (lat) {
        if (Tool.judgeBaseEle(lat) &&
            !lat.element.hasAnyState() &&
            !lat.doorClosed) {
            return true;
        }
        return false;
    };
    Tool.judgeChosen = function (ele) {
        if (!ele ||
            ele.type == ElementType_1.ElementType.ROCK ||
            ele.hasState(StateType_1.StateType.LOCK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLGREY) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBLACK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBROWN) ||
            ele.type == ElementType_1.ElementType.JELLY ||
            ele.type == ElementType_1.ElementType.CHICKEN_EGG ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_BIG ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_SMALL) {
            return false;
        }
        return true;
    };
    Tool.judgeHasScore = function (ele) {
        if (!ele ||
            ele.type == ElementType_1.ElementType.ROCK ||
            ele.type == ElementType_1.ElementType.JELLY ||
            ele.type == ElementType_1.ElementType.CHICKEN_EGG ||
            ele.type == ElementType_1.ElementType.LOLLIPOP ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_BIG ||
            ele.type == ElementType_1.ElementType.FESTIVALELE_SMALL ||
            ele.hasState(StateType_1.StateType.LOCK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLGREY) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBLACK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return false;
        }
        return true;
    };
    Tool.judgeMagicRotate = function (ele) {
        if (!ele ||
            ele.effectType != null ||
            ele.hasState(StateType_1.StateType.LOCK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLGREY) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBLACK) ||
            ele.hasState(StateType_1.StateType.HAIRBALLBROWN)) {
            return false;
        }
        return true;
    };
    Tool.getExplosiveIndexes = function (curLat, lats) {
        var arr = [];
        Tool.ExplosiveMatchArr.forEach(function (e) {
            var col = curLat.column + e[0];
            var row = curLat.row + e[1];
            var index = Tool.rcToIndex(row, col);
            if (Tool.judgeEliminate(lats[index]))
                arr.push(index);
        });
        return arr;
    };
    Tool.dieMapCheck = function (lattices) {
        var judgeMatch = Tool.judgeMatch;
        var effectElements = [];
        var lat2, lat3;
        for (var i = Tool.colNum * Tool.rowNum - 1; i >= 0; i--) {
            var rc = Tool.indexToRc(i);
            var row = rc[0];
            var col = rc[1];
            var lat = lattices[i];
            if (!this.judgeMove(lat))
                continue;
            if (lat.element.effectType != null) {
                effectElements.push(lat.element);
            }
            var latDown = lattices[i + Tool.colNum];
            if (this.judgeMove(latDown) && lat.element.type != latDown.element.type) {
                lat2 = lattices[i + Tool.colNum * 2];
                lat3 = lattices[i + Tool.colNum * 3];
                if (judgeMatch(lat2) &&
                    judgeMatch(lat3) &&
                    lat.element.type == lat2.element.type &&
                    lat.element.type == lat3.element.type) {
                    return [lat.element, latDown.element];
                }
                lat2 = lattices[i - Tool.colNum];
                lat3 = lattices[i - Tool.colNum * 2];
                if (judgeMatch(lat2) &&
                    judgeMatch(lat3) &&
                    latDown.element.type == lat2.element.type &&
                    latDown.element.type == lat3.element.type) {
                    return [lat.element, latDown.element];
                }
                if (col > 1) {
                    lat2 = lattices[i + Tool.colNum - 1];
                    lat3 = lattices[i + Tool.colNum - 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col < Tool.colNum - 2) {
                    lat2 = lattices[i + Tool.colNum + 1];
                    lat3 = lattices[i + Tool.colNum + 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col > 0 && col < Tool.colNum - 1) {
                    lat2 = lattices[i + Tool.colNum + 1];
                    lat3 = lattices[i + Tool.colNum - 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col > 1) {
                    lat2 = lattices[i - 1];
                    lat3 = lattices[i - 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latDown.element.type == lat2.element.type &&
                        latDown.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col < Tool.colNum - 2) {
                    lat2 = lattices[i + 1];
                    lat3 = lattices[i + 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latDown.element.type == lat2.element.type &&
                        latDown.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
                if (col > 0 && col < Tool.colNum - 1) {
                    lat2 = lattices[i + 1];
                    lat3 = lattices[i - 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latDown.element.type == lat2.element.type &&
                        latDown.element.type == lat3.element.type) {
                        return [lat.element, latDown.element];
                    }
                }
            }
            if (col != Tool.colNum - 1) {
                var latRight = lattices[i + 1];
                if (this.judgeMove(latRight) && lat.element.type != latRight.element.type) {
                    if (col < Tool.colNum - 3) {
                        lat2 = lattices[i + 2];
                        lat3 = lattices[i + 3];
                        if (judgeMatch(lat2) &&
                            judgeMatch(lat3) &&
                            lat.element.type == lat2.element.type &&
                            lat.element.type == lat3.element.type) {
                            return [lat.element, latRight.element];
                        }
                    }
                    if (col > 1) {
                        lat2 = lattices[i - 1];
                        lat3 = lattices[i - 2];
                        if (judgeMatch(lat2) &&
                            judgeMatch(lat3) &&
                            latRight.element.type == lat2.element.type &&
                            latRight.element.type == lat3.element.type) {
                            return [lat.element, latRight.element];
                        }
                    }
                    lat2 = lattices[i + Tool.colNum * 1 + 1];
                    lat3 = lattices[i + Tool.colNum * 2 + 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i - Tool.colNum * 1 + 1];
                    lat3 = lattices[i - Tool.colNum * 2 + 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i + Tool.colNum + 1];
                    lat3 = lattices[i - Tool.colNum + 1];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        lat.element.type == lat2.element.type &&
                        lat.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i + Tool.colNum * 1];
                    lat3 = lattices[i + Tool.colNum * 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latRight.element.type == lat2.element.type &&
                        latRight.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i - Tool.colNum * 1];
                    lat3 = lattices[i - Tool.colNum * 2];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latRight.element.type == lat2.element.type &&
                        latRight.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                    lat2 = lattices[i + Tool.colNum];
                    lat3 = lattices[i - Tool.colNum];
                    if (judgeMatch(lat2) &&
                        judgeMatch(lat3) &&
                        latRight.element.type == lat2.element.type &&
                        latRight.element.type == lat3.element.type) {
                        return [lat.element, latRight.element];
                    }
                }
            }
        }
        for (var i = 0; i < effectElements.length; i++) {
            var effectElement = effectElements[i];
            if (effectElement.effectType == EffectType_1.EffectType.MAGICLION) {
                var up = lattices[effectElement.index - Tool.colNum];
                if (this.judgeMove(up) && up.element.type != ElementType_1.ElementType.LOLLIPOP)
                    return [effectElement, up.element];
                var down = lattices[effectElement.index + Tool.colNum];
                if (this.judgeMove(down) && down.element.type != ElementType_1.ElementType.LOLLIPOP)
                    return [effectElement, down.element];
                var col = Tool.indexToRc(effectElement.index)[1];
                if (col != 0) {
                    var left = lattices[effectElement.index - 1];
                    if (this.judgeMove(left) && left.element.type != ElementType_1.ElementType.LOLLIPOP)
                        return [effectElement, left.element];
                }
                if (col != Tool.colNum - 1) {
                    var right = lattices[effectElement.index + 1];
                    if (this.judgeMove(right) && right.element.type != ElementType_1.ElementType.LOLLIPOP)
                        return [effectElement, right.element];
                }
                continue;
            }
            var up = lattices[effectElement.index - Tool.colNum];
            if (this.judgeMove(up) && up.element.effectType != null)
                return [effectElement, up.element];
            var down = lattices[effectElement.index + Tool.colNum];
            if (this.judgeMove(down) && down.element.effectType != null)
                return [effectElement, down.element];
            var col = Tool.indexToRc(effectElement.index)[1];
            if (col != 0) {
                var left = lattices[effectElement.index - 1];
                if (this.judgeMove(left) && left.element.effectType != null)
                    return [effectElement, left.element];
            }
            if (col != Tool.colNum) {
                var right = lattices[effectElement.index + 1];
                if (this.judgeMove(right) && right.element.effectType != null)
                    return [effectElement, right.element];
            }
        }
        return null;
    };
    Tool.alreadyDie = function (lattices) {
        var arr = {};
        var hasEffect = false;
        var effectCount = 0;
        var hasTwo = false;
        var hasThree = false;
        for (var i = 0; i < lattices.length; i++) {
            if (this.judgeBaseEle(lattices[i]) &&
                !lattices[i].element.hasState(StateType_1.StateType.LOCK) &&
                !lattices[i].element.hasState(StateType_1.StateType.HAIRBALLGREY) &&
                !lattices[i].element.hasState(StateType_1.StateType.HAIRBALLBLACK) &&
                !lattices[i].element.hasState(StateType_1.StateType.HAIRBALLGREY)) {
                var type = lattices[i].element.type;
                if (!arr[type])
                    arr[type] = 0;
                arr[type]++;
                var ele = lattices[i].element;
                if (ele.effectType == EffectType_1.EffectType.MAGICLION) {
                    hasEffect = true;
                }
                if (ele.effectType != null) {
                    effectCount++;
                    if (effectCount >= 2) {
                        hasEffect = true;
                    }
                }
                var rc = Tool.indexToRc(i);
                if (rc[1] < Tool.colNum - 1) {
                    var latRight1 = lattices[i + 1];
                    if (Tool.judgeMove(latRight1) && latRight1.element.type != ElementType_1.ElementType.LOLLIPOP) {
                        hasTwo = true;
                    }
                    if (rc[1] < Tool.colNum - 2) {
                        var latRight2 = lattices[i + 2];
                        if (Tool.judgeMove(latRight1) &&
                            latRight1.element.type != ElementType_1.ElementType.LOLLIPOP &&
                            Tool.judgeMove(latRight2) &&
                            latRight2.element.type != ElementType_1.ElementType.LOLLIPOP) {
                            hasThree = true;
                        }
                    }
                }
                var latDown1 = lattices[i + Tool.colNum];
                if (Tool.judgeMove(latDown1) && latDown1.element.type != ElementType_1.ElementType.LOLLIPOP) {
                    hasTwo = true;
                }
                if (hasTwo && hasEffect)
                    return false;
                var latDown2 = lattices[i + Tool.colNum * 2];
                if (Tool.judgeMove(latDown1) &&
                    latDown1.element.type != ElementType_1.ElementType.LOLLIPOP &&
                    Tool.judgeMove(latDown2) &&
                    latDown2.element.type != ElementType_1.ElementType.LOLLIPOP) {
                    hasThree = true;
                }
                if (hasThree) {
                    for (var a in arr) {
                        if (arr[a] >= 3) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    };
    Tool.fn = function (arr, lattices) {
        var result = [], i = 0;
        result[i] = [arr[0]];
        arr.reduce(function (prev, cur) {
            var latP = lattices[prev];
            var latC = lattices[cur];
            if (Tool.judgeMatch(latP) &&
                Tool.judgeMatch(latC) &&
                latP.element.type == latC.element.type) {
                result[i].push(cur);
            }
            else {
                result[++i] = [cur];
            }
            return cur;
        });
        return result;
    };
    Tool.returnType = function (index, lattices, baseElementTypes) {
        var rc = Tool.indexToRc(index);
        var arr = baseElementTypes.slice();
        if (rc[1] > 1) {
            var lat1 = lattices[index - 1];
            var lat2 = lattices[index - 2];
            if (Tool.judgeMatch(lat1) &&
                Tool.judgeMatch(lat2) &&
                lat1.element.type == lat2.element.type) {
                Tool.removeEle(lat1.element.type, arr);
            }
        }
        var lat1 = lattices[index - Tool.colNum];
        var lat2 = lattices[index - Tool.colNum * 2];
        if (Tool.judgeMatch(lat1) &&
            Tool.judgeMatch(lat2) &&
            lat1.element.type == lat2.element.type) {
            Tool.removeEle(lat1.element.type, arr);
        }
        return Tool.randomT(arr);
    };
    Tool.setGenerateLats = function (lattices, generateLats) {
        var arr = [];
        for (var i = 0; i < generateLats.length; i++) {
            var generateLat = generateLats[i];
            generateLat.cus = generateLat.cus || [];
            var index = generateLat.index;
            if (!lattices[index])
                continue;
            lattices[index].isGenerate = true;
            var rc = this.indexToRc(index);
            var col = rc[1];
            if (!arr[col])
                arr[col] = [];
            arr[col].push({
                index: generateLat.index,
                type: generateLat.type || [],
                cus: generateLat.cus.slice(),
            });
        }
        for (var j = 0; j < arr.length; j++) {
            if (arr[j])
                arr[j].sort(function (a, b) { return a.index > b.index ? 1 : -1; });
        }
        return arr;
    };
    Tool.setNumber01 = function (nums) {
        var arr = [];
        for (var i = 0; i < nums.length; i++) {
            if (nums[i]) {
                arr[i] = 1;
            }
            else {
                arr[i] = 0;
            }
        }
        return arr;
    };
    Tool.findBottom = function (lattice, emptys, lattices) {
        var indexDown, lat;
        var connects = [];
        var isThrough = false;
        if (lattice.down != null) {
            indexDown = lattice.down;
            isThrough = true;
        }
        else {
            indexDown = lattice.index + this.colNum;
        }
        var lastEmptyIndex;
        var emptyIndex = emptys.indexOf(indexDown);
        while (emptyIndex > -1) {
            if (isThrough)
                connects.push({ index: indexDown, type: FallAniData_1.FallType.THROUGH });
            lastEmptyIndex = emptyIndex;
            lat = lattices[indexDown];
            if (lat.down != null) {
                if (!isThrough)
                    connects.push({ index: indexDown, type: FallAniData_1.FallType.STRIGHT });
                isThrough = true;
                indexDown = lat.down;
            }
            else {
                isThrough = false;
                indexDown = lat.index + this.colNum;
            }
            emptyIndex = emptys.indexOf(indexDown);
        }
        if (lastEmptyIndex != undefined) {
            if (isThrough) {
                return connects;
            }
            else {
                connects.push({ index: emptys[lastEmptyIndex], type: FallAniData_1.FallType.STRIGHT });
                return connects;
            }
        }
        else {
            return null;
        }
    };
    Tool.judgeOutOne = function (emptys, lattices) {
        for (var m = 0; m < Tool.colNum; m++) {
            for (var n = Tool.rowNum - 1; n >= 0; n--) {
                var index = Tool.rcToIndex(n, m);
                var lat = lattices[index];
                if (Tool.judgeFall(lat)) {
                    var indexs = Tool.findBottom(lat, emptys, lattices);
                    if (indexs != null) {
                        if (indexs.length > 1) {
                            return true;
                        }
                        else {
                            var downIndex = indexs[0].index;
                            var type = indexs[0].type;
                            if (type == FallAniData_1.FallType.STRIGHT && (downIndex - index) / Tool.colNum > 1) {
                                return true;
                            }
                        }
                    }
                }
                else {
                    if (lat && !lat.element && lat.isGenerate) {
                        var arr = [];
                        var downIndex = index;
                        while (emptys.indexOf(downIndex) > -1) {
                            arr.push(downIndex);
                            if (lat.down != null) {
                                downIndex = lat.down;
                            }
                            else {
                                downIndex = lat.index + this.colNum;
                            }
                            lat = lattices[downIndex];
                        }
                        if (arr.length > 1)
                            return true;
                    }
                }
            }
        }
        return false;
    };
    Tool.praseEleNumber = function (num) {
        var arr = this.returnTO(num);
        var baseType = arr[1] ? arr[1] - 1 : null;
        if (ElementType_1.FiveBaseElementTypes.indexOf(baseType) == -1)
            baseType = null;
        var effectType = arr[0] ? arr[0] - 1 : null;
        return [baseType, effectType];
    };
    Tool.removeEle = function (e, arr) {
        var index = arr.indexOf(e);
        if (index >= 0) {
            arr.splice(index, 1);
        }
    };
    Tool.randomT = function (e, n) {
        return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e));
    };
    Tool.removeReapty = function (arr) {
        var obj = {};
        for (var i = arr.length - 1; i >= 0; i--) {
            if (obj[arr[i]]) {
                arr.splice(i, 1);
            }
            else {
                obj[arr[i]] = true;
            }
        }
    };
    Tool.getElement = function (type) {
        var obj = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.ELEMENT);
        if (!obj) {
            obj = new Element_1.Element(type);
        }
        else {
            obj.reset(type);
        }
        return obj;
    };
    Tool.getRectMask = function () {
        var rect = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.RECT_MASK);
        if (!rect)
            rect = new RectMask_1.RectMask();
        return rect;
    };
    Tool.returnTO = function (num) {
        var length = num.toString().length;
        var arr = [];
        var a;
        for (var i = 0; i < length; i++) {
            a = (num % Math.pow(10, i + 1)) / Math.pow(10, i);
            arr.push(parseInt(a));
        }
        return arr;
    };
    Tool.getForwardRotation = function (fromPoint, toPoint) {
        var deltaX = toPoint[0] - fromPoint[0];
        var deltaY = toPoint[1] - fromPoint[1];
        var vec1 = [1, 0];
        var vec2 = [deltaX, deltaY];
        var a = Math.sqrt(vec1[0] * vec1[0] + vec1[1] * vec1[1]);
        var b = Math.sqrt(vec2[0] * vec2[0] + vec2[1] * vec2[1]);
        var ab = vec1[0] * vec2[0] + vec1[1] * vec2[1];
        var cos = ab / (a * b);
        var r = Math.acos(cos);
        if (deltaY < 0) {
            r = Math.PI * 2 - r;
        }
        return r;
    };
    Tool.getRandomArrayElements = function (arr, count) {
        var shuffled = arr.slice(0), i = arr.length, min = i - count, temp, index;
        if (min <= 0)
            return shuffled;
        while (i-- > min) {
            index = Math.floor((i + 1) * Math.random());
            temp = shuffled[index];
            shuffled[index] = shuffled[i];
            shuffled[i] = temp;
        }
        return shuffled.slice(min);
    };
    Tool.getRandomArrayElementsEx = function (arr, count) {
        if (arr.length <= count)
            return arr.slice();
        if (count <= 0)
            return [];
        var arrCopy = arr.slice();
        var outArr = [];
        while (count--) {
            var rand = Math.floor(Math.random() * arrCopy.length);
            var ele = arrCopy.splice(rand, 1)[0];
            outArr.push(ele);
        }
        return outArr;
    };
    Tool.latDeltaTime = 90;
    Tool.rowNum = 9;
    Tool.colNum = 9;
    Tool.width = 80;
    Tool.height = 80;
    Tool.radius = 10;
    Tool.rcToIndexMap = {};
    Tool.indexToRcMap = [];
    Tool.rowColPositions = {};
    Tool.indexPositions = [];
    Tool.indexToRcMap10 = [];
    Tool.indexPositions10 = [];
    Tool.ExplosiveMatchArr = [
        [-1, -1], [0, -1], [1, -1],
        [-1, 0], [1, 0],
        [-1, 1], [0, 1], [1, 1],
    ];
    return Tool;
}());
exports.Tool = Tool;


/***/ }),

/***/ "./src/something/anis/BonusShootAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/BonusShootAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
exports.stepPosition = [375, 60];
var BonusShootAni = (function (_super) {
    __extends(BonusShootAni, _super);
    function BonusShootAni() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("bonusShoot.png");
        _this.shoot = new FYGE.Sprite(texture);
        _this.shoot.anchorTexture.set(78 / 95, 0.5);
        _this.addChild(_this.shoot);
        var arr = [];
        for (var i = 0; i <= 11; i++)
            arr.push(RES_1.RES.getRes("bonusFra" + i + ".png"));
        _this.imageAni = new FYGE.FrameAni(arr);
        _this.addChild(_this.imageAni);
        _this.imageAni.visible = false;
        return _this;
    }
    BonusShootAni.prototype.reset = function () {
        this.shoot.visible = true;
        this.imageAni.visible = false;
        this.x = exports.stepPosition[0];
        this.y = exports.stepPosition[1];
    };
    BonusShootAni.prototype.play = function (p, callback) {
        var _this = this;
        this.reset();
        this.shoot.rotation = Tool_1.Tool.getForwardRotation(exports.stepPosition, p) * 180 / Math.PI;
        FYGE.Tween.get(this)
            .to({ x: p[0], y: p[1] }, 300)
            .call(function () {
            callback();
            _this.shoot.visible = false;
            _this.imageAni.visible = true;
            _this.imageAni.play(1, function () {
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                ;
                Pool_1.Pool.recover(RecoverName_1.RecoverName.BONUSSHOOT_ANI, _this);
            });
        });
    };
    return BonusShootAni;
}(FYGE.Container));
exports.BonusShootAni = BonusShootAni;


/***/ }),

/***/ "./src/something/anis/BoomAni.ts":
/*!***************************************!*\
  !*** ./src/something/anis/BoomAni.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var BoomAni = (function (_super) {
    __extends(BoomAni, _super);
    function BoomAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.BOOM_ANI;
        var arr = [];
        for (var i = 0; i <= 20; i++) {
            arr.push(RES_1.RES.getRes("boom" + i + ".png"));
        }
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    BoomAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return BoomAni;
}(Ani_1.Ani));
exports.BoomAni = BoomAni;


/***/ }),

/***/ "./src/something/anis/BubbleAni.ts":
/*!*****************************************!*\
  !*** ./src/something/anis/BubbleAni.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var baseEleWidth = 80;
var baseEleHeight = 80;
var time = 300;
var BubbleAni = (function (_super) {
    __extends(BubbleAni, _super);
    function BubbleAni() {
        var _this = _super.call(this) || this;
        _this.eleFrom = new FYGE.Sprite();
        _this.eleFrom.x = -baseEleWidth / 2;
        _this.eleFrom.y = -baseEleHeight / 2;
        _this.eleFrom.visible = false;
        _this.addChild(_this.eleFrom);
        _this.eleTarget = new FYGE.Sprite();
        _this.eleTarget.x = -baseEleWidth / 2;
        _this.eleTarget.y = -baseEleHeight / 2;
        _this.eleTarget.visible = false;
        _this.addChild(_this.eleTarget);
        var arr = [];
        for (var i = 1; i <= 19; i++) {
            arr.push(RES_1.RES.getRes("bubbleStar" + i + ".png"));
        }
        _this.bubbleAni = new FYGE.FrameAni(arr);
        _this.bubbleAni.visible = false;
        _this.addChild(_this.bubbleAni);
        return _this;
    }
    BubbleAni.prototype.play = function (fromType, targetType, callback) {
        var _this = this;
        this.eleFrom.texture = RES_1.RES.getRes("bubleEle" + fromType + ".png");
        this.eleFrom.visible = true;
        this.eleFrom.alpha = 1;
        this.eleTarget.texture = RES_1.RES.getRes("bubleEle" + targetType + ".png");
        this.eleTarget.visible = true;
        this.eleTarget.alpha = 0;
        FYGE.Tween.get(this)
            .to({ scaleX: 0.96, scaleY: 1.02 }, 100)
            .to({ scaleX: 1.02, scaleY: 0.98 }, 100)
            .to({ scaleX: 0.98, scaleY: 1.02 }, 100)
            .to({ scaleX: 1, scaleY: 1 }, 100)
            .call(function () {
            _this.bubbleAni.visible = true;
            _this.bubbleAni.play(1, function () {
                _this.bubbleAni.visible = false;
            });
            FYGE.Tween.get(_this.eleTarget)
                .to({ alpha: 1 }, 600)
                .call(function () {
                FYGE.Tween.get(_this.eleFrom)
                    .to({ alpha: 0 }, 100)
                    .call(function () {
                    if (_this.parent) {
                        _this.parent.removeChild(_this);
                    }
                    ;
                    Pool_1.Pool.recover(RecoverName_1.RecoverName.BUBBLE_ANI, _this);
                    callback();
                });
            });
        });
    };
    return BubbleAni;
}(FYGE.Container));
exports.BubbleAni = BubbleAni;


/***/ }),

/***/ "./src/something/anis/CrossAni.ts":
/*!****************************************!*\
  !*** ./src/something/anis/CrossAni.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var CrossAni = (function (_super) {
    __extends(CrossAni, _super);
    function CrossAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.CROSS_ANI;
        _this.showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage);
        _this.showImage.anchorTexture.set(0.5, 0.5);
        _this.showImage.scaleY = 0.1;
        _this.showImage2 = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage2);
        _this.showImage2.anchorTexture.set(0.5, 0.5);
        _this.showImage2.scaleY = 0.1;
        _this.showImage2.rotation = 90;
        return _this;
    }
    CrossAni.prototype.play = function () {
        var _this = this;
        this.showImage.scaleY = 0.1;
        this.showImage.alpha = 1;
        this.showImage2.scaleY = 0.1;
        this.showImage2.alpha = 1;
        FYGE.Tween.get(this.showImage)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100);
        FYGE.Tween.get(this.showImage2)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)
            .call(function () {
            _this.recover();
        });
    };
    return CrossAni;
}(Ani_1.Ani));
exports.CrossAni = CrossAni;


/***/ }),

/***/ "./src/something/anis/EggBrokenAni.ts":
/*!********************************************!*\
  !*** ./src/something/anis/EggBrokenAni.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var offsetX = 91 / 2;
var offsetY = 62 / 2;
var EggBrokenAni = (function (_super) {
    __extends(EggBrokenAni, _super);
    function EggBrokenAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.EGGBROKEN_ANI;
        var arr = ["yellowCircleDown.png", "yellowCircleUp.png", "eggPiece1.png", "eggPiece2.png", "eggPiece3.png", "eggPiece4.png", "eggPiece5.png"];
        var objs = ["downCircle", "upCircle", "eggPiece1", "eggPiece2", "eggPiece3", "eggPiece4", "eggPiece5"];
        for (var i = 0; i < arr.length; i++) {
            var texture = RES_1.RES.getRes(arr[i]);
            var obj = new FYGE.Sprite(texture);
            _this.addChild(obj);
            obj.anchorTexture.set(0.5, 0.5);
            _this[objs[i]] = obj;
        }
        return _this;
    }
    EggBrokenAni.prototype.play = function () {
        var _this = this;
        this.alpha = 1;
        FYGE.Tween.get(this.downCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .to({ scaleX: 0.6, scaleY: 0.6 }, 300, FYGE.Ease.cubicOut);
        FYGE.Tween.get(this.downCircle)
            .set({ alpha: 1 })
            .wait(140)
            .to({ alpha: 0 }, 160);
        FYGE.Tween.get(this.upCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .wait(70)
            .to({ scaleX: 1, scaleY: 1 }, 160, FYGE.Ease.cubicOut);
        FYGE.Tween.get(this.upCircle)
            .set({ alpha: 1 })
            .wait(170)
            .to({ alpha: 0 }, 100);
        FYGE.Tween.get(this.eggPiece1)
            .set({ rotation: 0, x: 37 - offsetX, y: 22 - offsetY })
            .to({ rotation: 60, x: 37 - offsetX - 30, y: 22 - offsetY - 34 }, 400);
        FYGE.Tween.get(this.eggPiece2)
            .set({ rotation: 0, x: 48 - offsetX, y: 20 - offsetY })
            .to({ rotation: 60, x: 48 - offsetX + 36, y: 20 - offsetY - 28 }, 400);
        FYGE.Tween.get(this.eggPiece3)
            .set({ rotation: 0, x: 52 - offsetX, y: 32 - offsetY })
            .to({ rotation: 60, x: 52 - offsetX + 30, y: 32 - offsetY + 10 }, 400);
        FYGE.Tween.get(this.eggPiece4)
            .set({ rotation: 0, x: 45 - offsetX, y: 44 - offsetY })
            .to({ rotation: 60, x: 45 - offsetX + 32, y: 44 - offsetY + 38 }, 400);
        FYGE.Tween.get(this.eggPiece5)
            .set({ rotation: 0, x: 34 - offsetX, y: 34 - offsetY })
            .to({ rotation: 60, x: 34 - offsetX - 20, y: 34 - offsetY + 14 }, 400);
        FYGE.Tween.get(this)
            .wait(250)
            .to({ alpha: 0 }, 150)
            .call(function () {
            _this.recover();
        });
    };
    return EggBrokenAni;
}(Ani_1.Ani));
exports.EggBrokenAni = EggBrokenAni;


/***/ }),

/***/ "./src/something/anis/EleDisAni.ts":
/*!*****************************************!*\
  !*** ./src/something/anis/EleDisAni.ts ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
function EleDisAni(type) {
    var arr = [];
    for (var i = 0; i <= 14; i++) {
        arr.push(RES_1.RES.getRes("dis_" + "ele" + type + "_" + i + ".png"));
    }
    var frameAni = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.FRAME_ANI);
    if (!frameAni) {
        frameAni = new FYGE.FrameAni(arr);
    }
    else {
        frameAni.resetTexturesAll(arr);
    }
    frameAni.play(1, function () {
        if (frameAni.parent) {
            frameAni.parent.removeChild(frameAni);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.FRAME_ANI, frameAni);
        }
    });
    return frameAni;
}
exports.EleDisAni = EleDisAni;


/***/ }),

/***/ "./src/something/anis/EleDownAni.ts":
/*!******************************************!*\
  !*** ./src/something/anis/EleDownAni.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
function EleDownAni(eleC, p, wait, con, isUp, deltaTime, callback) {
    if (isUp === void 0) { isUp = false; }
    var ele = Tool_1.Tool.getElement(eleC.type);
    ele.effectType = eleC.effectType;
    ele.x = p[0];
    ele.y = p[1] - Tool_1.Tool.height * (isUp ? 0 : 1);
    FYGE.Tween.get(ele)
        .wait(wait)
        .call(function () {
        con.addChild(ele);
    })
        .to({ x: p[0], y: p[1] + Tool_1.Tool.height * (isUp ? 1 : 0) }, deltaTime)
        .call(function () {
        con.removeChild(ele);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, ele);
        callback && callback();
    });
}
exports.EleDownAni = EleDownAni;


/***/ }),

/***/ "./src/something/anis/EleMaskAni.ts":
/*!******************************************!*\
  !*** ./src/something/anis/EleMaskAni.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
function EleMaskAni(eleC, p, wait, con, isUp, deltaTime, callback) {
    if (isUp === void 0) { isUp = false; }
    var ele = Tool_1.Tool.getElement(eleC.type);
    ele.effectType = eleC.effectType;
    ele.x = p[0];
    ele.y = p[1] - Tool_1.Tool.height * (isUp ? 0 : 1);
    var mask = Tool_1.Tool.getRectMask();
    mask.x = p[0];
    mask.y = p[1];
    ele.mask = mask;
    con.addChild(mask);
    FYGE.Tween.get(ele)
        .wait(wait)
        .call(function () {
        con.addChild(ele);
    })
        .to({ x: p[0], y: p[1] + Tool_1.Tool.height * (isUp ? 1 : 0) }, deltaTime)
        .call(function () {
        con.removeChild(ele);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, ele);
        ele.mask = null;
        mask.recover();
        callback && callback();
    });
}
exports.EleMaskAni = EleMaskAni;


/***/ }),

/***/ "./src/something/anis/FlyTargetAni.ts":
/*!********************************************!*\
  !*** ./src/something/anis/FlyTargetAni.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var BitmapRecycle_1 = __webpack_require__(/*! ../class/BitmapRecycle */ "./src/something/class/BitmapRecycle.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
function FlyTargetAni(type, fromP, targetP, callback) {
    var texture = RES_1.RES.getRes("ele" + type + ".png");
    var eleC = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BITMAPRECYCLE);
    if (!eleC) {
        eleC = new BitmapRecycle_1.BitmapRecycle(texture);
    }
    else {
        eleC.reset(texture);
    }
    eleC.x = fromP[0];
    eleC.y = fromP[1];
    FYGE.Tween.get(eleC)
        .to({ x: targetP[0], y: targetP[1], scaleX: 0.7, scaleY: 0.7 }, 500 + (Math.random() * 100) >> 0)
        .call(function () {
        if (eleC.parent) {
            eleC.parent.removeChild(eleC);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.BITMAPRECYCLE, eleC);
        }
        callback();
    });
    return eleC;
}
exports.FlyTargetAni = FlyTargetAni;


/***/ }),

/***/ "./src/something/anis/HairballBrownDivideAni.ts":
/*!******************************************************!*\
  !*** ./src/something/anis/HairballBrownDivideAni.ts ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var offsetX = 80 / 2;
var offsetY = 80 / 2;
var HairballBrownDivideAni = (function (_super) {
    __extends(HairballBrownDivideAni, _super);
    function HairballBrownDivideAni() {
        var _this = _super.call(this) || this;
        _this.startHairball = new Hairball();
        _this.startHairball.brownFace.visible = false;
        _this.startHairball.x = -offsetX;
        _this.startHairball.y = -offsetY;
        _this.addChild(_this.startHairball);
        _this.endHairball = new Hairball();
        _this.endHairball.x = -offsetX;
        _this.endHairball.y = -offsetY;
        _this.addChild(_this.endHairball);
        return _this;
    }
    HairballBrownDivideAni.prototype.reset = function () {
        this.startHairball.eyesDown.scaleY = 1.5;
        this.startHairball.visible = false;
        this.endHairball.x = -offsetX;
        this.endHairball.y = -offsetY;
        this.endHairball.brownFace.visible = true;
        this.endHairball.greyFace.alpha = 0;
    };
    HairballBrownDivideAni.prototype.play = function (startP, endP, callback) {
        var _this = this;
        this.reset();
        var oriEyeX = 23;
        var oriEyeY = 33;
        var obj = { x: -offsetX, y: -offsetY };
        var eyeObj = { x: oriEyeX, y: oriEyeY };
        if (Math.abs(endP[0] - startP[0]) <= 0.001 && Math.abs(endP[1] - startP[1]) <= 0.001) {
        }
        else if (Math.abs(endP[0] - startP[0]) <= 0.001) {
            if (endP[1] - startP[1] > 0) {
                obj.y += Tool_1.Tool.height;
                eyeObj.y += 4;
            }
            else {
                obj.y -= Tool_1.Tool.height;
                eyeObj.y -= 4;
            }
        }
        else {
            if (endP[0] - startP[0] > 0) {
                obj.x += Tool_1.Tool.width;
                eyeObj.x += 4;
            }
            else {
                obj.x -= Tool_1.Tool.width;
                eyeObj.x -= 4;
            }
        }
        this.x = startP[0];
        this.y = startP[1];
        var tweenPosAll = FYGE.Tween.get(this.endHairball);
        for (var i = 0; i < 5; i++) {
            tweenPosAll.to({ x: -offsetX - 1 }, 20)
                .to({ x: -offsetX + 2 }, 20)
                .to({ x: -offsetX }, 20);
        }
        tweenPosAll.call(function () {
            _this.startHairball.visible = true;
        });
        tweenPosAll.to(obj, 200);
        FYGE.Tween.get(this.endHairball.greyFace)
            .wait(100)
            .to({ alpha: 1 }, 100)
            .call(function () {
            _this.endHairball.brownFace.visible = false;
        });
        FYGE.Tween.get(this.endHairball.eyesDown)
            .wait(50)
            .to({ scaleY: 1.5 }, 50)
            .wait(420)
            .to({ scaleY: 1 }, 30);
        FYGE.Tween.get(this.startHairball.eyesDown)
            .wait(520)
            .to({ scaleY: 1 }, 30);
        FYGE.Tween.get(this.endHairball.eyes)
            .wait(200)
            .to(eyeObj, 30)
            .wait(290)
            .to({ x: oriEyeX, y: oriEyeY }, 30)
            .call(function () {
            if (_this.parent)
                _this.parent.removeChild(_this);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.HAIRBALLBROWNDIVIDE_ANI, _this);
            callback();
        });
    };
    return HairballBrownDivideAni;
}(FYGE.Container));
exports.HairballBrownDivideAni = HairballBrownDivideAni;
var Hairball = (function (_super) {
    __extends(Hairball, _super);
    function Hairball() {
        var _this = _super.call(this) || this;
        _this.brownFace = new FYGE.Sprite(RES_1.RES.getRes("brownBallFace.png"));
        _this.addChild(_this.brownFace);
        _this.greyFace = new FYGE.Sprite(RES_1.RES.getRes("greyBallFace.png"));
        _this.addChild(_this.greyFace);
        _this.eyesDown = new EyesDown();
        _this.eyesDown.x = 16;
        _this.eyesDown.y = 29 + 29 / 2;
        _this.addChild(_this.eyesDown);
        _this.eyes = new Eyes();
        _this.eyes.x = 23;
        _this.eyes.y = 33;
        _this.addChild(_this.eyes);
        return _this;
    }
    return Hairball;
}(FYGE.Container));
var Eyes = (function (_super) {
    __extends(Eyes, _super);
    function Eyes() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("eyeSingle.png");
        _this.left = new FYGE.Sprite(texture);
        _this.addChild(_this.left);
        _this.right = new FYGE.Sprite(texture);
        _this.right.x = 23;
        _this.addChild(_this.right);
        return _this;
    }
    return Eyes;
}(FYGE.Container));
var EyesDown = (function (_super) {
    __extends(EyesDown, _super);
    function EyesDown() {
        var _this = _super.call(this) || this;
        _this.left = new FYGE.Sprite(RES_1.RES.getRes("eyeDownLeft.png"));
        _this.left.y = -29 / 2;
        _this.addChild(_this.left);
        _this.right = new FYGE.Sprite(RES_1.RES.getRes("eyeDownRight.png"));
        _this.right.x = 45 - 16;
        _this.right.y = -29 / 2;
        _this.addChild(_this.right);
        return _this;
    }
    return EyesDown;
}(FYGE.Container));


/***/ }),

/***/ "./src/something/anis/HairballGreyDisAni.ts":
/*!**************************************************!*\
  !*** ./src/something/anis/HairballGreyDisAni.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var offsetX = 120 / 2;
var offsetY = 120 / 2;
var config = [
    {
        "name": "hairballPiece1",
        "x": 57,
        "y": 70,
    },
    {
        "name": "hairballPiece2",
        "x": 23,
        "y": 71,
    },
    {
        "name": "hairballPiece3",
        "x": 61,
        "y": 63,
    },
    {
        "name": "hairballPiece4",
        "x": 22,
        "y": 64,
    },
    {
        "name": "hairballPiece5",
        "x": 71,
        "y": 49,
    },
    {
        "name": "hairballPiece6",
        "x": 42,
        "y": 55,
    },
    {
        "name": "hairballPiece7",
        "x": 23,
        "y": 44,
    },
    {
        "name": "hairballPiece8",
        "x": 59,
        "y": 26,
    },
    {
        "name": "hairballPiece9",
        "x": 23,
        "y": 26,
    },
];
var HairballGreyDisAni = (function (_super) {
    __extends(HairballGreyDisAni, _super);
    function HairballGreyDisAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.HAIRBALLGREYDIS_ANI;
        _this.pieces = [];
        for (var i = 0; i < config.length; i++) {
            var bitmap = _this.addChild(new FYGE.Sprite(RES_1.RES.getRes(config[i].name + ".png")));
            _this.pieces.push(bitmap);
        }
        _this.upBg = _this.addChild(new FYGE.Sprite(RES_1.RES.getRes("hairballDisBg.png")));
        _this.upBg.anchorTexture.set(0.5, 0.5);
        _this.reset();
        return _this;
    }
    HairballGreyDisAni.prototype.reset = function () {
        for (var i = 0; i < config.length; i++) {
            this.pieces[i].x = config[i].x - offsetX;
            this.pieces[i].y = config[i].y - offsetY;
            this.pieces[i].alpha = 1;
        }
        this.upBg.scaleX = this.upBg.scaleY = 1;
        this.upBg.alpha = 1;
    };
    HairballGreyDisAni.prototype.play = function () {
        var _this = this;
        this.reset();
        FYGE.Tween.get(this.upBg)
            .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
            .to({ scaleX: 1, scaleY: 1, alpha: 0 }, 160)
            .call(function () {
            var _loop_1 = function (i) {
                var p = _this.pieces[i];
                var y = config[i].y;
                FYGE.Tween.get(p)
                    .wait(i * 30)
                    .to({ y: y + 6 }, 170);
                FYGE.Tween.get(p)
                    .wait(i * 30 + 100)
                    .to({ alpha: 0 }, 50)
                    .call(function () {
                    if (i == config.length - 1) {
                        _this.recover();
                    }
                });
            };
            for (var i = 0; i < config.length; i++) {
                _loop_1(i);
            }
        });
    };
    return HairballGreyDisAni;
}(Ani_1.Ani));
exports.HairballGreyDisAni = HairballGreyDisAni;


/***/ }),

/***/ "./src/something/anis/HairballJumpAni.ts":
/*!***********************************************!*\
  !*** ./src/something/anis/HairballJumpAni.ts ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var StateType_1 = __webpack_require__(/*! ../enum/StateType */ "./src/something/enum/StateType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var HairballJumpAni = (function (_super) {
    __extends(HairballJumpAni, _super);
    function HairballJumpAni() {
        return _super.call(this) || this;
    }
    HairballJumpAni.prototype.play = function (type, startP, endP, callback) {
        var _this = this;
        var source;
        switch (type) {
            case StateType_1.StateType.HAIRBALLBLACK:
                source = "ele" + ElementType_1.ElementType.HAIRBALLBLACK + ".png";
                break;
            case StateType_1.StateType.HAIRBALLGREY:
                source = "ele" + ElementType_1.ElementType.HAIRBALLGREY + ".png";
                break;
            case StateType_1.StateType.HAIRBALLBROWN:
                source = "ele" + ElementType_1.ElementType.HAIRBALLBROWN + ".png";
                break;
            default:
                source = "ele" + ElementType_1.ElementType.HAIRBALLGREY + ".png";
                break;
        }
        var texture = RES_1.RES.getRes(source);
        this.texture = texture;
        this.anchorTexture.set(0.5, 1);
        this.x = startP[0];
        this.y = startP[1] + texture.height / 2;
        FYGE.Tween.get(this)
            .to({ scaleX: 1.2, scaleY: 0.8 }, 50)
            .to({ scaleX: 0.8, scaleY: 1.2 }, 50)
            .to({ scaleX: 1, scaleY: 1 }, 50)
            .to({ scaleX: 1.2, scaleY: 0.8 }, 50)
            .to({ scaleX: 0.8, scaleY: 1.2 }, 50)
            .to({ scaleX: 1, scaleY: 1 }, 50)
            .call(function () {
            if (_this.parent)
                _this.parent.removeChild(_this);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.HAIRBALLJUMP_ANI, _this);
            callback();
        });
        FYGE.Tween.get(this)
            .to({ x: endP[0], y: endP[1] + texture.height / 2 }, 300, FYGE.Ease.sineInOut);
    };
    return HairballJumpAni;
}(FYGE.Sprite));
exports.HairballJumpAni = HairballJumpAni;


/***/ }),

/***/ "./src/something/anis/HatchAni.ts":
/*!****************************************!*\
  !*** ./src/something/anis/HatchAni.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var BitmapRecycle_1 = __webpack_require__(/*! ../class/BitmapRecycle */ "./src/something/class/BitmapRecycle.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
function HatchAni(startIndex, endIndexs, thisObj, callback) {
    var countAll = endIndexs.length;
    var count = 0;
    var startP = Tool_1.Tool.getPositionByIndex(startIndex);
    var _loop_1 = function (i) {
        var endIndex = endIndexs[i];
        var endP = Tool_1.Tool.getPositionByIndex(endIndex);
        texture = RES_1.RES.getRes("ele" + ElementType_1.ElementType.CHICKEN + ".png");
        var eleC = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BITMAPRECYCLE);
        if (!eleC) {
            eleC = new BitmapRecycle_1.BitmapRecycle(texture);
        }
        else {
            eleC.reset(texture);
        }
        eleC.x = startP[0];
        eleC.y = startP[1];
        eleC.scaleX = eleC.scaleY = 0.7;
        thisObj.addChild(eleC);
        paraCurveAni(eleC, startP, endP, function () {
            thisObj.removeChild(eleC);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.BITMAPRECYCLE, eleC);
            thisObj.lattices[endIndex].element.reset(ElementType_1.ElementType.CHICKEN);
            if (++count == countAll)
                callback();
        });
    };
    var texture;
    for (var i = 0; i < endIndexs.length; i++) {
        _loop_1(i);
    }
}
exports.HatchAni = HatchAni;
var deltaTime = 500;
var gravity = 0.003;
function paraCurveAni(ele, startP, endP, callback) {
    var deltaX = endP[0] - startP[0];
    var deltaY = endP[1] - startP[1];
    var vy0 = deltaY / deltaTime - gravity * deltaTime / 2;
    var a = { t: 0 };
    FYGE.Tween.get(a, {
        onChange: function () {
            ele.x = deltaX * a.t / deltaTime + startP[0];
            ele.y = vy0 * a.t + gravity * a.t * a.t / 2 + startP[1];
        }
    })
        .to({ t: deltaTime }, deltaTime)
        .call(function () {
        callback();
    });
    var rotation;
    if (deltaX > 0) {
        rotation = 360;
    }
    else if (deltaX < 0) {
        rotation = -360;
    }
    else {
        rotation = 0;
    }
    FYGE.Tween.get(ele)
        .set({ scaleX: 0.3, scaleY: 0.3, rotation: 0 })
        .to({ scaleX: 1, scaleY: 1, rotation: rotation }, deltaTime);
}


/***/ }),

/***/ "./src/something/anis/HorizontalAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/HorizontalAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var HorizontalAni = (function (_super) {
    __extends(HorizontalAni, _super);
    function HorizontalAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.HORIZONTAL_ANI;
        _this.showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage);
        _this.showImage.anchorTexture.set(0.5, 0.5);
        _this.showImage.scaleY = 0.1;
        _this.showImage.rotation = 90;
        return _this;
    }
    HorizontalAni.prototype.play = function () {
        var _this = this;
        this.showImage.scaleY = 0.1;
        this.showImage.alpha = 1;
        FYGE.Tween.get(this.showImage)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)
            .call(function () {
            _this.recover();
        });
    };
    return HorizontalAni;
}(Ani_1.Ani));
exports.HorizontalAni = HorizontalAni;


/***/ }),

/***/ "./src/something/anis/IceAni.ts":
/*!**************************************!*\
  !*** ./src/something/anis/IceAni.ts ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var IceAni = (function (_super) {
    __extends(IceAni, _super);
    function IceAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.ICE_ANI;
        var arr = [];
        arr.push(RES_1.RES.getRes("ele" + ElementType_1.ElementType.ICE + ".png"));
        for (var i = 2; i <= 6; i++)
            arr.push(RES_1.RES.getRes("ice" + i + ".png"));
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    IceAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return IceAni;
}(Ani_1.Ani));
exports.IceAni = IceAni;


/***/ }),

/***/ "./src/something/anis/JellyDisAni.ts":
/*!*******************************************!*\
  !*** ./src/something/anis/JellyDisAni.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var JellyDisAni = (function (_super) {
    __extends(JellyDisAni, _super);
    function JellyDisAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.JELLYDIS_ANI;
        var arr = ["ele" + ElementType_1.ElementType.JELLY + ".png", "greenCircleDown.png", "greenCircleUp.png"];
        var objs = ["showImage", "downCircle", "upCircle"];
        for (var i = 0; i < arr.length; i++) {
            var texture = RES_1.RES.getRes(arr[i]);
            var obj = new FYGE.Sprite(texture);
            _this.addChild(obj);
            obj.anchorTexture.set(0.5, 0.5);
            _this[objs[i]] = obj;
        }
        return _this;
    }
    JellyDisAni.prototype.play = function () {
        var _this = this;
        FYGE.Tween.get(this.showImage)
            .set({ alpha: 1 })
            .to({ alpha: 0 }, 250 * 1.5);
        FYGE.Tween.get(this.downCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .to({ scaleX: 0.6, scaleY: 0.6 }, 300 * 1.5, FYGE.Ease.cubicOut)
            .call(function () {
            _this.recover();
        });
        FYGE.Tween.get(this.downCircle)
            .set({ alpha: 1 })
            .wait(140 * 1.5)
            .to({ alpha: 0 }, 160 * 1.5);
        FYGE.Tween.get(this.upCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .wait(70 * 1.5)
            .to({ scaleX: 1, scaleY: 1 }, 160 * 1.5, FYGE.Ease.cubicOut);
        FYGE.Tween.get(this.upCircle)
            .set({ alpha: 1 })
            .wait(170 * 1.5)
            .to({ alpha: 0 }, 100 * 1.5);
    };
    return JellyDisAni;
}(Ani_1.Ani));
exports.JellyDisAni = JellyDisAni;


/***/ }),

/***/ "./src/something/anis/JellySpreadAni.ts":
/*!**********************************************!*\
  !*** ./src/something/anis/JellySpreadAni.ts ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var JellySpreadAni = (function (_super) {
    __extends(JellySpreadAni, _super);
    function JellySpreadAni() {
        var _this = _super.call(this) || this;
        var texture = RES_1.RES.getRes("ele" + ElementType_1.ElementType.JELLY + ".png");
        _this.targetImage = new FYGE.Sprite(texture);
        _this.targetImage.anchorTexture.set(0.5, 0.5);
        _this.addChild(_this.targetImage);
        _this.oriImage = new FYGE.Sprite(texture);
        _this.oriImage.anchorTexture.set(0.5, 0.5);
        _this.addChild(_this.oriImage);
        _this.shoot = new FYGE.Sprite(RES_1.RES.getRes("jellyArrow.png"));
        _this.shoot.anchorTexture.set(0, 0.5);
        _this.addChild(_this.shoot);
        return _this;
    }
    JellySpreadAni.prototype.play = function (startP, cloneEle, callback) {
        var _this = this;
        this.x = startP[0];
        this.y = startP[1];
        var endP = [cloneEle.x, cloneEle.y];
        this.addChildAt(cloneEle, 0);
        this.shoot.visible = true;
        this.shoot.x = 0;
        this.shoot.y = 0;
        this.shoot.scaleX = this.shoot.scaleY = 0.01;
        this.targetImage.visible = false;
        var obj = { scaleX: 0.01, scaleY: 0.01, x: 0, y: 0 };
        if (Math.abs(endP[0] - startP[0]) <= 0.001) {
            if (endP[1] - startP[1] > 0) {
                this.shoot.rotation = 90;
                this.targetImage.x = 0;
                this.targetImage.y = Tool_1.Tool.height;
                obj.y = Tool_1.Tool.height;
            }
            else {
                this.shoot.rotation = 270;
                this.targetImage.x = 0;
                this.targetImage.y = -Tool_1.Tool.height;
                obj.y = -Tool_1.Tool.height;
            }
        }
        else {
            if (endP[0] - startP[0] > 0) {
                this.shoot.rotation = 0;
                this.targetImage.x = Tool_1.Tool.width;
                this.targetImage.y = 0;
                obj.x = Tool_1.Tool.width;
            }
            else {
                this.shoot.rotation = 180;
                this.targetImage.x = -Tool_1.Tool.width;
                this.targetImage.y = 0;
                obj.x = -Tool_1.Tool.width;
            }
        }
        cloneEle.x = this.targetImage.x;
        cloneEle.y = this.targetImage.y;
        FYGE.Tween.get(this.oriImage)
            .to({ scaleX: 1.07, scaleY: 0.89 }, 150)
            .to({ scaleX: 0.91, scaleY: 1.07 }, 150)
            .to({ scaleX: 1.07, scaleY: 0.89 }, 100)
            .to({ scaleX: 0.93, scaleY: 1.06 }, 100)
            .to({ scaleX: 1.07, scaleY: 0.93 }, 100)
            .to({ scaleX: 1, scaleY: 1 }, 100);
        FYGE.Tween.get(this.shoot)
            .to({ scaleX: 2, scaleY: 1 }, 230)
            .to(obj, 50)
            .call(function () {
            _this.removeChild(cloneEle);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, cloneEle);
            callback();
            _this.shoot.visible = false;
            _this.targetImage.visible = true;
            FYGE.Tween.get(_this.targetImage)
                .to({ scaleX: 1.07, scaleY: 0.89 }, 150)
                .to({ scaleX: 0.91, scaleY: 1.07 }, 150)
                .to({ scaleX: 1.07, scaleY: 0.89 }, 100)
                .to({ scaleX: 0.93, scaleY: 1.06 }, 100)
                .to({ scaleX: 1.07, scaleY: 0.93 }, 100)
                .to({ scaleX: 1, scaleY: 1 }, 100)
                .call(function () {
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                ;
                Pool_1.Pool.recover(RecoverName_1.RecoverName.JELLYSPREAD_ANI, _this);
            });
        });
    };
    return JellySpreadAni;
}(FYGE.Container));
exports.JellySpreadAni = JellySpreadAni;


/***/ }),

/***/ "./src/something/anis/MagicLionAni.ts":
/*!********************************************!*\
  !*** ./src/something/anis/MagicLionAni.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var FrameAni = FYGE.FrameAni;
var MagicLionAni = (function (_super) {
    __extends(MagicLionAni, _super);
    function MagicLionAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.MAGICLION_ANI;
        _this.downImage = new FYGE.Container();
        _this.addChild(_this.downImage);
        var texture = RES_1.RES.getRes("magicLionBg.png");
        var one = new FYGE.Sprite(texture);
        one.anchorTexture.set(0.5, 0.5);
        _this.downImage.addChild(one);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            one.rotation -= 5;
        }, _this);
        var other = new FYGE.Sprite(texture);
        other.anchorTexture.set(0.5, 0.5);
        _this.downImage.addChild(other);
        _this.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            other.rotation += 5;
        }, _this);
        var magicAniActiveTexture = [];
        for (var i = 0; i <= 16; i++) {
            magicAniActiveTexture.push(RES_1.RES.getRes("MagicAniActive_" + i + ".png"));
        }
        _this.magicAniActive = _this.addChild(new FrameAni(magicAniActiveTexture));
        _this.upImage = new FYGE.Sprite(RES_1.RES.getRes("magicLion.png"));
        _this.upImage.anchorTexture.set(0.5, 0.5);
        _this.addChild(_this.upImage);
        return _this;
    }
    MagicLionAni.prototype.play = function () {
        var _this = this;
        this.magicAniActive.play(1);
        this.downImage.scaleX = this.downImage.scaleY = 0.7;
        this.downImage.alpha = 1;
        this.upImage.scaleX = this.upImage.scaleY = 1;
        this.upImage.alpha = 1;
        FYGE.Tween.get(this.downImage)
            .to({ scaleX: 2, scaleY: 2 }, 400)
            .to({ scaleX: 1.2, scaleY: 1.2 }, 300)
            .wait(450)
            .to({ alpha: 0, scaleX: 0.2, scaleY: 0.2 }, 100)
            .call(function () {
            _this.recover();
        });
        FYGE.Tween.get(this.upImage)
            .to({ scaleX: 1.7, scaleY: 1.7 }, 350)
            .wait(300)
            .to({ scaleX: 0, scaleY: 0, alpha: 0 }, 300);
    };
    return MagicLionAni;
}(Ani_1.Ani));
exports.MagicLionAni = MagicLionAni;


/***/ }),

/***/ "./src/something/anis/MagicRotateAni.ts":
/*!**********************************************!*\
  !*** ./src/something/anis/MagicRotateAni.ts ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var BitmapRecycle_1 = __webpack_require__(/*! ../class/BitmapRecycle */ "./src/something/class/BitmapRecycle.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var pi = Math.PI;
var pi2 = pi * 2;
function MagicRotateAni(ele, p, con) {
    var eleC = Pool_1.Pool.takeOut(RecoverName_1.RecoverName.BITMAPRECYCLE);
    var texture = RES_1.RES.getRes("ele" + ele.type + ".png");
    if (!eleC) {
        eleC = new BitmapRecycle_1.BitmapRecycle(texture);
    }
    else {
        eleC.reset(texture);
    }
    eleC.x = ele.x;
    eleC.y = ele.y;
    con.addChild(eleC);
    var tAll = 60;
    var deltaX = eleC.x - p[0];
    var deltaY = eleC.y - p[1];
    var dis = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    var vec0 = [1, 0];
    var vec1 = [deltaX, deltaY];
    var rotation = getRotByTwoVectors(vec0, vec1);
    if (deltaY > 0) {
        rotation = pi2 - rotation;
    }
    var a = { t: 0 };
    FYGE.Tween.get(a, {
        onChange: function () {
            var r = dis * (1 - a.t / tAll);
            var theta = a.t / tAll * pi;
            var x = r * Math.cos(theta);
            var y = r * Math.sin(theta);
            var xy = rotationAcodPoint([x, y], rotation);
            eleC.x = xy[0] + p[0];
            eleC.y = xy[1] + p[1];
            eleC.alpha = eleC.scaleX = eleC.scaleY = 1 - a.t / tAll;
        }
    })
        .to({ t: 60 }, 800, FYGE.Ease.quadIn)
        .call(function () {
        con.removeChild(eleC);
        Pool_1.Pool.recover(RecoverName_1.RecoverName.BITMAPRECYCLE, eleC);
    });
}
exports.MagicRotateAni = MagicRotateAni;
function rotationAcodPoint(p, rotation, point) {
    if (point === void 0) { point = [0, 0]; }
    var xp = p[0] - point[0];
    var yp = p[1] - point[1];
    var x = xp * Math.cos(rotation) + yp * Math.sin(rotation);
    var y = yp * Math.cos(rotation) - xp * Math.sin(rotation);
    return [x, y];
}
function getRotByTwoVectors(vec1, vec2) {
    var a = Math.sqrt(vec1[0] * vec1[0] + vec1[1] * vec1[1]);
    var b = Math.sqrt(vec2[0] * vec2[0] + vec2[1] * vec2[1]);
    var ab = vec1[0] * vec2[0] + vec1[1] * vec2[1];
    var cos = ab / (a * b);
    return Math.acos(cos);
}
exports.getRotByTwoVectors = getRotByTwoVectors;


/***/ }),

/***/ "./src/something/anis/PieceToEggAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/PieceToEggAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var offsetX = 91 / 2;
var offsetY = 62 / 2;
var PieceToEggAni = (function (_super) {
    __extends(PieceToEggAni, _super);
    function PieceToEggAni() {
        var _this = _super.call(this) || this;
        var arr = ["ele" + ElementType_1.ElementType.CHICKEN_EGG + ".png", "eggPiece1.png", "eggPiece2.png", "eggPiece3.png", "eggPiece4.png", "eggPiece5.png"];
        var objs = ["showImage", "eggPiece1", "eggPiece2", "eggPiece3", "eggPiece4", "eggPiece5"];
        for (var i = 0; i < arr.length; i++) {
            var texture = RES_1.RES.getRes(arr[i]);
            var obj = new FYGE.Sprite(texture);
            _this.addChild(obj);
            obj.anchorTexture.set(0.5, 0.5);
            _this[objs[i]] = obj;
        }
        return _this;
    }
    PieceToEggAni.prototype.play = function (p, callback) {
        var _this = this;
        this.x = p[0];
        this.y = p[1];
        this.showImage.alpha = 0;
        FYGE.Tween.get(this.showImage)
            .wait(250)
            .to({ alpha: 1 }, 150);
        this.alpha = 0;
        FYGE.Tween.get(this)
            .to({ alpha: 1 }, 150);
        FYGE.Tween.get(this.eggPiece1)
            .set({ rotation: 60, x: 37 - offsetX - 30, y: 22 - offsetY - 34 })
            .to({ rotation: 0, x: 37 - offsetX, y: 22 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece2)
            .set({ rotation: 60, x: 48 - offsetX + 36, y: 20 - offsetY - 28 })
            .to({ rotation: 0, x: 48 - offsetX, y: 20 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece3)
            .set({ rotation: 60, x: 52 - offsetX + 30, y: 32 - offsetY + 10 })
            .to({ rotation: 0, x: 52 - offsetX, y: 32 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece4)
            .set({ rotation: 60, x: 45 - offsetX + 32, y: 44 - offsetY + 38 })
            .to({ rotation: 0, x: 45 - offsetX, y: 44 - offsetY }, 400);
        FYGE.Tween.get(this.eggPiece5)
            .set({ rotation: 60, x: 34 - offsetX - 20, y: 34 - offsetY + 14 })
            .to({ rotation: 0, x: 34 - offsetX, y: 34 - offsetY }, 400)
            .call(function () {
            callback();
            if (_this.parent) {
                _this.parent.removeChild(_this);
            }
            ;
            Pool_1.Pool.recover(RecoverName_1.RecoverName.PIECETOEGG_ANI, _this);
        });
    };
    return PieceToEggAni;
}(FYGE.Container));
exports.PieceToEggAni = PieceToEggAni;


/***/ }),

/***/ "./src/something/anis/RockAni.ts":
/*!***************************************!*\
  !*** ./src/something/anis/RockAni.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RockAni = (function (_super) {
    __extends(RockAni, _super);
    function RockAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.ROCK_ANI;
        var arr = [];
        arr.push(RES_1.RES.getRes("ele" + ElementType_1.ElementType.ROCK + ".png"));
        for (var i = 2; i <= 6; i++)
            arr.push(RES_1.RES.getRes("rock" + i + ".png"));
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    RockAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return RockAni;
}(Ani_1.Ani));
exports.RockAni = RockAni;


/***/ }),

/***/ "./src/something/anis/ScoreAni.ts":
/*!****************************************!*\
  !*** ./src/something/anis/ScoreAni.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ScoreAni = (function (_super) {
    __extends(ScoreAni, _super);
    function ScoreAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.SCORE_ANI;
        _this.scoreNumber = new FYGE.BitmapText({});
        _this.addChild(_this.scoreNumber);
        return _this;
    }
    Object.defineProperty(ScoreAni.prototype, "score", {
        get: function () {
            return this._score;
        },
        set: function (value) {
            if (this._score == value)
                return;
            this._score = value;
            this.scoreNumber.text = "" + value;
        },
        enumerable: true,
        configurable: true
    });
    ScoreAni.prototype.play = function () {
        var _this = this;
        this.scoreNumber.y = 0;
        this.scoreNumber.alpha = 1;
        FYGE.Tween.get(this.scoreNumber)
            .to({ y: -50, alpha: 0 }, 1000)
            .call(function () {
            _this.recover();
        });
    };
    return ScoreAni;
}(Ani_1.Ani));
exports.ScoreAni = ScoreAni;


/***/ }),

/***/ "./src/something/anis/StepAni.ts":
/*!***************************************!*\
  !*** ./src/something/anis/StepAni.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var StepAni = (function (_super) {
    __extends(StepAni, _super);
    function StepAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.STEP_ANI;
        var arr = [];
        for (var i = 1; i <= 11; i++) {
            arr.push(RES_1.RES.getRes("stepAni" + i + ".png"));
        }
        _this.showImage = new FYGE.FrameAni(arr);
        _this.addChild(_this.showImage);
        return _this;
    }
    StepAni.prototype.play = function () {
        var _this = this;
        this.showImage.reset(0);
        this.showImage.play(1, function () {
            _this.recover();
        });
    };
    return StepAni;
}(Ani_1.Ani));
exports.StepAni = StepAni;


/***/ }),

/***/ "./src/something/anis/ThreeCrossAni.ts":
/*!*********************************************!*\
  !*** ./src/something/anis/ThreeCrossAni.ts ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var ThreeCrossAni = (function (_super) {
    __extends(ThreeCrossAni, _super);
    function ThreeCrossAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.THREECROSS_ANI;
        for (var i = 1; i < 4; i++) {
            var showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
            _this.addChild(showImage);
            showImage.anchorTexture.set(0.5, 0.5);
            showImage.x = (i - 2) * Tool_1.Tool.height;
            showImage.scaleY = 0.1;
            _this["showImage" + i] = showImage;
        }
        for (var i = 4; i < 7; i++) {
            var showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
            _this.addChild(showImage);
            showImage.anchorTexture.set(0.5, 0.5);
            showImage.y = (i - 5) * Tool_1.Tool.width;
            showImage.scaleY = 0.1;
            showImage.rotation = 90;
            _this["showImage" + i] = showImage;
        }
        return _this;
    }
    ThreeCrossAni.prototype.play = function () {
        var _this = this;
        for (var i = 1; i < 7; i++) {
            this["showImage" + i].scaleY = 0.1;
            this["showImage" + i].alpha = 1;
            if (i == 6) {
                FYGE.Tween.get(this["showImage" + i])
                    .to({ scaleY: 1.2 }, 300)
                    .to({ alpha: 0 }, 100)
                    .call(function () {
                    _this.recover();
                });
            }
            else {
                FYGE.Tween.get(this["showImage" + i])
                    .to({ scaleY: 1.2 }, 300)
                    .to({ alpha: 0 }, 100);
            }
        }
    };
    return ThreeCrossAni;
}(Ani_1.Ani));
exports.ThreeCrossAni = ThreeCrossAni;


/***/ }),

/***/ "./src/something/anis/VerticalAni.ts":
/*!*******************************************!*\
  !*** ./src/something/anis/VerticalAni.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Ani_1 = __webpack_require__(/*! ../class/Ani */ "./src/something/class/Ani.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var VerticalAni = (function (_super) {
    __extends(VerticalAni, _super);
    function VerticalAni() {
        var _this = _super.call(this) || this;
        _this.aniName = RecoverName_1.RecoverName.VERTICAL_ANI;
        _this.showImage = new FYGE.Sprite(RES_1.RES.getRes("lineLight.png"));
        _this.addChild(_this.showImage);
        _this.showImage.anchorTexture.set(0.5, 0.5);
        _this.showImage.scaleY = 0.1;
        return _this;
    }
    VerticalAni.prototype.play = function () {
        var _this = this;
        this.showImage.scaleY = 0.1;
        this.showImage.alpha = 1;
        FYGE.Tween.get(this.showImage)
            .to({ scaleY: 1.2 }, 300)
            .to({ alpha: 0 }, 100)
            .call(function () {
            _this.recover();
        });
    };
    return VerticalAni;
}(Ani_1.Ani));
exports.VerticalAni = VerticalAni;


/***/ }),

/***/ "./src/something/anisCall/DoorChangeAni.ts":
/*!*************************************************!*\
  !*** ./src/something/anisCall/DoorChangeAni.ts ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Door_1 = __webpack_require__(/*! ../class/Door */ "./src/something/class/Door.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var DoorChangeAni = (function (_super) {
    __extends(DoorChangeAni, _super);
    function DoorChangeAni(lat) {
        var _this = _super.call(this) || this;
        var door = lat.door;
        if (!door) { }
        var textureBg = RES_1.RES.getRes(Door_1.doorBgImages[door.statusNum]);
        _this.doorBg = new FYGE.Sprite(textureBg);
        _this.doorBg.x = -textureBg.width / 2;
        _this.doorBg.y = -textureBg.height / 2;
        _this.addChild(_this.doorBg);
        var textureDoor = RES_1.RES.getRes(Door_1.doorImages[door.closed ? 0 : 1]);
        _this.door = new FYGE.Sprite(textureDoor);
        _this.door.x = -textureDoor.width / 2;
        _this.door.y = -textureDoor.height / 2;
        _this.addChild(_this.door);
        _this.addIce(lat.ice);
        _this.addEle(lat.element);
        return _this;
    }
    DoorChangeAni.prototype.reset = function (lat) {
        this.resetDoor(lat.door);
        this.addIce(lat.ice);
        this.addEle(lat.element);
    };
    DoorChangeAni.prototype.play = function (lat, callback) {
        var _this = this;
        var isClosed = lat.door.closed;
        this.reset(lat);
        var p = Tool_1.Tool.getPositionByIndex(lat.index);
        this.x = p[0];
        this.y = p[1];
        if (this.ice)
            this.ice.visible = !isClosed;
        if (this.ele)
            this.ele.visible = !isClosed;
        FYGE.Tween.get(this)
            .to({ scaleX: 0 }, 300)
            .call(function () {
            _this.door.texture = RES_1.RES.getRes(Door_1.doorImages[isClosed ? 1 : 0]);
            if (_this.ice)
                _this.ice.visible = isClosed;
            if (_this.ele)
                _this.ele.visible = isClosed;
            FYGE.Tween.get(_this)
                .to({ scaleX: 1 }, 300)
                .call(function () {
                callback();
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                Pool_1.Pool.recover(RecoverName_1.RecoverName.DOORCHANGE_ANI, _this);
            });
        });
    };
    DoorChangeAni.prototype.resetDoor = function (door) {
        this.doorBg.texture = RES_1.RES.getRes(Door_1.doorBgImages[door.statusNum]);
        this.door.texture = RES_1.RES.getRes(Door_1.doorImages[door.closed ? 0 : 1]);
    };
    DoorChangeAni.prototype.addIce = function (ice) {
        if (ice) {
            if (!this.ice) {
                var textureIce = RES_1.RES.getRes("ele" + ElementType_1.ElementType.ICE + ".png");
                this.ice = new FYGE.Sprite(textureIce);
                this.ice.x = -textureIce.width / 2;
                this.ice.y = -textureIce.height / 2;
                this.addChildAt(this.ice, 2);
            }
            this.ice.alpha = ice.countNum == 2 ? 1 : 0.6;
        }
        else if (this.ice) {
            this.removeChild(this.ice);
            this.ice = null;
        }
    };
    DoorChangeAni.prototype.addEle = function (ele) {
        if (ele) {
            if (!this.ele) {
                this.ele = Tool_1.Tool.getElement(ele.type);
                this.ele.x = 0;
                this.ele.y = 0;
                this.addChild(this.ele);
            }
            this.ele.copy(ele);
        }
        else if (this.ele) {
            this.removeChild(this.ele);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.ELEMENT, this.ele);
            this.ele = null;
        }
    };
    return DoorChangeAni;
}(FYGE.Container));
exports.DoorChangeAni = DoorChangeAni;


/***/ }),

/***/ "./src/something/anisCall/FesRedBombShowAni.ts":
/*!*****************************************************!*\
  !*** ./src/something/anisCall/FesRedBombShowAni.ts ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var FesRedBombShowAni = (function (_super) {
    __extends(FesRedBombShowAni, _super);
    function FesRedBombShowAni() {
        var _this = _super.call(this) || this;
        var down = new FYGE.Sprite(RES_1.RES.getRes("fesRedDown.png"));
        down.anchorTexture.set(0.5, 0.5);
        _this.addChild(down);
        var textureDown = RES_1.RES.getRes("fesRedBombSta1.png");
        var up = new FYGE.Sprite(textureDown);
        up.anchorTexture.set(0.5, 0.5);
        _this.addChild(up);
        return _this;
    }
    FesRedBombShowAni.prototype.play = function (position, callback) {
        var _this = this;
        this.scaleX = this.scaleY = 0.29;
        this.x = position[0];
        this.y = position[1];
        FYGE.Tween.get(this)
            .wait(200)
            .to({ scaleX: 1, scaleY: 1 }, 500, FYGE.Ease.backOut)
            .wait(500)
            .to({ scaleX: 0.29, scaleY: 0.29 }, 500, FYGE.Ease.backInOut)
            .call(function () {
            if (_this.parent)
                _this.parent.removeChild(_this);
            Pool_1.Pool.recover(RecoverName_1.RecoverName.FESREDBOMBSHOW_ANI, _this);
            callback();
        });
    };
    return FesRedBombShowAni;
}(FYGE.Container));
exports.FesRedBombShowAni = FesRedBombShowAni;


/***/ }),

/***/ "./src/something/anisCall/FesRedShootAni.ts":
/*!**************************************************!*\
  !*** ./src/something/anisCall/FesRedShootAni.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Pool_1 = __webpack_require__(/*! ../Pool */ "./src/something/Pool.ts");
var RecoverName_1 = __webpack_require__(/*! ../enum/RecoverName */ "./src/something/enum/RecoverName.ts");
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var FesRedShootAni = (function (_super) {
    __extends(FesRedShootAni, _super);
    function FesRedShootAni() {
        var _this = _super.call(this) || this;
        _this.light = new LightingAni();
        _this.addChild(_this.light);
        var arr = [];
        for (var i = 1; i <= 10; i++) {
            arr.push(RES_1.RES.getRes("fesEleSmallDis" + i + ".png"));
        }
        _this.imageAniCon = new FYGE.Container();
        _this.imageAni = new FYGE.FrameAni(arr);
        _this.imageAniCon.addChild(_this.imageAni);
        _this.addChild(_this.imageAniCon);
        _this.imageAni.visible = false;
        return _this;
    }
    FesRedShootAni.prototype.reset = function () {
        this.light.visible = true;
        this.imageAni.visible = false;
        this.light.scaleX = 0.2;
    };
    FesRedShootAni.prototype.play = function (startP, ele, callback) {
        var _this = this;
        this.reset();
        this.light.visible = true;
        var r = Tool_1.Tool.getForwardRotation(startP, [ele.x, ele.y]);
        this.light.rotation = r * 180 / Math.PI;
        this.light.x = startP[0];
        this.light.y = startP[1];
        this.imageAniCon.x = ele.x;
        this.imageAniCon.y = ele.y;
        var dis = Math.sqrt((startP[0] - ele.x) * (startP[0] - ele.x) +
            (startP[1] - ele.y) * (startP[1] - ele.y));
        var scaleX = dis / 247;
        FYGE.Tween.get(this.light)
            .to({ scaleX: scaleX, }, 400)
            .call(function () {
            ele.reset(ElementType_1.ElementType.FESTIVALELE_SMALL);
            ele.scaleX = ele.scaleY = 0.1;
            FYGE.Tween.get(ele)
                .to({ scaleX: 1, scaleY: 1 }, 500, FYGE.Ease.backOut);
            callback();
            _this.imageAni.visible = true;
            _this.imageAni.play(1, function () {
                if (_this.parent) {
                    _this.parent.removeChild(_this);
                }
                Pool_1.Pool.recover(RecoverName_1.RecoverName.FESREDSHOOT_ANI, _this);
            });
            setTimeout(function () {
                _this.light.visible = false;
            }, 200);
        });
    };
    return FesRedShootAni;
}(FYGE.Container));
exports.FesRedShootAni = FesRedShootAni;
var LightingAni = (function (_super) {
    __extends(LightingAni, _super);
    function LightingAni() {
        var _this = _super.call(this) || this;
        var arr = [];
        for (var i = 1; i <= 13; i++) {
            arr.push(RES_1.RES.getRes("lineLight" + i + ".png"));
        }
        _this.anchorTexture.set(23 / 293, 27 / 58);
        _this.sourceAll = arr;
        _this.texture = _this.sourceAll[0];
        _this.currentFrame = 0;
        _this.totalFrames = arr.length;
        _this.addEventListener(FYGE.Event.ENTER_FRAME, _this.onEnterFrame, _this);
        _this.startTime = Date.now();
        _this.allTime = _this.sourceAll.length / 30 * 1000;
        return _this;
    }
    LightingAni.prototype.onEnterFrame = function () {
        if (!this.stage)
            return;
        var dataNow = Date.now();
        var deltaTime = dataNow - this.startTime;
        var scale = deltaTime / this.allTime;
        if (scale >= 1) {
            this.startTime = Date.now();
            this.currentFrame = 0;
        }
        else {
            this.currentFrame = (scale * this.sourceAll.length) >> 0;
        }
        this.texture = this.sourceAll[this.currentFrame];
    };
    return LightingAni;
}(FYGE.Sprite));


/***/ }),

/***/ "./src/something/anisCall/RectsWaveAni.ts":
/*!************************************************!*\
  !*** ./src/something/anisCall/RectsWaveAni.ts ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Tool_1 = __webpack_require__(/*! ../Tool */ "./src/something/Tool.ts");
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var whiteRectPool = [];
function RectsWaveAni(lattices, container, callback, centerIndex) {
    if (centerIndex === void 0) { centerIndex = 40; }
    var loops = [];
    var rc = Tool_1.Tool.indexToRc(centerIndex);
    var num = 0;
    var maxNum = Math.max(rc[0], rc[1], Tool_1.Tool.rowNum - rc[0] - 1, Tool_1.Tool.colNum - rc[1] - 1);
    while (num <= maxNum) {
        var indexs = [];
        if (num) {
            var rowMax = rc[0] + num;
            var rowMin = rc[0] - num;
            var colMax = rc[1] + num;
            var colMin = rc[1] - num;
            var colIndexs = rangeIndexs(colMin >= 0 ? colMin : 0, colMax < Tool_1.Tool.colNum ? colMax : Tool_1.Tool.colNum - 1);
            var rowIndexs = rangeIndexs(rowMin >= 0 ? rowMin : 0, rowMax < Tool_1.Tool.rowNum ? rowMax : Tool_1.Tool.rowNum - 1, false);
            if (rowMin >= 0) {
                for (var i = 0; i < colIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowMin, colIndexs[i]);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
            if (rowMax < Tool_1.Tool.rowNum) {
                for (var i = 0; i < colIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowMax, colIndexs[i]);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
            if (colMin >= 0) {
                for (var i = 0; i < rowIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowIndexs[i], colMin);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
            if (colMax < Tool_1.Tool.colNum) {
                for (var i = 0; i < rowIndexs.length; i++) {
                    var index = Tool_1.Tool.rcToIndex(rowIndexs[i], colMax);
                    if (lattices[index])
                        indexs.push(index);
                }
            }
        }
        else {
            indexs.push(centerIndex);
        }
        var loop = [];
        for (var i = 0; i < indexs.length; i++) {
            var index = indexs[i];
            var p = Tool_1.Tool.getPositionByIndex(index);
            var rect = whiteRectPool.shift();
            if (!rect)
                rect = new WhiteRect();
            rect.alpha = 0;
            rect.x = p[0];
            rect.y = p[1];
            container.addChild(rect);
            loop.push(rect);
        }
        loops.push(loop);
        num++;
    }
    for (var m = loops.length - 1; m >= 0; m--) {
        if (!loops[m].length) {
            loops.pop();
        }
        else {
            break;
        }
    }
    var loopsLen = loops.length;
    var _loop_1 = function (m) {
        var loop_1 = loops[m];
        var wait = m * 100;
        var loopLen = loop_1.length;
        var _loop_2 = function (n) {
            var rect = loop_1[n];
            FYGE.Tween.get(rect)
                .wait(wait)
                .to({ alpha: 1 }, 150)
                .to({ alpha: 0 }, 150)
                .call(function () {
                if (rect.parent) {
                    rect.parent.removeChild(rect);
                    whiteRectPool.push(rect);
                }
                if (m == loopsLen - 1 && n == loopLen - 1 && callback)
                    callback();
            });
        };
        for (var n = 0; n < loop_1.length; n++) {
            _loop_2(n);
        }
    };
    for (var m = 0; m < loops.length; m++) {
        _loop_1(m);
    }
}
exports.RectsWaveAni = RectsWaveAni;
var WhiteRect = (function (_super) {
    __extends(WhiteRect, _super);
    function WhiteRect() {
        var _this = _super.call(this) || this;
        _this.texture = RES_1.RES.getRes("rectLatWhite.png");
        _this.anchorTexture.set(0.5, 0.5);
        return _this;
    }
    return WhiteRect;
}(FYGE.Sprite));
function rangeIndexs(min, max, include) {
    if (include === void 0) { include = true; }
    var nums = [];
    if (include)
        nums.push(min);
    var num = min;
    while (++num < max)
        nums.push(num);
    if (include)
        nums.push(max);
    return nums;
}


/***/ }),

/***/ "./src/something/chapters/Chapter1.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter1.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var PassType_1 = __webpack_require__(/*! ../enum/PassType */ "./src/something/enum/PassType.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
exports.Chapters1 = [
    null,
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 45,
                },
            ],
        },
        starScores: [1000, 5000, 10000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 11, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 20, 0, 0, 0, 20, 0, 0,
                0, 20, 10, 20, 0, 20, 10, 20, 0,
                20, 10, 20, 10, 20, 10, 20, 10, 20,
                20, 10, 20, 20, 10, 20, 20, 10, 20,
                0, 20, 10, 20, 10, 20, 10, 20, 0,
                0, 0, 20, 10, 20, 10, 20, 0, 0,
                0, 0, 0, 20, 10, 20, 0, 0, 0,
                0, 0, 0, 0, 20, 0, 0, 0, 0,
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 6,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 26,
                },
            ],
        },
        starScores: [100, 500, 950],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                2, 2, 2, 2, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 2, 2, 0, 0, 0, 1, 1, 0,
                1, 2, 2, 1, 0, 1, 2, 2, 1,
                0, 2, 2, 0, 0, 0, 2, 2, 0,
                2, 2, 2, 2, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 10, 0, 0, 0, 10, 20, 0,
                20, 20, 10, 20, 0, 10, 20, 10, 20,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 40, 30, 0, 0, 0, 10, 30, 0,
                10, 30, 40, 20, 0, 20, 30, 40, 10,
                0, 40, 30, 0, 0, 0, 40, 30, 0,
                20, 20, 10, 10, 0, 20, 40, 20, 10,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 20,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ROCK,
                    count: 19
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                0, 0, 2, 1, 2, 1, 2, 0, 0,
                0, 0, 1, 2, 1, 2, 1, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 10, 10, 20, 10, 10, 0, 0,
                0, 0, 30, 40, 10, 40, 40, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 10, 2, 2, 0, 0,
                0, 0, 2, 10, 2, 10, 2, 0, 0,
                0, 0, 10, 2, 10, 2, 10, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 24
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.RABBIT,
                    count: 35
                },
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 35
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 10, 20, 10, 20, 10, 20, 10, 0,
                0, 20, 10, 20, 30, 20, 10, 20, 0,
                0, 10, 0, 10, 20, 30, 0, 10, 0,
                0, 20, 10, 20, 30, 1, 1, 1, 0,
                40, 50, 40, 50, 30, 40, 50, 40, 50,
                0, 20, 10, 20, 10, 30, 10, 20, 0,
                0, 10, 0, 10, 30, 10, 0, 10, 0,
                0, 20, 10, 20, 10, 20, 10, 20, 0,
                0, 10, 20, 10, 20, 10, 20, 10, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [10, 20, 30, 40] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 17
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 0, 1, 1, 3, 1, 1, 0, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 20, 20, 0, 30, 30, 50, 0,
                0, 40, 30, 30, 40, 10, 10, 30, 0,
                0, 10, 30, 30, 40, 10, 10, 50, 0,
                0, 0, 40, 40, 50, 40, 40, 0, 0,
                0, 30, 20, 20, 40, 50, 50, 20, 0,
                0, 30, 20, 20, 40, 50, 50, 10, 0,
                0, 40, 40, 50, 0, 20, 40, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 24
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 20, 20, 30, 30, 20, 20,
                10, 20, 0, 20, 20, 30, 30, 20, 20,
                10, 20, 0, 10, 10, 40, 40, 10, 10,
                20, 10, 0, 10, 10, 40, 40, 10, 10,
                10, 20, 0, 20, 20, 30, 30, 20, 20,
                20, 10, 0, 20, 20, 30, 30, 20, 20,
                20, 10, 0, 40, 40, 10, 10, 40, 40,
                0, 0, 0, 40, 40, 10, 10, 40, 40,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 9, type: [10, 20], cus: [] },
                { index: 10, type: [10, 20], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [10, 20, 30, 40] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 18
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 0, 0, 0, 1, 0,
                0, 2, 2, 2, 0, 0, 1, 1, 1,
                1, 2, 2, 2, 1, 0, 0, 1, 0,
                0, 2, 2, 2, 1, 1, 0, 1, 0,
                0, 0, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 2, 2, 2, 1,
                0, 1, 0, 0, 1, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 2, 2, 2, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 1, 0, 0, 0, 0, 1, 0,
                0, 1, 1, 1, 0, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 0, 1, 0,
                0, 0, 1, 1, 0, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 10, 0, 0, 0, 0, 10, 0,
                0, 20, 10, 20, 0, 0, 10, 30, 10,
                10, 10, 20, 10, 40, 0, 0, 10, 0,
                0, 10, 20, 10, 40, 40, 0, 10, 0,
                0, 0, 10, 40, 0, 40, 10, 20, 20,
                0, 0, 0, 40, 40, 30, 10, 10, 20,
                0, 10, 0, 0, 40, 10, 20, 10, 10,
                10, 30, 10, 10, 20, 10, 20, 30, 30,
                0, 10, 0, 0, 20, 20, 10, 30, 30,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [40, 40] },
                { index: 7, type: [0], cus: [] },
                { index: 10, type: [0], cus: [30] },
                { index: 12, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
                { index: 18, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
                { index: 55, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 36
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 2, 0, 1, 1, 0, 0, 1, 1,
                2, 2, 0, 2, 2, 1, 1, 2, 2,
                2, 2, 0, 2, 2, 1, 1, 2, 2,
                2, 2, 0, 1, 1, 1, 1, 1, 1,
                2, 2, 0, 1, 1, 1, 1, 1, 1,
                2, 2, 0, 1, 2, 2, 2, 2, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 2, 2, 0, 2, 2, 0, 2,
                2, 0, 2, 2, 0, 2, 2, 0, 2,
            ],
            elements: [
                1, 1, 0, 1, 1, 0, 0, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 0, 1, 1, 0, 1, 1, 0, 1,
                1, 0, 1, 1, 0, 1, 1, 0, 1,
            ],
            baseElements: [
                10, 10, 0, 50, 50, 0, 0, 50, 50,
                10, 10, 0, 40, 40, 30, 30, 20, 20,
                20, 20, 0, 40, 40, 30, 30, 20, 20,
                20, 20, 0, 20, 20, 10, 10, 40, 40,
                30, 30, 0, 20, 20, 10, 10, 40, 40,
                30, 30, 0, 40, 40, 20, 20, 30, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                21, 0, 10, 10, 0, 20, 20, 0, 30,
                33, 0, 10, 10, 0, 20, 20, 0, 30,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
                { index: 68, type: [0], cus: [] },
                { index: 69, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 35
                },
                {
                    type: ElementType_1.ElementType.CATTLE,
                    count: 35
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 0, 30, 20, 30, 20, 30, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 30, 20, 30, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 20, 0, 30, 30, 20, 20, 10, 10,
                0, 20, 0, 30, 30, 20, 20, 10, 10,
                20, 30, 0, 40, 40, 30, 30, 20, 20,
                0, 20, 0, 40, 40, 30, 30, 20, 20,
                0, 20, 0, 10, 10, 20, 20, 10, 10,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 40, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
            ],
            connectedLats: [[3, 21], [4, 22], [5, 23], [6, 24], [7, 25]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 37
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 0, 0, 0, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 3, 3, 3, 3, 3, 3,
                2, 2, 0, 3, 3, 3, 3, 3, 3,
                0, 0, 0, 3, 3, 3, 3, 3, 3,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                1, 0, 0, 0, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                11, 0, 0, 0, 20, 20, 30, 30, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 10, 20, 20, 10, 10,
                0, 0, 0, 40, 40, 50, 50, 40, 40,
                0, 0, 0, 20, 20, 30, 30, 20, 20,
                0, 0, 0, 40, 40, 10, 10, 40, 40,
                11, 13, 0, 50, 50, 30, 30, 50, 50,
                0, 0, 0, 40, 40, 20, 20, 40, 40,
                0, 0, 0, 30, 30, 10, 10, 30, 30,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 5, type: [0], cus: [14, 11, 14] },
                { index: 6, type: [0], cus: [11, 14, 11] },
                { index: 72, type: [0], cus: [] },
                { index: 73, type: [0], cus: [] },
                { index: 21, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 23, type: [0], cus: [] },
                { index: 24, type: [0], cus: [] },
                { index: 25, type: [0], cus: [] },
                { index: 26, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 35
                },
                {
                    type: ElementType_1.ElementType.CATTLE,
                    count: 35
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 14, 20, 0, 0, 0,
                0, 0, 0, 0, 21, 0, 0, 0, 0,
                10, 10, 20, 20, 50, 30, 30, 40, 40,
                10, 10, 20, 20, 50, 30, 30, 40, 40,
                40, 40, 30, 30, 40, 10, 10, 50, 50,
                40, 40, 30, 20, 30, 10, 10, 50, 50,
                0, 0, 0, 0, 30, 0, 0, 0, 0,
                0, 0, 10, 20, 10, 20, 10, 0, 0,
            ],
            generateLats: [
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
                { index: 28, type: [0], cus: [] },
                { index: 29, type: [0], cus: [] },
                { index: 30, type: [0], cus: [] },
                { index: 32, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 74, type: [0], cus: [] },
                { index: 75, type: [0], cus: [] },
                { index: 77, type: [0], cus: [] },
                { index: 78, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 27
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                2, 1, 1, 1, 2, 1, 1, 1, 2,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                2, 1, 2, 1, 1, 1, 1, 1, 2,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 2, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 9, type: [0], cus: [] },
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ROCK,
                    count: 39
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
            ],
            baseElements: [
                0, 0, 0, 10, 20, 10, 0, 0, 0,
                0, 0, 0, 20, 10, 20, 0, 0, 0,
                0, 0, 0, 10, 20, 10, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
                { index: 28, type: [0], cus: [] },
                { index: 29, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 18
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 20, 10, 2, 20, 10, 20, 0,
                0, 20, 10, 20, 2, 10, 20, 10, 0,
                0, 10, 20, 10, 2, 20, 10, 20, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 27
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 1, 2, 2, 2, 1, 0, 0,
                0, 1, 1, 2, 2, 2, 1, 1, 0,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                0, 1, 1, 2, 2, 2, 1, 1, 0,
                0, 0, 1, 2, 2, 2, 1, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 12, 0, 0, 0, 0,
                0, 0, 0, 12, 20, 12, 0, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 1, 3, 1, 3, 1, 3, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 2, 3, 2, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
            ],
            baseElements: [
                0, 10, 3, 10, 3, 10, 3, 10, 0,
                0, 20, 30, 20, 30, 20, 30, 20, 0,
                0, 2, 2, 2, 3, 2, 2, 2, 0,
                0, 2, 2, 2, 20, 2, 2, 2, 0,
                0, 2, 2, 20, 30, 40, 2, 2, 0,
                0, 2, 2, 2, 20, 2, 2, 2, 0,
                0, 2, 2, 2, 30, 2, 2, 2, 0,
                0, 2, 2, 40, 20, 30, 2, 2, 0,
                0, 0, 2, 2, 30, 2, 2, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
            recycles: [74, 75, 76, 77, 78, 70, 64]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 0, 1, 3, 1, 3, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
            recycles: [54, 62, 73, 74, 75, 76, 77, 78, 79],
            connectedLats: [[29, 47], [30, 48], [32, 50], [33, 51]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 33
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 32,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                1, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                1, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 0, 1,
            ],
            elements: [
                0, 3, 0, 3, 0, 3, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                0, 2, 0, 2, 0, 2, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 1, 2, 1, 2, 1, 2, 0, 1,
                1, 2, 1, 2, 1, 2, 1, 0, 1,
            ],
            baseElements: [
                0, 3, 0, 3, 0, 3, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                0, 2, 0, 2, 0, 2, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 22, 2, 22, 2, 22, 2, 0, 13,
                22, 2, 22, 2, 22, 2, 22, 0, 11,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
            ],
            recycles: [72, 73, 74, 77, 75, 76, 78]
        },
    },
];


/***/ }),

/***/ "./src/something/chapters/Chapter2.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter2.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var PassType_1 = __webpack_require__(/*! ../enum/PassType */ "./src/something/enum/PassType.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
exports.Chapters2 = [
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 56
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 0, 0, 0, 1, 1, 1,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ROCK,
                    count: 40
                },
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 50
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                2, 2, 1, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 1, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 1, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 1, 2, 2
            ],
            baseElements: [
                0, 0, 31, 0, 24, 0, 31, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 31, 20, 0, 0, 0,
                0, 0, 0, 0, 20, 0, 0, 0, 0,
                2, 2, 30, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 30, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 30, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 30, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 30, 2, 2
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 38, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
            ],
            connectedLats: [[2, 21], [4, 22], [6, 23]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 22,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.LOLLIPOP,
                    count: 12
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 1, 2, 1, 2, 1, 2, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 0, 3, 0, 3, 0, 3, 0, 0,
                0, 10, 2, 30, 2, 20, 2, 10, 0,
                0, 30, 2, 30, 2, 20, 2, 10, 0,
                0, 20, 2, 20, 2, 10, 2, 30, 0,
                0, 10, 2, 20, 2, 10, 2, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                40, 40, 50, 40, 50, 40, 50, 40, 40,
                0, 50, 40, 50, 40, 50, 40, 50, 0,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 64, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
                { index: 67, type: [0], cus: [] },
                { index: 68, type: [0], cus: [] },
                { index: 69, type: [0], cus: [] },
                { index: 70, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
            ],
            recycles: [46, 47, 48, 49, 50, 51, 52]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 37,
        passTarget: {
            type: 1,
            elements: [
                {
                    type: 9,
                    count: 31
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 0, 2, 2, 1, 0, 3, 3, 3,
                2, 0, 0, 0, 0, 0, 3, 3, 3,
                0, 0, 0, 0, 0, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
            ],
            elements: [
                1, 0, 2, 2, 2, 0, 2, 0, 2,
                1, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 0, 2, 0,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
            ],
            baseElements: [
                11, 0, 2, 2, 2, 0, 2, 0, 2,
                23, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 0, 2, 0,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [33] },
                { index: 3, type: [0], cus: [21] },
                { index: 4, type: [0], cus: [] },
            ],
            connectedLats: [[2, 29], [3, 30], [4, 31], [74, 6], [75, 7], [76, 8]]
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.RABBIT,
                    count: 42
                },
                {
                    type: ElementType_1.ElementType.CHICKEN,
                    count: 42
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                4, 4, 1, 1, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
            ],
            baseElements: [
                12, 13, 20, 10, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
                33, 32, 0, 10, 20, 10, 20, 10, 20,
                32, 41, 0, 20, 10, 20, 10, 20, 10,
                42, 23, 0, 10, 20, 10, 20, 10, 20,
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 21, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 23, type: [0], cus: [] },
                { index: 24, type: [0], cus: [] },
                { index: 25, type: [0], cus: [] },
                { index: 26, type: [0], cus: [] },
                { index: 30, type: [0], cus: [] },
                { index: 31, type: [0], cus: [] },
                { index: 32, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 40, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
                { index: 48, type: [0], cus: [] },
                { index: 49, type: [0], cus: [] },
                { index: 50, type: [0], cus: [] },
                { index: 51, type: [0], cus: [] },
                { index: 52, type: [0], cus: [] },
                { index: 53, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 5,
                    count: 8
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 1, 1, 4, 1, 1, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 4, 1, 4, 1, 4, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 4, 1, 4, 1, 4, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 14, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 31, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 4, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 48
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 0, 1, 1, 0, 0,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                1, 1, 3, 3, 1, 3, 3, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
            ],
            elements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 1, 0, 0, 1, 0, 0, 1, 2,
                1, 2, 1, 0, 1, 0, 1, 2, 1,
            ],
            baseElements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 3, 0, 0, 2,
                2, 32, 0, 0, 22, 0, 0, 32, 2,
                32, 2, 32, 0, 23, 0, 32, 2, 32,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 45, type: [0], cus: [] },
                { index: 53, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 25
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 4, 4, 4, 4, 4, 4, 4, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 3, 0, 0, 2,
                2, 32, 0, 0, 22, 0, 0, 32, 2,
                32, 2, 32, 0, 23, 0, 32, 2, 32,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 21
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 3, 3, 3, 1, 2, 2, 2, 1,
                1, 1, 1, 3, 1, 2, 1, 2, 1,
                1, 3, 3, 3, 1, 2, 2, 2, 1,
                1, 3, 1, 1, 1, 1, 1, 2, 1,
                1, 3, 3, 3, 1, 1, 1, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 4, 4, 4, 1,
                1, 1, 1, 1, 1, 4, 1, 4, 1,
                1, 1, 1, 1, 1, 4, 4, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 4, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 42, 0, 32, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 23, 0, 12, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 9, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 6,
                    count: 7
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 0, 1, 0, 1, 0, 0, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                3, 0, 3, 0, 3, 0, 0, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                0, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
            ],
            recycles: [72, 73, 74, 75, 76, 77, 78, 79]
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 24
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
            ],
            elements: [
                4, 4, 4, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 4, 4, 4, 4, 4, 0, 0,
                0, 0, 4, 4, 1, 4, 4, 0, 0,
                0, 2, 2, 2, 4, 2, 2, 2, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
            ],
            baseElements: [
                30, 20, 30, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 50, 50, 40, 50, 50, 0, 0,
                0, 0, 40, 40, 50, 40, 40, 0, 0,
                0, 2, 2, 2, 50, 2, 2, 2, 1,
                1, 1, 2, 2, 40, 2, 2, 1, 1,
                1, 1, 2, 2, 44, 2, 2, 1, 1,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 66
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 0, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
            ],
            elements: [
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 4, 4, 4, 4, 4, 4,
                4, 4, 0, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 0, 1, 0, 1, 0, 1, 0,
            ],
            baseElements: [
                0, 0, 0, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 30, 20, 30, 20, 30, 20,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                50, 50, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                53, 42, 0, 32, 0, 32, 0, 32, 0,
            ],
            generateLats: [
                { index: 36, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: 6,
                    count: 6
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 1, 1, 1,
                0, 0, 0, 0, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 4, 4, 4, 4, 4,
                3, 3, 3, 0, 4, 4, 4, 4, 4,
                4, 4, 4, 0, 1, 4, 4, 4, 4,
                4, 4, 4, 0, 1, 4, 4, 4, 4
            ],
            baseElements: [
                0, 0, 0, 0, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 20, 30, 50, 50, 20,
                0, 0, 0, 0, 30, 20, 30, 20, 30,
                3, 3, 3, 0, 20, 30, 20, 30, 20,
                21, 31, 42, 0, 52, 20, 30, 20, 30,
                20, 31, 41, 0, 51, 30, 20, 30, 20
            ],
            generateLats: [
                { index: 54, type: [0], cus: [] },
                { index: 55, type: [0], cus: [] },
                { index: 56, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 64, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 72, type: [0], cus: [] },
                { index: 73, type: [0], cus: [] },
                { index: 74, type: [0], cus: [] },
            ],
            recycles: [80, 76, 77, 78, 79],
            connectedLats: [[72, 5], [73, 6], [74, 7]]
        },
    },
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 32,
        passTarget: {
            type: PassType_1.PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType_1.ElementType.ICE,
                    count: 64
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
            ],
            elements: [
                2, 2, 0, 0, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 0, 0, 2, 2, 2, 2, 4,
                1, 1, 4, 1, 2, 2, 2, 2, 4,
                4, 1, 0, 0, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 0, 0, 2, 2, 2, 2, 4,
            ],
            baseElements: [
                2, 2, 0, 0, 2, 2, 2, 2, 0,
                2, 2, 51, 52, 2, 2, 2, 2, 0,
                2, 2, 51, 52, 2, 2, 2, 2, 0,
                2, 2, 0, 0, 2, 2, 2, 2, 0,
                40, 30, 41, 23, 2, 2, 2, 2, 0,
                4, 40, 0, 0, 2, 2, 2, 2, 0,
                2, 2, 52, 51, 2, 2, 2, 2, 0,
                2, 2, 52, 51, 2, 2, 2, 2, 0,
                2, 2, 0, 0, 2, 2, 2, 2, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 38, type: [0], cus: [] },
                { index: 46, type: [0], cus: [] },
                { index: 47, type: [0], cus: [] },
            ],
        },
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 27,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 70 }]
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                2, 3, 2, 2, 3, 3, 3, 3, 3,
                2, 2, 2, 2, 3, 3, 3, 3, 3,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                1, 2, 2, 2, 2, 2, 2, 2, 1
            ],
            connectedLats: [[31, 49], [32, 50], [33, 51], [34, 52], [35, 53]],
            elements: [
                1, 1, 1, 1, 4, 4, 4, 4, 4,
                1, 1, 1, 1, 2, 4, 2, 4, 2,
                1, 1, 1, 1, 4, 2, 4, 2, 4,
                1, 1, 1, 1, 2, 4, 2, 4, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 0, 0, 0, 0, 0
            ],
            baseElements: [
                20, 11, 30, 30, 22, 52, 51, 41, 12,
                20, 11, 30, 30, 0, 10, 0, 20, 0,
                11, 40, 0, 0, 30, 0, 30, 0, 30,
                40, 11, 0, 0, 0, 10, 0, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 56, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 45, type: [0], cus: [] },
                { index: 46, type: [0], cus: [] },
                { index: 47, type: [0], cus: [] },
                { index: 48, type: [0], cus: [] },
            ],
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: 1,
            elements: [{ type: 6, count: 16 }],
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0],
            connectedLats: [[29, 47], [33, 51], [39, 46], [41, 52], [28, 57], [34, 59]],
            elements: [
                1, 4, 2, 3, 3, 3, 2, 4, 4,
                1, 4, 2, 3, 3, 3, 2, 4, 2,
                1, 4, 2, 3, 1, 3, 2, 4, 4,
                1, 4, 2, 1, 3, 1, 2, 4, 2,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            baseElements: [20, 0, 30, 30, 22, 52, 51, 0, 12, 20, 0, 30, 30, 0, 10, 0, 0, 0, 11, 0, 0, 0, 10, 0, 30, 0, 30, 40, 0, 0, 10, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [73, 74, 75, 76, 77, 78, 79],
            generateLats: [
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null }
            ]
        }
    },
    {
        baseElementTypes: [2, 1, 3, 4],
        bubbleProbability: 0,
        stepCount: 38,
        passTarget: {
            type: 1,
            elements: [{ type: 6, count: 22 }],
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1
            ],
            connectedLats: [[80, 3], [79, 2], [78, 1], [77, 0]],
            elements: [
                3, 3, 3, 3, 0, 0, 0, 0, 0,
                3, 3, 3, 3, 0, 0, 2, 2, 0,
                4, 4, 4, 4, 0, 0, 2, 2, 1,
                4, 4, 4, 4, 0, 0, 2, 2, 1,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 4,
                4, 4, 4, 4, 0, 2, 2, 2, 4,
                4, 4, 4, 4, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 2, 2, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                30, 20, 30, 20, 0, 0, 0, 0, 11,
                20, 30, 20, 30, 0, 0, 0, 0, 12,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 41,
                10, 40, 40, 10, 0, 0, 0, 0, 43,
                30, 50, 50, 30, 0, 0, 0, 0, 41,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [63, 64, 65, 66],
            generateLats: [{ index: 15, type: 0 }, { index: 16, type: 0 }]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: 1,
            elements: [{ type: 5, count: 12 }]
        },
        starScores: [6000, 12000, 24000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [[32, 50], [33, 51], [34, 52], [35, 53]],
            elements: [
                0, 0, 0, 2, 2, 4, 4, 4, 4,
                0, 0, 0, 0, 2, 4, 4, 4, 4,
                0, 0, 0, 0, 2, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                4, 4, 4, 4, 0, 1, 1, 1, 1,
                2, 2, 2, 2, 0, 1, 1, 1, 1,
                4, 4, 4, 4, 0, 1, 1, 1, 1,
                2, 2, 2, 2, 0, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 30, 50, 20, 30,
                0, 0, 0, 0, 0, 30, 20, 30, 20,
                0, 0, 0, 0, 0, 20, 50, 20, 50,
                0, 0, 0, 0, 0, 12, 30, 12, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                20, 20, 50, 50, 0, 10, 50, 10, 50,
                0, 0, 0, 0, 0, 20, 30, 30, 10,
                10, 10, 20, 20, 0, 10, 20, 20, 10,
                0, 0, 0, 0, 0, 30, 20, 30, 30
            ],
            recycles: [],
            generateLats: [
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [3, 2, 1, 0, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 56 }]
        },
        starScores: [6000, 14000, 25000],
        map: {
            lattices: [2, 0, 2, 0, 2, 2, 0, 2, 0, 0, 3, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 2],
            connectedLats: [],
            elements: [
                1, 0, 2, 0, 2, 1, 0, 1, 0,
                0, 2, 0, 2, 0, 0, 0, 0, 0,
                0, 0, 2, 0, 2, 4, 4, 4, 4,
                0, 2, 0, 2, 0, 4, 4, 4, 1,
                0, 0, 2, 0, 2, 4, 4, 4, 1,
                0, 2, 0, 2, 0, 4, 4, 4, 1,
                0, 0, 2, 0, 2, 4, 4, 4, 1,
                0, 2, 0, 2, 0, 0, 0, 0, 0,
                1, 0, 0, 0, 0, 0, 1, 0, 1
            ],
            baseElements: [
                41, 0, 0, 0, 0, 42, 0, 42, 0,
                0, 0, 40, 0, 40, 0, 0, 0, 0,
                0, 40, 0, 40, 0, 10, 10, 20, 20, 0, 0, 40, 0, 40, 50, 30, 30, 42, 0, 41, 0, 40, 0, 20, 20, 30, 10, 0, 0, 40, 0, 0, 30, 50, 50, 40, 0, 40, 0, 40, 0, 30, 50, 50, 40, 0, 0, 40, 0, 40, 0, 0, 0, 0, 42, 0, 0, 0, 0, 0, 42, 0, 41
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 2, type: 0, cus: [14] },
                { index: 4, type: 0, cus: [14] },
                { index: 5, type: 0 },
                { index: 7, type: 0 },
                { index: 26, type: 0 },
                { index: 25, type: 0 },
                { index: 24, type: 0 },
                { index: 72, type: 0 },
                { index: 78, type: 0 },
                { index: 80, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 54 }]
        },
        starScores: [6000, 15000, 23000],
        map: {
            lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 3, 3, 0, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0],
            connectedLats: [],
            elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 2, 0, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 4, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 2, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 4, 4, 0],
            baseElements: [11, 22, 12, 22, 12, 22, 12, 22, 11, 12, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 10, 10, 40, 0, 0, 0, 0, 0, 40, 10, 20, 40, 50, 0, 0, 0, 50, 40, 20, 20, 30, 50, 10, 0, 10, 50, 30, 20, 0, 30, 30, 10, 20, 10, 30, 30, 0],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 20, type: 0, cus: [14, 14, 14, 14] },
                { index: 21, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 23, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 24, type: 0, cus: [14, 14, 14, 14] },
                { index: 28, type: 0, cus: [14, 14] },
                { index: 31, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 34, type: 0, cus: [14, 14] },
                { index: 36, type: 0 },
                { index: 44, type: 0 }
            ]
        }
    },
];


/***/ }),

/***/ "./src/something/chapters/Chapter3.ts":
/*!********************************************!*\
  !*** ./src/something/chapters/Chapter3.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var PassType_1 = __webpack_require__(/*! ../enum/PassType */ "./src/something/enum/PassType.ts");
var ElementType_1 = __webpack_require__(/*! ../enum/ElementType */ "./src/something/enum/ElementType.ts");
exports.Chapters3 = [
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 20,
        passTarget: { type: 1, elements: [{ type: 9, count: 27 }] },
        starScores: [5000, 12000, 25000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 2, 2, 2, 2, 2, 1, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 2, 5, 2, 2, 0, 0,
                0, 0, 5, 1, 1, 1, 5, 0, 0,
                0, 2, 2, 2, 5, 2, 2, 2, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 10, 0, 0, 0, 0,
                0, 0, 0, 40, 20, 40, 0, 0, 0,
                0, 0, 20, 20, 30, 40, 20, 0, 0,
                0, 20, 40, 30, 20, 30, 30, 10, 0,
                0, 0, 10, 20, 10, 20, 30, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 40, 40, 20, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 13, type: 0 },
                { index: 21, type: 0 },
                { index: 23, type: 0 },
                { index: 29, type: 0 },
                { index: 33, type: 0 },
                { index: 37, type: 0 },
                { index: 43, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 4, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 57 }] },
        starScores: [6000, 15000, 21000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 5, 5, 5, 2, 0, 0,
                0, 2, 5, 2, 2, 2, 5, 2, 0,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                2, 5, 2, 1, 1, 1, 2, 5, 2,
                0, 2, 5, 2, 2, 2, 5, 2, 0,
                0, 0, 2, 5, 5, 5, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0
            ],
            baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 10, 20, 0, 0, 0, 0, 0, 0, 20, 30, 10, 0, 0, 0, 0, 0, 0, 20, 20, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [],
            generateLats: [
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 11, type: 0 },
                { index: 12, type: 0 },
                { index: 13, type: 0 },
                { index: 14, type: 0 },
                { index: 15, type: 0 },
                { index: 19, type: 0 },
                { index: 20, type: 0 },
                { index: 21, type: 0 },
                { index: 22, type: 0 },
                { index: 23, type: 0 },
                { index: 24, type: 0 },
                { index: 25, type: 0 },
                { index: 27, type: 0 },
                { index: 28, type: 0 },
                { index: 29, type: 0 },
                { index: 33, type: 0 },
                { index: 34, type: 0 },
                { index: 35, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 22, passTarget: { type: 1, elements: [{ type: 9, count: 41 }] }, starScores: [5000, 15000, 22000], map: { lattices: [0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0], connectedLats: [], elements: [0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 4, 1, 1, 0, 0, 0, 1, 1, 4, 5, 4, 1, 1, 0, 1, 1, 4, 5, 5, 5, 4, 1, 1, 0, 1, 1, 4, 5, 4, 1, 1, 0, 0, 0, 1, 1, 4, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 4, type: 0 }, { index: 12, type: 0 }, { index: 14, type: 0 }, { index: 20, type: 0 }, { index: 24, type: 0 }, { index: 28, type: 0 }, { index: 34, type: 0 }, { index: 36, type: 0 }, { index: 44, type: 0 }] }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 39 }] },
        starScores: [8000, 15000, 31000],
        map: {
            lattices: [
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                3, 3, 3, 0, 0, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 3, 3,
                3, 3, 3, 0, 1, 0, 3, 2, 3,
                1, 1, 1, 0, 0, 0, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                5, 5, 5, 4, 4, 4, 5, 5, 5,
                4, 4, 4, 0, 0, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 1, 0, 4, 4, 4,
                4, 4, 4, 0, 0, 0, 4, 4, 4
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 13, 0, 0, 0, 0,
                0, 0, 0, 0, 12, 0, 0, 0, 0,
                0, 0, 0, 0, 23, 0, 0, 0, 0,
                0, 0, 0, 0, 22, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 40, type: [13, 12, 11, 23, 22, 21] }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 26,
        passTarget: { type: 1, elements: [{ type: 5, count: 39 }] },
        starScores: [6000, 14000, 24000],
        map: {
            lattices: [1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
            connectedLats: [],
            elements: [4, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2],
            baseElements: [
                40, 0, 0, 0, 0, 0, 0, 0, 40,
                0, 40, 0, 0, 0, 0, 0, 40, 0,
                0, 0, 40, 0, 0, 0, 40, 0, 0,
                0, 0, 0, 40, 0, 40, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                43, 0, 0, 0, 0, 0, 0, 0, 43,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                43, 0, 0, 0, 40, 0, 0, 0, 43,
                0, 0, 0, 0, 24, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 8, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 40, type: 0 },
                { index: 41, type: 0 },
                { index: 42, type: 0 },
                { index: 43, type: 0 },
                { index: 44, type: 0 },
                { index: 48, type: 0 },
                { index: 49, type: 0 },
                { index: 50, type: 0 },
                { index: 57, type: 0 },
                { index: 58, type: 0, cus: [40, 44] },
                { index: 59, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 32, passTarget: { type: 1, elements: [{ type: 9, count: 50 }] }, starScores: [6000, 14000, 25000], map: { lattices: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1], connectedLats: [], elements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 0, 1, 2, 1, 2, 2, 0, 0, 0, 1, 1, 2, 2, 2, 2, 1, 0, 0, 1, 1, 2, 2, 2, 2, 1, 0, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 4, 4, 4, 4, 4, 2, 1, 2, 2, 4, 4, 4, 4, 4, 2, 2, 2, 2, 4, 4, 4, 4, 4, 2, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 12, type: 0 }, { index: 13, type: 0 }, { index: 14, type: 0 }, { index: 20, type: 0 }, { index: 24, type: 0 }, { index: 28, type: 0 }, { index: 34, type: 0 }, { index: 45, type: 0 }, { index: 53, type: 0 }] }
    },
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 6, count: 23 }] },
        starScores: [6000, 12000, 18000],
        map: {
            lattices: [0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            connectedLats: [[63, 14], [64, 15], [65, 16], [66, 17]],
            elements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 3, 5, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 3, 3, 3, 3, 0, 1, 1, 1, 1, 5, 5, 5, 5, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            baseElements: [
                0, 0, 0, 0, 0, 10, 40, 40, 30,
                0, 0, 0, 0, 0, 20, 20, 40, 40,
                0, 0, 0, 0, 0, 10, 10, 30, 30,
                0, 0, 0, 0, 0, 20, 20, 40, 40,
                0, 0, 0, 0, 0, 30, 30, 10, 10,
                0, 0, 0, 0, 0, 40, 40, 20, 20,
                0, 0, 0, 0, 0, 20, 30, 40, 30,
                0, 0, 0, 0, 0, 11, 12, 21, 22,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [68, 69, 70, 71],
            generateLats: [
                { index: 9, type: 0 },
                { index: 10, type: 0 },
                { index: 11, type: 0 },
                { index: 12, type: 0 },
                { index: 27, type: 0 },
                { index: 28, type: 0 },
                { index: 29, type: 0 },
                { index: 30, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 45, type: 0 },
                { index: 46, type: 0 },
                { index: 47, type: 0 },
                { index: 48, type: 0 },
                { index: 54, type: 0 },
                { index: 55, type: 0 },
                { index: 56, type: 0 },
                { index: 57, type: 0 },
                { index: 63, type: 0 },
                { index: 64, type: 0 },
                { index: 65, type: 0 },
                { index: 66, type: 0 },
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 33,
        passTarget: { type: 1, elements: [{ type: 5, count: 34 }, { type: 9, count: 7 }] }, starScores: [5000, 12000, 24000], map: {
            lattices: [1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 2, 2, 1, 1, 0, 0, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 2], connectedLats: [],
            elements: [1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 2, 2, 2, 2, 2, 0, 0, 1, 1, 2, 5, 5, 2, 2, 0, 0, 1, 1, 2, 5, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 5, 5, 2, 2, 1, 1, 2, 2, 2, 5, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 5], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: 0 }, { index: 1, type: 0 }, { index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 43, type: 0 }, { index: 44, type: 0 }]
        }
    },
    {
        baseElementTypes: [1, 2, 0, 4], bubbleProbability: 0, stepCount: 28, passTarget: { type: 1, elements: [{ type: 5, count: 16 }] }, starScores: [6000, 12000, 20000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                1, 1, 1, 1, 0, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 5, 5, 5, 5,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 0, 0, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                12, 31, 12, 31, 0, 12, 30, 30, 12,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                30, 10, 30, 10, 0, 0, 0, 0, 0,
                10, 30, 10, 30, 0, 0, 0, 0, 0,
                30, 10, 30, 10, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 14, type: 0 },
                { index: 15, type: 0 },
                { index: 16, type: 0 },
                { index: 17, type: 0 },
                { index: 23, type: 0 },
                { index: 24, type: 0 },
                { index: 25, type: 0 },
                { index: 26, type: 0 },
                { index: 32, type: 0 },
                { index: 33, type: 0 },
                { index: 34, type: 0 },
                { index: 35, type: 0 },
                { index: 41, type: 0 },
                { index: 42, type: 0 },
                { index: 43, type: 0 },
                { index: 44, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 54, type: 0 },
                { index: 55, type: 0 },
                { index: 56, type: 0 },
                { index: 57, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 28 }] },
        starScores: [5000, 14000, 23000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                2, 2, 0, 1, 1, 1, 0, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 2, 1, 0, 0, 0, 1, 2, 2,
                2, 2, 1, 0, 1, 0, 1, 2, 2
            ],
            connectedLats: [[11, 29], [15, 33]],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                4, 4, 0, 2, 2, 2, 0, 4, 4,
                2, 5, 4, 2, 2, 2, 4, 5, 2,
                5, 2, 4, 1, 1, 1, 4, 2, 5,
                2, 5, 4, 1, 1, 1, 4, 5, 2,
                5, 2, 4, 1, 1, 1, 4, 2, 5,
                2, 5, 4, 0, 0, 0, 4, 5, 2,
                4, 4, 1, 0, 1, 0, 1, 4, 4
            ],
            baseElements: [
                0, 30, 50, 30, 40, 30, 50, 30, 0,
                0, 0, 0, 0, 33, 0, 0, 0, 0,
                20, 30, 0, 0, 0, 0, 0, 30, 20,
                0, 0, 20, 0, 0, 0, 20, 0, 0,
                0, 0, 20, 30, 42, 30, 20, 0, 0,
                0, 0, 30, 40, 50, 40, 30, 0, 0,
                0, 0, 20, 30, 40, 30, 20, 0, 0,
                0, 0, 20, 0, 0, 0, 20, 0, 0,
                20, 30, 30, 0, 21, 0, 30, 30, 20
            ],
            recycles: [],
            generateLats: [
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 18, type: 0 },
                { index: 19, type: 0 },
                { index: 25, type: 0 },
                { index: 26, type: 0 },
                { index: 39, type: 0 },
                { index: 40, type: 0 },
                { index: 41, type: 0 }
            ]
        }
    },
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 38,
        passTarget: { type: 1, elements: [{ type: 9, count: 14 }] },
        starScores: [8000, 12000, 24000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                2, 1, 3, 3, 3, 3, 3, 1, 2,
                1, 1, 3, 3, 3, 3, 3, 1, 1,
                2, 1, 1, 1, 1, 1, 1, 1, 2
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                0, 2, 5, 5, 5, 5, 5, 2, 0,
                0, 5, 0, 0, 0, 0, 0, 5, 0,
                5, 5, 0, 0, 0, 0, 0, 5, 5,
                0, 5, 5, 5, 5, 5, 5, 5, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            ], recycles: [], generateLats: [{ index: 0, type: 0 }, { index: 1, type: 0 }, { index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 7, type: 0 }, { index: 8, type: 0 }]
        }
    },
    { baseElementTypes: [0, 1, 2, 4, 3], bubbleProbability: 0, stepCount: 43, passTarget: { type: 1, elements: [{ type: 6, count: 4 }] }, starScores: [6000, 12000, 21000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 5, 1, 1, 1, 5, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: 0 }, { index: 1, type: 0 }, { index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 7, type: 0 }, { index: 8, type: 0 }] } },
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 30, passTarget: { type: 1, elements: [{ type: 9, count: 34 }] }, starScores: [6000, 14000, 24000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1], connectedLats: [], elements: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1, 1, 1, 2, 4, 2, 4, 2, 1, 1, 1, 2, 4, 2, 0, 2, 4, 2, 1, 2, 4, 2, 0, 0, 0, 2, 4, 2, 4, 2, 0, 0, 0, 0, 0, 2, 4, 2, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 10, type: 0 }, { index: 16, type: 0 }, { index: 18, type: 0 }, { index: 26, type: 0 }] }
    },
    {
        baseElementTypes: [1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 26,
        passTarget: { type: 1, elements: [{ type: 9, count: 28 }] },
        starScores: [5000, 12000, 20000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 0, 1, 0, 1, 0, 1, 0, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
      