import { Ani } from "../class/Ani";

import { RES } from "../../../module/RES";
import { RecoverName } from "../enum/RecoverName";

const offsetX = 120 / 2;
const offsetY = 120 / 2;


/**
 * 碎片位置参数
 */
const config = [
    {
        "name": "hairballPiece1",
        "x": 57,
        "y": 70,
    },
    {
        "name": "hairballPiece2",
        "x": 23,
        "y": 71,
    },
    {
        "name": "hairballPiece3",
        "x": 61,
        "y": 63,
    },
    {
        "name": "hairballPiece4",
        "x": 22,
        "y": 64,
    },
    {
        "name": "hairballPiece5",
        "x": 71,
        "y": 49,
    },
    {
        "name": "hairballPiece6",
        "x": 42,
        "y": 55,
    },
    {
        "name": "hairballPiece7",
        "x": 23,
        "y": 44,
    },
    {
        "name": "hairballPiece8",
        "x": 59,
        "y": 26,
    },
    {
        "name": "hairballPiece9",
        "x": 23,
        "y": 26,
    },
]
/**
 * 毛球消失动效
 */
export class HairballGreyDisAni extends Ani {
    pieces: FYGE.Sprite[];
    upBg: FYGE.Sprite;
    constructor() {
        super();
        this.aniName = RecoverName.HAIRBALLGREYDIS_ANI// "HairballGreyDisAni";

        this.pieces = []
        for (var i = 0; i < config.length; i++) {
            var bitmap = this.addChild(new FYGE.Sprite(RES.getRes(config[i].name + ".png")))
            this.pieces.push(bitmap);
        }
        this.upBg = this.addChild(new FYGE.Sprite(RES.getRes("hairballDisBg.png")))
        this.upBg.anchorTexture.set(0.5, 0.5)

        this.reset();
    }

    private reset() {
        for (var i = 0; i < config.length; i++) {
            this.pieces[i].x = config[i].x - offsetX;
            this.pieces[i].y = config[i].y - offsetY;
            this.pieces[i].alpha = 1;
        }
        this.upBg.scaleX = this.upBg.scaleY = 1;
        this.upBg.alpha = 1;
    }

    play() {
        //重置
        this.reset();
        //动画，完了要调this.recover()
        FYGE.Tween.get(this.upBg)
            .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
            .to({ scaleX: 1, scaleY: 1, alpha: 0 }, 160)
            .call(()=>{
                //碎片掉落
                for (let i = 0; i < config.length; i++) {
                    let p = this.pieces[i];
                    let y = config[i].y;
                    FYGE.Tween.get(p)
                        .wait(i * 30)
                        .to({ y: y + 6 }, 170);
                    FYGE.Tween.get(p)
                        .wait(i * 30 + 100)
                        .to({ alpha: 0 }, 50)
                        .call(() => {
                            if (i == config.length - 1) {
                                this.recover();
                            }
                        })
                }
            })
    }
}
