import MapPart from "./MapPart";
import { RES } from "../../../module/RES";
import Point = FYGE.Point;

export default class MapTop extends MapPart {

    public static HEIGHT = 852;

    public static totalCount = 1;

    public btnPos = [
        [225, 694],
    ];

    constructor(data) {
        super(data);

        this.data = data;

        this.bg.texture = RES.getRes('map_bg3.jpg');
        this.initIcon();
    }

    public update() {
        super.update();
        let up = this.localToGlobal(new Point(0, -10), new Point());
        let bp = this.localToGlobal(new Point(0, MapTop.HEIGHT + 10), new Point());
        let ucp = this.localToGlobal(new Point(0, MapTop.HEIGHT / 4), new Point());
        let bcp = this.localToGlobal(new Point(0, MapTop.HEIGHT / 4 * 3), new Point());
        this.alpha = +(this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp));
    }

    public destroy() {
        super.destroy();
    }

}
