import MapPart from "./MapPart";
import { RES } from "../../../module/RES";
import Point = FYGE.Point;

export default class MapMid extends MapPart {

    public static HEIGHT = 1763;

    public static  totalCount = 6;

    protected btnPos = [
        [502, 1591],
        [510, 1263],
        [357, 1053],
        [146, 652],
        [287, 281],
        [412, 63],
    ];

    constructor(data) {
        super(data);
        this.data = data;

        this.bg.texture = RES.getRes('map_bg2.jpg');

        this.initIcon();
        this.initEffect();
    }

    private initEffect() {

    }

    public update() {
        super.update();
        let up = this.localToGlobal(new Point(0, -10), new Point());
        let bp = this.localToGlobal(new Point(0, MapMid.HEIGHT + 10), new Point());
        let ucp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4), new Point());
        let bcp = this.localToGlobal(new Point(0, MapMid.HEIGHT / 4 * 3), new Point());
        this.alpha = +(this.stage.viewRect.isPointIn(up)
            || this.stage.viewRect.isPointIn(bp)
            || this.stage.viewRect.isPointIn(ucp)
            || this.stage.viewRect.isPointIn(bcp));

    }


    public destroy() {
        super.destroy();
    }

}
