import Button = FYGE.Button;
import Container = FYGE.Container;
import Sprite = FYGE.Sprite;
import Texture = FYGE.Texture;
import MouseEvent = FYGE.MouseEvent;
import Point = FYGE.Point;
import BitmapText = FYGE.BitmapText;
import { RES } from "../../../module/RES";
import { Tools } from "../../Tools";
import { showPanel } from "../../../module/ctrls";
import { StartPanel } from "../../panels/StartPanel";
import { Lottie } from "../../Lottie";
import { CheckTip } from "../../lotties/checkTip";

export enum CHECK_TYPE {
    COM,   // 普通
    CUR,    // 当前
}

export default class CheckBtn extends Container {

    public checkData: {
        level: number,
        scores: number,
        stars: number,
        isPrizeLevel: boolean,
        isVisitSuccess: boolean
        isPlayed: boolean,
    } = {
        level: 1,
        scores: 0,
        stars: 0,
        isPrizeLevel: false,
        isVisitSuccess: false,
        isPlayed: false,
    };

    private btn: Button = null;
    private checkTxt: BitmapText = null;

    private star: CheckStar[] = null;

    private checkNum: number = null;

    private _data: any = null;
    public set data(data) {
        this._data = data;
        this.checkData.isPlayed = true;
        if (!data) return;
        if (!data.isVisitSuccess) return;
        this.enabled = data.isVisitSuccess;
        this.starCount = data.stars;

        this.checkData = data;
        this.checkData.isPlayed = true;
    }

    private _starCount = 0;
    public set starCount(count: number) {
        if (count > 3) {
            count = 3;
        } else if (count < 1) {
            count = 1;
        }
        if (this._starCount == count) return;
        this._starCount = count;
        this.star.forEach((value, index) => {
            value.enabled = (index < count);
        });
    }

    public get starCount(): number {
        return this._starCount;
    }

    private _enabled: boolean = true;
    public set enabled(enabled: boolean) {
        if (this._enabled == enabled) return;
        this._enabled = enabled;

        this.btn.enabled = enabled;
        this.star.forEach(v => v.visible = enabled);
        this.checkTxt.visible = enabled;
    }

    // 按钮类型
    private _type: CHECK_TYPE = CHECK_TYPE.COM;
    public set type(type: CHECK_TYPE) {
        if (this._type == type) return;
        this._type = type;

        switch (type) {
            case CHECK_TYPE.COM:
                this.btn.changeTexture(
                    RES.getRes('map_check_enable.png'),
                    RES.getRes('map_check_enable.png'),
                    RES.getRes('map_check_disable.png'));
                break;

            case CHECK_TYPE.CUR:
                this.btn.changeTexture(
                    RES.getRes('map_check_enable_cur.png'),
                    RES.getRes('map_check_enable_cur.png'),
                    RES.getRes('map_check_disable.png'));
                const curAni = this.addChildAt(new Lottie(CheckTip), -1);
                curAni.position.set(-72, -60);
                curAni.play(-1);
                break;
        }
    }

    public update() {
        super.update();
        let up = this.localToGlobal(new Point(), new Point());
        let bp = this.localToGlobal(new Point(0, 120), new Point());
        this.alpha = +(this.stage.viewRect.isPointIn(up) || this.stage.viewRect.isPointIn(bp));
    }

    constructor(data) {
        super();
        this.initUi(data);
    }

    protected initUi(data) {
        this.btn = this.addChild(new Button(
            RES.getRes('map_check_enable.png'),
            RES.getRes('map_check_enable.png'),
            RES.getRes('map_check_disable.png')
        ));

        // 三个星星
        const star1 = this.addChild(new CheckStar());
        star1.position.set(13, 107);
        star1.rotation = 10;
        const star2 = this.addChild(new CheckStar());
        star2.position.set(60, 112);
        const star3 = this.addChild(new CheckStar());
        star3.position.set(105, 107);
        star3.rotation = -10;
        this.star = [star1, star2, star3];

        // 关卡文字
        this.checkNum = data.check;
        this.checkData.level = data.check;

        this.checkTxt = this.btn.addChild(new BitmapText(Tools.getNumTextures('map_check_')));
        this.checkTxt.position.set(79, 61);
        this.checkTxt.text = data.check + '';

        this.enabled = false;   // 先设置成关闭

        // 点击事件
        this.btn.addEventListener(MouseEvent.CLICK, this.clickStart, this);

        if (data.check == Tools.maxLevel) {
            this.addChild(Tools.getSprite("checkTip99.png", -34, -62));
        }

    }

    public clickStart() {
        console.log(`关卡:${this.checkNum}`);
        console.log(this.checkData);
        showPanel(StartPanel, this.checkData);
    }
}

/**
 * 关卡按钮star
 */
class CheckStar extends Sprite {

    private static starEnableTexture: Texture = null;
    private static starDisableTexture: Texture = null;

    private _enabled: boolean = false;

    public set enabled(enabled: boolean) {
        this._enabled = enabled;
        this.texture = enabled ? CheckStar.starEnableTexture : CheckStar.starDisableTexture;
    }

    constructor() {
        super(RES.getRes('map_star_disable.png'));
        CheckStar.starDisableTexture = RES.getRes('map_star_disable.png');
        CheckStar.starEnableTexture = RES.getRes('map_star_enable.png');

        this.anchor.set(23, 21);
    }

}

