import { Scene } from "../../module/views/Scene";
import { Tools } from "../Tools";
import { ProgressBarS } from "../common/ProgressBarS";
import { RES } from "../../module/RES";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import { layers } from "../../module/views/layers";
import { changeScene, showToast } from "../../module/ctrls";
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import TextField = FYGE.TextField;
import Tween = FYGE.Tween;
import { MapScene } from "./map/MapScene";

export class LoadingScene extends Scene {
    get groupNames() {
        return ["loadingScene"]
    }

    progressBar: ProgressBarS;
    loadingTxt: TextField;

    initUi() {
        //适配
        this.y = -layers.stageOffsetY;
        //背景
        this.addChild(FYGE.Sprite.fromFrame("loadingBg.jpg"))

        //进度条帧动画
        const pro = this.addChild(Tools.getSprite('loadingPro.png'));
        pro.position.set(80, 768)//位置按正常满条的位置

        //@ts-ignore 进度条托管
        this.progressBar = new ProgressBarS(pro);

        this.loadingTxt = this.addChild(Tools.getText(
            `loading...`, 28, "#feeeea",
            TEXT_ALIGN.CENTER, 750, 0, 841
        ));

        this.dotTween = Tween.get(FYGE, { loop: true })
            .to({}, 500)
            .call(() => {
                this.dotCount = ++this.dotCount % 3 || 3;
                this.loadingTxt.text = `loading${this.strMul('.', this.dotCount)}`;
            });
    }

    dotTween = null;
    dotCount = 0;

    /**
     * string 乘法
     * @param str
     * @param by
     */
    strMul(str, by) {
        by = (by >> 0);
        const t = (by > 1 ? this.strMul(str, by / 2) : '');
        return t + (by % 2 ? t + str : t);
    }

    async start() {
        super.start()

        this.addEventListener(FYGE.Event.PROGRESS, this.progressEvent, this)
        //首次进度一点
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.2)

        //获取app数据
        const { data } = await sendTbNet(TbNetName.getAppData);
        Tools.globalData = data;
        Tools.globalData.oldInviteId = Tools.globalData.inviteId;
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.3);

        //询问读取权限，不阻止进程
        // Tools.checkPermission();//这个需要吗？


        // 游戏基本信息
        const baseInfo = await Tools.getGameInfo();
        if (!baseInfo) showToast("获取游戏信息失败");

        this.dispatchEvent(FYGE.Event.PROGRESS, 0.5);


        await RES.loadGroup("map");
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.6);
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.7);
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.8);
        this.dispatchEvent(FYGE.Event.PROGRESS, 0.9);

        this.dispatchEvent(FYGE.Event.PROGRESS, 1);
    }

    // private lastP=0
    progressEvent(e: FYGE.Event) {
        let pro = e.data;
        FYGE.Tween.get(this.progressBar, null, null, true)
            .to({ value: pro }, 2000/**(p-this.lastP)*/)
            .call(() => {
                if (pro >= 1) {
                    this.removeEventListener(FYGE.Event.PROGRESS, this.progressEvent, this);
                    changeScene(MapScene, {from: "loading"});
                    sendTbNet(TbNetName.openMusic, { isOn: true });
                    // showPanel(LotteryPanel);
                    // changeScene(PlayScene, { chapter: 1 });
                    // changeScene(LotteryScene,{level:1});
                }
            });
        // this.lastP=p
    }

    destroy() {
        //动效要去掉
        // FYGE.Tween.removeTweens()
        super.destroy()
        //到时如果内存炸了，考虑销毁用过的贴图缓存，待测试，在RES里写个根据销毁组内贴图的方法

        Tween.removeTweenSelf(this.dotTween);
    }
}


