import { Panel } from "../../module/views/Panel";
import { SuccessStarGroup } from "./SuccessNoPrizePanel";
import { RES } from "../../module/RES";
import { changeScene, showToast } from "../../module/ctrls";
import { MapScene } from "../scene/map/MapScene";
import { Tools } from "../Tools";
import { PropType } from "../something/enum/PropType";
import { sendTbNet, TbNetName } from "../TaoBaoNet";
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import MouseEvent = FYGE.MouseEvent;
import Button = FYGE.Button;
import Sprite = FYGE.Sprite;
import Texture = FYGE.Texture;

export class SuccessPrizePanel extends Panel {
    get groupNames() {
        return ['SuccessPanel']
    }

    public showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({ scaleX: 0, scaleY: 0 })
            .to({ scaleX: 1, scaleY: 1 }, 400, Ease.backOut)
            .call(() => {
                this.isShowing = false;
            });
    }

    initUi() {
        const { prize, level, isVisitSuccess, score, stars } = this.data;
        const { name, _id, image, type, toolType } = prize;

        this.addChild(Tools.getSprite("successBgL.png")).position.set(79, 345);

        const starGroup = this.addChild(new SuccessStarGroup());
        starGroup.position.set(375, 600);
        starGroup.play(stars);

        this.addChild(Tools.getText(
            "闯关成功！获得奖励", 36, "#744f1d",
            FYGE.TEXT_ALIGN.CENTER, 750, 0, 713
        ));

        const prizeImg = this.addChild(new Sprite());
        prizeImg.anchorTexture.set(0.5, 0.5);
        prizeImg.position.set(375, 890);
        prizeImg.width = 200;
        prizeImg.height = 200;

        if (type == 6) {    // 道具
            switch (toolType) {
                case PropType.BOOMS:
                    prizeImg.texture = RES.getRes('boomBtn.png');
                    break;

                case PropType.HAMMERS:
                    prizeImg.texture = RES.getRes('hammerBtn.png');
                    break;

                case PropType.STEPS:
                    prizeImg.texture = RES.getRes('stepBtn.png');
                    break;
            }
            if (stars >= 3) {   //三星
                this.addChild(new Button(RES.getRes('sucContinueL.png')))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(190, 1050);
            } else {    // 不是三星
                this.addChild(Tools.getSprite("sucPropTip.png")).position.set(142, 1010);
                this.addChild(new Button(RES.getRes("sucAgain.png")))
                    .addEventListener(MouseEvent.CLICK, this.again, this)
                    .position.set(100, 1089);
                this.addChild(new Button(RES.getRes("sucGet.png")))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(385, 1089);
            }
        } else {    // 不是道具
            prizeImg.texture = Texture.fromUrl(image);
            this.addChild(Tools.getSprite("sucPrizeTip.png")).position.set(142, 1010);
            this.addChild(new Button(RES.getRes("sucContinueS.png")))
                .addEventListener(MouseEvent.CLICK, this.continue, this)
                .position.set(100, 1089);
            this.addChild(new Button(RES.getRes("sucGet.png")))
                .addEventListener(MouseEvent.CLICK, this.getPrize, this)
                .position.set(385, 1089);
        }

        this.addChild(new Button(RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(640, 460);
    }

    start(data) {
        super.start();
    }

    /**
     * 挑战满星
     */
    private again() {
        changeScene(MapScene, { level: this.data.level });
        super.hidePanel();
    }

    /**
     * 继续闯关
     */
    private continue() {
        if (this.data.level == Tools.maxLevel) {
            changeScene(MapScene);
        } else {
            changeScene(MapScene, { level: this.data.level + 1 });
        }
        super.hidePanel();
    }

    /**
     * 领奖
     */
    public getPrize(e) {
        this.btnDelay(e.target);
        const { name, _id, image, type, toolType } = this.data.prize;

        switch (this.data.prize.type) {
            case 1: // 权益
                sendTbNet(TbNetName.receiveEnamePrize, { _id: _id, id:_id },
                    (success, res) => {
                        if (!success || !res) {
                            showToast('奖品发放失败\n请前往我的奖品处进行处理');
                            this.hidePanel();
                            return;
                        }
                        if (res.data && res.data.drawStatus == 3) {
                            showToast('奖品发放成功\n请前往我的奖品处查看');
                        } else {
                            showToast('奖品发放失败\n请前往我的奖品处进行处理');
                        }
                        this.hidePanel();
                    }, true
                );
                break;
            case 3: // 实物
                sendTbNet(TbNetName.getUserAddress, { prizeId: _id },
                    (success, res) => {
                        if (!success) {
                            // showToast('奖品发放失败\n请前往我的奖品处进行处理');
                            return;
                        }
                        showToast('奖品发放成功\n请前往我的奖品处查看');
                        this.hidePanel();
                    }, true
                );
                break;

            case 2: // 积分
            case 5: // 谢谢参与
                this.hidePanel();
                break;
        }
    }


    public hidePanel() {
        changeScene(MapScene);
        super.hidePanel();
    }

}
