import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import { RES } from "../../module/RES";
import { changeScene, showPanel } from "../../module/ctrls";
import { MapScene } from "../scene/map/MapScene";
import { LotteryPanel } from "./LotteryPanel";
import Container = FYGE.Container;
import Sprite = FYGE.Sprite;
import Tween = FYGE.Tween;
import Ease = FYGE.Ease;
import MouseEvent = FYGE.MouseEvent;
import Button = FYGE.Button;

export class SuccessNoPrizePanel extends Panel {
    get groupNames() {
        return ['SuccessPanel']
    }

    public showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        this.anchor.set(375, 812);
        Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1, scaleY: 1}, 400, Ease.backOut)
            .call(() => {
                this.isShowing = false;
            });
    }

    initUi() {
        const { level, isVisitSuccess, score, stars } = this.data;

        this.addChild(Tools.getSprite("successBgS.png")).position.set(79, 345);

        const starGroup = this.addChild(new SuccessStarGroup());
        starGroup.position.set(375, 600);
        starGroup.play(stars);

        const tipLabel = this.addChild(Tools.getText(
            "闯关成功！", 36, "#744f1d",
            FYGE.TEXT_ALIGN.CENTER, 750, 0, 713
        ));

        if (level == Tools.maxLevel && !Tools.gameData.isDrawTopLevelPrize) {  // 99关 且没有抽奖
            tipLabel.text = '成功通关！\n获得一次抽奖机会！';
            this.addChild(new Button(RES.getRes("sucGoPrize.png")))
                .addEventListener(MouseEvent.CLICK, this.goPrize, this)
                .position.set(190, 828);
        } else {
            if (stars >= 3) {// 满星
                this.addChild(new Button(RES.getRes("sucContinueL.png")))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(190, 824);
            } else { // 不满
                tipLabel.text = '闯关成功！';
                this.addChild(new Button(RES.getRes("sucAgain.png")))
                    .addEventListener(MouseEvent.CLICK, this.again, this)
                    .position.set(100, 869);
                this.addChild(new Button(RES.getRes("sucContinueSR.png")))
                    .addEventListener(MouseEvent.CLICK, this.continue, this)
                    .position.set(385, 869);
            }
        }

        this.addChild(new Button(RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(638, 458);
    }

    start(data) {
        super.start();
    }


    /**
     * 挑战满星
     */
    private again() {
        changeScene(MapScene, {level: this.data.level});
        super.hidePanel();
    }

    public goPrize() {
        // 去抽奖
        showPanel(LotteryPanel, { callFun: () => changeScene(MapScene) });
        super.hidePanel();
    }

    /**
     * 继续闯关
     */
    private continue() {
        if (this.data.level == Tools.maxLevel) {
            changeScene(MapScene);
        } else {
            changeScene(MapScene, {level: this.data.level + 1});
        }
        super.hidePanel();
    }

    public hidePanel() {
        changeScene(MapScene);
        super.hidePanel();
    }

}

export class SuccessStarGroup extends Container {

    private leftStarDis: Sprite = null;
    private midStarDis: Sprite = null;
    private rightStarDis: Sprite = null;

    private leftStarEn: Sprite = null;
    private midStarEn: Sprite = null;
    private rightStarEn: Sprite = null;

    constructor() {
        super();

        this.leftStarDis = this.addChild(Tools.getSprite('star_dis.png'));
        this.midStarDis = this.addChild(Tools.getSprite('star_dis.png'));
        this.rightStarDis = this.addChild(Tools.getSprite('star_dis.png'));

        this.leftStarDis.anchorTexture.set(0.5, 0.5);
        this.midStarDis.anchorTexture.set(0.5, 0.5);
        this.rightStarDis.anchorTexture.set(0.5, 0.5);

        this.leftStarDis.position.set(-140, 10);
        this.rightStarDis.position.set(140, 10);

        this.leftStarEn = this.addChild(Tools.getSprite('star_en.png'));
        this.midStarEn = this.addChild(Tools.getSprite('star_en.png'));
        this.rightStarEn = this.addChild(Tools.getSprite('star_en.png'));

        this.leftStarEn.anchorTexture.set(0.5, 0.5);
        this.midStarEn.anchorTexture.set(0.5, 0.5);
        this.rightStarEn.anchorTexture.set(0.5, 0.5);

        this.leftStarEn.position.set(-140, 10);
        this.rightStarEn.position.set(140, 10);

        this.leftStarEn.scale.set(0, 0);
        this.midStarEn.scale.set(0, 0);
        this.rightStarEn.scale.set(0, 0);
    }

    public play(count: number, wait: number = 600) {
        const time1 = 200;
        const time2 = 100;
        const max = 3;
        const interval = 80;

        if (count < 1) return;
        Tween.get(this.leftStarEn)
            .wait(wait)
            .set({ scaleX: max, scaleY: max })
            .to({ scaleX: 0.648, scaleY: 0.648 }, time1, Ease.quadOut)
            .to({ scaleX: 1, scaleY: 1 }, time2, Ease.quadOut)
            .wait(interval)
            .call(() => {
                if (count <= 1) return;
                Tween.get(this.midStarEn)
                    .set({scaleX: max, scaleY: max})
                    .to({scaleX: 0.8, scaleY: 0.8}, time1, Ease.quadOut)
                    .to({scaleX: 1, scaleY: 1}, time2, Ease.quadOut)
                    .wait(interval)
                    .call(() => {
                        if (count <= 2) return;
                        Tween.get(this.rightStarEn)
                            .set({ scaleX: max, scaleY: max })
                            .to({ scaleX: 0.648, scaleY: 0.648 }, time1, Ease.quadOut)
                            .to({ scaleX: 1, scaleY: 1 }, time2, Ease.quadOut)
                    });
            });
    }
}
