import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import { RES } from "../../module/RES";
import TextField = FYGE.TextField;
import TEXT_lINETYPE = FYGE.TEXT_lINETYPE;
import ScrollPage = FYGE.ScrollPage;
import Button = FYGE.Button;
import MouseEvent = FYGE.MouseEvent;

export class RulePanel extends Panel {
    get groupNames() {
        return ["RulePanel"]
    }

    get skinName() {
        return "RulePanel"
    }

    closeBtn: FYGE.Button;
    ruleTex: TextField;
    scroll: ScrollPage;

    initUi() {

    }

    start(data) {
        super.start();

        this.addChild(Tools.getText(
            "活动规则", 38, '#892a1a',
            FYGE.TEXT_ALIGN.CENTER, 570, 96,510
        ));

        const rule = Tools.gameData.rule;
        this.ruleTex = this.addChild(Tools.getText(
            rule, 26, '#892a1a',
            FYGE.TEXT_ALIGN.LEFT, 570
        ));
        this.ruleTex.lineType = TEXT_lINETYPE.MULTI;

        this.scroll = this.addChild(new ScrollPage(
            570, 500, this.ruleTex.textHeight + 30
        ));
        this.scroll.position.set(96, 580);
        this.scroll.view.addChild(this.ruleTex);

        this.addChild(new Button(RES.getRes('ruleBtn.png')))
            .addEventListener(MouseEvent.CLICK, () => this.hidePanel())
            .position.set(192, 1095);

    }

    initEvents() {
        super.initEvents();
    }

    removeEvents() {
        super.removeEvents();
    }
}
