import { Panel } from "../../module/views/Panel";
import MouseEvent = FYGE.MouseEvent;
import { Tools } from "../Tools";
import Button = FYGE.Button;
import { RES } from "../../module/RES";

export class NoEnergyPanel extends Panel {
    get groupNames() {
        return ["NoEnergyPanel"]
    }

    closeBtn: FYGE.Button;
    okBtn: FYGE.Button;

    initUi() {
        this.addChild(Tools.getSprite('panelBgS.png')).position.set(79, 513);
        this.addChild(Tools.getSprite('体力不足.png')).position.set(171, 582);
        this.okBtn = this.addChild(new Button(RES.getRes('体力不足按钮.png')));
        this.okBtn.position.set(190, 830);

        this.addChild(new Button(RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, () => {
                this.hidePanel();
            }, this)
            .position.set(640, 494);
    }

    start(data) {
        super.start();
    }

    initEvents() {
        super.initEvents();
        this.okBtn.addEventListener(MouseEvent.CLICK, () => {
            Tools.openTask();
            this.hidePanel();
        }, this);
    }

    removeEvents() {
        super.removeEvents();
    }
}
