import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import { RES } from "../../module/RES";
import Button = FYGE.Button;
import MouseEvent = FYGE.MouseEvent;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;

export class FreePowerPanel extends Panel {
	get groupNames() {
		return ["FreePowerPanel"]
	}


	protected initUi() {
		super.initUi();
		this.addChild(Tools.getSprite('freePowerBg.png')).position.set(79, 345);

		this.addChild(new Button(RES.getRes('freePowerBtn.png')))
			.addEventListener(MouseEvent.CLICK, this.hidePanel, this)
			.position.set(190, 893);

		this.addChild(Tools.getSprite('powerIcon.png')).position.set(280, 763);
		const powerTxt = this.addChild(Tools.getText(
			`+${this.data.loginAddPower}`, 38, "#ffe090",
			TEXT_ALIGN.LEFT,
		));
		powerTxt.strokeColor = '#7f3c05';
		powerTxt.stroke = 2;
		powerTxt.position.set(400, 795);

		this.addChild(new Button(RES.getRes('关闭按钮.png')))
			.addEventListener(MouseEvent.CLICK, this.hidePanel, this)
			.position.set(633, 456);


	}

	hidePanel() {
		super.hidePanel();
		//显示倒计时
	}

}
