import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import { changeScene } from "../../module/ctrls";
import { MapScene } from "../scene/map/MapScene";
import { RES } from "../../module/RES";
import MouseEvent = FYGE.MouseEvent;
import Button = FYGE.Button;

export class FailedPanel extends Panel {
    get groupNames() {
        return ["FailedPanel"]
    }

    initUi() {

        this.addChild(Tools.getSprite('panelBgS.png')).position.set(79, 513);
        this.addChild(Tools.getSprite('failedTxt.png')).position.set(171, 582);

        this.addChild(new Button(RES.getRes("failedBtn.png")))
            .addEventListener(MouseEvent.CLICK, this.again, this)
            .position.set(171, 830);

        this.addChild(new Button(RES.getRes('关闭按钮.png')))
            .addEventListener(MouseEvent.CLICK, this.hidePanel, this)
            .position.set(638, 488);
    }

    start(data) {
        super.start();
    }

    public hidePanel() {
        changeScene(MapScene);
        super.hidePanel();
    }

    public again() {
        changeScene(MapScene, {level: this.data.level});
        super.hidePanel();
    }
}
