
import { RES } from "../../../module/RES";
import Sprite = FYGE.Sprite;


export class PropBtnCon extends FYGE.Container {
    boomBtn: FYGE.Button;
    hammerBtn: FYGE.Button;
    stepBtn: FYGE.Button;

    private stepNum: FYGE.BitmapText;
    private _stepCount: number;
    get stepCount() {
        return this._stepCount;
    }
    set stepCount(value) {
        this._stepCount = value;
        this.stepNum.text = "" + value;
    }

    private boomNum: FYGE.BitmapText;
    private _boomCount: number;
    get boomCount() {
        return this._boomCount;
    }
    set boomCount(value) {
        this._boomCount = value;
        this.boomNum.text = "" + value;
    }
    private hammerNum: FYGE.BitmapText;
    private _hammerCount: number;
    get hammerCount() {
        return this._hammerCount;
    }
    set hammerCount(value) {
        this._hammerCount = value;
        this.hammerNum.text = "" + value;
    }


    constructor() {
        super();
        // this.addChild(FYGE.Sprite.fromFrame("table.png"));
        this.stepBtn = new FYGE.Button(RES.getRes("stepBtn.png"));
        this.stepBtn.x = 117;
        this.addChild(this.stepBtn);
        this.boomBtn = new FYGE.Button(RES.getRes("boomBtn.png"));
        this.boomBtn.x = 298;
        this.addChild(this.boomBtn);
        this.hammerBtn = new FYGE.Button(RES.getRes("hammerBtn.png"));
        this.hammerBtn.x = 479;
        this.addChild(this.hammerBtn);
        this.stepBtn.y = this.boomBtn.y = this.hammerBtn.y = -20;

        this.addChild(new Sprite(RES.getRes('propNumBg.png'))).position.set(219, 70);
        this.addChild(new Sprite(RES.getRes('propNumBg.png'))).position.set(400, 70);
        this.addChild(new Sprite(RES.getRes('propNumBg.png'))).position.set(581, 70);


        const arr = {};
        for (let i = 0; i < 10; i++)arr[i] = RES.getRes("propNum" + i + ".png")
        //文案
        this.stepNum = this.addChild(new FYGE.BitmapText(arr));
        this.boomNum = this.addChild(new FYGE.BitmapText(arr));
        this.hammerNum = this.addChild(new FYGE.BitmapText(arr));
        this.stepNum.y = this.boomNum.y = this.hammerNum.y = 100;
        this.stepNum.text = this.boomNum.text = this.hammerNum.text = "0";
        this.stepNum.textAlign = this.boomNum.textAlign = this.hammerNum.textAlign = FYGE.TEXT_ALIGN.CENTER;
        this.stepNum.x = 249
        this.boomNum.x = 249 + 182
        this.hammerNum.x = 249 + 182 * 2;
        // console.log(this.stepNum, this.boomNum,this.hammerNum)
    }
}



/**
 * 自定义按钮
 */


