import { ElementType } from "../enum/ElementType";
import { RES } from "../../../module/RES";
import { Tools } from "../../Tools";


/**
 * 通关目标是多个元素时的ui
 *
 */
export class ElementTargets extends FYGE.Container {
    targets: ElementTarget[];
    constructor(passElement: number[]) {
        super()
        this.targets = [];
        for (let i = 0; i < passElement.length; i++) {
            if (passElement[i]) {
                const eleTar: ElementTarget = new ElementTarget(i);
                eleTar.count = passElement[i];
                this.addChild(eleTar);
                this.targets[i] = eleTar;
            }
        }
        this.center()
    }

    center() {
        //按顺序排，从右到左，
        const len = this.children.length;
        const w = 80 * 0.8;
        const space = 25
        const right = len / 2 * w - w + (len - 1) / 2 * space;
        for (let i = this.children.length - 1; i >= 0; i--) {
            this.children[i].x = right - w * i - space * i;
        }
    }
}


/**
 * 通关目标是元素时的单个元素的ui
 *
 */
class ElementTarget extends FYGE.Container {
    /**
     * 元素类型
     */
    type: ElementType;
    /**
     * 打勾完成
     */
    zeroMark: FYGE.Sprite;
    /**
     * 数量文案
     */
    private countNum: FYGE.BitmapText;
    /**
     * 数量
     */
    private _count: number;
    get count(): number {
        return this._count;
    }
    set count(value: number) {
        if (value <= 0) {
            value = 0;
            this.countNum.visible = false;
            this.zeroMark.visible = true;
        }
        this._count = value;
        this.countNum.text = "" + value;
    }
    constructor(type: ElementType) {
        super()
        let targetKey = 'ele';
        if ([0, 1, 2, 3, 4].indexOf(+type) > -1) {
            targetKey = 'target';
        }

        let texture: FYGE.Texture = RES.getRes(targetKey + type + ".png");
        const showImage = new FYGE.Sprite(texture);
        showImage.scaleX = showImage.scaleY = 0.7
        this.addChild(showImage);
        texture = RES.getRes("rightMark.png");
        this.zeroMark = new FYGE.Sprite(texture);
        this.zeroMark.x = 35 - 10;
        this.zeroMark.y = 35 - 10;
        this.zeroMark.visible = false;
        this.addChild(this.zeroMark);
        this.countNum = new FYGE.BitmapText(Tools.getNumTextures("tarNum"));//文字待定
        this.countNum.x = 55;
        this.countNum.y = 37;
        this.addChild(this.countNum);
    }
}
